/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.management.tools.AbstractNodeConfigUtility;
import com.ibm.ws.management.tools.WindowsService;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.process.CreationParams;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessFactory;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class NodeRemovalUtility
extends AbstractNodeConfigUtility {
    private static TraceComponent tc = Tr.register(NodeRemovalUtility.class, "Admin", "com.ibm.ws.management.resources.nodeutils");
    private static final String DEFAULT_TRACE_STRING = "com.ibm.ws.management.tools.*=all=enabled";
    private static final String DEFAULT_TRACE_FILE = "removeNode.log";
    protected String restoredCellName = null;
    protected boolean terminateServers = false;
    private Repository localRepository = null;
    private VariableMap map = null;
    private boolean forceRemove = false;
    private String backupRoot = null;
    private Properties clientProps = null;
    private boolean invokedFromMBean = false;
    private boolean removeWasForced = false;
    private boolean baseBackupDirFound = false;
    private Properties nodeProperties = new Properties();

    public static void main(String[] stringArray) {
        System.exit(new NodeRemovalUtility().executeUtility(stringArray));
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        string = string + File.separator + "logs";
        string = string + File.separator + DEFAULT_TRACE_FILE;
        return string;
    }

    protected int getMinimumNumArgs() {
        return 3;
    }

    protected void issueUsageMessage() {
        this.issueMessage("ADMU2002I", null, null);
    }

    protected int parseRequiredArgs(String[] stringArray) {
        return 3;
    }

    protected int parseUtilitySpecificOption(String[] stringArray, int n) {
        int n2 = n + 1;
        String string = stringArray[n];
        if (string.equals("-local") || string.equals("-force")) {
            this.forceRemove = true;
        } else if (string.equals("-fromMBean")) {
            this.invokedFromMBean = true;
        } else {
            n2 = -1;
        }
        return n2;
    }

    protected int runTool() throws Exception {
        this.issueMessage("ADMU2001I", new Object[]{this.nodeName}, null);
        this.createAdminClientInstance();
        try {
            ModelMgr.initialize("ws-server");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ModelMgr initialized");
            }
            if (this.doCheckIfRemoveNodeIsOkToRun() == -1) {
                return -1;
            }
            Runtime.getRuntime().addShutdownHook(new AbstractNodeConfigUtility.ShutdownThread());
            if (this.terminateServers) {
                this.terminateAllServers();
            } else {
                this.stopAllServers();
            }
            this.doRemoveNodeOnDmgr();
            this.completeAddOrRemoveNode();
            this.doFinalCleanup();
            this.showNextTasks();
        }
        catch (Throwable throwable) {
            this.issueMessage("ADMU0029E", new Object[]{NodeRemovalUtility.getRootCause(throwable).getMessage()}, null);
            this.issueMessage("ADMU0211I", new Object[]{this.logfile}, null);
            throw Utils.makeAdminException(throwable);
        }
        return 0;
    }

    private void doRemoveNodeOnDmgr() throws Exception {
        try {
            if (this.adminClient != null) {
                this.issueMessage("ADMU2021I", null, null);
                this.doUnconfigOnDMgr();
            }
        }
        catch (Exception exception) {
            Tr.error(tc, "ADMU2023E", exception);
            this.issueMessage("ADMU2023E", new Object[]{exception}, null);
            if (!this.forceRemove) {
                this.issueMessage("ADMU2015I", null, null);
                throw exception;
            }
            this.removeWasForced = true;
        }
    }

    private void doFinalCleanup() throws Exception, AdminException {
        this.deleteAppBins();
        String string = this.configRoot + "/cells/" + this.cellName;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deleting " + string);
        }
        this.deleteDirs(string);
        this.restoredCellName = this.restoreBaseAppServerConfig();
        this.localRepository = null;
        this.fixWsadminProps(this.getClientProperties());
        this.fixSetupCmdLine(this.restoredCellName, this.getClientProperties());
        if (this.isZOS()) {
            this.transformConfig2Native(this.restoredCellName, this.nodeName);
        }
        this.doRemoveService();
        this.issueMessage("ADMU2017I", null, null);
    }

    private int doCheckIfRemoveNodeIsOkToRun() throws Exception {
        if (!this.isMemberOfCell()) {
            this.issueMessage("ADMU2026E", new Object[]{this.nodeName}, null);
            this.issueMessage("ADMU0211I", new Object[]{this.logfile}, null);
            return -1;
        }
        if (!this.beginAddOrRemoveNode()) {
            this.issueMessage("ADMU0041E", null, null);
            this.issueMessage("ADMU0211I", new Object[]{this.logfile}, null);
            return -1;
        }
        if (!this.checkIfBackupBaseDirExists()) {
            this.issueMessage("ADMU2035W", null, null);
            this.issueMessage("ADMU2036I", null, null);
            return -1;
        }
        return 0;
    }

    private void createAdminClientInstance() throws Exception {
        try {
            this.initAdminClient();
        }
        catch (Exception exception) {
            Tr.error(tc, "ADMU0006E", exception);
            this.issueMessage("ADMU0006E", new Object[]{exception}, null);
            if (!this.forceRemove) {
                this.issueMessage("ADMU2015I", null, null);
                throw exception;
            }
            this.removeWasForced = true;
        }
    }

    private void doRemoveService() throws AdminException {
        if (!System.getProperty("os.name").toLowerCase().startsWith("win")) {
            return;
        }
        String string = System.getProperty("was.install.root") + File.separator + "bin" + File.separator + "WASService.exe";
        WindowsService windowsService = WindowsService.getWindowsServiceInstance("nodeagent");
        if (windowsService == null) {
            return;
        }
        String string2 = windowsService.getServiceName();
        String string3 = " -remove " + string2;
        Tr.audit(tc, string + " " + string3);
        CreationParams creationParams = new CreationParams();
        creationParams.setExecutable(string);
        creationParams.setProcessName("WASService");
        creationParams.setDetachProcess(true);
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        creationParams.setCommandLineArgs(stringArray);
        try {
            Process process = ProcessFactory.create(creationParams);
            process.waitForTermination(30);
            process.release();
        }
        catch (Exception exception) {
            this.issueMessage("ADMU1501W", null, null);
            throw new AdminException(this.getFormattedMessage("ADMU1501W", null, null));
        }
    }

    private void issueWarnings(Collection collection, String string) {
        if (collection != null && !collection.isEmpty()) {
            int n = 0;
            String string2 = "\n";
            String[] stringArray = (String[])collection.toArray();
            for (int i = 0; i < stringArray.length; ++i) {
                n += stringArray[i].length();
                n += string2.length();
            }
            n = (n + 256) / 256 * 256;
            StringBuffer stringBuffer = new StringBuffer(n);
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                stringBuffer.append(string2);
                if (string3.length() > 0) {
                    stringBuffer.append(string3);
                    continue;
                }
                stringBuffer.append("Warning message missing?");
            }
            String string4 = "" + stringArray.length;
            this.issueMessage(string, new Object[]{string4, this.nodeName, stringBuffer.toString()}, null);
        }
    }

    private void initAdminClient() throws Exception {
        Properties properties = this.getCellMgrProps();
        if (properties == null) {
            return;
        }
        if (this.userid != null) {
            properties.setProperty("username", this.userid);
        }
        if (this.pwd != null) {
            properties.setProperty("password", this.pwd);
        }
        this.adminClient = this.getAdminClient(properties);
        this.notificationService = this.getNotificationServiceMBean();
        this.emitNotification("ADMU2001I", this.getFormattedMessage("ADMU2001I", new Object[]{this.nodeName}, null));
    }

    protected Properties getClientProperties() throws Exception {
        if (this.clientProps == null) {
            this.clientProps = System.getProperties();
            this.clientProps.setProperty("user.install.root", this.getUserInstallRootIfSetElseGetWasInstallRoot());
            this.clientProps.setProperty("host", "localhost");
            this.clientProps.setProperty("type", "SOAP");
            try {
                this.clientProps.setProperty("port", this.getBaseSOAPPort().toString());
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return this.clientProps;
    }

    private Integer getBaseSOAPPort() throws Exception {
        ConfigRoot configRoot = this.getLocalRepository().getConfigRoot();
        Resource resource = configRoot.getResource(3, "serverindex.xml");
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        EList eList = serverIndex.getServerEntries();
        ServerEntry serverEntry = (ServerEntry)eList.iterator().next();
        EList eList2 = serverEntry.getSpecialEndpoints();
        Iterator iterator = eList2.iterator();
        while (iterator.hasNext()) {
            NamedEndPoint namedEndPoint = (NamedEndPoint)iterator.next();
            if (!namedEndPoint.getEndPointName().equals("SOAP_CONNECTOR_ADDRESS")) continue;
            EndPoint endPoint = namedEndPoint.getEndPoint();
            return new Integer(endPoint.getPort());
        }
        return new Integer(8880);
    }

    private String restoreBaseAppServerConfig() throws Exception {
        this.issueMessage("ADMU2014I", null, null);
        String string = this.backupRoot + "/base/cells/";
        String string2 = null;
        File[] fileArray = new File(string).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            string2 = fileArray[i].getName();
            break;
        }
        this.nodeName = this.getOriginalNodeName(string, string2);
        String string3 = this.configRoot + "/cells/";
        String string4 = this.backupRoot + "/base/templates/";
        String string5 = this.configRoot + "/templates/";
        File file = new File(string3);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.copyDocuments(string, string3);
        File file2 = new File(string5);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        this.copyDocuments(string4, string5);
        File file3 = new File(this.configRoot + "/plugin-cfg.xml");
        File file4 = new File(this.backupRoot + "/base/plugin-cfg.xml");
        if (file4.exists()) {
            this.copyDocument(file4, file3);
        }
        File file5 = new File(this.configRoot + "/plugin-cfg-service.xmi");
        File file6 = new File(this.backupRoot + "/base/plugin-cfg-service.xmi");
        if (file6.exists()) {
            this.copyDocument(file6, file5);
        }
        this.restoreApplications(string2);
        return string2;
    }

    private String getOriginalNodeName(String string, String string2) {
        String string3 = string + string2 + "/nodes/";
        String string4 = null;
        File[] fileArray = new File(string3).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            string4 = fileArray[i].getName();
            break;
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreApplications(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreApplications: " + string);
        }
        VariableMap variableMap = null;
        try {
            File file;
            variableMap = this.getVarMap(this.configRoot, string, this.nodeName);
            if (variableMap == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "restoreApplications:  null varmap for base cell");
                }
                return;
            }
            String string2 = this.configRoot + "/cells/" + string + "/applications";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "apps dir: " + string2);
            }
            if ((file = new File(string2)).exists()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2;
                    if (!fileArray[i].isDirectory() || !(file2 = new File(string2 + "/" + fileArray[i].getName() + "/" + fileArray[i].getName())).exists()) continue;
                    Vector vector = this.getDeploymentPaths(string2 + "/" + fileArray[i].getName() + "/deployments");
                    this.expandEar(file2.getPath(), vector, variableMap);
                }
            }
        }
        catch (Throwable throwable) {
            this.issueMessage("ADMU0529E", new Object[]{throwable}, null);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "restoreApplications");
            }
            variableMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAppBins() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteAppBins");
        }
        VariableMap variableMap = null;
        try {
            variableMap = this.getVarMap(this.configRoot, this.cellName, this.nodeName);
            if (variableMap == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "deleteAppBins: no var map was created");
                }
                return;
            }
            String string = variableMap.expand("$(APP_INSTALL_ROOT)/" + this.cellName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Deleting: " + string);
            }
            this.deleteDirs(string);
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected exception: " + throwable + " in deleting binaries from ND config for " + this.nodeName);
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteAppBins");
            }
            variableMap = null;
        }
    }

    protected void emitNotification(String string, String string2) {
        if (this.notificationService != null) {
            String string3 = null;
            string3 = string.equals("ADMU2001I") && !this.invokedFromMBean ? "websphere.removenode.starting" : (string.equals("ADMU2024I") || string.equals("ADMU2025I") ? "websphere.removenode.complete" : (string.equals("ADMU0211I") ? "websphere.removenode.failed" : "websphere.removenode.message"));
            try {
                this.adminClient.invoke(this.notificationService, "emitNotification", new Object[]{string3, string2, this.notificationUserData}, NTFY_PARAMS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Properties getCellMgrProps() throws Exception {
        Object object;
        Resource resource;
        ConfigRoot configRoot = this.getLocalRepository().getConfigRoot();
        this.backupRoot = this.getBackupRoot(this.getLocalRepository(), this.getVariableMap());
        String[] stringArray = configRoot.list(3, null);
        ServerEntry serverEntry = null;
        block0: for (int i = 0; i < stringArray.length; ++i) {
            configRoot.setValue(3, stringArray[i]);
            resource = configRoot.getResource(3, "serverindex.xml");
            object = (ServerIndex)resource.getContents().get(0);
            EList eList = object.getServerEntries();
            for (int j = 0; j < eList.size(); ++j) {
                ServerEntry serverEntry2 = (ServerEntry)eList.get(j);
                String string = serverEntry2.getServerType();
                if (!string.equals("DEPLOYMENT_MANAGER")) continue;
                serverEntry = serverEntry2;
                continue block0;
            }
        }
        EndPoint endPoint = null;
        resource = null;
        if (serverEntry != null) {
            object = serverEntry.getSpecialEndpoints();
            for (int i = 0; i < object.size(); ++i) {
                NamedEndPoint namedEndPoint = (NamedEndPoint)object.get(i);
                if (namedEndPoint.getEndPointName().equals("SOAP_CONNECTOR_ADDRESS")) {
                    endPoint = namedEndPoint.getEndPoint();
                }
                if (!namedEndPoint.getEndPointName().equals("BOOTSTRAP_ADDRESS")) continue;
                resource = namedEndPoint.getEndPoint();
            }
        }
        object = null;
        if (endPoint != null) {
            object = new Properties();
            ((Properties)object).setProperty("type", "SOAP");
            ((Properties)object).setProperty("port", new Integer(endPoint.getPort()).toString());
            ((Properties)object).setProperty("host", endPoint.getHost());
        } else if (resource != null) {
            object = new Properties();
            ((Properties)object).setProperty("type", "RMI");
            ((Properties)object).setProperty("port", new Integer(resource.getPort()).toString());
            ((Properties)object).setProperty("host", resource.getHost());
        }
        return object;
    }

    protected Repository getLocalRepository() throws Exception {
        this.setupLocalRepository();
        return this.localRepository;
    }

    protected VariableMap getVariableMap() throws Exception {
        if (this.map == null) {
            this.setupLocalRepository();
        }
        return this.map;
    }

    private void setupLocalRepository() throws Exception {
        ServerIdentifiers serverIdentifiers = new ServerIdentifiers();
        serverIdentifiers.setConfigRoot(this.configRoot);
        if (this.restoredCellName != null) {
            serverIdentifiers.setCellName(this.restoredCellName);
            serverIdentifiers.setServerName("server1");
        } else {
            serverIdentifiers.setCellName(this.cellName);
            serverIdentifiers.setServerName("nodeagent");
        }
        serverIdentifiers.setNodeName(this.nodeName);
        this.localRepository = RepositoryFactory.createRepository("ws-server", serverIdentifiers.getConfigRoot(), serverIdentifiers.getCellName(), serverIdentifiers.getNodeName(), serverIdentifiers.getServerName());
        this.map = VariableMapFactory.createVariableMap(this.localRepository);
        this.map.initialize(null);
    }

    protected AdminClient getAdminClient(Properties properties) throws Exception {
        AdminClient adminClient = null;
        adminClient = AdminClientFactory.createAdminClient(properties);
        Object[] objectArray = new Object[2];
        objectArray[0] = properties.getProperty("host");
        objectArray[1] = properties.getProperty("port");
        this.issueMessage("ADMU0009I", objectArray, null);
        return adminClient;
    }

    public void setForceRemove(boolean bl) {
        this.forceRemove = bl;
    }

    private void showNextTasks() {
        this.issueMessage("ADMU9990I", null, null);
        this.issueMessage("ADMU0306I", null, null);
        this.issueMessage("ADMU2031I", new Object[]{this.cellName}, null);
        this.issueMessage("ADMU0307I", null, null);
        this.issueMessage("ADMU2032I", null, null);
        this.issueMessage("ADMU9990I", null, null);
        this.issueMessage("ADMU9990I", null, null);
        this.issueMessage("ADMU0306I", null, null);
        this.issueMessage("ADMU2033I", new Object[]{this.cellName}, null);
        this.issueMessage("ADMU0307I", null, null);
        this.issueMessage("ADMU2034I", null, null);
        if (this.removeWasForced) {
            this.issueMessage("ADMU2025W", new Object[]{this.nodeName}, null);
        } else {
            this.issueMessage("ADMU2024I", new Object[]{this.nodeName}, null);
        }
    }

    private void doUnconfigOnDMgr() throws Exception {
        Object var1_1 = null;
        this.nodeProperties.setProperty("CELL_NAME_KEY", this.cellName);
        this.nodeProperties.setProperty("NODE_NAME_KEY", this.nodeName);
        ObjectName objectName = this.getMBeanByType("AdminOperations");
        if (objectName != null) {
            this.invokeMBean(objectName, "doUnMergeConfigDataOnDmgr", new Object[]{this.nodeProperties}, new String[]{"java.util.Properties"});
        }
    }

    private boolean checkIfBackupBaseDirExists() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfBackupBaseDirExists");
        }
        boolean bl = false;
        String string = this.backupRoot + "/base/cells/";
        Tr.debug(tc, "backup base dir = " + string);
        File file = new File(string);
        if (file.exists()) {
            this.baseBackupDirFound = true;
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfBackupBaseDirExists" + bl);
        }
        return bl;
    }
}

