/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.management.launcher.LaunchScriptCollaboratorFactory;
import com.ibm.ws.management.launcher.LaunchScriptPlatformCollaborator;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.management.tools.AbstractNodeConfigUtility;
import com.ibm.ws.management.tools.DoNotDoAddNodeException;
import com.ibm.ws.management.util.EncodingUtils;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.Vector;
import javax.management.MBeanException;
import javax.management.ObjectName;

public class NodeRenameUtility
extends AbstractNodeConfigUtility {
    private static final TraceComponent tc = Tr.register(NodeRenameUtility.class, "Admin", "com.ibm.ws.management.resources.nodeutils");
    private static final String DEFAULT_TRACE_STRING = "com.ibm.ws.management.tools.*=all=enabled";
    private static final String DEFAULT_TRACE_FILE = "renameNode.log";
    private static final String FSEP = "/";
    private Repository localRunTimeRepository;
    private VariableMap map;
    private String newNodeName = "";
    private String nodeShortName = "";
    private Properties clientProps;

    public static void main(String[] stringArray) {
        System.exit(new NodeRenameUtility().executeUtility(stringArray));
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        string = string + File.separator + "logs";
        string = string + File.separator + DEFAULT_TRACE_FILE;
        return string;
    }

    protected int getMinimumNumArgs() {
        return 6;
    }

    protected int parseRequiredArgs(String[] stringArray) {
        int n = 6;
        this.connHost = stringArray[3];
        this.connPort = stringArray[4];
        this.newNodeName = stringArray[5];
        return n;
    }

    protected int parseUtilitySpecificOption(String[] stringArray, int n) {
        int n2 = n + 1;
        String string = stringArray[n];
        if (string.equals("-nodeshortname")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.nodeShortName = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-conntype")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.connType = stringArray[n + 1];
                this.adminProperties.setProperty("-connType", this.connType);
                ++n2;
            } else {
                n2 = -2;
            }
        } else {
            n2 = -1;
        }
        return n2;
    }

    protected void issueUsageMessage() {
        this.issueMessage("ADMU0252I", null, null);
    }

    protected void toolFailed(Throwable throwable) {
    }

    public AdminClient getAdminClient() {
        return this.adminClient;
    }

    protected int runTool() throws Exception {
        this.issueMessage("ADMU0251I", new Object[]{this.nodeName}, null);
        this.init();
        this.checkIfNodeNamesMatch();
        this.issueMessage("ADMU0254I", new Object[]{this.newNodeName}, null);
        this.renameNode();
        this.issueMessage("ADMU0250I", new Object[]{this.nodeName, this.newNodeName}, null);
        return 0;
    }

    private void renameNode() throws Exception, DoNotDoAddNodeException {
        this.configNodeOnDMgr();
        this.doRegenNDPluginConfig();
        this.syncNode();
        this.fixNodeSetupCmdLine(this.newNodeName, this.clientProps);
        this.fixWsadminProps(this.clientProps);
        if (this.isZOS()) {
            this.transformConfig2Native(this.cellName, this.newNodeName);
        }
    }

    private void configNodeOnDMgr() throws Exception {
        ObjectName objectName = this.getMBeanByType("AdminOperations");
        if (objectName == null) {
            throw new AdminException(this.getFormattedMessage("ADMU0025E", null, null));
        }
        this.invokeMBean(objectName, "renameNodeOnDmgr", new Object[]{this.nodeName, this.newNodeName, this.nodeShortName}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String"});
    }

    private void doRegenNDPluginConfig() throws Exception {
        ObjectName objectName;
        ObjectName objectName2 = this.getMBeanByType("PluginCfgGenerator");
        if (objectName2 != null && (objectName = this.getMBeanByType("JVM")) != null) {
            String string = (String)this.adminClient.invoke(objectName, "getProperty", new Object[]{"user.install.root"}, new String[]{"java.lang.String"});
            Object var4_4 = null;
            try {
                this.invokeMBean(objectName2, "generate", new Object[]{string, var4_4, this.cellName, null, null, "plugin-cfg.xml"}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"});
            }
            catch (MBeanException mBeanException) {
                this.issueMessage("ADMU0040E", new Object[]{objectName2, "generate", mBeanException}, null);
            }
        }
    }

    private void checkIfNodeNamesMatch() throws Exception {
        if (this.newNodeName != null && this.newNodeName.length() > 0 && this.nodeName.equalsIgnoreCase(this.newNodeName)) {
            throw new AdminException(this.getFormattedMessage("ADMU0039E", new Object[]{this.nodeName}, null));
        }
    }

    private void init() throws Exception {
        this.clientProps = this.getClientProperties();
        if ("RMI".equals(this.clientProps.getProperty("type")) && this.clientProps.getProperty("host") != null && this.clientProps.getProperty("port") != null) {
            Properties properties = System.getProperties();
            properties.setProperty("com.ibm.CORBA.securityServerHost", this.clientProps.getProperty("host"));
            properties.setProperty("com.ibm.CORBA.securityServerPort", this.clientProps.getProperty("port"));
            System.setProperties(properties);
        }
        this.localRunTimeRepository = null;
        this.map = null;
        this.adminClient = this.getAdminClient(this.clientProps);
        if (!this.isConnectedToDeploymentManager()) {
            throw new AdminException(this.getFormattedMessage("ADMU0025E", null, null));
        }
        this.issueMessage("ADMU0009I", new Object[]{this.connHost, this.connPort}, null);
        ModelMgr.initialize("ws-server");
        this.stopAllServers();
    }

    private boolean isConnectedToDeploymentManager() throws Exception {
        ObjectName objectName = this.getMBeanByType("DeploymentManager");
        return objectName != null;
    }

    protected void syncNode() throws Exception {
        NodeSync nodeSync = NodeSync.createNodeSync();
        try {
            this.clientProps.setProperty("was.repository.root", this.configRoot);
            System.setProperty("com.ibm.ws.management.standalone", "true");
            this.clientProps.setProperty("nodeName", this.newNodeName);
            nodeSync.initialize(this.clientProps, null, null);
            this.issueMessage("ADMU0016I", null, null);
            Boolean bl = nodeSync.sync();
            if (!bl.booleanValue()) {
                throw new AdminException(this.getFormattedMessage("ADMU0005E", new Object[]{""}, null));
            }
        }
        catch (AdminException adminException) {
            Tr.error(tc, "ADMU0005E", adminException);
            throw adminException;
        }
    }

    protected Repository getLocalRepository() throws Exception {
        Vector vector;
        if (this.localRunTimeRepository == null && (vector = this.getServerList()) != null && vector.size() > 0) {
            this.setupServerRepository(this.cellName, (String)vector.elementAt(0));
        }
        return this.localRunTimeRepository;
    }

    private void setupServerRepository(String string, String string2) throws Exception {
        this.localRunTimeRepository = this.setupServerRepository(string, this.nodeName, string2);
        this.map = VariableMapFactory.createVariableMap(this.localRunTimeRepository);
        this.map.initialize(null);
    }

    private Repository setupServerRepository(String string, String string2, String string3) throws Exception {
        return RepositoryFactory.createRepository("ws-server", this.configRoot, string, string2, string3);
    }

    protected VariableMap getVariableMap() throws Exception {
        Vector vector;
        if (this.map == null && (vector = this.getServerList()) != null && vector.size() > 0) {
            this.setupServerRepository(this.cellName, (String)vector.elementAt(0));
        }
        return this.map;
    }

    public void fix390NodeSetupCmdLine(String string, String string2) throws Exception {
        File file = new File(string);
        String string3 = null;
        if (file.exists()) {
            Vector<String> vector = new Vector<String>();
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Cp1047"));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "line is " + string3);
                }
                if (string3 != null && string3.indexOf("WAS_NODE=") >= 0 && !string3.startsWith("#")) {
                    string3 = string3.substring(0, string3.indexOf("=") + 1) + string2;
                }
                vector.add(string3);
            }
            bufferedReader.close();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "Cp1047"));
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                printWriter.println((String)vector.get(i));
            }
            printWriter.flush();
            printWriter.close();
        } else {
            Tr.error(tc, "ADMU2003E", new Object[]{string});
        }
    }

    protected void fixNodeSetupCmdLine(String string, Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixNodeSetupCmdLine", new Object[]{string, properties});
        }
        String string2 = System.getProperty("os.name").toLowerCase();
        LaunchScriptPlatformCollaborator launchScriptPlatformCollaborator = LaunchScriptCollaboratorFactory.getCollaborator(string2);
        Tr.debug(tc, "LaunchScriptCollaborator: " + launchScriptPlatformCollaborator.getClass());
        String string3 = properties.getProperty("user.install.root") + "/bin/setupCmdLine";
        string3 = launchScriptPlatformCollaborator.customizeScriptFilename(string3);
        if (this.isZOS()) {
            this.fix390NodeSetupCmdLine(string3, string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "fixNodeSetupCmdLine");
            }
            return;
        }
        File file = new File(string3);
        if (file.exists()) {
            Vector<String> vector = new Vector<String>();
            FileInputStream fileInputStream = new FileInputStream(string3);
            BufferedReader bufferedReader = null;
            String string4 = EncodingUtils.getProperEncoding();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "*** returned readerencoding = " + string4);
            }
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, string4));
            String string5 = null;
            while ((string5 = bufferedReader.readLine()) != null) {
                if (string5.indexOf("WAS_NODE=") >= 0 && !string5.startsWith(launchScriptPlatformCollaborator.getPlatformComment())) {
                    string5 = string5.substring(0, string5.indexOf("=") + 1) + string;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "modified line in setupCmdLine: " + string5);
                    }
                }
                vector.add(string5);
            }
            bufferedReader.close();
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            PrintWriter printWriter = null;
            String string6 = EncodingUtils.getProperEncoding();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "*** returned writer encoding = " + string6);
            }
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream, string6));
            for (int i = 0; i < vector.size(); ++i) {
                string5 = (String)vector.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "line", string5);
                }
                printWriter.println((String)vector.get(i));
            }
            printWriter.flush();
            printWriter.close();
        } else {
            Tr.error(tc, "ADMU2003E", new Object[]{string3});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixNodeSetupCmdLine");
        }
    }
}

