/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.nodeagent.ConfigSynchronizationService;
import com.ibm.websphere.models.config.nodeagent.NodeAgent;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.management.tools.NodeFederationUtility;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.runtime.service.ConfigRoot;
import java.io.File;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Properties;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class NodeSyncUtility
extends NodeFederationUtility {
    private static TraceComponent tc = Tr.register(NodeSyncUtility.class, "Admin", "com.ibm.ws.management.resources.nodeutils");
    private static final String DEFAULT_TRACE_STRING = "com.ibm.ws.management.tools.*=all=enabled";
    private static final String DEFAULT_TRACE_FILE = "syncNode.log";
    private boolean stopservers = false;
    private boolean restart = false;
    private String localUserName = null;
    private String localPassword = null;

    public static void main(String[] stringArray) {
        Properties properties = System.getProperties();
        properties.put("com.ibm.WebSphere.main_class", "NodeSyncUtility");
        System.setProperties(properties);
        System.exit(new NodeSyncUtility().executeUtility(stringArray));
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        string = string + File.separator + "logs";
        string = string + File.separator + DEFAULT_TRACE_FILE;
        return string;
    }

    protected int getMinimumNumArgs() {
        return 4;
    }

    protected void issueUsageMessage() {
        this.issueMessage("ADMU0400I", null, null);
    }

    protected int parseUtilitySpecificOption(String[] stringArray, int n) {
        int n2 = n + 1;
        String string = stringArray[n];
        if (string.equals("-stopservers")) {
            this.stopservers = true;
        } else if (string.equals("-conntype")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.connType = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-localusername")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.localUserName = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-localpassword")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.localPassword = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-restart")) {
            this.restart = true;
        } else {
            n2 = -1;
        }
        return n2;
    }

    protected int runTool() throws Exception {
        Serializable serializable;
        block16: {
            if (!this.isMemberOfCell()) {
                this.issueMessage("ADMU2026E", new Object[]{this.nodeName}, null);
                return -1;
            }
            ConfigService configService = ConfigServiceFactory.getConfigService();
            if (configService == null) {
                try {
                    serializable = new Properties();
                    ((Properties)serializable).setProperty("location", "local");
                    configService = ConfigServiceFactory.createConfigService(true, (Properties)serializable);
                    Tr.debug(tc, "configService = " + configService.toString());
                }
                catch (AdminException adminException) {
                    if (!tc.isDebugEnabled()) break block16;
                    Tr.debug(tc, "Exception while creating a ConfigService", adminException);
                }
            }
        }
        this.adminClient = this.getAdminClient(this.getClientProperties());
        serializable = this.adminClient.getServerMBean();
        String string = ((ObjectName)serializable).getKeyProperty("cell");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Local node belongs to cell " + this.cellName + ", the cell to sync from is " + string);
        }
        if (!this.cellName.equals(string)) {
            throw new AdminException(this.getFormattedMessage("ADMU0005E", new Object[0], null));
        }
        ConfigServiceProxy configServiceProxy = new ConfigServiceProxy(this.adminClient);
        Session session = new Session();
        ObjectName[] objectNameArray = configServiceProxy.resolve(session, "Node=\"" + this.nodeName + "\"");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Node " + this.nodeName + " is resolved in cell " + string);
        }
        if (objectNameArray.length < 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...Not!");
            }
            throw new AdminException(this.getFormattedMessage("ADMU0005E", new Object[0], null));
        }
        this.collectNodeMetadata(this.adminClient);
        this.notificationService = this.getNotificationServiceMBean();
        this.issueMessage("ADMU0401I", new Object[]{this.nodeName, this.connHost, this.connPort}, null);
        this.checkProductExtensions(this.getWASProduct(), this.adminClient);
        if (this.stopservers) {
            ModelMgr.initialize("ws-server");
            if (this.localUserName != null && this.localPassword != null) {
                this.stopAllServers(this.localUserName, this.localPassword);
            } else {
                this.stopAllServers();
            }
        }
        if (!this.isDmgrSameOrLaterVersion()) {
            this.issueMessage("ADMU0127E", new String[]{this.getDMgrVersion(), Utils.getProductVersion()}, null);
            return -1;
        }
        if (this.isNodeAgentRunning()) {
            this.issueMessage("ADMU0403E", null, null);
            return -1;
        }
        this.syncNode(this.getSyncProperties());
        if (this.isZOS()) {
            this.transformConfig2Native(this.cellName, this.nodeName);
        }
        if (this.restart) {
            this.setupNodeAgentData(this.cellName);
            this.issueMessage("ADMU0018I", new Object[]{this.nodeName}, null);
            this.newCellName = this.cellName;
            this.launchNodeAgent();
        }
        this.issueMessage("ADMU0402I", new Object[]{this.nodeName, this.connHost, this.connPort}, null);
        return 0;
    }

    private boolean isNodeAgentRunning() throws Exception {
        ObjectName objectName = new ObjectName("WebSphere:*,type=NodeAgent,node=" + this.nodeName);
        return !this.adminClient.queryNames(objectName, null).isEmpty();
    }

    private Properties getSyncProperties() throws Exception {
        Object object;
        Properties properties = this.getClientProperties();
        ConfigRoot configRoot = this.getLocalRepository().getConfigRoot();
        String string = configRoot.getValue(4);
        configRoot.setValue(4, "nodeagent");
        Resource resource = configRoot.getResource(4, "server.xml");
        configRoot.setValue(4, string);
        Server server2 = null;
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            object = eList.get(i);
            if (!(object instanceof Server)) continue;
            server2 = (Server)object;
            break;
        }
        if (server2 != null) {
            EList eList2 = server2.getComponents();
            object = eList2.iterator();
            while (object.hasNext()) {
                Component component2 = (Component)object.next();
                if (!(component2 instanceof NodeAgent)) continue;
                NodeAgent nodeAgent = (NodeAgent)component2;
                ConfigSynchronizationService configSynchronizationService = nodeAgent.getFileSynchronizationService();
                EList eList3 = configSynchronizationService.getProperties();
                Iterator iterator = eList3.iterator();
                while (iterator.hasNext()) {
                    Property property = (Property)iterator.next();
                    properties.setProperty(property.getName(), property.getValue());
                }
                break block1;
            }
        }
        return properties;
    }

    protected void syncNode(Properties properties) throws Exception {
        NodeSync nodeSync = NodeSync.createNodeSync();
        try {
            properties.setProperty("was.repository.root", this.configRoot);
            System.setProperty("com.ibm.ws.management.standalone", "true");
            nodeSync.initialize(properties, null, this.getVariableMap());
            this.issueMessage("ADMU0016I", null, null);
            Boolean bl = nodeSync.sync();
            if (!bl.booleanValue()) {
                throw new AdminException(this.getFormattedMessage("ADMU0005E", new Object[]{""}, null));
            }
        }
        catch (AdminException adminException) {
            Tr.error(tc, "ADMU0005E", adminException);
            throw adminException;
        }
    }
}

