/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.management.tools.AdminTool;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class RestoreConfigUtility
extends AdminTool {
    private static TraceComponent tc = Tr.register(RestoreConfigUtility.class, "Admin", "com.ibm.ws.management.resources.nodeutils");
    private static final String DEFAULT_TRACE_STRING = "*=all=disabled";
    private static final String DEFAULT_TRACE_FILE = "restoreConfig.log";
    public static final int BUFFER_SIZE = 1024;
    private File restoreLocation;
    private String backupFileName;
    private boolean stopServers = true;
    private byte[] buffer = new byte[1024];
    private int numFilesRestored;
    private File retainFileList;
    private String appInstallDir;
    private boolean forceOption = false;
    private static final ResourceBundle APP_BUNDLE = ResourceBundle.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", Locale.getDefault());
    private static final String OPTIONAL = "optional:";

    public static void main(String[] stringArray) {
        System.exit(new RestoreConfigUtility().executeUtility(stringArray));
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        string = string + File.separator + "logs";
        string = string + File.separator + DEFAULT_TRACE_FILE;
        return string;
    }

    protected int getMinimumNumArgs() {
        return 4;
    }

    protected void issueUsageMessage() {
        this.issueMessage("ADMU5500I", null, null);
    }

    protected int parseRequiredArgs(String[] stringArray) {
        this.backupFileName = stringArray[3];
        return 4;
    }

    protected int parseUtilitySpecificOption(String[] stringArray, int n) {
        int n2 = n + 1;
        if (stringArray[n].equals("-nostop")) {
            this.stopServers = false;
        } else if (stringArray[n].equals("-force")) {
            this.forceOption = true;
        } else if (stringArray[n].equals("-location")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.restoreLocation = new File(stringArray[n + 1]);
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (stringArray[n].equals("-retainFileList")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.retainFileList = new File(stringArray[n + 1]);
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (stringArray[n].equals("-appInstallDir")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.appInstallDir = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
        } else {
            n2 = -1;
        }
        return n2;
    }

    protected int runTool() throws Exception {
        File file;
        if (this.restoreLocation == null) {
            this.restoreLocation = new File(this.configRoot);
        }
        if (!new File(this.backupFileName).exists()) {
            this.issueMessage("ADMU5501E", new Object[]{this.backupFileName}, null);
            return -1;
        }
        if (this.retainFileList != null && !this.retainFileList.exists()) {
            this.printMessage("File specified for retainFileList does not exist: " + this.retainFileList.getAbsolutePath());
            return -1;
        }
        if (this.appInstallDir != null) {
            boolean bl;
            file = new File(this.appInstallDir);
            if (file.exists() && !file.isDirectory()) {
                this.printMessage("Location for appInstallDir option is an existing file, needs to be a directory: " + this.appInstallDir);
                return -1;
            }
            if (!file.exists() && !(bl = file.mkdirs())) {
                this.printMessage("Directory structure could not be created for: " + this.appInstallDir);
                return -1;
            }
        }
        ModelMgr.initialize("ws-server");
        file = null;
        if (this.stopServers) {
            this.stopAllServers();
        }
        File file2 = null;
        if (this.restoreLocation.exists()) {
            file2 = this.getUniqueDirectory(this.restoreLocation);
            this.issueMessage("ADMU5502I", new Object[]{this.restoreLocation, file2}, null);
            boolean bl = this.renameRestoreLocation(file2);
            if (!bl) {
                this.issueMessage("ADMU5503E", null, null);
                return -1;
            }
        }
        this.issueMessage("ADMU5505I", new Object[]{this.backupFileName, this.restoreLocation}, null);
        this.ckCellNameAgainstFile();
        this.uncompressConfigDir();
        this.issueMessage("ADMU5506I", new Object[]{new Integer(this.numFilesRestored)}, null);
        this.restoreAppBinaries();
        this.removeExistingWorkSpace();
        if (file2 != null && this.retainFileList != null) {
            this.restoreFromRetainFileList(file2, this.restoreLocation, this.retainFileList);
        }
        return 0;
    }

    private File getUniqueDirectory(File file) {
        int n = 1;
        File file2 = new File(file + ".old");
        while (file2.exists()) {
            file2 = new File(file + ".old_" + String.valueOf(n++));
        }
        return file2;
    }

    private boolean renameRestoreLocation(File file) {
        boolean bl = this.restoreLocation.renameTo(file);
        if (bl) {
            this.issueMessage("ADMU5504I", null, null);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ckCellNameAgainstFile() throws IOException {
        ZipEntry zipEntry;
        String string = "cells" + File.separatorChar + this.cellName + File.separatorChar;
        FileInputStream fileInputStream = new FileInputStream(this.backupFileName);
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(fileInputStream));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (!zipEntry.getName().startsWith(string)) continue;
            return;
        }
        if (this.forceOption) {
            this.issueMessage("ADMU7006W", new Object[]{string}, null);
            return;
        }
        this.issueMessage("ADMU7005E", new Object[]{string}, null);
        System.exit(1);
    }

    private void uncompressConfigDir() throws IOException {
        try {
            ZipEntry zipEntry;
            BufferedOutputStream bufferedOutputStream = null;
            FileInputStream fileInputStream = new FileInputStream(this.backupFileName);
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(fileInputStream));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n;
                if (!this.isQuiet()) {
                    System.out.print('.');
                }
                byte[] byArray = new byte[1024];
                File file = new File(this.restoreLocation, zipEntry.getName());
                file.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 1024);
                while ((n = zipInputStream.read(byArray, 0, 1024)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                ++this.numFilesRestored;
            }
            zipInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipFile(ZipEntry zipEntry, ZipFile zipFile) throws IOException {
        if (!this.isQuiet()) {
            System.out.print('.');
        }
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        File file = new File(this.restoreLocation, zipEntry.getName());
        file.getParentFile().mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            int n = 0;
            while ((n = inputStream.read(this.buffer)) > -1) {
                fileOutputStream.write(this.buffer, 0, n);
            }
        }
        finally {
            fileOutputStream.close();
            inputStream.close();
        }
        ++this.numFilesRestored;
    }

    public String getBackupFileName() {
        return this.backupFileName;
    }

    public void restoreAppBinaries() {
        this.issueMessage("ADMU6001I", null, "Begin restoring application binaries..");
        try {
            String string;
            Object object;
            Object object2;
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", Locale.getDefault());
            Resource resource = this.getResource("nodes/" + this.nodeName + "/serverindex.xml", "serverindex.xml", resourceBundle);
            if (resource == null) {
                return;
            }
            VariableMap variableMap = this.createVarMap();
            Hashtable hashtable = new Hashtable();
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            for (int i = 0; i < eList.size(); ++i) {
                object2 = (ServerEntry)eList.get(i);
                object = object2.getDeployedApplications();
                for (int j = 0; j < object.size(); ++j) {
                    string = (String)object.get(j);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "si: " + string);
                    }
                    if (string.indexOf(47) == -1 || string.indexOf(47) == string.lastIndexOf(47)) continue;
                    String string2 = string.substring(0, string.indexOf(47));
                    Tr.debug(tc, "ear name: " + string2);
                    Resource resource2 = this.getResource("applications/" + string + "/deployment.xml", "deployment.xml", resourceBundle);
                    Deployment deployment = (Deployment)resource2.getContents().get(0);
                    ApplicationDeployment applicationDeployment = (ApplicationDeployment)deployment.getDeployedObject();
                    if (applicationDeployment.isZeroEarCopy()) {
                        Tr.debug(tc, "Notice: " + string2 + " is installed as a systemapp using zeroEarCopy option.\n " + "Since the " + string2 + " binary does not exist in config repository, we do not try to expand it.\n" + "The " + string2 + " should already be expanded in systemApps directory.");
                        continue;
                    }
                    Vector<String> vector = (Vector<String>)hashtable.get(string2);
                    if (vector == null) {
                        vector = new Vector<String>();
                        hashtable.put(string2, vector);
                    }
                    try {
                        if (!((ApplicationDeployment)deployment.getDeployedObject()).isEnableDistribution()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "app at " + string + " has distrib disabled, hence skipping");
                            }
                            resource2.unload();
                            continue;
                        }
                        String string3 = ((ApplicationDeployment)deployment.getDeployedObject()).getBinariesURL();
                        if (this.appInstallDir != null) {
                            string3 = this.appInstallDir + "/" + string.substring(string.lastIndexOf(47) + 1);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "New path for " + string + " is -> " + string3);
                            }
                            ((ApplicationDeployment)deployment.getDeployedObject()).setBinariesURL(string3);
                            resource2.save(new HashMap());
                        }
                        string3 = this.normalizePath(variableMap, string3);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "path: " + string3);
                        }
                        if (!vector.contains(string3)) {
                            vector.addElement(string3);
                        }
                        resource2.unload();
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.issueMessage("ADMU7004E", new Object[]{string, string2, throwable}, "ADMU7004E=ADMU7004E: Unexpected exception while building cache entry for " + string + ". Exception is: " + throwable + " All the related binaries may not be deleted/updated.");
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "table: " + hashtable);
            }
            resource.unload();
            Enumeration enumeration = hashtable.keys();
            object2 = this.configRoot + "/cells/" + this.cellName + "/applications/";
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                Vector vector = (Vector)hashtable.get(object);
                if (vector.size() == 0) continue;
                object = (String)object2 + (String)object + "/" + (String)object;
                string = null;
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting ear: " + (String)object);
                    }
                    string = EarUtils.getEarFile((String)object, false, true);
                }
                catch (Throwable throwable) {
                    this.issueMessage("ADMU7008E", new Object[]{object, vector, throwable}, "ADMU7008E=ADMU7008E: Unexpected exception in expandEar. The ear file " + (String)object + " will not be extracted in following " + "paths " + vector + ". Exception: " + throwable);
                }
                if (string == null) continue;
                for (int i = 0; i < vector.size(); ++i) {
                    try {
                        EarUtils.extractEar((EARFile)string, (String)vector.elementAt(i), true);
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.issueMessage("ADMU7008E", new Object[]{object, vector.elementAt(i), throwable}, "ADMU7008E=ADMU7008E: Unexpected exception in expandEar. The ear file " + (String)object + " will not be extracted in following " + "paths " + vector.elementAt(i) + ". Exception: " + throwable);
                    }
                }
                string.close();
            }
        }
        catch (Throwable throwable) {
            this.issueMessage("ADMU6012I", new Object[]{throwable}, "Exception in app restore: " + throwable);
        }
        this.issueMessage("ADMU6009I", null, "ADMU6009I: Processing complete.");
    }

    private VariableMap createVarMap() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createVarMap");
        }
        Repository repository2 = RepositoryFactory.createRepository("ws-server", this.configRoot, this.cellName, this.nodeName, null);
        VariableMap variableMap = VariableMapFactory.createVariableMap(repository2);
        variableMap.initialize(null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createVarMap: " + variableMap);
        }
        return variableMap;
    }

    protected ResourceSet createResourceSet(final String string) {
        WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
        URIConverterImpl uRIConverterImpl = new URIConverterImpl(){

            public URI normalize(URI uRI) {
                if (uRI.isRelative()) {
                    return uRI.resolve(URI.createFileURI((String)(string + File.separator)));
                }
                return super.normalize(uRI);
            }
        };
        wASResourceSetImpl.setURIConverter((URIConverter)uRIConverterImpl);
        return wASResourceSetImpl;
    }

    private Resource getResource(String string, String string2, ResourceBundle resourceBundle) {
        String string3 = this.configRoot + "/cells/" + this.cellName + "/" + string;
        try {
            ResourceSet resourceSet = this.createResourceSet(this.configRoot);
            URI uRI = URI.createFileURI((String)string3);
            Resource resource = resourceSet.getResource(uRI, true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "res for: " + string3 + " is: " + resource);
            }
            return resource;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected exception loading " + string3 + " as resource: " + throwable);
            }
            return null;
        }
    }

    private String normalizePath(VariableMap variableMap, String string) {
        String string2 = variableMap.expand(string);
        string2 = string2.replace('/', File.separatorChar);
        string2 = string2.replace('\\', File.separatorChar);
        return string2;
    }

    protected String getFormattedMessage(String string, Object[] objectArray, String string2) {
        if (string == null || !string.startsWith("ADMA")) {
            return super.getFormattedMessage(string, objectArray, string2);
        }
        try {
            String string3 = APP_BUNDLE.getString(string);
            if (string3 == null) {
                return string2;
            }
            return MessageFormat.format(string3, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            if (string2 == null) {
                return string2;
            }
            return MessageFormat.format(string2, objectArray);
        }
        catch (NullPointerException nullPointerException) {
            return string2;
        }
    }

    private void removeExistingWorkSpace() {
        String string = this.getUserInstallRoot() + File.separator + "wstemp";
        String string2 = "workspace";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removing Existing WorkSpace(s) in " + string);
        }
        try {
            File file = new File(string);
            if (file.exists() && file.isDirectory()) {
                this.searchAndRemoveWorkSpace(file, string2, 0);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error: either " + string + " does not exist or it is a file");
            }
        }
        catch (Throwable throwable) {
            Tr.debug(tc, "Error: Hit an exception when removing workspace :" + throwable.toString());
        }
    }

    protected String getUserInstallRoot() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        if (File.separator.equals("/")) {
            string = string.replace('\\', '/');
        } else if (File.separator.equals("\\")) {
            string = string.replace('/', '\\');
        }
        return string;
    }

    private void searchAndRemoveWorkSpace(File file, String string, int n) throws IOException {
        ++n;
        String[] stringArray = null;
        try {
            stringArray = file.list();
        }
        catch (SecurityException securityException) {
            Tr.debug(tc, "The directory: " + file.getAbsolutePath() + " has a securityViolation and is not accessible.");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (!file2.isDirectory()) continue;
            if (stringArray[i].equals(string) && n >= 2) {
                this.removeWholeDirectory(file2);
                continue;
            }
            if (n >= 2) continue;
            this.searchAndRemoveWorkSpace(file2, string, n);
        }
    }

    private void removeWholeDirectory(File file) throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removing workspace in " + file.getAbsolutePath());
        }
        String[] stringArray = null;
        try {
            stringArray = file.list();
        }
        catch (SecurityException securityException) {
            String string = file.getAbsolutePath();
            Tr.debug(tc, "The directory: " + string + " has a securityViolation. Not accessible.");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                this.removeWholeDirectory(file2);
                continue;
            }
            if (file2.delete()) continue;
            String string = file2.getAbsolutePath();
            Tr.debug(tc, "Error: File can not be removed: " + file2.getAbsolutePath());
        }
        if (!file.delete()) {
            Tr.debug(tc, "Error: Directory can not be removed: " + file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreFromRetainFileList(File file, File file2, File file3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreFromRetainFileList " + file + ", " + file2 + ", " + file3);
        }
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = new FileReader(file3);
            bufferedReader = new BufferedReader(fileReader);
            while (bufferedReader.ready()) {
                String string = bufferedReader.readLine();
                if (string == null) {
                    break;
                }
                String string2 = string.trim();
                if (string2.length() == 0 || string2.startsWith("#")) continue;
                Boolean bl = Boolean.FALSE;
                if (string2.startsWith(OPTIONAL)) {
                    bl = Boolean.TRUE;
                    string2 = string2.substring(OPTIONAL.length()).trim();
                }
                hashtable.put(string2, bl);
            }
        }
        catch (Throwable throwable) {
            this.printMessage("Error reading retainFileList " + throwable);
            return;
        }
        finally {
            block29: {
                block28: {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {
                            if (!tc.isDebugEnabled()) break block28;
                            Tr.debug(tc, "exception closing buffered reader for retainList: " + file3);
                        }
                    }
                }
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException iOException) {
                        if (!tc.isDebugEnabled()) break block29;
                        Tr.debug(tc, "exception closing input stream for retainList: " + file3);
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "files table = " + hashtable);
        }
        if (hashtable.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "restoreFromRetainFileList");
            }
            return;
        }
        this.recurseAndRestore(file.getAbsolutePath(), file, file2, hashtable);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreFromRetainFileList");
        }
    }

    private void recurseAndRestore(String string, File file, File file2, Hashtable hashtable) {
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string2 = fileArray[i].getAbsolutePath().substring(string.length() + 1).replace('\\', '/');
            if (hashtable.get(string2) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Retain entry: " + string2);
                }
                Boolean bl = (Boolean)hashtable.get(string2);
                if (fileArray[i].isFile()) {
                    try {
                        if (Boolean.TRUE.equals(bl) && new File(file2 + "/" + string2).exists()) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Optional file exists in destination location, skipping - " + string2);
                            continue;
                        }
                        RestoreConfigUtility.copyFile(fileArray[i], file2 + "/" + string2);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    continue;
                }
                if (!fileArray[i].isDirectory()) continue;
                try {
                    this.copyDir(fileArray[i], string, file2.getAbsolutePath(), hashtable, bl);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                continue;
            }
            if (!fileArray[i].isDirectory()) continue;
            this.recurseAndRestore(string, fileArray[i], file2, hashtable);
        }
    }

    public void copyDir(File file, String string, String string2, Hashtable hashtable, Boolean bl) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Copying dir ..: " + file.getAbsolutePath());
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string3 = fileArray[i].getAbsolutePath().substring(string.length() + 1).replace('\\', '/');
            Boolean bl2 = (Boolean)hashtable.get(string3);
            if (bl2 == null) {
                bl2 = bl;
            }
            if (fileArray[i].isFile()) {
                String string4 = string2 + fileArray[i].getAbsolutePath().substring(string.length());
                if (Boolean.TRUE.equals(bl2) && new File(string4).exists()) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Optional file exists in destination location, skipping - " + string3);
                    continue;
                }
                RestoreConfigUtility.copyFile(fileArray[i], string4);
                continue;
            }
            if (!fileArray[i].isDirectory()) continue;
            this.copyDir(fileArray[i], string, string2, hashtable, bl2);
        }
    }

    public static void copyFile(File file, String string) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Copying..: " + file.getAbsolutePath() + " to " + string);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        RestoreConfigUtility.copyFile(fileInputStream, string);
        fileInputStream.close();
    }

    public static void copyFile(InputStream inputStream, String string) throws Exception {
        File file = new File(string);
        file.getParentFile().mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[4096];
        int n = inputStream.read(byArray);
        while (n != -1) {
            fileOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
    }
}

