/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.models.config.adminservice.JMXConnector;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.cellmanager.CellManager;
import com.ibm.websphere.models.config.messagingserver.JMSServer;
import com.ibm.websphere.models.config.nodeagent.NodeAgent;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.management.tools.AdminTool;
import com.ibm.ws.management.tools.GenericServerProcHelper;
import com.ibm.ws.management.tools.LaunchUtils;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class ServerStatus
extends AdminTool {
    private static TraceComponent tc = Tr.register(ServerStatus.class, "Admin", "com.ibm.ws.management.resources.nodeutils");
    private static final String DEFAULT_TRACE_STRING = "*=all=disabled";
    private static final String DEFAULT_TRACE_FILE = "serverStatus.log";
    private boolean allservers = false;
    private AdminClient adminClient = null;
    private ServerIdentifiers sid = null;
    private static final String WSSERVER_CLASS = "com.ibm.ws.runtime.WsServer";
    private VariableMap variableMap = null;
    private Repository repository = null;

    public static void main(String[] stringArray) {
        System.exit(new ServerStatus().executeUtility(stringArray));
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        string = string + File.separator + "logs";
        if (!this.allservers) {
            string = string + File.separator + this.sid.getServerName();
        }
        string = string + File.separator + DEFAULT_TRACE_FILE;
        return string;
    }

    protected int getMinimumNumArgs() {
        return 4;
    }

    protected boolean isValidMinimumArgument(String string) {
        return !string.startsWith("-") || string.equals("-all");
    }

    protected void issueUsageMessage() {
        this.issueMessage("ADMU0502I", null, null);
    }

    protected int parseRequiredArgs(String[] stringArray) {
        this.sid = new ServerIdentifiers();
        this.sid.setConfigRoot(stringArray[0]);
        this.sid.setCellName(stringArray[1]);
        this.sid.setNodeName(stringArray[2]);
        if (stringArray[3].equals("-all")) {
            this.allservers = true;
        } else {
            this.sid.setServerName(stringArray[3]);
        }
        return 4;
    }

    protected int runTool() throws Exception {
        String string = "all servers";
        if (!this.allservers) {
            string = this.sid.getServerName();
            if (!this.serverConfigExists(this.sid)) {
                this.issueMessage("ADMU0522E", new Object[]{this.sid.getServerName()}, null);
                return -1;
            }
        }
        if (!this.allservers) {
            this.issueMessage("ADMU0500I", new Object[]{string}, null);
        } else {
            this.issueMessage("ADMU0503I", null, null);
        }
        Vector<String> vector = null;
        if (this.allservers) {
            vector = this.getServers();
        } else {
            vector = new Vector<String>();
            vector.add(this.sid.getServerName());
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.get(i);
            this.getStatus(string2);
        }
        return 0;
    }

    private void getStatus(String string) {
        block9: {
            AdminClient adminClient = null;
            this.sid.setServerName(string);
            try {
                this.repository = RepositoryFactory.createRepository("ws-server", this.sid.getConfigRoot(), this.sid.getCellName(), this.sid.getNodeName(), this.sid.getServerName());
                this.variableMap = VariableMapFactory.createVariableMap(this.repository);
                this.variableMap.initialize(null);
                Resource resource = this.repository.getConfigRoot().getResource(4, "server.xml");
                if (GenericServerProcHelper.isServerAWebServer(this.sid)) {
                    String string2 = GenericServerProcHelper.getStatusUsingPing(this.sid);
                    this.issueMessage("ADMU0508I", new Object[]{"Web server", string, string2}, null);
                    return;
                }
                if (GenericServerProcHelper.isServerAGenericServer(this.sid)) {
                    String string3 = GenericServerProcHelper.getStatusUsingPidFile(this.sid);
                    this.issueMessage("ADMU0508I", new Object[]{"generic server", string, string3}, null);
                    return;
                }
                String string4 = this.getServerType(resource);
                JMXConnector jMXConnector = LaunchUtils.getJMXConnector(resource);
                if (jMXConnector != null) {
                    try {
                        adminClient = LaunchUtils.getAdminClient(this.repository, jMXConnector, this.userid, this.pwd);
                    }
                    catch (Exception exception) {
                        this.issueMessage("ADMU0509I", new Object[]{string4, string}, null);
                        return;
                    }
                }
                if (adminClient == null) break block9;
                String string5 = null;
                try {
                    string5 = this.getServerStatus(adminClient);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this.issueMessage("ADMU0002E", new Object[]{string, outOfMemoryError}, null);
                    Tr.error(tc, "ADMU0002E", new Object[]{string, outOfMemoryError});
                    return;
                }
                this.issueMessage("ADMU0508I", new Object[]{string4, string, string5}, null);
            }
            catch (Exception exception) {
                Tr.error(tc, "ADMU0002E", new Object[]{this.sid.getServerName(), exception});
                this.issueMessage("ADMU0002E", new Object[]{string, exception}, null);
            }
        }
    }

    private String getServerType(Resource resource) {
        Server server2 = (Server)resource.getContents().get(0);
        EList eList = server2.getComponents();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Component component2 = (Component)iterator.next();
            if (component2 instanceof CellManager) {
                return "Deployment Manager";
            }
            if (component2 instanceof NodeAgent) {
                return "Node Agent";
            }
            if (component2 instanceof ApplicationServer) {
                return "Application Server";
            }
            if (!(component2 instanceof JMSServer)) continue;
            return "JMS Server";
        }
        return "Server";
    }

    private String getServerStatus(AdminClient adminClient) throws Exception {
        String string = null;
        ObjectName objectName = this.getServerHandle(adminClient);
        string = objectName != null ? (String)adminClient.getAttribute(objectName, "state") : "RUNTIME/CONFIG MISMATCH";
        return string;
    }

    private boolean serverConfigExists(ServerIdentifiers serverIdentifiers) {
        boolean bl = false;
        String string = serverIdentifiers.getConfigRoot() + "/cells/" + serverIdentifiers.getCellName() + "/nodes/" + serverIdentifiers.getNodeName() + "/servers/" + serverIdentifiers.getServerName();
        File file = new File(string);
        if (file.exists()) {
            bl = true;
        }
        return bl;
    }
}

