/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.models.config.properties.PropertiesFactory;
import com.ibm.websphere.models.config.properties.PropertiesPackage;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.properties.PropertySet;
import com.ibm.websphere.resource.WASResourceSetImpl;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class ServerTemplateBuilder {
    protected String configRoot;
    protected String fileURI;
    protected PropertiesFactory propFactory;

    public void setConfigRoot(String string) {
        this.configRoot = string;
    }

    public void setFileName(String string) {
        this.fileURI = string;
    }

    public ServerTemplateBuilder() {
        this.initializeFactories();
    }

    private PropertySet createZOSV5defaultTemplate() {
        PropertySet propertySet = this.propFactory.createPropertySet();
        Property property = this.propFactory.createProperty();
        property.setName("name");
        property.setValue("defaultZOS_5X");
        propertySet.getProperties().add((Object)property);
        property = this.propFactory.createProperty();
        property.setName("com.ibm.websphere.baseProductVersion");
        property.setValue("5.0.0.0");
        propertySet.getProperties().add((Object)property);
        property = this.propFactory.createProperty();
        property.setName("com.ibm.websphere.baseProductMinorVersion");
        property.setValue("0.0.0");
        propertySet.getProperties().add((Object)property);
        property = this.propFactory.createProperty();
        property.setName("com.ibm.websphere.nodeOperatingSystem");
        property.setValue("os390");
        propertySet.getProperties().add((Object)property);
        property = this.propFactory.createProperty();
        property.setName("com.ibm.websphere.baseProductMajorVersion");
        property.setValue("5");
        propertySet.getProperties().add((Object)property);
        property = this.propFactory.createProperty();
        property.setName("description");
        property.setValue("");
        propertySet.getProperties().add((Object)property);
        property = this.propFactory.createProperty();
        property.setName("isSystemTemplate");
        property.setValue("true");
        propertySet.getProperties().add((Object)property);
        property = this.propFactory.createProperty();
        property.setName("isDefaultTemplate");
        property.setValue("true");
        propertySet.getProperties().add((Object)property);
        return propertySet;
    }

    private PropertySet createV5defaultTemplate() {
        PropertySet propertySet = this.propFactory.createPropertySet();
        Property property = this.propFactory.createProperty();
        property.setName("name");
        property.setValue("default_5X");
        propertySet.getProperties().add((Object)property);
        property = this.propFactory.createProperty();
        property.setName("com.ibm.websphere.baseProductVersion");
        property.setValue("5.0.0");
        propertySet.getProperties().add((Object)property);
        property = this.propFactory.createProperty();
        property.setName("com.ibm.websphere.baseProductMinorVersion");
        property.setValue("0.0");
        propertySet.getProperties().add((Object)property);
        property = this.propFactory.createProperty();
        property.setName("com.ibm.websphere.nodeOperatingSystem");
        property.setValue("");
        propertySet.getProperties().add((Object)property);
        property = this.propFactory.createProperty();
        property.setName("com.ibm.websphere.baseProductMajorVersion");
        property.setValue("5");
        propertySet.getProperties().add((Object)property);
        property = this.propFactory.createProperty();
        property.setName("description");
        property.setValue("");
        propertySet.getProperties().add((Object)property);
        property = this.propFactory.createProperty();
        property.setName("isSystemTemplate");
        property.setValue("true");
        propertySet.getProperties().add((Object)property);
        property = this.propFactory.createProperty();
        property.setName("isDefaultTemplate");
        property.setValue("true");
        propertySet.getProperties().add((Object)property);
        return propertySet;
    }

    public void addV5Templates() {
        try {
            List list = this.readTemplateFile();
            list.add(this.createV5defaultTemplate());
            list.add(this.createZOSV5defaultTemplate());
            this.writeTemplateFile(list);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initializeFactories() {
        CommonarchiveFactoryImpl.getActiveFactory();
        ArchiveInit.init();
        ConfigInit.init();
        PropertiesPackage propertiesPackage = (PropertiesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/properties.xmi");
        this.propFactory = propertiesPackage.getPropertiesFactory();
    }

    private ResourceSet getResourceSet() {
        WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
        URIConverterImpl uRIConverterImpl = new URIConverterImpl(){

            public URI normalize(URI uRI) {
                if (uRI.isRelative()) {
                    return uRI.resolve(URI.createFileURI((String)(ServerTemplateBuilder.this.configRoot + File.separator)));
                }
                return super.normalize(uRI);
            }
        };
        wASResourceSetImpl.setURIConverter((URIConverter)uRIConverterImpl);
        return wASResourceSetImpl;
    }

    private void writeTemplateFile(List list) {
        try {
            ResourceSet resourceSet = this.getResourceSet();
            URI uRI = URI.createFileURI((String)this.fileURI);
            Resource resource = resourceSet.createResource(uRI);
            resource.getContents().addAll((Collection)list);
            resource.save(new HashMap());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private List readTemplateFile() {
        try {
            ResourceSet resourceSet = this.getResourceSet();
            URI uRI = URI.createFileURI((String)this.fileURI);
            Resource resource = resourceSet.createResource(uRI);
            resource.load(new HashMap());
            EList eList = resource.getContents();
            return eList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        ServerTemplateBuilder serverTemplateBuilder = new ServerTemplateBuilder();
        String string = System.getProperty("user.install.root");
        string = string + File.separator + "config";
        String string2 = string + File.separator + "templates" + File.separator + "servertypes" + File.separator + "APPLICATION_SERVER" + File.separator + "template-metadata.xml";
        System.out.println("Adding V5 templates in " + string2);
        serverTemplateBuilder.setConfigRoot(string);
        serverTemplateBuilder.setFileName(string2);
        serverTemplateBuilder.addV5Templates();
    }
}

