/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.websphere.models.util.WASEcoreUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.RefObjectHelperFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class UnmanagedNode {
    private static final String DEFAULT_NODE_VERSION = "6.1.0.0";
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.unnodeutils";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private WorkSpace workSpace = null;
    private Session session = null;
    private String nodeName = null;
    private String hostName = null;
    private String cellName = null;
    private RepositoryContext cellContext = null;
    private RepositoryContext nodeContext = null;
    private static final String nodeXML = "node.xml";
    private static final String serverIndexXML = "serverindex.xml";
    static final String NODE_PROPERTIES = "node-metadata.properties";
    private Properties nodeProperties = new Properties();
    private static TraceComponent tc = Tr.register(UnmanagedNode.class, "Admin", "com.ibm.ws.management.resources.unmgdnodeutils");

    UnmanagedNode(Session session, String string) throws WorkSpaceException, AdminException, IOException {
        this.session = session;
        this.nodeName = string;
        this.workSpace = WorkspaceHelper.getWorkspace(session);
        this.cellName = UnmanagedNode.getTheCellName(this.workSpace);
        this.removeNode();
    }

    UnmanagedNode(Session session, String string, String string2, String string3) throws WorkSpaceException, FileNotFoundException, IOException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "UnmanagedNode()");
        }
        this.session = session;
        this.nodeName = string;
        this.hostName = string2;
        if (!this.isValidPlatform(string3)) {
            throw new AdminException(this.getFormattedMessage("ADMK0203E", null, null));
        }
        this.nodeProperties.setProperty("com.ibm.websphere.nodeOperatingSystem", string3);
        String string4 = this.getVersion(UnmanagedNode.findDmgrNode(session));
        this.nodeProperties.setProperty("com.ibm.websphere.baseProductVersion", string4);
        this.workSpace = WorkspaceHelper.getWorkspace(session);
        this.cellName = UnmanagedNode.getTheCellName(this.workSpace);
        this.addNode();
        this.createManagedObjectMetadataPropertiesFile();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UnmanagedNode()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createManagedObjectMetadataPropertiesFile() throws IOException, FileNotFoundException, WorkSpaceException {
        String string = this.nodeContext.getPath() + File.separator + NODE_PROPERTIES;
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        try {
            this.nodeProperties.store(fileOutputStream, null);
        }
        finally {
            fileOutputStream.close();
        }
        this.nodeContext.notifyChanged(0, NODE_PROPERTIES);
    }

    private boolean isValidPlatform(String string) {
        String[] stringArray = new String[]{"os400", "aix", "hpux", "linux", "solaris", "windows", "os390"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private void addNode() throws WorkSpaceException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNode()");
        }
        String string = nodeXML;
        String string2 = serverIndexXML;
        RepositoryContext repositoryContext = null;
        repositoryContext = this.workSpace.findContext(this.cellName);
        this.nodeContext = this.workSpace.findContext(this.cellName + "/nodes/" + this.nodeName);
        if (this.nodeContext != null) {
            throw new AdminException(this.getFormattedMessage("ADMK0204E", null, null));
        }
        try {
            this.nodeContext = repositoryContext.create(RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("nodes"), this.nodeName);
        }
        catch (Exception exception) {
            Tr.error(tc, "caught exception creating node context: " + exception);
        }
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/topology.node.xmi");
        EFactory eFactory = ePackage.getEFactoryInstance();
        EClassifier eClassifier = ePackage.getEClassifier("Node");
        Node node = (Node)eFactory.create((EClass)eClassifier);
        node.setName(this.nodeName);
        String string3 = UnmanagedNode.makeTemporary((EObject)node);
        Node node2 = (Node)UnmanagedNode.getTemporaryObject(string3);
        String string4 = this.jmakeChild(this.workSpace, this.nodeContext.getURI(), nodeXML, (EObject)node2, string);
        ePackage = EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/serverindex.xmi");
        eFactory = ePackage.getEFactoryInstance();
        eClassifier = ePackage.getEClassifier("ServerIndex");
        ServerIndex serverIndex = (ServerIndex)eFactory.create((EClass)eClassifier);
        serverIndex.setHostName(this.hostName);
        string3 = UnmanagedNode.makeTemporary((EObject)serverIndex);
        ServerIndex serverIndex2 = (ServerIndex)UnmanagedNode.getTemporaryObject(string3);
        string4 = this.jmakeChild(this.workSpace, this.nodeContext.getURI(), serverIndexXML, (EObject)serverIndex2, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNode()");
        }
    }

    private String jmakeChild(WorkSpace workSpace, String string, String string2, EObject eObject, String string3) {
        EList eList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jmakeChild()");
        }
        RepositoryContext repositoryContext = null;
        Resource resource = null;
        String string4 = null;
        String string5 = UnmanagedNode.decodeContextUri(string);
        try {
            repositoryContext = workSpace.findContext(string5);
        }
        catch (WorkSpaceException workSpaceException) {
            Tr.error(tc, "error in finding context " + workSpaceException.toString());
            return null;
        }
        Tr.audit(tc, "Context" + repositoryContext.getURI());
        Tr.audit(tc, "resourceUri " + string2);
        ResourceSet resourceSet = repositoryContext.getResourceSet();
        if (!repositoryContext.isAvailable(string3)) {
            Tr.audit(tc, "File " + string3 + " was not available in context, " + repositoryContext.getURI());
            eList = workSpace.getResourceFactoryRegistry().getFactory(URI.createURI((String)string3));
            resource = eList.createResource(URI.createURI((String)string3));
            resourceSet.getResources().add((Object)resource);
        }
        if (eObject.eResource() != null) {
            ((XMIResource)eObject.eResource()).setID(eObject, null);
        }
        eList = resource.getContents();
        eList.add(eObject);
        try {
            resource.save(new HashMap());
            string4 = ((XMIResource)eObject.eResource()).getID(eObject);
        }
        catch (Exception exception) {
            Tr.error(tc, "error in saving resource for root object " + exception.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jmakeChild()");
        }
        return string4;
    }

    private static String decodeContextUri(String string) {
        String string2 = null;
        if (string == null) {
            return string2;
        }
        string2 = string.replace(':', '/');
        return string2;
    }

    private static EObject getTemporaryObject(String string) {
        EObject eObject = RefObjectHelperFactory.getRefObjectHelper().getTemporaryObject(string);
        return eObject;
    }

    private static String makeTemporary(EObject eObject) {
        String string = RefObjectHelperFactory.getRefObjectHelper().makeTemporary(eObject);
        return string;
    }

    private static String getTheCellName(WorkSpace workSpace) throws WorkSpaceException {
        RepositoryContextType repositoryContextType = workSpace.getMetaData().getContextType("cells");
        Collection collection = workSpace.findContext(repositoryContextType);
        Iterator iterator = collection.iterator();
        RepositoryContext repositoryContext = (RepositoryContext)iterator.next();
        return repositoryContext.getURI();
    }

    private boolean isManaged(ServerIndex serverIndex) {
        boolean bl = false;
        EList eList = serverIndex.getServerEntries();
        for (int i = 0; i < eList.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            if (!serverEntry.getServerType().equalsIgnoreCase("NODE_AGENT") && !serverEntry.getServerType().equalsIgnoreCase("DEPLOYMENT_MANAGER")) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private String getFormattedMessage(String string, Object[] objectArray, String string2) {
        try {
            String string3 = RESOURCE_BUNDLE.getString(string);
            if (string3 == null) {
                return string2;
            }
            return MessageFormat.format(string3, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            if (string2 == null) {
                return string2;
            }
            return MessageFormat.format(string2, objectArray);
        }
        catch (NullPointerException nullPointerException) {
            return string2;
        }
    }

    public static List listUnmanagedNodes(Session session) throws ConfigServiceException, WorkSpaceException, IOException {
        boolean bl = true;
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        ArrayList<String> arrayList = new ArrayList<String>();
        RepositoryContextType repositoryContextType = workSpace.getMetaData().getContextType("nodes");
        Collection collection = workSpace.findContext(repositoryContextType);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext = (RepositoryContext)iterator.next();
            WorkSpaceFile workSpaceFile = null;
            try {
                workSpaceFile = repositoryContext.getFile(serverIndexXML);
            }
            catch (Throwable throwable) {
                continue;
            }
            if (workSpaceFile == null) continue;
            Resource resource = repositoryContext.getResourceSet().createResource(URI.createURI((String)serverIndexXML));
            resource.load(new HashMap());
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            bl = false;
            EList eList = serverIndex.getServerEntries();
            for (int i = 0; i < eList.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)eList.get(i);
                String string = serverEntry.getServerType();
                if (string.equals("NODE_AGENT")) {
                    bl = true;
                    break;
                }
                if (!string.equals("DEPLOYMENT_MANAGER")) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            String string = repositoryContext.getURI();
            string.substring(string.lastIndexOf("/") + 1);
            arrayList.add(string.substring(string.lastIndexOf("/") + 1));
        }
        return arrayList;
    }

    public static List listManagedNodes(Session session) throws ConfigServiceException, WorkSpaceException, IOException {
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        ArrayList<String> arrayList = new ArrayList<String>();
        RepositoryContextType repositoryContextType = workSpace.getMetaData().getContextType("nodes");
        Collection collection = workSpace.findContext(repositoryContextType);
        Iterator iterator = collection.iterator();
        block2: while (iterator.hasNext()) {
            RepositoryContext repositoryContext = (RepositoryContext)iterator.next();
            WorkSpaceFile workSpaceFile = null;
            try {
                workSpaceFile = repositoryContext.getFile(serverIndexXML);
            }
            catch (Throwable throwable) {
                continue;
            }
            if (workSpaceFile == null) continue;
            Resource resource = repositoryContext.getResourceSet().createResource(URI.createURI((String)serverIndexXML));
            resource.load(new HashMap());
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            for (int i = 0; i < eList.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)eList.get(i);
                String string = serverEntry.getServerType();
                if (!string.equals("NODE_AGENT")) continue;
                String string2 = repositoryContext.getURI();
                string2.substring(string2.lastIndexOf("/") + 1);
                arrayList.add(string2.substring(string2.lastIndexOf("/") + 1));
                continue block2;
            }
        }
        return arrayList;
    }

    public static String findDmgrNode(Session session) throws ConfigServiceException, WorkSpaceException, IOException {
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        RepositoryContextType repositoryContextType = workSpace.getMetaData().getContextType("nodes");
        Collection collection = workSpace.findContext(repositoryContextType);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext = (RepositoryContext)iterator.next();
            WorkSpaceFile workSpaceFile = null;
            try {
                workSpaceFile = repositoryContext.getFile(serverIndexXML);
            }
            catch (Throwable throwable) {
                continue;
            }
            if (workSpaceFile == null) continue;
            Resource resource = repositoryContext.getResourceSet().createResource(URI.createURI((String)serverIndexXML));
            resource.load(new HashMap());
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            for (int i = 0; i < eList.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)eList.get(i);
                String string = serverEntry.getServerType();
                if (!string.equals("DEPLOYMENT_MANAGER")) continue;
                String string2 = repositoryContext.getURI();
                string2.substring(string2.lastIndexOf("/") + 1);
                return string2.substring(string2.lastIndexOf("/") + 1);
            }
        }
        return null;
    }

    private String getVersion(String string) throws AdminException {
        if (string == null) {
            return this.localNodeVersion();
        }
        ManagedObjectMetadataAccessor managedObjectMetadataAccessor = null;
        Properties properties = null;
        try {
            managedObjectMetadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(properties);
        }
        catch (AdminException adminException) {
            adminException.printStackTrace();
        }
        String string2 = null;
        try {
            string2 = managedObjectMetadataAccessor.getMetadataProperty(string, "com.ibm.websphere.baseProductVersion");
        }
        catch (AdminException adminException) {
            adminException.printStackTrace();
        }
        return string2;
    }

    private String localNodeVersion() {
        return DEFAULT_NODE_VERSION;
    }

    private void removeNode() throws WorkSpaceException, IOException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNode()");
        }
        this.cellContext = this.workSpace.findContext(this.cellName);
        this.nodeContext = this.workSpace.findContext(this.cellName + "/nodes/" + this.nodeName);
        this.nodeContext.extract(serverIndexXML, false);
        Resource resource = this.nodeContext.getResourceSet().createResource(URI.createURI((String)serverIndexXML));
        resource.load(new HashMap());
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        EList eList = serverIndex.getServerEntries();
        if (this.isManaged(serverIndex)) {
            throw new AdminException(this.getFormattedMessage("ADMK0202E", new Object[]{this.nodeName}, null));
        }
        this.removeServers((List)eList);
        this.nodeContext.delete(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNode()");
        }
    }

    private void removeServers(List list) throws AdminException, WorkSpaceException, IOException, InvalidParameterValueException, InvalidParameterNameException {
        if (list.size() > 0) {
            TaskCommand taskCommand = null;
            try {
                taskCommand = (TaskCommand)CommandMgr.getCommandMgr().createCommand("deleteServer");
            }
            catch (Throwable throwable) {
                throw Utils.makeAdminException(throwable);
            }
            for (int i = 0; i < list.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)list.get(i);
                String string = serverEntry.getServerName();
                RepositoryContext repositoryContext = null;
                EList eList = serverEntry.getDeployedApplications();
                for (int j = 0; j < eList.size(); ++j) {
                    repositoryContext = this.cellContext.findContext("applications/" + eList.get(j));
                    Resource resource = repositoryContext.getResourceSet().createResource(URI.createURI((String)"deployment.xml"));
                    resource.load(new HashMap());
                    EList eList2 = resource.getContents();
                    if (eList2 == null || eList2.isEmpty() || !(eList2.get(0) instanceof Deployment)) continue;
                    this.removeDeploymentTargets((List)eList2, this.nodeContext.getName());
                }
                taskCommand.setConfigSession(this.session);
                taskCommand.setParameter("serverName", string);
                taskCommand.setParameter("nodeName", this.nodeName);
                taskCommand.execute();
                CommandResult commandResult = taskCommand.getCommandResult();
                if (commandResult.isSuccessful()) continue;
                throw new AdminException(this.getFormattedMessage("ADMK0202E", new Object[]{this.nodeName}, null));
            }
        }
    }

    private void removeDeploymentTargets(List list, String string) throws AdminException {
        for (int i = 0; i < list.size(); ++i) {
            Deployment deployment = (Deployment)list.get(i);
            EList eList = deployment.getDeploymentTargets();
            ServerTarget serverTarget = null;
            DeploymentTarget deploymentTarget = null;
            boolean bl = false;
            for (int j = 0; j < eList.size(); ++j) {
                deploymentTarget = (DeploymentTarget)eList.get(j);
                if (!(deploymentTarget instanceof ServerTarget) || !(serverTarget = (ServerTarget)deploymentTarget).getNodeName().equals(string)) continue;
                WASEcoreUtil.remove((EObject)deploymentTarget);
                bl = true;
            }
            if (!bl) continue;
            try {
                deployment.eResource().save(new HashMap());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            bl = false;
        }
    }
}

