/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import java.net.InetAddress;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class UpdateVirtualHost {
    private static final TraceComponent tc = Tr.register(UpdateVirtualHost.class, "Admin", "com.ibm.ws.management.resources.nodeutils");
    protected ConfigService _configService = null;
    protected Session _session = null;

    public UpdateVirtualHost(ConfigService configService) {
        this._configService = configService;
        this._session = new Session();
    }

    public void updateDefaultHostHostAliases(String string, String[] stringArray, String[] stringArray2) {
        block8: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "updateDefaultHostAliases:" + string);
            }
            try {
                ObjectName objectName = this.queryDefaultHostVirtualHost();
                if (objectName != null) {
                    ObjectName[] objectNameArray = this.queryHostAliases(objectName);
                    boolean bl = this.updateDefaultHostHostAliases(objectName, objectNameArray, string, stringArray, stringArray2);
                    if (bl) {
                        this._configService.save(this._session, false);
                    } else {
                        this._configService.discard(this._session);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No default_host found in dmgr virtuahosts");
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Caught exception ", exception);
            }
        }
    }

    public void updateDefaultHostHostAliases(String string, List list, List list2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "updateDefaultHostAliases:" + string);
        }
        if (list2.size() < 1) {
            return;
        }
        String[] stringArray = new String[list.size()];
        String[] stringArray2 = new String[list2.size()];
        stringArray = list.toArray(stringArray);
        stringArray2 = list2.toArray(stringArray2);
        this.updateDefaultHostHostAliases(string, stringArray, stringArray2);
    }

    private boolean updateDefaultHostHostAliases(ObjectName objectName, ObjectName[] objectNameArray, String string, String[] stringArray, String[] stringArray2) throws Exception {
        int n;
        String string2 = this.getHostName(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dmgrHost=" + string2);
        }
        boolean bl = false;
        boolean[] blArray = new boolean[stringArray2.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = false;
        }
        String[] stringArray3 = this.getHostNames(stringArray);
        for (n = 0; n < objectNameArray.length; ++n) {
            String string3 = (String)this._configService.getAttribute(this._session, objectNameArray[n], "hostname");
            String string4 = (String)this._configService.getAttribute(this._session, objectNameArray[n], "port");
            if (string3.equals("*")) {
                string3 = string2;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "HostAlias DMGR: hostname=" + string3 + "  Port:" + string4);
            }
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!stringArray2[i].equals(string4) || !stringArray3[i].equals(string3)) continue;
                blArray[i] = true;
            }
        }
        for (n = 0; n < stringArray2.length; ++n) {
            if (blArray[n]) continue;
            for (int i = n + 1; i < stringArray2.length; ++i) {
                if (!stringArray2[i].equals(stringArray2[n]) || !stringArray3[i].equals(stringArray3[n])) continue;
                blArray[i] = true;
            }
        }
        for (n = 0; n < stringArray2.length; ++n) {
            if (blArray[n]) continue;
            if (stringArray3[n].equals(string2)) {
                stringArray3[n] = "*";
            }
            this.addNewHostAlias(objectName, stringArray3[n], stringArray2[n]);
            bl = true;
        }
        return bl;
    }

    protected ObjectName queryDefaultHostVirtualHost() throws Exception {
        block4: {
            try {
                ObjectName objectName = ConfigServiceHelper.createObjectName(null, "VirtualHost", "default_host");
                ObjectName[] objectNameArray = this._configService.queryConfigObjects(this._session, null, objectName, null);
                if (objectNameArray != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found VirtualHost =" + objectNameArray[0].toString());
                    }
                    return objectNameArray[0];
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Caught exception ", exception);
            }
        }
        return null;
    }

    protected ObjectName[] queryHostAliases(ObjectName objectName) throws Exception {
        ObjectName[] objectNameArray = null;
        try {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "HostAlias", null);
            objectNameArray = this._configService.queryConfigObjects(this._session, objectName, objectName2, null);
            return objectNameArray;
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caught exception ", exception);
            }
            return null;
        }
    }

    protected void addNewHostAlias(ObjectName objectName, String string, String string2) throws Exception {
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("hostname", string));
        attributeList.add(new Attribute("port", string2));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addNewHostAlias:" + string + ":" + string2);
        }
        this._configService.createConfigData(this._session, objectName, "aliases", null, attributeList);
    }

    protected String getHostName(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getHostName:" + string);
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = string.equalsIgnoreCase("localhost") ? InetAddress.getLocalHost() : InetAddress.getByName(string);
            String string2 = inetAddress.getHostAddress();
            String string3 = InetAddress.getByName(string2).getHostName();
            return string3.toLowerCase();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }

    protected String[] getHostNames(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            Object var4_4 = null;
            stringArray2[i] = stringArray[i].equals("*") ? this.getHostName("localhost") : this.getHostName(stringArray[i]);
        }
        return stringArray2;
    }
}

