/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ws.management.tools.unix.AddCmd;
import com.ibm.ws.management.tools.unix.NLSFunctions;
import com.ibm.ws.management.tools.unix.PermissionCmd;
import com.ibm.ws.management.tools.unix.RemoveCmd;
import com.ibm.ws.management.tools.unix.StartCmd;
import com.ibm.ws.management.tools.unix.StatusCmd;
import com.ibm.ws.management.tools.unix.StopCmd;
import com.ibm.ws.management.tools.unix.SupportedCmd;
import com.ibm.ws.management.tools.unix.WASServiceCmd;
import com.ibm.ws.management.tools.unix.WASServiceData;
import com.ibm.ws.management.tools.unix.WASServiceException;
import java.util.Hashtable;

public class WASServiceUtility {
    private static Hashtable runTypes = new Hashtable();

    private static int getRunType(String string) {
        Object v = runTypes.get(string.toLowerCase());
        if (v == null) {
            return 0;
        }
        return (Integer)v;
    }

    private static void usage() {
        String string = NLSFunctions.getXString("CWSFU0010I");
        System.err.print(string);
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        try {
            Exception exception;
            WASServiceData wASServiceData;
            WASServiceCmd wASServiceCmd = null;
            if (stringArray.length == 0) {
                WASServiceUtility.usage();
            }
            switch (WASServiceUtility.getRunType(stringArray[0])) {
                case 1: {
                    WASServiceUtility.usage();
                }
                case 2: {
                    wASServiceCmd = new AddCmd();
                    break;
                }
                case 3: {
                    wASServiceCmd = new RemoveCmd();
                    break;
                }
                case 4: {
                    wASServiceCmd = new StartCmd();
                    break;
                }
                case 5: {
                    wASServiceCmd = new StopCmd();
                    break;
                }
                case 6: {
                    wASServiceCmd = new StatusCmd();
                    break;
                }
                case 7: {
                    wASServiceCmd = new SupportedCmd();
                    break;
                }
                case 8: {
                    wASServiceCmd = new PermissionCmd();
                    break;
                }
                default: {
                    wASServiceCmd = new StartCmd();
                }
            }
            wASServiceCmd.processArgs(stringArray);
            bl = wASServiceCmd.exec();
            if (!bl && (wASServiceData = wASServiceCmd.getServiceData()) != null && (exception = wASServiceData.getException()) != null) {
                throw new WASServiceException(exception);
            }
        }
        catch (WASServiceException wASServiceException) {
            System.err.println(wASServiceException.getMessage());
            System.exit(1);
        }
        if (!bl) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    public static boolean add(WASServiceData wASServiceData) throws WASServiceException {
        AddCmd addCmd = new AddCmd(wASServiceData);
        return addCmd.exec();
    }

    public static boolean remove(WASServiceData wASServiceData) throws WASServiceException {
        RemoveCmd removeCmd = new RemoveCmd(wASServiceData);
        return removeCmd.exec();
    }

    public static boolean start(WASServiceData wASServiceData) throws WASServiceException {
        StartCmd startCmd = new StartCmd(wASServiceData);
        return startCmd.exec();
    }

    public static boolean stop(WASServiceData wASServiceData) throws WASServiceException {
        StopCmd stopCmd = new StopCmd(wASServiceData);
        return stopCmd.exec();
    }

    public static boolean status(WASServiceData wASServiceData) throws WASServiceException {
        StatusCmd statusCmd = new StatusCmd(wASServiceData);
        return statusCmd.exec();
    }

    public static boolean isSupportedPlatform() throws WASServiceException {
        SupportedCmd supportedCmd = new SupportedCmd();
        return supportedCmd.exec();
    }

    public static boolean hasInstallPermissions() throws WASServiceException {
        PermissionCmd permissionCmd = new PermissionCmd();
        return permissionCmd.exec();
    }

    static {
        runTypes.put("-help", new Integer(1));
        runTypes.put("-add", new Integer(2));
        runTypes.put("-remove", new Integer(3));
        runTypes.put("-start", new Integer(4));
        runTypes.put("-stop", new Integer(5));
        runTypes.put("-status", new Integer(6));
        runTypes.put("-issupportedplatform", new Integer(7));
        runTypes.put("-hasinstallpermissions", new Integer(8));
    }
}

