/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.tools.AdminTool;
import com.ibm.ws.management.tools.ProblemInWASServiceException;
import com.ibm.ws.management.util.EncodingUtils;
import com.ibm.ws.management.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class WindowsService
extends AdminTool {
    public static final int STATUS_REGISTERED_STOPPED = 1;
    public static final int STATUS_REGISTERED_STARTED = 2;
    public static final int STATUS_NOT_REGISTERED = 3;
    private static final String DEFAULT_TRACE_FILE = "startServer.log";
    private static final String DEFAULT_TRACE_STRING = "*=all=enabled";
    private static TraceComponent tc = Tr.register(WindowsService.class, "Admin", BUNDLE_NAME);
    private String windowsServiceName = null;
    private String wasServerName = null;
    private List cmdLineArgs = new ArrayList();
    private String serviceLogFileName = null;
    private String wasServiceExeCmd = null;

    public static WindowsService getWindowsServiceInstance(String string) throws AdminException {
        WindowsService windowsService = null;
        windowsService = new WindowsService(string);
        if (windowsService.windowsServiceName == null) {
            windowsService = null;
        }
        return windowsService;
    }

    protected WindowsService(String string) throws AdminException {
        this.wasServerName = string;
        this.windowsServiceName = this.getWindowsServiceNameForServer(this.wasServerName);
    }

    public static WindowsService getWindowsServiceInstance(String string, String[] stringArray) throws AdminException {
        WindowsService windowsService = null;
        windowsService = new WindowsService(string, stringArray);
        if (windowsService.windowsServiceName == null) {
            windowsService = null;
        }
        return windowsService;
    }

    private WindowsService(String string, String[] stringArray) throws AdminException {
        this.wasServerName = string;
        this.windowsServiceName = this.getWindowsServiceNameForServer(this.wasServerName);
        Tr.event(tc, "Trying to new up WindowsService using serverName=" + this.wasServerName + ", winServiceName=" + this.windowsServiceName);
        if (this.windowsServiceName == null) {
            return;
        }
        if (stringArray.length >= 4) {
            for (int i = 4; i < stringArray.length; ++i) {
                this.cmdLineArgs.add(stringArray[i]);
            }
        }
        this.serviceLogFileName = this.getServiceLogName(string);
    }

    protected int getServiceStatus() throws AdminException {
        String[] stringArray = new String[]{this.getWASServiceCmdPath(), "-status", this.windowsServiceName};
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            n = this.executeCommand(stringArray, stringBuffer, false);
        }
        catch (ProblemInWASServiceException problemInWASServiceException) {
            throw new AdminException(this.getFormattedMessage("ADMU7712E", new Object[]{this.wasServerName, problemInWASServiceException}, null));
        }
        return n;
    }

    private String getWindowsServiceNameForServer(String string) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWindowsServiceNameForServer()");
        }
        String string2 = System.getProperty("user.install.root").replace('/', '\\');
        String[] stringArray = new String[]{this.getWASServiceCmdPath(), "-getServiceName", string, "-profilePath", string2};
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            n = this.executeCommand(stringArray, stringBuffer, false);
        }
        catch (Throwable throwable) {
            throw new AdminException(this.getFormattedMessage("ADMU7707E", new Object[]{this.wasServerName, throwable}, null));
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Throwable throwable) {
            throw Utils.makeAdminException(throwable);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString());
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        return string3;
    }

    private String getServiceLogName(String string) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceLogName()");
        }
        int n = 0;
        String string2 = System.getProperty("user.install.root").replace('/', '\\');
        String[] stringArray = new String[]{this.getWASServiceCmdPath(), "-getServiceLogName", string, "-profilePath", string2};
        StringBuffer stringBuffer = new StringBuffer();
        try {
            n = this.executeCommand(stringArray, stringBuffer, false);
        }
        catch (ProblemInWASServiceException problemInWASServiceException) {
            throw new AdminException(this.getFormattedMessage("ADMU7708E", new Object[]{string, problemInWASServiceException}, null));
        }
        if (n != 0) {
            this.issueMessage("ADMU7708E", new Object[]{this.wasServerName, stringBuffer}, null);
            System.exit(n);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "caught InterruptedException while trying to determine service name", interruptedException);
            }
            throw new AdminException(this.getFormattedMessage("ADMU7709E", new Object[]{string, interruptedException}, null));
        }
        return stringBuffer.toString();
    }

    private int executeCommand(String[] stringArray, StringBuffer stringBuffer, boolean bl) throws AdminException, ProblemInWASServiceException {
        Tr.event(tc, "In executeCommand, args are: " + this.getUtilityArguments(stringArray));
        int n = 0;
        StringBuffer stringBuffer2 = new StringBuffer();
        Runtime runtime2 = Runtime.getRuntime();
        try {
            Process process = runtime2.exec(stringArray);
            Tr.event(tc, "Runtime.exec() returned process " + process);
            StreamConsumer streamConsumer = new StreamConsumer(process.getInputStream(), stringBuffer);
            StreamConsumer streamConsumer2 = new StreamConsumer(process.getErrorStream(), stringBuffer2);
            streamConsumer.start();
            streamConsumer2.start();
            LogReader logReader = null;
            if (this.serviceLogFileName == null) {
                bl = false;
            }
            if (bl) {
                logReader = new LogReader(this.serviceLogFileName);
                logReader.start();
            }
            try {
                n = process.waitFor();
                Tr.event(tc, "retCode from childProcess.waitFor() is " + n);
            }
            catch (InterruptedException interruptedException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught InterrupedException while waiting for child process", interruptedException);
                }
                throw new AdminException(this.getFormattedMessage("ADMU7709E", new Object[]{this.wasServerName, interruptedException}, null));
            }
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "-- interrupt the thread that is collecting stdout");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                logReader.interrupt();
            }
            Tr.debug(tc, "exitCode = " + n);
        }
        catch (IOException iOException) {
            throw new AdminException(this.getFormattedMessage("ADMU7709E", new Object[]{this.wasServerName, iOException}, null));
        }
        if (stringBuffer2 != null && stringBuffer2.length() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, stringBuffer2.toString());
            }
            stringBuffer.append("\n");
            stringBuffer.append(stringBuffer2);
        }
        return n;
    }

    protected void doWASServiceAction(String string) throws AdminException {
        int n;
        StringBuffer stringBuffer;
        block10: {
            this.doWasServiceMsg(this.wasServerName, string);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.getWASServiceCmdPath());
            arrayList.add("-" + string);
            arrayList.add(this.windowsServiceName);
            arrayList.addAll(this.cmdLineArgs);
            String[] stringArray = new String[arrayList.size()];
            stringArray = arrayList.toArray(stringArray);
            stringBuffer = new StringBuffer();
            n = 0;
            try {
                n = this.executeCommand(stringArray, stringBuffer, true);
            }
            catch (Throwable throwable) {
                if (string.equals("start")) {
                    throw new AdminException(this.getFormattedMessage("ADMU7704E", new Object[]{this.wasServerName, throwable}, null));
                }
                if (string.equals("stop")) {
                    throw new AdminException(this.getFormattedMessage("ADMU7705E", new Object[]{this.wasServerName, throwable}, null));
                }
                if (!string.equals("remove")) break block10;
                throw new AdminException(this.getFormattedMessage("ADMU7706E", new Object[]{this.wasServerName, throwable}, null));
            }
        }
        if (n != 0) {
            if (string.equals("start")) {
                this.issueMessage("ADMU7704E", new Object[]{this.wasServerName, stringBuffer}, null);
            } else if (string.equals("stop")) {
                this.issueMessage("ADMU7705E", new Object[]{this.wasServerName, stringBuffer}, null);
            } else if (string.equals("remove")) {
                this.issueMessage("ADMU7706E", new Object[]{this.wasServerName, stringBuffer}, null);
            }
            System.exit(n);
        }
    }

    private void doWasServiceMsg(String string, String string2) {
        if (string2.equals("start")) {
            this.issueMessage("ADMU7701I", new Object[]{string}, null);
        } else if (string2.equals("stop")) {
            this.issueMessage("ADMU7702I", new Object[]{string}, null);
        } else if (string2.equals("remove")) {
            this.issueMessage("ADMU7703I", new Object[]{this.windowsServiceName, string}, null);
        }
    }

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected String getDefaultTraceFile() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        string = string + File.separator + "logs";
        string = string + File.separator + this.wasServerName;
        string = string + File.separator + DEFAULT_TRACE_FILE;
        return string;
    }

    protected int getMinimumNumArgs() {
        return 4;
    }

    protected int parseRequiredArgs(String[] stringArray) throws AdminException {
        return 0;
    }

    protected void issueUsageMessage() {
    }

    protected int runTool() throws Exception {
        return 0;
    }

    protected void doStopService() throws AdminException {
        this.doWASServiceAction("stop");
    }

    protected void doRemoveService() throws AdminException {
        this.doWASServiceAction("remove");
    }

    private String getWASServiceCmdPath() {
        if (this.wasServiceExeCmd == null) {
            StringBuffer stringBuffer = new StringBuffer().append(System.getProperty("was.install.root")).append(File.separator).append("bin").append(File.separator).append("WASService.exe");
            this.wasServiceExeCmd = stringBuffer.toString();
        }
        return this.wasServiceExeCmd;
    }

    protected String getServiceName() {
        return this.windowsServiceName;
    }

    private class LogReader
    extends Thread {
        private boolean stopFlag = false;
        private static final long tenthOfSecond = 100L;
        private static final long halfOfSecond = 500L;
        private String jserviceLogFileName = null;

        private LogReader(String string) {
            this.jserviceLogFileName = string;
        }

        public void run() {
            this.waitForFileExist(this.jserviceLogFileName);
            try {
                this.readAndDisplayServiceLogFile(this.jserviceLogFileName);
            }
            catch (IOException iOException) {
                Tr.debug(tc, "Caught IOException in run() method of LogReader.class", iOException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readAndDisplayServiceLogFile(String string) throws IOException {
            block17: {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    if (!tc.isDebugEnabled()) break block17;
                    Tr.debug(tc, "readAndDisplayServiceLogFile(), caught InterruptedException1");
                }
            }
            String string2 = EncodingUtils.getProperEncoding();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "*** returned readerencoding = " + string2);
            }
            FileInputStream fileInputStream = null;
            InputStreamReader inputStreamReader = null;
            try {
                fileInputStream = new FileInputStream(string);
                inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string2);
                int n = -1;
                while (!this.stopFlag) {
                    while ((n = inputStreamReader.read()) >= 0) {
                        System.out.print((char)n);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        Tr.debug(tc, "readAndDisplayServiceLogFile(), caught InterruptedException");
                        this.stopFlag = true;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException2) {
                            // empty catch block
                        }
                        while ((n = inputStreamReader.read()) >= 0) {
                            System.out.print((char)n);
                        }
                        break;
                    }
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Tr.debug(tc, "caught UnsupportedEncodingException while waiting for file to be present", unsupportedEncodingException);
            }
            finally {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
        }

        private void waitForFileExist(String string) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "waitForFileExist(" + string + ")");
            }
            File file = new File(string);
            while (!this.stopFlag && !file.exists()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "caught InterruptedException while waiting for file to be present", interruptedException);
                    }
                    return;
                }
            }
        }
    }

    class StreamConsumer
    extends Thread {
        InputStream inputStream;
        StringBuffer oBuff;

        StreamConsumer(InputStream inputStream, StringBuffer stringBuffer) {
            this.inputStream = inputStream;
            this.oBuff = stringBuffer;
        }

        public void run() {
            String string = null;
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((string = bufferedReader.readLine()) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "inputRec == " + string);
                    }
                    this.oBuff.append(string);
                }
            }
            catch (Throwable throwable) {
                Tr.debug(tc, "Caught Throwable", throwable);
            }
        }
    }
}

