/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.launcher.ServerIdentifiers;
import com.ibm.ws.management.tools.AdminTool;
import com.ibm.ws.management.tools.WindowsService;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;

public abstract class WsServerController
extends AdminTool {
    private static TraceComponent tc = Tr.register(WsServerController.class, "Admin", BUNDLE_NAME);
    private static final String DEFAULT_TRACE_STRING = "*=all=disabled";
    protected boolean timeout = false;
    protected String serverName;
    protected boolean isNodeAgent = false;
    protected boolean isDmgr = false;
    private String exitStatusFile = null;

    protected abstract void printEnhancedErrorMessage(Throwable var1);

    protected String getDefaultTraceString() {
        return DEFAULT_TRACE_STRING;
    }

    protected int getMinimumNumArgs() {
        return 4;
    }

    protected boolean parseArgs(String[] stringArray) throws AdminException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-nodeagent")) {
                this.isNodeAgent = true;
                continue;
            }
            if (!stringArray[i].equals("-dmgr")) continue;
            this.isDmgr = true;
        }
        return super.parseArgs(stringArray);
    }

    protected int parseRequiredArgs(String[] stringArray) {
        this.serverName = stringArray[3];
        if (this.serverName == null || this.serverName.startsWith("-")) {
            this.issueMessage("ADMU3402E", null, null);
            return -1;
        }
        return 4;
    }

    protected int parseUtilitySpecificOption(String[] stringArray, int n) {
        int n2 = n + 1;
        String string = stringArray[n];
        if (string.equals("-fromWinService")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.exitStatusFile = stringArray[n + 1];
                this.invokedByWindowsService = true;
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-timeout")) {
            this.timeout = true;
            if (this.isValidParameter(stringArray, n + 1)) {
                this.statusTimeout = Integer.parseInt(stringArray[n + 1]) * 1000;
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (!string.equals("-dmgr") && !string.equals("-nodeagent")) {
            n2 = -1;
        }
        return n2;
    }

    protected int executeUtilityOnWindows(String[] stringArray) throws AdminException {
        this.parseAndSetTraceCalled = true;
        int n = this.parseAndSetTrace(stringArray);
        if (n == 0) {
            Tr.event(tc, "Executing executeUtilityOnWindows with args: " + this.getUtilityArguments(stringArray));
            WindowsService windowsService = this.getWindowsServiceIfAvailable(stringArray);
            if (windowsService != null) {
                Tr.event(tc, "Window service status (1=stopped, 2=started, 3=not-registred) is " + windowsService.getServiceStatus());
                this.execWithWinService(windowsService);
                return 0;
            }
            return this.executeUtility(stringArray);
        }
        if (n == 12345) {
            return 0;
        }
        return n;
    }

    protected WindowsService getWindowsServiceIfAvailable(String[] stringArray) throws AdminException {
        if (this.invokedByWindowsService) {
            Tr.event(tc, "invokedByWindowsService has been set to true earlier");
            return null;
        }
        WindowsService windowsService = null;
        Tr.event(tc, "Getting WindowsService obj with: " + stringArray[3] + " and " + this.getUtilityArguments(stringArray));
        windowsService = WindowsService.getWindowsServiceInstance(stringArray[3], stringArray);
        return windowsService;
    }

    protected abstract void execWithWinService(WindowsService var1) throws AdminException;

    protected abstract void logUnknownException(Exception var1);

    protected abstract int getTimeoutStatus();

    protected abstract int getFailureStatus();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getStatus(Socket socket) {
        int n = this.getFailureStatus();
        InputStream inputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            inputStream = socket.getInputStream();
            filterInputStream = new DataInputStream(inputStream);
            n = ((DataInputStream)filterInputStream).readInt();
        }
        catch (IOException iOException) {
            this.logUnknownException(iOException);
        }
        finally {
            try {
                filterInputStream.close();
                inputStream.close();
            }
            catch (IOException iOException) {
                this.logUnknownException(iOException);
            }
            filterInputStream = null;
            inputStream = null;
        }
        return n;
    }

    protected int waitForServerInit() {
        Socket socket = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (!bl && !bl2) {
            try {
                socket = this.statusSocket.accept();
            }
            catch (InterruptedIOException interruptedIOException) {
                socket = null;
                bl2 = true;
            }
            catch (IOException iOException) {
                this.logUnknownException(iOException);
                socket = null;
                bl = true;
                n = this.getFailureStatus();
            }
            if (socket == null) continue;
            n = this.getStatus(socket);
            bl = this.isFinalStatus(n);
        }
        if (!bl) {
            n = this.getTimeoutStatus();
        }
        return n;
    }

    protected int waitForServerInit(int n) {
        Socket socket = null;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (!bl && !bl2) {
            try {
                this.statusSocket.setSoTimeout(n);
                socket = this.statusSocket.accept();
            }
            catch (InterruptedIOException interruptedIOException) {
                socket = null;
                bl2 = true;
            }
            catch (IOException iOException) {
                this.logUnknownException(iOException);
                socket = null;
                bl = true;
                n2 = this.getFailureStatus();
            }
            if (socket == null) continue;
            n2 = this.getStatus(socket);
            bl = this.isFinalStatus(n2);
        }
        if (!bl) {
            n2 = this.getTimeoutStatus();
        }
        return n2;
    }

    protected abstract boolean isFinalStatus(int var1);

    protected ServerIdentifiers createServerIdentifiers() {
        ServerIdentifiers serverIdentifiers = new ServerIdentifiers();
        serverIdentifiers.setConfigRoot(this.configRoot);
        serverIdentifiers.setCellName(this.cellName);
        serverIdentifiers.setNodeName(this.nodeName);
        serverIdentifiers.setServerName(this.serverName);
        return serverIdentifiers;
    }

    protected void writeExitCode(String[] stringArray, int n) {
        if (!this.invokedByWindowsService) {
            System.exit(n);
        }
        String string = this.exitStatusFile;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            String string2 = Integer.toString(n);
            fileOutputStream.write(string2.getBytes());
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.exit(n);
    }
}

