/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.launcher.LaunchCommand;
import com.ibm.ws.management.launcher.LaunchScriptCollaboratorFactory;
import com.ibm.ws.management.launcher.LaunchScriptPlatformCollaborator;
import com.ibm.ws.management.tools.GenericServerProcHelper;
import com.ibm.ws.management.tools.WindowsService;
import com.ibm.ws.management.tools.WsServerController;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.process.Process;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class WsServerLauncher
extends WsServerController {
    private static final String DEFAULT_TRACE_FILE = "startServer.log";
    private static TraceComponent tc = Tr.register(WsServerLauncher.class, "Admin", BUNDLE_NAME);
    private String scriptFileName = null;
    private boolean createScript = false;
    private boolean backgroundScript = false;
    private boolean binaryData = false;
    private Vector extraSystemProperties = null;
    private LaunchCommand launcher = null;
    private boolean devOption = false;
    private VariableMap variableMap = null;
    private static boolean forceGenericServerStart = false;
    private boolean recoveryMode = false;

    protected String getDefaultTraceFile() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        string = string + File.separator + "logs";
        string = string + File.separator + this.serverName;
        string = string + File.separator + DEFAULT_TRACE_FILE;
        return string;
    }

    public static void main(String[] stringArray) throws AdminException {
        WsServerLauncher wsServerLauncher = new WsServerLauncher();
        if (!WsServerLauncher.isPlatformWindows()) {
            System.exit(wsServerLauncher.executeUtility(stringArray));
        }
        wsServerLauncher.writeExitCode(stringArray, wsServerLauncher.executeUtilityOnWindows(stringArray));
    }

    protected WindowsService getWindowsServiceIfAvailable(String[] stringArray) throws AdminException {
        if (this.createScript) {
            return null;
        }
        WindowsService windowsService = super.getWindowsServiceIfAvailable(stringArray);
        if (windowsService != null) {
            int n = windowsService.getServiceStatus();
            if (n == 2) {
                this.issueMessage("ADMU3027E", new Object[]{this.serverName}, null);
                Tr.error(tc, "ADMU3027E", new Object[]{this.serverName});
                System.exit(n);
            }
            if (n == 3) {
                windowsService = null;
            }
        }
        return windowsService;
    }

    protected void execWithWinService(WindowsService windowsService) throws AdminException {
        windowsService.doWASServiceAction("start");
    }

    protected int parseUtilitySpecificOption(String[] stringArray, int n) {
        int n2 = n + 1;
        String string = stringArray[n];
        if (string.equals("-developerscript")) {
            this.createScript = true;
            this.devOption = true;
            this.scriptFileName = "start_" + this.serverName;
            String string2 = System.getProperty("os.name").toLowerCase();
            LaunchScriptPlatformCollaborator launchScriptPlatformCollaborator = LaunchScriptCollaboratorFactory.getCollaborator(string2);
            this.scriptFileName = launchScriptPlatformCollaborator.customizeScriptFilename(this.scriptFileName);
        } else if (string.equals("-script")) {
            if (AdminHelper.getPlatformHelper().isZOS()) {
                this.issueMessage("ADMU4018E", null, null);
                System.exit(-1);
            }
            this.createScript = true;
            if (this.isValidParameter(stringArray, n + 1)) {
                this.scriptFileName = stringArray[n + 1];
                ++n2;
            } else {
                this.scriptFileName = "start_" + this.serverName;
                String string3 = System.getProperty("os.name").toLowerCase();
                LaunchScriptPlatformCollaborator launchScriptPlatformCollaborator = LaunchScriptCollaboratorFactory.getCollaborator(string3);
                this.scriptFileName = launchScriptPlatformCollaborator.customizeScriptFilename(this.scriptFileName);
            }
        } else if (string.equals("-binaryData")) {
            this.binaryData = true;
        } else if (string.equals("-background")) {
            this.backgroundScript = true;
        } else if (string.equals("-forceGenericServerStart")) {
            forceGenericServerStart = true;
        } else if (string.startsWith("-D")) {
            if (this.extraSystemProperties == null) {
                this.extraSystemProperties = new Vector();
            }
            this.extraSystemProperties.add(string);
        } else if (string.startsWith("-J")) {
            if (this.extraSystemProperties == null) {
                this.extraSystemProperties = new Vector();
            }
            this.extraSystemProperties.add(string.substring(2));
        } else if (string.startsWith("-recovery")) {
            if (this.extraSystemProperties == null) {
                this.extraSystemProperties = new Vector();
            }
            this.recoveryMode = true;
            this.extraSystemProperties.add("-Dcom.ibm.ws.server.mode=recovery");
        } else {
            n2 = super.parseUtilitySpecificOption(stringArray, n);
        }
        return n2;
    }

    protected void issueUsageMessage() {
        if (this.isNodeAgent) {
            this.issueMessage("ADMU4016I", null, null);
        } else if (this.isDmgr) {
            this.issueMessage("ADMU4017I", null, null);
        } else {
            this.issueMessage("ADMU4001I", null, null);
        }
        this.issueMessage("ADMU4002I", null, null);
        this.issueMessage("ADMU4004I", null, null);
        this.issueMessage("ADMU4010I", null, null);
        this.issueMessage("ADMU4012I", null, null);
        this.issueMessage("ADMU4011I", null, null);
        this.issueMessage("ADMU4005I", null, null);
        this.issueMessage("ADMU4006I", null, null);
        this.issueMessage("ADMU4009I", null, null);
        this.issueMessage("ADMU4026I", null, null);
        this.issueMessage("ADMU4027I", null, null);
        this.issueMessage("ADMU4025I", null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int runTool() throws Exception {
        try {
            int n;
            block39: {
                block40: {
                    this.issueMessage("ADMU3100I", new Object[]{this.serverName}, null);
                    Repository repository2 = this.initializeRepositoryAndLauncher();
                    if (this.createScript) {
                        String string = System.getProperty("os.name");
                        if (this.devOption) {
                            this.launcher.setDevOption(this.devOption);
                        }
                        this.launcher.createLaunchScript(string, this.scriptFileName, this.backgroundScript);
                        this.issueMessage("ADMU3300I", new Object[]{this.scriptFileName}, null);
                        int n2 = 0;
                        return n2;
                    }
                    if (this.binaryData) {
                        this.scriptFileName = this.serverName + "_binary.data";
                        this.launcher.createBinaryData(this.scriptFileName);
                        int n3 = 0;
                        return n3;
                    }
                    if (GenericServerProcHelper.isServerAGenericServer(this.createServerIdentifiers())) {
                        int n4 = this.doGenericServer();
                        return n4;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Launching a new server process: " + this.serverName);
                    }
                    if (!this.nowait) {
                        this.statusPort = this.getStatusPort();
                        this.launcher.setStatusSocketPort(this.statusPort);
                        if (this.statusPort != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "status socket = " + this.statusPort.toString());
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "  The communication with the server was lost due to a commination error.  \nSuch communication error is related to the operating system trying to get a free port.\nPlease check the logs of the server to determine the status of the server.");
                            }
                        }
                    }
                    if (this.serverIsRunning(repository2)) {
                        this.issueMessage("ADMU3027E", new Object[]{this.serverName}, null);
                        throw new AdminException(this.getFormattedMessage("ADMU3027E", new Object[]{this.serverName}, null));
                    }
                    Process process = this.launcher.launchProcess();
                    String string = process.id();
                    if (this.nowait) {
                        process.release();
                        this.issueMessage("ADMU3400I", new Object[]{string}, null);
                        int n5 = 0;
                        return n5;
                    }
                    this.issueMessage("ADMU3200I", null, null);
                    new ProcessWatcher(process);
                    n = this.waitForServerInit();
                    if (n != 0) break block40;
                    if (this.recoveryMode) {
                        this.issueMessage("ADMU3001I", new Object[]{this.serverName, string}, null);
                        n = this.waitForServerInit();
                        if (n == 0) {
                            this.issueMessage("ADMU3013I", new Object[]{this.serverName}, null);
                            break block39;
                        } else {
                            this.issueMessage("ADMU3014W", new Object[]{this.serverName}, null);
                        }
                        break block39;
                    } else {
                        this.issueMessage("ADMU3000I", new Object[]{this.serverName, string}, null);
                    }
                    break block39;
                }
                if (n != -1 && n != 0) {
                    String string = new Integer(this.statusTimeout / 1000).toString();
                    throw new AdminException(this.getFormattedMessage("ADMU3040E", new Object[]{string}, "Timed out waiting for server initialization."));
                }
                String string = System.getProperty("user.install.root") + File.separator + "logs" + File.separator + this.serverName;
                this.issueMessage("ADMU3011E", new Object[]{string}, null);
            }
            int n6 = n;
            return n6;
        }
        catch (Exception exception) {
            Tr.error(tc, "ADMU3002E", this.serverName);
            Tr.error(tc, "ADMU3007E", exception);
            throw exception;
        }
        finally {
            if (this.statusSocket != null) {
                try {
                    this.statusSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void toolFailed() {
        String string = null;
        if (this.launcher != null) {
            try {
                string = this.launcher.getLaunchCommand().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ManagerAdmin.appendTraceString("*=all=enabled");
        Tr.dump(tc, "LaunchCommand is: ", string);
    }

    private Repository initializeRepositoryAndLauncher() throws Exception {
        Repository repository2 = RepositoryFactory.createRepository("ws-server", this.configRoot, this.cellName, this.nodeName, this.serverName);
        ConfigRoot configRoot = repository2.getConfigRoot();
        Resource resource = null;
        resource = configRoot.getResource(4, "server.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "com.ibm.ws.management.nodeagent.launchProcess  resource :" + resource);
        }
        Server server2 = WsServerLauncher.getServer(resource);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "com.ibm.ws.management.nodeagent.launchProcess  server :" + server2);
        }
        String string = server2.getClusterName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "com.ibm.ws.management.nodeagent.launchProcess Cluster  :" + string);
        }
        if (string != null) {
            repository2 = RepositoryFactory.createRepository("ws-server", this.configRoot, this.cellName, this.nodeName, this.serverName, string);
        }
        this.variableMap = VariableMapFactory.createVariableMap(repository2);
        this.variableMap.initialize(null);
        this.launcher = new LaunchCommand(repository2, this.variableMap, this.createServerIdentifiers());
        if (this.extraSystemProperties != null) {
            for (int i = 0; i < this.extraSystemProperties.size(); ++i) {
                this.launcher.addSystemProperty((String)this.extraSystemProperties.get(i));
            }
        }
        return repository2;
    }

    protected boolean isFinalStatus(int n) {
        if (n == 0 || n == -1 || n == -2 || n == 0) {
            return true;
        }
        if (n == 2) {
            this.issueMessage("ADMU3220I", null, null);
        }
        return false;
    }

    protected int getFailureStatus() {
        return -1;
    }

    protected int getTimeoutStatus() {
        return -2;
    }

    protected void logUnknownException(Exception exception) {
        Tr.error(tc, "ADMU3009E", exception);
    }

    protected void printEnhancedErrorMessage(Throwable throwable) {
        if (throwable instanceof AdminException) {
            AdminException adminException = (AdminException)throwable;
            Throwable throwable2 = adminException.getCause();
        }
    }

    public Vector getLaunchCommand(String[] stringArray) {
        Vector vector = null;
        try {
            this.parseArgs(stringArray);
            this.initializeRepositoryAndLauncher();
            vector = this.launcher.getLaunchCommand();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return vector;
    }

    private static Server getServer(Resource resource) throws Exception {
        Server server2 = null;
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            Object e2 = eList.get(i);
            if (!(e2 instanceof Server)) continue;
            server2 = (Server)e2;
        }
        return server2;
    }

    private boolean serverIsRunning(Repository repository2) throws Exception {
        Object object;
        Object object2;
        int n;
        boolean bl = false;
        Resource resource = repository2.getConfigRoot().getResource(3, "serverindex.xml");
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        EList eList = serverIndex.getServerEntries();
        NamedEndPoint namedEndPoint = null;
        for (n = 0; n < eList.size(); ++n) {
            object2 = (ServerEntry)eList.get(n);
            if (!object2.getServerName().equals(this.serverName)) continue;
            object = object2.getSpecialEndpoints();
            for (int i = 0; i < object.size(); ++i) {
                NamedEndPoint namedEndPoint2 = (NamedEndPoint)object.get(i);
                if (namedEndPoint2.getEndPointName().equals("SOAP_CONNECTOR_ADDRESS")) {
                    if (namedEndPoint != null) continue;
                    namedEndPoint = namedEndPoint2;
                    continue;
                }
                if (!namedEndPoint2.getEndPointName().equals("SOAP_PROXY_CONNECTOR_ADDRESS") || !object2.getServerType().equals("DEPLOYMENT_MANAGER")) continue;
                namedEndPoint = namedEndPoint2;
            }
        }
        if (namedEndPoint != null) {
            n = namedEndPoint.getEndPoint().getPort();
            object2 = namedEndPoint.getEndPoint().getHost();
            try {
                object = new Socket((String)object2, n);
                bl = true;
                ((Socket)object).close();
                String string = new Integer(n).toString();
                this.issueMessage("ADMU3028I", new Object[]{string, this.serverName}, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    private int doGenericServer() throws AdminException {
        int n = 0;
        String string = null;
        try {
            string = GenericServerProcHelper.getStatusUsingPidFile(this.createServerIdentifiers());
        }
        catch (Throwable throwable) {
            throw Utils.makeAdminException(throwable);
        }
        if (string.equals("STOPPED")) {
            n = GenericServerProcHelper.launchGenericServer(this.launcher, this.createServerIdentifiers());
            if (n == 0) {
                this.issueMessage("ADMU7770I", new Object[]{this.serverName}, null);
            }
            return n;
        }
        if (!forceGenericServerStart) {
            this.issueMessage("ADMU7771E", new Object[]{this.serverName}, null);
            Tr.error(tc, "ADMU7771E", this.serverName);
            throw new AdminException(this.getFormattedMessage("ADMU7771E", new Object[]{this.serverName}, null));
        }
        n = GenericServerProcHelper.launchGenericServer(this.launcher, this.createServerIdentifiers());
        if (n == 0) {
            this.issueMessage("ADMU7770I", new Object[]{this.serverName}, null);
        }
        return n;
    }

    private class ProcessWatcher
    extends Thread {
        Process process;

        private ProcessWatcher(Process process) {
            this.process = process;
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            try {
                if (this.process.isAlive()) {
                    this.process.waitForTermination();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Socket socket = new Socket("localhost", WsServerLauncher.this.statusSocket.getLocalPort());
                DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
                dataOutputStream.writeInt(-1);
                dataOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

