/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.tools.GenericServerProcHelper;
import com.ibm.ws.management.tools.LaunchUtils;
import com.ibm.ws.management.tools.WindowsService;
import com.ibm.ws.management.tools.WsServerController;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServices;
import java.beans.beancontext.BeanContextServicesSupport;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import org.eclipse.emf.ecore.resource.Resource;

public class WsServerStop
extends WsServerController {
    private static final String DEFAULT_TRACE_FILE = "stopServer.log";
    private static TraceComponent tc = Tr.register(WsServerStop.class, "Admin", BUNDLE_NAME);
    private BeanContextServices bc = null;
    private Repository repository = null;
    private String hostName = null;
    private String portNumber = null;
    private String connType = null;
    private boolean stopServers = false;
    private boolean saveNodeState = false;
    private VariableMap variableMap = null;
    private static int twentyMinutes = 1200000;

    protected String getDefaultTraceFile() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        string = string + File.separator + "logs";
        string = string + File.separator + this.serverName;
        string = string + File.separator + DEFAULT_TRACE_FILE;
        return string;
    }

    public static void main(String[] stringArray) throws AdminException {
        WsServerStop wsServerStop = new WsServerStop();
        if (!WsServerStop.isPlatformWindows()) {
            System.exit(wsServerStop.executeUtility(stringArray));
        }
        wsServerStop.writeExitCode(stringArray, wsServerStop.executeUtilityOnWindows(stringArray));
    }

    protected WindowsService getWindowsServiceIfAvailable(String[] stringArray) throws AdminException {
        WindowsService windowsService = super.getWindowsServiceIfAvailable(stringArray);
        if (windowsService != null) {
            try {
                if (windowsService.getServiceStatus() != 2) {
                    windowsService = null;
                }
            }
            catch (AdminException adminException) {
                windowsService = null;
            }
        }
        return windowsService;
    }

    protected void execWithWinService(WindowsService windowsService) throws AdminException {
        windowsService.doWASServiceAction("stop");
    }

    protected int parseUtilitySpecificOption(String[] stringArray, int n) {
        int n2 = n + 1;
        String string = stringArray[n];
        if (string.equals("-port")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.portNumber = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-conntype")) {
            if (this.isValidParameter(stringArray, n + 1)) {
                this.connType = stringArray[n + 1];
                ++n2;
            } else {
                n2 = -2;
            }
        } else if (string.equals("-stopservers")) {
            this.stopServers = true;
        } else if (string.equals("-saveNodeState")) {
            this.saveNodeState = true;
        } else {
            n2 = super.parseUtilitySpecificOption(stringArray, n);
        }
        return n2;
    }

    protected void issueUsageMessage() {
        if (this.isNodeAgent) {
            this.issueMessage("ADMU4014I", null, null);
        } else if (this.isDmgr) {
            this.issueMessage("ADMU4015I", null, null);
        } else {
            this.issueMessage("ADMU4003I", null, null);
        }
        this.issueMessage("ADMU4002I", null, null);
        if (this.isNodeAgent) {
            this.issueMessage("ADMU4013I", null, null);
        }
        this.issueMessage("ADMU4004I", null, null);
        this.issueMessage("ADMU4010I", null, null);
        this.issueMessage("ADMU4012I", null, null);
        this.issueMessage("ADMU4011I", null, null);
        this.issueMessage("ADMU4006I", null, null);
        this.issueMessage("ADMU4009I", null, null);
        this.issueMessage("ADMU4020I", null, null);
        this.issueMessage("ADMU4022I", null, null);
        this.issueMessage("ADMU4023I", null, null);
        this.issueMessage("ADMU4024I", null, null);
        this.issueMessage("ADMU4026I", null, null);
        this.issueMessage("ADMU4025I", null, null);
    }

    private void stopAllServers(AdminClient adminClient) throws Exception {
        ObjectName objectName = null;
        Set set = null;
        try {
            objectName = new ObjectName("WebSphere:*,type=NodeAgent,node=" + this.nodeName + ",process=nodeagent");
            Tr.debug(tc, "mbean " + objectName.getCanonicalName());
            set = adminClient.queryNames(objectName, null);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.tools.WsServerStop.stopAllServers", "161", this);
            throw new AdminException("Failed to query NodeAgent mbean at node: " + this.nodeName);
        }
        ObjectName objectName2 = objectName = set.iterator().hasNext() ? (ObjectName)set.iterator().next() : null;
        if (objectName == null) {
            throw new AdminException("no NodeAgent mbean found at node: " + this.nodeName);
        }
        String[] stringArray = new String[]{};
        Object[] objectArray = new Object[]{};
        adminClient.invoke(objectName, "stopNode", objectArray, stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int runTool() throws Exception {
        int n = 0;
        AdminClient adminClient = null;
        try {
            Object object;
            Properties properties;
            if (this.portNumber != null) {
                if (this.hostName == null) {
                    this.hostName = "localhost";
                }
                if (this.connType == null) {
                    this.connType = "SOAP";
                }
                this.issueMessage("ADMU3101I", new Object[]{this.hostName, this.portNumber, this.serverName}, null);
                properties = new Properties();
                properties.setProperty("host", this.hostName);
                properties.setProperty("port", this.portNumber);
                properties.setProperty("type", this.connType);
                if (this.userid != null) {
                    properties.setProperty("username", this.userid);
                }
                if (this.pwd != null) {
                    properties.setProperty("password", this.pwd);
                }
                adminClient = AdminClientFactory.createAdminClient(properties);
            } else {
                if (!this.serverConfigExists()) {
                    this.issueMessage("ADMU3522E", new Object[]{this.serverName}, null);
                    int n2 = -1;
                    return n2;
                }
                this.issueMessage("ADMU3100I", new Object[]{this.serverName}, null);
                this.bc = new BeanContextServicesSupport();
                this.repository = RepositoryFactory.createRepository("ws-server", this.configRoot, this.cellName, this.nodeName, this.serverName);
                this.bc.addService(Repository.class, (BeanContextServiceProvider)((Object)this.repository));
                this.variableMap = VariableMapFactory.createVariableMap();
                this.bc.add(this.variableMap);
                this.variableMap.initialize(null);
                properties = this.repository.getConfigRoot().getResource(4, "server.xml");
                if (GenericServerProcHelper.isServerAGenericServer(this.createServerIdentifiers()) || GenericServerProcHelper.isServerAnIHSServer(this.createServerIdentifiers())) {
                    String string = null;
                    string = GenericServerProcHelper.isServerAnIHSServer(this.createServerIdentifiers()) ? GenericServerProcHelper.getStatusUsingPing(this.createServerIdentifiers()) : GenericServerProcHelper.getStatusUsingPidFile(this.createServerIdentifiers());
                    if (string.equals("RUNNING")) {
                        GenericServerProcHelper.stopArbitraryServerProcess(this.createServerIdentifiers());
                        this.issueMessage("ADMU7772I", new Object[]{this.serverName}, null);
                        int n3 = 0;
                        return n3;
                    }
                    this.issueMessage("ADMU7773E", new Object[]{this.serverName}, null);
                    Tr.error(tc, "ADMU7773E", this.serverName);
                    throw new AdminException(this.getFormattedMessage("ADMU7773E", new Object[]{this.serverName}, null));
                }
                object = LaunchUtils.getJMXConnector((Resource)properties);
                if (object != null) {
                    adminClient = LaunchUtils.getAdminClient(this.repository, object, this.userid, this.pwd);
                }
            }
            if (adminClient != null) {
                if (this.stopServers) {
                    if (this.saveNodeState) {
                        this.getServers();
                        this.issueMessage("ADMU2010I", new Object[]{this.nodeName}, null);
                        this.stopAllServers(adminClient);
                    } else {
                        this.stopAllServers();
                    }
                } else if (this.nowait) {
                    this.sendStop(adminClient);
                    this.issueMessage("ADMU3401I", null, null);
                } else {
                    this.statusPort = this.getStatusPort();
                    boolean bl = this.sendWaitStop(adminClient);
                    this.issueMessage("ADMU3201I", null, null);
                    n = bl ? this.waitForServerInit(this.timeout ? this.statusTimeout : twentyMinutes) : 0;
                    if (n != 0) {
                        this.issueMessage("ADMU3111E", null, null);
                        System.out.println("");
                        object = new Integer(this.statusTimeout / 1000).toString();
                        throw new AdminException(this.getFormattedMessage("ADMU3060E", new Object[]{object}, "Timed out waiting for server shutdown."));
                    }
                    this.issueMessage("ADMU4000I", new Object[]{this.serverName}, null);
                    System.out.println("");
                }
            }
            int n4 = n;
            return n4;
        }
        catch (ConnectorException connectorException) {
            Tr.error(tc, "ADMU3002E", this.serverName);
            Tr.error(tc, "ADMU3007E", connectorException.toString());
            Tr.service(tc, "ADMU3007E", connectorException);
            this.issueMessage("ADMU0509I", new Object[]{"server", this.serverName}, null);
            this.issueMessage("ADMU0211I", new Object[]{this.logfile}, null);
            int n5 = -10;
            return n5;
        }
        catch (Exception exception) {
            Tr.error(tc, "ADMU3002E", this.serverName);
            Tr.error(tc, "ADMU3007E", exception.toString());
            Tr.service(tc, "ADMU3007E", exception);
            throw exception;
        }
        finally {
            if (this.statusSocket != null) {
                try {
                    this.statusSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected boolean isFinalStatus(int n) {
        return n == 0;
    }

    protected int getFailureStatus() {
        return -10;
    }

    protected int getTimeoutStatus() {
        return -11;
    }

    protected void logUnknownException(Exception exception) {
        Tr.error(tc, "ADMU3019E", exception);
    }

    private void sendStop(AdminClient adminClient) throws Exception {
        ObjectName objectName = this.getServerHandle(adminClient);
        if (objectName != null) {
            String string = "stop";
            adminClient.invoke(objectName, string, null, null);
        }
    }

    private boolean sendWaitStop(AdminClient adminClient) throws Exception {
        boolean bl = true;
        boolean bl2 = false;
        ObjectName objectName = this.getServerHandle(adminClient);
        if (objectName != null) {
            String string = "stop";
            String[] stringArray = new String[]{"java.lang.Boolean", "java.lang.Integer"};
            Object[] objectArray = new Object[]{new Boolean(true), this.statusPort};
            try {
                adminClient.invoke(objectName, string, objectArray, stringArray);
            }
            catch (Exception exception) {
                try {
                    adminClient.isAlive();
                    bl2 = true;
                    throw exception;
                }
                catch (Exception exception2) {
                    if (bl2) {
                        throw exception2;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    protected void printEnhancedErrorMessage(Throwable throwable) {
        if (throwable instanceof AdminException) {
            AdminException adminException = (AdminException)throwable;
            adminException.getCause();
        } else if (throwable instanceof ConnectorException) {
            this.issueMessage("ADMU4122E", null, "The specified server may not be running.");
        }
    }

    private boolean serverConfigExists() {
        boolean bl = false;
        String string = this.configRoot + "/cells/" + this.cellName + "/nodes/" + this.nodeName + "/servers/" + this.serverName;
        File file = new File(string);
        if (file.exists()) {
            bl = true;
        }
        return bl;
    }
}

