/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.tools.unix;

import com.ibm.ws.management.tools.unix.NLSFunctions;
import com.ibm.ws.management.tools.unix.WASServiceData;
import com.ibm.ws.management.tools.unix.WASServiceException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Properties;

public class OSCmds {
    private Properties OSProps;
    private Runtime OSrt;
    private static final String SERVICE_NAME_REPL = "@@SERVICENAME@@";
    private static final String SERVER_NAME_PREFIX = "SERVERNAME=";
    private static final String SERVICE_NAME_PREFIX = "SERVICENAME=";
    private static final String PROFILE_PATH_PREFIX = "PROFILEPATH=";
    private static final String RUNAS_PREFIX = "RUNASUSER=";
    private static final String WAS_HOME_PREFIX = "WASHOME=";
    private static final String START_ARGS_PREFIX = "STARTARGS=";
    private static final String STOP_ARGS_PREFIX = "STOPARGS=";
    private static final String TEMPLATE_RESOURCE = "com/ibm/ws/management/tools/templates/was.init";
    private static final String SERVICE_FILE_SUFFIX = "_was.init";
    private static final String NODE_VAR_PREFIX = "WAS_NODE=";
    private static final String SETUPCMDLINE_PATH = "/bin/setupCmdLine.sh";
    private static final String PYSCRIPT_PATH = "/bin/setRunAsUser.py";
    private static final String WSADMIN_PATH = "/bin/wsadmin.sh";

    public OSCmds(Properties properties) {
        this.OSProps = new Properties(properties);
        this.OSrt = Runtime.getRuntime();
    }

    protected boolean start(WASServiceData wASServiceData) {
        String string = wASServiceData.getServiceName();
        String string2 = wASServiceData.getExecStartArgs();
        String string3 = this.OSProps.getProperty("StartCmd");
        boolean bl = false;
        if (string == null) {
            String string4 = NLSFunctions.getXString("CWSFU0018E");
            wASServiceData.setException(new WASServiceException(string4));
            return bl;
        }
        string3 = string3.replaceAll(SERVICE_NAME_REPL, string);
        if (string2 != null) {
            string3 = string3 + " " + string2;
        }
        try {
            Process process = this.OSrt.exec(new String[]{"sh", "-c", string3});
            WASServiceOutputConsumer wASServiceOutputConsumer = new WASServiceOutputConsumer(process);
            wASServiceOutputConsumer.consume();
            int n = process.waitFor();
            wASServiceOutputConsumer.waitForOutput();
            String string5 = wASServiceOutputConsumer.getStatus();
            if (string5.equals("ERROR")) {
                throw new Exception(wASServiceOutputConsumer.getException());
            }
            if (n == 0) {
                Object[] objectArray = new Object[]{string};
                String string6 = NLSFunctions.getXFormattedString("CWSFU0011I", objectArray);
                System.out.println(string6);
                bl = true;
            } else {
                Object[] objectArray = new Object[]{string};
                String string7 = NLSFunctions.getXFormattedString("CWSFU0005E", objectArray);
                System.err.println(string7);
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            String string8 = iOException.getMessage();
            if (string8.indexOf(string) != -1) {
                Object[] objectArray = new Object[]{string};
                String string9 = NLSFunctions.getXFormattedString("CWSFU0016E", objectArray);
                System.err.println(string9);
                iOException2 = null;
            }
            wASServiceData.setException(iOException2);
        }
        catch (Exception exception) {
            wASServiceData.setException(exception);
        }
        return bl;
    }

    protected boolean stop(WASServiceData wASServiceData) {
        String string = wASServiceData.getServiceName();
        String string2 = wASServiceData.getExecStopArgs();
        String string3 = this.OSProps.getProperty("StopCmd");
        boolean bl = false;
        if (string == null) {
            String string4 = NLSFunctions.getXString("CWSFU0018E");
            wASServiceData.setException(new WASServiceException(string4));
            return bl;
        }
        string3 = string3.replaceAll(SERVICE_NAME_REPL, string);
        if (string2 != null) {
            string3 = string3 + " " + string2;
        }
        try {
            Process process = this.OSrt.exec(new String[]{"sh", "-c", string3});
            WASServiceOutputConsumer wASServiceOutputConsumer = new WASServiceOutputConsumer(process);
            wASServiceOutputConsumer.consume();
            int n = process.waitFor();
            wASServiceOutputConsumer.waitForOutput();
            String string5 = wASServiceOutputConsumer.getStatus();
            if (string5.equals("ERROR")) {
                throw new Exception(wASServiceOutputConsumer.getException());
            }
            if (n == 0) {
                Object[] objectArray = new Object[]{string};
                String string6 = NLSFunctions.getXFormattedString("CWSFU0012I", objectArray);
                System.out.println(string6);
                bl = true;
            } else {
                Object[] objectArray = new Object[]{string};
                String string7 = NLSFunctions.getXFormattedString("CWSFU0006E", objectArray);
                System.err.println(string7);
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            String string8 = iOException.getMessage();
            if (string8.indexOf(string) != -1) {
                Object[] objectArray = new Object[]{string};
                String string9 = NLSFunctions.getXFormattedString("CWSFU0016E", objectArray);
                System.err.println(string9);
                iOException2 = null;
            }
            wASServiceData.setException(iOException2);
        }
        catch (Exception exception) {
            wASServiceData.setException(exception);
        }
        return bl;
    }

    protected boolean status(WASServiceData wASServiceData) {
        String string = wASServiceData.getServiceName();
        String string2 = this.OSProps.getProperty("StatusCmd");
        boolean bl = false;
        if (string == null) {
            String string3 = NLSFunctions.getXString("CWSFU0018E");
            wASServiceData.setException(new WASServiceException(string3));
            return bl;
        }
        string2 = string2.replaceAll(SERVICE_NAME_REPL, string);
        try {
            Process process = this.OSrt.exec(new String[]{"sh", "-c", string2});
            WASServiceOutputConsumer wASServiceOutputConsumer = new WASServiceOutputConsumer(process);
            wASServiceOutputConsumer.consume();
            process.waitFor();
            wASServiceOutputConsumer.waitForOutput();
            String string4 = wASServiceOutputConsumer.getStatus();
            if (string4.equals("ERROR")) {
                throw new Exception(wASServiceOutputConsumer.getException());
            }
            System.out.print(string4);
            bl = true;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            String string5 = iOException.getMessage();
            if (string5.indexOf(string) != -1) {
                Object[] objectArray = new Object[]{string};
                String string6 = NLSFunctions.getXFormattedString("CWSFU0016E", objectArray);
                System.err.println(string6);
                iOException2 = null;
            }
            wASServiceData.setException(iOException2);
        }
        catch (Exception exception) {
            wASServiceData.setException(exception);
        }
        System.err.println("status() returning rc=" + bl);
        return bl;
    }

    protected boolean add(WASServiceData wASServiceData) {
        String string = wASServiceData.getServiceName();
        String string2 = wASServiceData.getServerName();
        String string3 = wASServiceData.getProfilePath();
        String string4 = wASServiceData.getWasHome();
        String string5 = wASServiceData.getUserId();
        String string6 = wASServiceData.getStartArgs();
        String string7 = wASServiceData.getStopArgs();
        String string8 = this.OSProps.getProperty("AddCmd");
        String string9 = this.OSProps.getProperty("ChmodCmd");
        String string10 = this.OSProps.getProperty("InitLocation");
        boolean bl = wASServiceData.useSu;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        boolean bl2 = false;
        if (string == null || string2 == null || string3 == null) {
            String string11 = NLSFunctions.getXString("CWSFU0018E");
            wASServiceData.setException(new WASServiceException(string11));
            return bl2;
        }
        try {
            if (string4 == null) {
                wASServiceData.setWasHome(System.getProperty("was.install.root"));
                string4 = wASServiceData.getWasHome();
                wASServiceData.setWasHome(null);
            }
        }
        catch (IOException iOException) {
            wASServiceData.setException(iOException);
            return bl2;
        }
        String string12 = string3 + SETUPCMDLINE_PATH;
        String string13 = string4 + PYSCRIPT_PATH;
        String string14 = string3 + WSADMIN_PATH;
        try {
            String string15;
            try {
                string15 = this.getNodeName(string12);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Object[] objectArray = new Object[]{string3};
                String string16 = NLSFunctions.getXFormattedString("CWSFU0020E", objectArray);
                System.err.println(string16);
                wASServiceData.setException(null);
                return bl2;
            }
            string8 = string8.replaceAll(SERVICE_NAME_REPL, string);
            string9 = string9.replaceAll(SERVICE_NAME_REPL, string);
            string14 = "\"" + string14 + "\" -conntype NONE -lang jython -f \"" + string13 + "\" \"" + string15 + "\" \"" + string2 + "\" \"" + string5 + "\"";
            string10 = string10.replaceAll(SERVICE_NAME_REPL, string);
            if (string15 == null) {
                String string17 = NLSFunctions.getXString("CWSFU0017E");
                throw new WASServiceException(string17);
            }
            this.createInitFile(string10, string2, string, string3, string4, string6, string7, string5, bl);
            Process process = this.OSrt.exec(new String[]{"sh", "-c", string9});
            WASServiceOutputConsumer wASServiceOutputConsumer = new WASServiceOutputConsumer(process);
            wASServiceOutputConsumer.consume();
            n2 = process.waitFor();
            wASServiceOutputConsumer.waitForOutput();
            String string18 = wASServiceOutputConsumer.getStatus();
            if (string18.equals("ERROR")) {
                throw new Exception(wASServiceOutputConsumer.getException());
            }
            if (string5 != null) {
                process = this.OSrt.exec(new String[]{"sh", "-c", string14});
                wASServiceOutputConsumer = new WASServiceOutputConsumer(process);
                wASServiceOutputConsumer.consume();
                n3 = process.waitFor();
                wASServiceOutputConsumer.waitForOutput();
                string18 = wASServiceOutputConsumer.getStatus();
                if (string18.equals("ERROR")) {
                    throw new Exception(wASServiceOutputConsumer.getException());
                }
            } else {
                n3 = 0;
            }
            process = this.OSrt.exec(new String[]{"sh", "-c", string8});
            wASServiceOutputConsumer = new WASServiceOutputConsumer(process);
            wASServiceOutputConsumer.consume();
            n = process.waitFor();
            wASServiceOutputConsumer.waitForOutput();
            string18 = wASServiceOutputConsumer.getStatus();
            if (string18.equals("ERROR")) {
                throw new Exception(wASServiceOutputConsumer.getException());
            }
            if (n == 0 && n2 == 0 && n3 == 0) {
                Object[] objectArray = new Object[]{string};
                String string19 = NLSFunctions.getXFormattedString("CWSFU0013I", objectArray);
                System.out.println(string19);
                bl2 = true;
            } else {
                Object[] objectArray = new Object[]{string};
                String string20 = NLSFunctions.getXFormattedString("CWSFU0007E", objectArray);
                System.err.println(string20);
            }
        }
        catch (Exception exception) {
            wASServiceData.setException(exception);
        }
        return bl2;
    }

    protected boolean remove(WASServiceData wASServiceData) {
        String string = wASServiceData.getServiceName();
        String string2 = this.OSProps.getProperty("RemoveCmd");
        String string3 = this.OSProps.getProperty("InitLocation");
        boolean bl = false;
        if (string == null) {
            String string4 = NLSFunctions.getXString("CWSFU0018E");
            wASServiceData.setException(new WASServiceException(string4));
            return bl;
        }
        string2 = string2.replaceAll(SERVICE_NAME_REPL, string);
        string3 = string3.replaceAll(SERVICE_NAME_REPL, string);
        try {
            Process process = this.OSrt.exec(new String[]{"sh", "-c", string2});
            WASServiceOutputConsumer wASServiceOutputConsumer = new WASServiceOutputConsumer(process);
            wASServiceOutputConsumer.consume();
            int n = process.waitFor();
            wASServiceOutputConsumer.waitForOutput();
            String string5 = wASServiceOutputConsumer.getStatus();
            if (string5.equals("ERROR")) {
                throw new Exception(wASServiceOutputConsumer.getException());
            }
            if (n == 0) {
                File file = new File(string3);
                if (file.delete()) {
                    Object[] objectArray = new Object[]{string};
                    String string6 = NLSFunctions.getXFormattedString("CWSFU0014I", objectArray);
                    System.out.println(string6);
                    bl = true;
                } else {
                    Object[] objectArray = new Object[]{string + SERVICE_FILE_SUFFIX};
                    String string7 = NLSFunctions.getXFormattedString("CWSFU0009E", objectArray);
                    System.err.println(string7);
                }
            } else {
                Object[] objectArray = new Object[]{string};
                String string8 = NLSFunctions.getXFormattedString("CWSFU0008E", objectArray);
                System.err.println(string8);
            }
        }
        catch (Exception exception) {
            wASServiceData.setException(exception);
        }
        return bl;
    }

    protected boolean hasInstallPermissions() {
        boolean bl = false;
        File file = null;
        String string = this.OSProps.getProperty("InitLocation");
        int n = string.indexOf(SERVICE_NAME_REPL);
        if (string == null) {
            return bl;
        }
        string = string.substring(0, n);
        try {
            file = new File(string);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            boolean bl2 = false;
            File file2 = File.createTempFile("WASServiceTest", SERVICE_FILE_SUFFIX, file);
            if (file2 != null) {
                bl = file2.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private void createInitFile(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl) throws IOException {
        int n;
        int n2;
        Object object;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        StringBuffer stringBuffer = new StringBuffer();
        File file = new File(string);
        boolean bl2 = false;
        BufferedReader bufferedReader = null;
        if (file.canWrite()) {
            bufferedReader = new BufferedReader(new FileReader(file));
            bl2 = true;
        } else {
            InputStream inputStream = classLoader.getResourceAsStream(TEMPLATE_RESOURCE);
            if (inputStream == null) {
                String string9 = NLSFunctions.getXString("CWSFU0015E");
                throw new IOException(string9);
            }
            object = new DataInputStream(inputStream);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object, "ISO-8859-1"));
        }
        object = new char[1024];
        while ((n2 = bufferedReader.read((char[])object)) != -1) {
            stringBuffer.append((char[])object, 0, n2);
        }
        bufferedReader.close();
        int n3 = stringBuffer.indexOf(SERVICE_NAME_PREFIX);
        if (n3 == -1) {
            if (!bl2) {
                String string10 = NLSFunctions.getXString("CWSFU0019E");
                throw new IOException(string10);
            }
        } else {
            n = stringBuffer.indexOf("\n", n3);
            if (n == -1) {
                String string11 = NLSFunctions.getXString("CWSFU0019E");
                throw new IOException(string11);
            }
            stringBuffer.replace(n3, n, "SERVICENAME=\"" + string3 + SERVICE_FILE_SUFFIX + "\"");
        }
        if (string2 != null) {
            n3 = stringBuffer.indexOf(SERVER_NAME_PREFIX);
            if (n3 == -1) {
                String string12 = NLSFunctions.getXString("CWSFU0019E");
                throw new IOException(string12);
            }
            n = stringBuffer.indexOf("\n", n3);
            if (n == -1) {
                String string13 = NLSFunctions.getXString("CWSFU0019E");
                throw new IOException(string13);
            }
            stringBuffer.replace(n3, n, "SERVERNAME=\"" + string2 + "\"");
        }
        if (string4 != null) {
            n3 = stringBuffer.indexOf(PROFILE_PATH_PREFIX);
            if (n3 == -1) {
                String string14 = NLSFunctions.getXString("CWSFU0019E");
                throw new IOException(string14);
            }
            n = stringBuffer.indexOf("\n", n3);
            if (n == -1) {
                String string15 = NLSFunctions.getXString("CWSFU0019E");
                throw new IOException(string15);
            }
            stringBuffer.replace(n3, n, "PROFILEPATH=\"" + string4 + "\"");
        }
        if (string5 != null) {
            n3 = stringBuffer.indexOf(WAS_HOME_PREFIX);
            if (n3 == -1) {
                String string16 = NLSFunctions.getXString("CWSFU0019E");
                throw new IOException(string16);
            }
            n = stringBuffer.indexOf("\n", n3);
            if (n == -1) {
                String string17 = NLSFunctions.getXString("CWSFU0019E");
                throw new IOException(string17);
            }
            stringBuffer.replace(n3, n, "WASHOME=\"" + string5 + "\"");
        }
        if (string6 != null) {
            n3 = stringBuffer.indexOf(START_ARGS_PREFIX);
            if (n3 == -1) {
                String string18 = NLSFunctions.getXString("CWSFU0019E");
                throw new IOException(string18);
            }
            n = stringBuffer.indexOf("\n", n3);
            if (n == -1) {
                String string19 = NLSFunctions.getXString("CWSFU0019E");
                throw new IOException(string19);
            }
            stringBuffer.replace(n3, n, "STARTARGS=\"" + string6 + "\"");
        }
        if (string7 != null) {
            n3 = stringBuffer.indexOf(STOP_ARGS_PREFIX);
            if (n3 == -1) {
                String string20 = NLSFunctions.getXString("CWSFU0019E");
                throw new IOException(string20);
            }
            n = stringBuffer.indexOf("\n", n3);
            if (n == -1) {
                String string21 = NLSFunctions.getXString("CWSFU0019E");
                throw new IOException(string21);
            }
            stringBuffer.replace(n3, n, "STOPARGS=\"" + string7 + "\"");
        }
        if (string8 != null && bl) {
            this.replaceInitEntry(stringBuffer, bl2, false, RUNAS_PREFIX, "RUNASUSER=\"" + string8 + "\"");
        }
        this.replaceInitEntry(stringBuffer, bl2, true, SERVICE_NAME_REPL, string3);
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        printWriter.write(stringBuffer.toString());
        printWriter.close();
    }

    private void replaceInitEntry(StringBuffer stringBuffer, boolean bl, boolean bl2, String string, String string2) throws IOException {
        int n = stringBuffer.indexOf(string);
        if (n == -1 && !bl2) {
            String string3 = NLSFunctions.getXString("CWSFU0019E");
            throw new IOException(string3);
        }
        int n2 = stringBuffer.indexOf("\n", n);
        if (n2 == -1) {
            String string4 = NLSFunctions.getXString("CWSFU0019E");
            throw new IOException(string4);
        }
        stringBuffer.replace(n, n2, string2);
    }

    private String getNodeName(String string) throws IOException {
        String string2;
        String string3 = null;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.indexOf(NODE_VAR_PREFIX) == -1) continue;
            int n = string2.indexOf(61) + 1;
            if (n >= string2.length()) break;
            string3 = string2.substring(n);
            break;
        }
        bufferedReader.close();
        if (string3 == "") {
            string3 = null;
        }
        return string3;
    }

    private class WASServiceOutputConsumerHelper
    implements Runnable {
        private BufferedReader bReader;
        private StringBuffer strBuf = new StringBuffer("");
        private Exception e;
        DataInputStream istream;

        WASServiceOutputConsumerHelper(BufferedReader bufferedReader) {
            this.bReader = bufferedReader;
        }

        public String getStatus() {
            return this.strBuf.toString();
        }

        public Exception getException() {
            return this.e;
        }

        public void run() {
            try {
                int n;
                char[] cArray = new char[1024];
                while ((n = this.bReader.read(cArray)) != -1) {
                    this.strBuf.append(cArray, 0, n);
                }
                this.bReader.close();
            }
            catch (IOException iOException) {
                this.strBuf = new StringBuffer();
                this.strBuf.append("ERROR");
                this.e = iOException;
            }
        }
    }

    private class WASServiceOutputConsumer {
        private Thread stdoutThread;
        private Thread stderrThread;
        private DataInputStream outStream;
        private DataInputStream errStream;
        BufferedReader outReader;
        BufferedReader errReader;
        WASServiceOutputConsumerHelper outConsumer;
        WASServiceOutputConsumerHelper errConsumer;

        WASServiceOutputConsumer(Process process) {
            this.outStream = new DataInputStream(process.getInputStream());
            this.errStream = new DataInputStream(process.getErrorStream());
            this.outReader = new BufferedReader(new InputStreamReader(this.outStream));
            this.errReader = new BufferedReader(new InputStreamReader(this.errStream));
            this.outConsumer = new WASServiceOutputConsumerHelper(this.outReader);
            this.errConsumer = new WASServiceOutputConsumerHelper(this.errReader);
            this.stdoutThread = new Thread(this.outConsumer);
            this.stderrThread = new Thread(this.errConsumer);
        }

        public void consume() {
            this.stdoutThread.start();
            this.stderrThread.start();
        }

        public void waitForOutput() {
            try {
                this.stdoutThread.join();
                this.stderrThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public String getStatus() {
            Object var1_1 = null;
            return this.outConsumer.getStatus();
        }

        public Exception getException() {
            Exception exception = this.outConsumer.e;
            if (exception == null) {
                exception = this.errConsumer.e;
            }
            return exception;
        }
    }
}

