/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.touchpoint.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.xml.product.product;
import com.ibm.ws.management.touchpoint.common.CommonUtility;
import com.ibm.ws.management.touchpoint.common.MessageHelper;
import com.ibm.ws.management.touchpoint.common.ServiceDataElementList;
import com.ibm.ws.management.touchpoint.common.UnknownResourceTypeException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Element;

public abstract class AbstractBaseManagedResource {
    private static final String sccsId = "@(#)92    1.4  SERV1/ws/code/admin.wstp/src/com/ibm/ws/management/touchpoint/common/AbstractBaseManagedResource.java, WAS.admin.wstp, WAS61.SERV1, cf311012.09  3/11/05  13:42:18";
    private static final String TRACE_GROUP = "SI.WebSphereTouchpoints";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(AbstractBaseManagedResource.class, "SI.WebSphereTouchpoints", "com.ibm.ws.management.touchpoint.nls.WSTPMessages");
    static MessageHelper errorMessageHelper = new MessageHelper("com.ibm.ws.management.touchpoint.nls.WSTPMessages");
    public ServiceDataElementList sdeList = new ServiceDataElementList();
    protected String managedResourceID;
    protected String configID;
    protected HashMap referenceProperties;
    protected ObjectName configData;

    public AbstractBaseManagedResource() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "<init>");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "<init>");
        }
    }

    public ServiceDataElementList getGenericProperty(ObjectName objectName, String string) throws ConfigServiceException, ConnectorException, UnknownResourceTypeException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getGenericProperty", new Object[]{objectName, string});
        }
        ServiceDataElementList serviceDataElementList = this.getSDEList();
        if (string.equals("resourceIdentifier")) {
            serviceDataElementList.add(string, this.managedResourceID);
        } else if (string.equals("resourceType")) {
            serviceDataElementList.add(string, CommonUtility.getMridType(this.managedResourceID));
        } else if (string.equals("version")) {
            serviceDataElementList.add(string, this.getVersion());
        } else if (string.equals("discriminant")) {
            serviceDataElementList.add(string, this.getHEMrid());
        } else {
            Session session = new Session();
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Config data is " + objectName);
            }
            Object object = this.getConfigService().getAttribute(session, objectName, string);
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Attribute is " + object);
            }
            this.getSDEList().add(string, object.toString());
            this.getConfigService().discard(session);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getGenericProperty", serviceDataElementList);
        }
        return serviceDataElementList;
    }

    public void setGenericProperty(ObjectName objectName, String string) throws ConfigServiceException, ConnectorException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "set", new Object[]{string});
        }
        Session session = new Session();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute(string2, string3));
        this.getConfigService().setAttributes(session, objectName, attributeList);
        this.getConfigService().save(session, false);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "set");
        }
    }

    public List queryGenericProperty(ObjectName objectName, String string) {
        return null;
    }

    protected List findConfigObjectType(String[] stringArray, String string) throws UnknownResourceTypeException, ConfigServiceException, ConnectorException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "findConfigObjectType", new Object[]{stringArray, string});
        }
        ConfigService configService = this.getConfigService();
        Session session = new Session();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = string;
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Type to find is " + string2);
            }
            if (string == null || string == "" || string == "*") {
                string3 = string2;
            }
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Expression to find is " + string3);
            }
            ObjectName[] objectNameArray = configService.resolve(session, string3);
            for (int j = 0; j < objectNameArray.length; ++j) {
                if (!ConfigServiceHelper.getConfigDataType(objectNameArray[j]).equals(string2)) continue;
                String string4 = ConfigServiceHelper.getConfigDataId(objectNameArray[j]).toString();
                if (string2 == "DeployableObject" || string2 == "DeploymentTarget" || string2 == "ResourceFactory") {
                    arrayList.add(CommonUtility.createMRID(this.getMrid(), string2, string4, false));
                    continue;
                }
                arrayList.add(CommonUtility.createMRID(this.getMrid(), string2, string4, true));
            }
        }
        this.getConfigService().discard(session);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "findConfigObjectType", arrayList);
        }
        return arrayList;
    }

    protected abstract ConfigService getConfigService();

    protected abstract String getVersion();

    protected ServiceDataElementList getSDEList() {
        return this.sdeList;
    }

    protected String getBaseVersion() {
        String string;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getBaseVersion");
        }
        try {
            WASProduct wASProduct;
            product product2;
            String string2 = (String)this.referenceProperties.get("WASInstallDir");
            if (string2 == null || string2.equals("")) {
                string2 = System.getProperty("was.install.root");
            }
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WAS install directory is " + string2);
            }
            if ((product2 = (wASProduct = new WASProduct(string2)).getProductById("BASE")) == null) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "collect Version info for ND Version");
                }
                product2 = wASProduct.getProductById("ND");
            }
            if (product2 == null) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Not base nor ND.  Search any available product version");
                }
                Iterator iterator = wASProduct.getProducts();
                while (iterator.hasNext() && (product2 = (product)iterator.next()) == null) {
                }
            }
            string = product2.getVersion();
        }
        catch (Throwable throwable) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Exception found, return default version", throwable);
            }
            string = "6.0.0.0";
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getBaseVersion", string);
        }
        return string;
    }

    protected String getNodeVersion(String string) throws AdminException {
        String string2;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getNodeVersion");
        }
        try {
            Session session = new Session();
            Properties properties = new Properties();
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell");
            ObjectName objectName2 = this.getConfigService().queryConfigObjects(session, null, objectName, null)[0];
            String string3 = ConfigServiceHelper.getDisplayName(objectName2);
            properties.put("local.cell", string3);
            ManagedObjectMetadataHelper managedObjectMetadataHelper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(properties));
            string2 = managedObjectMetadataHelper.getNodeBaseProductVersion(string);
            this.getConfigService().discard(session);
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        catch (Throwable throwable) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Exception found, return base version", throwable);
            }
            string2 = this.getBaseVersion();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getNodeVersion", string2);
        }
        return string2;
    }

    public Element serializeSDE(Element element) {
        StringWriter stringWriter = new StringWriter();
        XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, new OutputFormat("xml", "UTF-8", true));
        try {
            xMLSerializer.serialize(element);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return element;
    }

    public String getMrid() {
        return this.managedResourceID;
    }

    public String getHEMrid() {
        return CommonUtility.getMridHostMrid(this.managedResourceID);
    }
}

