/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.touchpoint.common;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.touchpoint.common.Constants;
import com.ibm.ws.management.touchpoint.common.UnknownResourceTypeException;
import java.io.ByteArrayOutputStream;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;

public class CommonUtility {
    private static final String sccsId = "@(#)22    1.1  SERV1/ws/code/admin.wstp/src/com/ibm/ws/management/touchpoint/common/CommonUtility.java, WAS.admin.wstp, WAS61.SERV1, cf311012.09  5/18/04  22:54:31";
    private static final String TRACE_GROUP = "SI.WebSphereTouchpoints";
    private static final String WILDCARD = "*";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(CommonUtility.class, "SI.WebSphereTouchpoints", "com.ibm.ws.management.touchpoint.nls.WSTPMessages");

    public static String createMRID(String string, String string2, String string3, boolean bl) throws UnknownResourceTypeException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createMRID", new Object[]{string, string2, string3, new Boolean(bl)});
        }
        String string4 = string2;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        if (bl) {
            for (int i = 0; i < Constants.MANAGED_RESOURCES_LIST.length; ++i) {
                String string5 = (String)Constants.MANAGED_RESOURCES_LIST[i][0];
                String[] stringArray = (String[])Constants.MANAGED_RESOURCES_LIST[i][1];
                for (int j = 0; j < stringArray.length; ++j) {
                    String string6 = stringArray[j];
                    if (!stringArray[j].equals(string2)) continue;
                    string4 = string5;
                    bl2 = true;
                    break;
                }
                if (bl2) break;
            }
        }
        if (!bl2 && bl) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "createMRID", "No type found.  Throw exception");
            }
            throw new UnknownResourceTypeException("Unknown type" + string2);
        }
        stringBuffer.append(string);
        stringBuffer.append("!");
        if (string4.equals("ResourceFactory")) {
            stringBuffer.append("J2EERT:" + string4);
        } else {
            stringBuffer.append("WSRT:" + string4);
        }
        stringBuffer.append(":");
        stringBuffer.append(string3);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createMRID", stringBuffer);
        }
        return stringBuffer.toString();
    }

    public static String getAppNameFromDeployment(ObjectName objectName) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getAppNameFromDeployment", new Object[]{objectName});
        }
        String string = null;
        String string2 = ConfigServiceHelper.getConfigDataId(objectName).getContextUri();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string3.equals("deployments") || !stringTokenizer.hasMoreTokens()) continue;
            string = stringTokenizer.nextToken();
            break;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAppNameFromDeployment", string);
        }
        return string;
    }

    public static boolean useWildcard(String string, String string2) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "useWildcard", new Object[]{string, string2});
        }
        boolean bl = false;
        int n = string.indexOf(WILDCARD);
        if (-1 != n) {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1);
            bl = string2.startsWith(string3) && string2.endsWith(string4);
        } else {
            bl = string.equals(string2);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "useWildcard", new Boolean(bl));
        }
        return bl;
    }

    public static void setupTrace() {
        String string = System.getProperty("trace");
        if (string != null && string != "") {
            String string2 = System.getProperty("traceFile");
            String string3 = "stdout";
            if (string2 != null) {
                string3 = "named file";
            }
            ManagerAdmin.configureClientTrace(string, string3, string2, true, null, false);
        }
    }

    public static String convertManageableResourceType(String string) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "convertManageableResourceType", new Object[]{string});
        }
        if (string.startsWith("J2EERT:")) {
            string = string.substring("J2EERT:".length());
        } else if (string.startsWith("WSRT:")) {
            string = string.substring("WSRT:".length());
        }
        String string2 = string.equals("Application") || string.equals("EJBModule") || string.equals("WebModule") ? string + "Deployment" : (string.equals("JavaMailProvider") ? "MailProvider" : string);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "convertManageableResourceType", string2);
        }
        return string2;
    }

    public static String getMridType(String string) throws UnknownResourceTypeException {
        String string2;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getMridType", new Object[]{string});
        }
        if (string.indexOf("!") != -1) {
            String string3 = CommonUtility.convertManageableResourceType(string.substring(string.indexOf("!") + 1));
            string2 = string3.substring(0, string3.indexOf(":"));
        } else if (string.startsWith("mrid:WSTP:WS_Domain")) {
            string2 = "WS_Domain";
        } else {
            throw new UnknownResourceTypeException("Unknow MRID " + string);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getMridType", string2);
        }
        return string2;
    }

    public static String getMridHostMrid(String string) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getMridConfigID", new Object[]{string});
        }
        int n = string.indexOf("!");
        String string2 = string.substring(0, n);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getMridConfigID", string2);
        }
        return string2;
    }

    public static String getMridConfigID(String string) throws UnknownResourceTypeException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getMridConfigID", new Object[]{string});
        }
        if (string.indexOf("!") == -1) {
            throw new UnknownResourceTypeException("Unknow MRID " + string);
        }
        String string2 = CommonUtility.convertManageableResourceType(string.substring(string.indexOf("!") + 1));
        String string3 = string2.substring(string2.indexOf(":") + 1);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getMridConfigID", string3);
        }
        return string3;
    }

    public String getStringFromElement(Element element) throws Exception {
        DOMSource dOMSource = new DOMSource(element);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(dOMSource, streamResult);
        return byteArrayOutputStream.toString();
    }
}

