/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.touchpoint.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.ws.management.touchpoint.common.ConfigRepositoryAccessException;
import com.ibm.ws.management.touchpoint.common.ConfigServiceCreationException;
import com.ibm.ws.management.touchpoint.common.MessageHelper;
import com.ibm.ws.management.touchpoint.common.SOAPConnectorAddress;
import com.ibm.ws.management.touchpoint.common.ServiceDataElementList;
import com.ibm.ws.management.touchpoint.common.TouchpointException;
import com.ibm.ws.management.touchpoint.common.UnknownManageableResourceIDException;
import com.ibm.ws.management.touchpoint.common.UnknownServerTypeException;
import com.ibm.ws.management.touchpoint.common.WebSphereConfigurationUnavailableException;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;

public class Configuration {
    private static final String sccsId = "@(#)25    1.1  SERV1/ws/code/admin.wstp/src/com/ibm/ws/management/touchpoint/common/Configuration.java, WAS.admin.wstp, WAS61.SERV1, cf311012.09  5/18/04  22:54:36";
    private static final String TRACE_GROUP = "SI.WebSphereTouchpoints";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(Configuration.class, "SI.WebSphereTouchpoints", "com.ibm.ws.management.touchpoint.nls.WSTPMessages");
    private static MessageHelper errorMessageHelper = new MessageHelper("com.ibm.ws.management.touchpoint.nls.WSTPMessages");
    private AdminClient adminClient;
    private ConfigService masterConfigService;
    private String repositoryPath;
    private SOAPConnectorAddress masterRepositoryAddress;
    private Session session;

    public Configuration(String string) throws TouchpointException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "<init>", string);
        }
        this.setRepositoryPath(string);
        this.setMasterConfigService();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "<init>");
        }
    }

    private SOAPConnectorAddress getMasterRepositoryAddress() {
        return this.masterRepositoryAddress;
    }

    private void setMasterRepositoryAddress(ConfigService configService) throws TouchpointException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setMasterRepositoryAddress");
        }
        SOAPConnectorAddress sOAPConnectorAddress = null;
        ObjectName[] objectNameArray = this.getNodesObjectName(configService);
        for (int i = 0; i < objectNameArray.length; ++i) {
            ObjectName objectName = objectNameArray[i];
            ObjectName objectName2 = this.hasDeploymentManager(configService, objectName);
            if (null == objectName2) continue;
            sOAPConnectorAddress = this.extractSOAPConnectorAddressFromServerEntry(configService, objectName2);
        }
        if (null == sOAPConnectorAddress) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "setMasterRepositoryAddress", "Base Websphere only");
            }
            ObjectName objectName = this.getCellObjectName(configService);
            sOAPConnectorAddress = this.getSOAPConnectorAddress(configService, objectName);
        }
        this.masterRepositoryAddress = sOAPConnectorAddress;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setMasterRepositoryAddress", sOAPConnectorAddress);
        }
    }

    private SOAPConnectorAddress getSOAPConnectorAddress(ConfigService configService, ObjectName objectName) throws ConfigRepositoryAccessException {
        Object object;
        Object object2;
        Object object3;
        Comparable<ObjectName> comparable;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSOAPConnectorAddress", new Object[]{configService, objectName});
        }
        if (null == configService) {
            configService = this.getMasterConfigService();
        }
        AttributeList attributeList = null;
        Session session = this.getSession();
        try {
            comparable = ConfigServiceHelper.createObjectName(null, "SOAPConnector");
            object3 = configService.queryConfigObjects(session, objectName, (ObjectName)comparable, null)[0];
            attributeList = (AttributeList)configService.getAttribute(session, (ObjectName)object3, "SOAP_CONNECTOR_ADDRESS");
            object2 = ConfigServiceHelper.getAttributeValue(attributeList, "port");
            object = ConfigServiceHelper.getAttributeValue(attributeList, "host");
        }
        catch (ConnectorException connectorException) {
            String string = connectorException.toString();
            Tr.error(TRACE_COMPONENT, "access_repository_error", string);
            String string2 = errorMessageHelper.getMessage("access_repository_error", string);
            throw new ConfigRepositoryAccessException(string2);
        }
        catch (ConfigServiceException configServiceException) {
            ConfigServiceException configServiceException2 = configServiceException;
            Tr.error(TRACE_COMPONENT, "access_repository_error", configServiceException2);
            String string = errorMessageHelper.getMessage("access_repository_error", configServiceException2);
            throw new ConfigRepositoryAccessException(string);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            AttributeNotFoundException attributeNotFoundException2 = attributeNotFoundException;
            Tr.error(TRACE_COMPONENT, "access_repository_error", attributeNotFoundException2);
            String string = errorMessageHelper.getMessage("access_repository_error", attributeNotFoundException2);
            throw new ConfigRepositoryAccessException(string);
        }
        comparable = (Integer)object2;
        object3 = (String)object;
        SOAPConnectorAddress sOAPConnectorAddress = new SOAPConnectorAddress((String)object3, (Integer)comparable);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSOAPConnectorAddress", sOAPConnectorAddress);
        }
        return sOAPConnectorAddress;
    }

    private static ConfigService createServerConfigService() throws ConfigServiceCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createServerConfigService");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createServerConfigService");
        }
        return ConfigServiceFactory.getConfigService();
    }

    private static ConfigService createLocalConfigService(String string) throws ConfigServiceCreationException {
        ConfigService configService;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createLocalConfigService", string);
        }
        System.setProperty("com.ibm.ws.management.standalone", "true");
        System.setProperty("was.repository.root", string);
        System.setProperty("user.install.root", string + File.separator + "..");
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "createLocalConfigService", "Using config repository: " + string);
        }
        RepositoryMetaData repositoryMetaData = null;
        try {
            repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            NoClassDefFoundError noClassDefFoundError2 = noClassDefFoundError;
            Tr.error(TRACE_COMPONENT, "access_repository_error_classpath", noClassDefFoundError2);
            String string2 = errorMessageHelper.getMessage("access_repository_error_classpath", noClassDefFoundError2);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createLocalConfigService", string2);
            }
            throw new ConfigServiceCreationException(string2);
        }
        if (null == repositoryMetaData) {
            String string3 = string;
            Tr.error(TRACE_COMPONENT, "access_repository_error_path", string3);
            String string4 = errorMessageHelper.getMessage("access_repository_error_path", string3);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createLocalConfigService", string4);
            }
            throw new ConfigServiceCreationException(string4);
        }
        try {
            Properties properties = new Properties();
            properties.setProperty("location", "local");
            configService = ConfigServiceFactory.createConfigService(true, properties);
        }
        catch (AdminException adminException) {
            Tr.error(TRACE_COMPONENT, "error_creating_config_service", adminException);
            String string5 = errorMessageHelper.getMessage("error_creating_config_service", adminException);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createLocalConfigService", string5);
            }
            throw new ConfigServiceCreationException(string5);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createLocalConfigService");
        }
        return configService;
    }

    private ConfigService createRemoteConfigService(String string, int n) throws ConfigServiceCreationException, WebSphereConfigurationUnavailableException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createRemoteConfigService", new Object[]{string, new Integer(n)});
        }
        ConfigServiceProxy configServiceProxy = null;
        AdminClient adminClient = Configuration.createAdminClient(string, n);
        this.setAdminClient(adminClient);
        try {
            configServiceProxy = new ConfigServiceProxy(adminClient);
        }
        catch (ConnectorException connectorException) {
            ConnectorException connectorException2 = connectorException;
            Tr.error(TRACE_COMPONENT, "access_repository_error_classpath", connectorException2);
            String string2 = errorMessageHelper.getMessage("access_repository_error_classpath", connectorException2);
            throw new ConfigServiceCreationException(string2);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            InstanceNotFoundException instanceNotFoundException2 = instanceNotFoundException;
            Tr.error(TRACE_COMPONENT, "access_repository_error_classpath", instanceNotFoundException2);
            String string3 = errorMessageHelper.getMessage("access_repository_error_classpath", instanceNotFoundException2);
            throw new ConfigServiceCreationException(string3);
        }
        return configServiceProxy;
    }

    private static AdminClient createAdminClient(String string, int n) throws WebSphereConfigurationUnavailableException {
        AdminClient adminClient;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createAdminClient", new Object[]{string, new Integer(n)});
        }
        Properties properties = new Properties();
        properties.setProperty("type", "SOAP");
        properties.setProperty("host", string);
        properties.setProperty("port", Integer.toString(n));
        try {
            adminClient = AdminClientFactory.createAdminClient(properties);
        }
        catch (ConnectorException connectorException) {
            boolean bl = false;
            Throwable throwable = connectorException.getCause();
            if (null != throwable && throwable instanceof InvocationTargetException && null != (throwable = ((InvocationTargetException)throwable).getTargetException()) && throwable instanceof ConnectorNotAvailableException && null != (throwable = ((ConnectorNotAvailableException)throwable).getCause()) && throwable.toString().indexOf("Connection refused") != -1) {
                bl = true;
            }
            Object[] objectArray = null;
            String string2 = null;
            if (bl) {
                objectArray = new Object[]{string, Integer.toString(n)};
                string2 = "connection_refused";
            } else {
                objectArray = new Object[]{connectorException};
                string2 = "error_creating_admin_client";
            }
            Tr.error(TRACE_COMPONENT, string2, objectArray);
            String string3 = errorMessageHelper.getMessage(string2, objectArray);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createAdminClient", string3);
            }
            throw new WebSphereConfigurationUnavailableException(string3);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createAdminClient");
        }
        return adminClient;
    }

    private void checkServerExistsLocally(String string, String string2) throws TouchpointException {
        String string3;
        Object object;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "checkServerExistsLocally", new Object[]{string, string2});
        }
        ConfigService configService = this.getMasterConfigService();
        List<ObjectName> list = Arrays.asList(this.getServersObjectName(configService));
        Iterator<ObjectName> iterator = list.iterator();
        boolean bl = false;
        String string4 = this.getLocalHostAddress();
        while (iterator.hasNext() && !bl) {
            object = iterator.next();
            string3 = ConfigServiceHelper.getDisplayName((ObjectName)object);
            if (!string2.equalsIgnoreCase(string3)) continue;
            String string5 = this.getSOAPConnectorAddress(configService, (ObjectName)object).getHostname();
            try {
                String string6 = InetAddress.getByName(string5).getHostAddress();
                if (!string4.equalsIgnoreCase(string6)) continue;
                bl = true;
            }
            catch (UnknownHostException unknownHostException) {
                Object[] objectArray = new Object[]{string5, unknownHostException};
                Tr.error(TRACE_COMPONENT, "address_resolution_failed", objectArray);
                String string7 = errorMessageHelper.getMessage("address_resolution_failed", objectArray);
                throw new TouchpointException(string7, unknownHostException);
            }
        }
        if (!bl) {
            object = string2;
            Tr.error(TRACE_COMPONENT, "server_not_present_on_local_machine", object);
            string3 = errorMessageHelper.getMessage("server_not_present_on_local_machine", object);
            throw new UnknownManageableResourceIDException(string3);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "checkServerExistsLocally");
        }
    }

    private String getRepositoryCellName(String string) throws TouchpointException {
        String string2;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getRepositoryCellName", string);
        }
        ConfigService configService = Configuration.createLocalConfigService(string);
        Session session = new Session();
        try {
            ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell", null);
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
            ObjectName objectName2 = objectNameArray[0];
            string2 = (String)configService.getAttribute(session, objectName2, "name");
            configService.discard(session);
        }
        catch (ConfigServiceException configServiceException) {
            Tr.error(TRACE_COMPONENT, "cannot_find_cell_name", string);
            String string3 = errorMessageHelper.getMessage("cannot_find_cell_name", string);
            throw new ConfigRepositoryAccessException(string3, configServiceException);
        }
        catch (ConnectorException connectorException) {
            Tr.error(TRACE_COMPONENT, "cannot_find_cell_name", string);
            String string4 = errorMessageHelper.getMessage("cannot_find_cell_name", string);
            throw new ConfigRepositoryAccessException(string4, connectorException);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getRepositoryCellName", string2);
        }
        return string2;
    }

    public ConfigService getMasterConfigService() {
        return this.masterConfigService;
    }

    private void setMasterConfigService() throws TouchpointException {
        ConfigService configService;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setMasterConfigService");
        }
        if ((configService = Configuration.createServerConfigService()) == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "setMasterConfigService", "Server configService is not available.  Using local ConfigService");
            }
            configService = Configuration.createLocalConfigService(this.getRepositoryPath());
            this.setSession(new Session());
            this.setMasterRepositoryAddress(configService);
            try {
                configService.discard(this.session);
            }
            catch (ConnectorException connectorException) {
            }
            catch (ConfigServiceException configServiceException) {
                // empty catch block
            }
            SOAPConnectorAddress sOAPConnectorAddress = this.getMasterRepositoryAddress();
            String string = sOAPConnectorAddress.getHostname();
            int n = sOAPConnectorAddress.getPort();
            try {
                this.masterConfigService = this.createRemoteConfigService(string, n);
            }
            catch (WebSphereConfigurationUnavailableException webSphereConfigurationUnavailableException) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "setMasterConfigService", "Remote ConfigService not available.  Using local ConfigService");
                }
                this.masterConfigService = configService;
            }
        } else {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "setMasterConfigService", "Server configService is available.  Using server ConfigService");
            }
            this.masterConfigService = configService;
        }
        this.setSession(new Session());
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setMasterConfigService");
        }
    }

    private ObjectName getCellObjectName(ConfigService configService) throws TouchpointException {
        ObjectName objectName;
        Object object;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getCellObjectName");
        }
        if (null == configService) {
            configService = this.getMasterConfigService();
        }
        String string = null;
        try {
            object = this.getSession();
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "Cell", null);
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getCellObjectName", objectName2);
            }
            ObjectName[] objectNameArray = configService.queryConfigObjects((Session)object, null, objectName2, null);
            objectName = objectNameArray[0];
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getCellObjectName", objectName);
            }
        }
        catch (ConnectorException connectorException) {
            Tr.error(TRACE_COMPONENT, "access_repository_error", connectorException);
            String string2 = errorMessageHelper.getMessage("access_repository_error", connectorException);
            throw new ConfigRepositoryAccessException(string2, connectorException);
        }
        catch (ConfigServiceException configServiceException) {
            Tr.error(TRACE_COMPONENT, "access_repository_error", configServiceException);
            String string3 = errorMessageHelper.getMessage("access_repository_error", configServiceException);
            throw new ConfigRepositoryAccessException(string3, configServiceException);
        }
        string = ConfigServiceHelper.getDisplayName(objectName);
        if (null == objectName || null == string) {
            Tr.error(TRACE_COMPONENT, "access_repository_error");
            object = errorMessageHelper.getMessage("access_repository_error");
            throw new ConfigRepositoryAccessException((String)object);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getCellObjectName", objectName);
        }
        return objectName;
    }

    private ObjectName[] getNodesObjectName(ConfigService configService) throws TouchpointException {
        ObjectName[] objectNameArray;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getNodesObjectName");
        }
        if (null == configService) {
            configService = this.getMasterConfigService();
        }
        ObjectName objectName = this.getCellObjectName(configService);
        try {
            Session session = this.getSession();
            objectNameArray = configService.getRelationship(session, objectName, "Node");
        }
        catch (ConnectorException connectorException) {
            Tr.error(TRACE_COMPONENT, "access_repository_error", connectorException);
            String string = errorMessageHelper.getMessage("access_repository_error", connectorException);
            throw new ConfigRepositoryAccessException(string, connectorException);
        }
        catch (ConfigServiceException configServiceException) {
            Tr.error(TRACE_COMPONENT, "access_repository_error", configServiceException);
            String string = errorMessageHelper.getMessage("access_repository_error", configServiceException);
            throw new ConfigRepositoryAccessException(string, configServiceException);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getNodesObjectName", objectNameArray);
        }
        return objectNameArray;
    }

    private ObjectName[] getServersObjectName(ConfigService configService) throws TouchpointException {
        ObjectName[] objectNameArray;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getServersObjectName");
        }
        if (null == configService) {
            configService = this.getMasterConfigService();
        }
        ArrayList arrayList = new ArrayList();
        try {
            objectNameArray = this.getSession();
            ObjectName[] objectNameArray2 = this.getNodesObjectName(configService);
            List<ObjectName> list = Arrays.asList(objectNameArray2);
            Iterator<ObjectName> iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName = iterator.next();
                ObjectName[] objectNameArray3 = configService.getRelationship((Session)objectNameArray, objectName, "Server");
                ArrayList<ObjectName> arrayList2 = new ArrayList<ObjectName>();
                for (int i = 0; i < objectNameArray3.length; ++i) {
                    ObjectName objectName2 = objectNameArray3[i];
                    if (!this.isApplicationServer(configService, objectName2)) continue;
                    arrayList2.add(objectName2);
                }
                arrayList.addAll(arrayList2);
            }
        }
        catch (ConnectorException connectorException) {
            Tr.error(TRACE_COMPONENT, "access_repository_error", connectorException);
            String string = errorMessageHelper.getMessage("access_repository_error", connectorException);
            throw new ConfigRepositoryAccessException(string, connectorException);
        }
        catch (ConfigServiceException configServiceException) {
            Tr.error(TRACE_COMPONENT, "access_repository_error", configServiceException);
            String string = errorMessageHelper.getMessage("access_repository_error", configServiceException);
            throw new ConfigRepositoryAccessException(string, configServiceException);
        }
        objectNameArray = arrayList.toArray(new ObjectName[0]);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getServersObjectName", objectNameArray);
        }
        return objectNameArray;
    }

    public void getConfigObj(String string, ServiceDataElementList serviceDataElementList) throws TouchpointException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getConfigObj");
        }
        try {
            Session session = this.getSession();
            ConfigService configService = this.getMasterConfigService();
            ObjectName objectName = this.getCellObjectName(configService);
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, string);
            ObjectName objectName3 = configService.queryConfigObjects(session, objectName, objectName2, null)[0];
            AttributeList attributeList = configService.getAttributes(session, objectName3, null, false);
            Iterator iterator = attributeList.iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "getConfigObj", serviceDataElementList + " Attribute " + attribute.getName() + "=" + attribute.getValue());
                }
                serviceDataElementList.add(attribute.getName(), attribute.getValue().toString());
            }
        }
        catch (ConnectorException connectorException) {
            Tr.error(TRACE_COMPONENT, "access_repository_error", connectorException);
            String string2 = errorMessageHelper.getMessage("access_repository_error", connectorException);
            throw new ConfigRepositoryAccessException(string2, connectorException);
        }
        catch (ConfigServiceException configServiceException) {
            Tr.error(TRACE_COMPONENT, "access_repository_error", configServiceException);
            String string3 = errorMessageHelper.getMessage("access_repository_error", configServiceException);
            throw new ConfigRepositoryAccessException(string3, configServiceException);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getConfigObj", serviceDataElementList);
        }
    }

    private String getLocalHostAddress() throws TouchpointException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getLocalHostAddress");
        }
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            Object[] objectArray = new Object[]{"localhost", unknownHostException};
            Tr.error(TRACE_COMPONENT, "address_resolution_failed", objectArray);
            String string2 = errorMessageHelper.getMessage("address_resolution_failed", objectArray);
            throw new TouchpointException(string2, unknownHostException);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getLocalHostAddress", string);
        }
        return string;
    }

    public List listApplications() throws TouchpointException {
        Vector vector;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "listApplications");
        }
        AppManagement appManagement = this.getAppManagement();
        ArrayList<String> arrayList = new ArrayList<String>();
        AbstractList abstractList = new ArrayList();
        Hashtable hashtable = new Hashtable();
        String string = null;
        try {
            vector = appManagement.listApplications(hashtable, string);
        }
        catch (AdminException adminException) {
            Tr.error(TRACE_COMPONENT, "error_list_applications", adminException);
            String string2 = errorMessageHelper.getMessage("error_list_applications", adminException);
            throw new WebSphereConfigurationUnavailableException(string2, adminException);
        }
        abstractList = vector;
        Iterator iterator = abstractList.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            arrayList.add(string3);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "listApplications", arrayList);
        }
        return arrayList;
    }

    public AppManagement getAppManagement() throws TouchpointException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getAppManagement");
        }
        AppManagement appManagement = null;
        try {
            appManagement = AppManagementProxy.getJMXProxyForServer();
        }
        catch (Exception exception) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getAppManagement", "Error getting Server Appmanagement Proxy");
            }
            appManagement = null;
        }
        if (appManagement == null) {
            AdminClient adminClient = this.getAdminClient();
            if (adminClient == null) {
                try {
                    appManagement = AppManagementProxy.getLocalProxy();
                }
                catch (Exception exception) {
                    Tr.error(TRACE_COMPONENT, "error_get_local_app_management");
                    String string = errorMessageHelper.getMessage("error_get_local_app_management");
                    throw new WebSphereConfigurationUnavailableException(string, exception);
                }
            }
            try {
                appManagement = AppManagementProxy.getJMXProxyForClient(adminClient);
            }
            catch (Exception exception) {
                Tr.error(TRACE_COMPONENT, "error_get_remote_app_management");
                String string = errorMessageHelper.getMessage("error_get_remote_app_management");
                throw new WebSphereConfigurationUnavailableException(string, exception);
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAppManagement", appManagement);
        }
        return appManagement;
    }

    private AdminClient getAdminClient() {
        return this.adminClient;
    }

    private void setAdminClient(AdminClient adminClient) {
        this.adminClient = adminClient;
    }

    public String toString() {
        return "Configuration:path=" + this.getRepositoryPath();
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    private void setRepositoryPath(String string) {
        this.repositoryPath = string;
    }

    private boolean hasModuleDeployedOnServer(String string, String string2) throws TouchpointException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "hasModuleDeployedOnServer", new Object[]{string, string2});
        }
        boolean bl = false;
        AppManagement appManagement = this.getAppManagement();
        Hashtable hashtable = new Hashtable();
        String string3 = null;
        AppDeploymentTask appDeploymentTask = null;
        try {
            appDeploymentTask = (AppDeploymentTask)appManagement.listModules(string, hashtable, string3);
        }
        catch (AdminException adminException) {
            Object[] objectArray = new Object[]{string, adminException};
            Tr.error(TRACE_COMPONENT, "error_list_modules", objectArray);
            String string4 = errorMessageHelper.getMessage("error_list_modules", objectArray);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "hasModuleDeployedOnServer", string4);
            }
            throw new WebSphereConfigurationUnavailableException(string4);
        }
        if (null == appDeploymentTask) {
            String string5 = string;
            Tr.error(TRACE_COMPONENT, "error_list_modules", string5);
            String string6 = errorMessageHelper.getMessage("error_list_modules", string5);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "hasModuleDeployedOnServer", string6);
            }
            throw new WebSphereConfigurationUnavailableException(string6);
        }
        List list = Configuration.parseModuleInformation(appDeploymentTask);
        bl = list.contains(string2);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "hasModuleDeployedOnServer", new Boolean(bl));
        }
        return bl;
    }

    private static List parseModuleInformation(AppDeploymentTask appDeploymentTask) throws TouchpointException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "parseModuleInformation", appDeploymentTask);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String[][] stringArray = appDeploymentTask.getTaskData();
        int n = stringArray.length;
        for (int i = 1; i < n; ++i) {
            String string = stringArray[i][2];
            String string2 = Configuration.parseServerString(string);
            arrayList.add(string2);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "parseModuleInformation", arrayList);
        }
        return arrayList;
    }

    private static String parseServerString(String string) throws WebSphereConfigurationUnavailableException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = stringTokenizer.nextToken();
        int n = string2.indexOf("=");
        String string3 = string2.substring(n + 1);
        String string4 = stringTokenizer.nextToken();
        n = string4.indexOf("=");
        String string5 = string4.substring(n + 1);
        String string6 = stringTokenizer.nextToken();
        n = string6.indexOf("=");
        String string7 = string6.substring(n + 1);
        if (stringTokenizer.hasMoreTokens()) {
            String string8 = string;
            Tr.error(TRACE_COMPONENT, "error_parse_server_string", string8);
            String string9 = errorMessageHelper.getMessage("error_parse_server_string", string8);
            throw new WebSphereConfigurationUnavailableException(string9);
        }
        StringBuffer stringBuffer = new StringBuffer(string3);
        stringBuffer.append("/");
        stringBuffer.append(string5);
        stringBuffer.append("/");
        stringBuffer.append(string7);
        String string10 = stringBuffer.toString();
        return string10;
    }

    private boolean isApplicationServer(ConfigService configService, ObjectName objectName) throws TouchpointException {
        if (null == configService) {
            configService = this.getMasterConfigService();
        }
        boolean bl = false;
        Session session = this.getSession();
        String string = null;
        try {
            string = (String)configService.getAttribute(session, objectName, "serverType");
        }
        catch (ConfigServiceException configServiceException) {
            ObjectName objectName2 = objectName;
            Tr.error(TRACE_COMPONENT, "cannot_determine_server_type", objectName2);
            String string2 = errorMessageHelper.getMessage("cannot_determine_server_type", objectName2);
            throw new UnknownServerTypeException(string2, configServiceException);
        }
        catch (ConnectorException connectorException) {
            ObjectName objectName3 = objectName;
            Tr.error(TRACE_COMPONENT, "cannot_determine_server_type", objectName3);
            String string3 = errorMessageHelper.getMessage("cannot_determine_server_type", objectName3);
            throw new UnknownServerTypeException(string3, connectorException);
        }
        if (string.equalsIgnoreCase("APPLICATION_SERVER")) {
            bl = true;
        }
        return bl;
    }

    private ObjectName hasDeploymentManager(ConfigService configService, ObjectName objectName) throws TouchpointException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "hasDeploymentManager", objectName);
        }
        ObjectName objectName2 = null;
        String string = "DEPLOYMENT_MANAGER";
        Session session = this.getSession();
        try {
            ObjectName objectName3 = configService.getRelationship(session, objectName, "ServerIndex")[0];
            AttributeList attributeList = configService.getAttributes(session, objectName3, new String[]{"serverEntries"}, false);
            List list = (List)ConfigServiceHelper.getAttributeValue(attributeList, "serverEntries");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName4 = (ObjectName)iterator.next();
                String string2 = (String)configService.getAttribute(session, objectName4, "serverType");
                if (!string2.equals(string)) continue;
                objectName2 = objectName4;
                break;
            }
        }
        catch (ConnectorException connectorException) {
            Tr.error(TRACE_COMPONENT, "access_repository_error", connectorException);
            String string3 = errorMessageHelper.getMessage("access_repository_error", connectorException);
            throw new ConfigRepositoryAccessException(string3, connectorException);
        }
        catch (ConfigServiceException configServiceException) {
            Tr.error(TRACE_COMPONENT, "access_repository_error", configServiceException);
            String string4 = errorMessageHelper.getMessage("access_repository_error", configServiceException);
            throw new ConfigRepositoryAccessException(string4, configServiceException);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            Tr.error(TRACE_COMPONENT, "access_repository_error", attributeNotFoundException);
            String string5 = errorMessageHelper.getMessage("access_repository_error", attributeNotFoundException);
            throw new ConfigRepositoryAccessException(string5, attributeNotFoundException);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "hasDeploymentManager", objectName2);
        }
        return objectName2;
    }

    private SOAPConnectorAddress extractSOAPConnectorAddressFromServerEntry(ConfigService configService, ObjectName objectName) throws TouchpointException {
        Object object;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "extractSOAPCOnnectorAddressFromServerEntry", objectName);
        }
        Session session = this.getSession();
        String string = null;
        int n = 0;
        try {
            object = (List)configService.getAttribute(session, objectName, "specialEndpoints");
            Iterator iterator = object.iterator();
            boolean bl = true;
            AttributeList attributeList = null;
            while (iterator.hasNext() && bl) {
                AttributeList attributeList2 = (AttributeList)iterator.next();
                String string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList2, "endPointName");
                if (!string2.equalsIgnoreCase("SOAP_CONNECTOR_ADDRESS")) continue;
                attributeList = attributeList2;
                Iterator iterator2 = attributeList.iterator();
                while (iterator2.hasNext()) {
                    Attribute attribute = (Attribute)iterator2.next();
                    String string3 = attribute.getName();
                    if (!string3.equalsIgnoreCase("endpoint")) continue;
                    AttributeList attributeList3 = (AttributeList)attribute.getValue();
                    string = (String)ConfigServiceHelper.getAttributeValue(attributeList3, "host");
                    Integer n2 = (Integer)ConfigServiceHelper.getAttributeValue(attributeList3, "port");
                    n = n2;
                    break;
                }
                bl = false;
            }
        }
        catch (ConnectorException connectorException) {
            Tr.error(TRACE_COMPONENT, "access_repository_error", connectorException);
            String string4 = errorMessageHelper.getMessage("access_repository_error", connectorException);
            throw new ConfigRepositoryAccessException(string4, connectorException);
        }
        catch (ConfigServiceException configServiceException) {
            Tr.error(TRACE_COMPONENT, "access_repository_error", configServiceException);
            String string5 = errorMessageHelper.getMessage("access_repository_error", configServiceException);
            throw new ConfigRepositoryAccessException(string5, configServiceException);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            Tr.error(TRACE_COMPONENT, "access_repository_error", attributeNotFoundException);
            String string6 = errorMessageHelper.getMessage("access_repository_error", attributeNotFoundException);
            throw new ConfigRepositoryAccessException(string6, attributeNotFoundException);
        }
        object = new SOAPConnectorAddress(string, n);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "extractSOAPCOnnectorAddressFromServerEntry");
        }
        return object;
    }

    private Session getSession() {
        return this.session;
    }

    private void setSession(Session session) {
        this.session = session;
    }

    public void close() throws TouchpointException {
        try {
            this.getMasterConfigService().discard(this.getSession());
        }
        catch (ConnectorException connectorException) {
        }
        catch (ConfigServiceException configServiceException) {
            // empty catch block
        }
    }
}

