/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.touchpoint.si;

import com.ibm.ac.si.cm.hosts.EndpointReference;
import com.ibm.ac.si.cm.hosts.HostsCallOut;
import com.ibm.ac.si.cm.hosts.ICommon;
import com.ibm.ac.si.cm.hosts.IEndpoint;
import com.ibm.ac.si.cm.hosts.InvalidQueryExpressionException;
import com.ibm.ac.si.cm.hosts.InvalidResPropPathExprException;
import com.ibm.ac.si.cm.hosts.InvalidValueException;
import com.ibm.ac.si.cm.hosts.ManagerAlreadySetException;
import com.ibm.ac.si.cm.hosts.ManagerRejectedException;
import com.ibm.ac.si.cm.hosts.NotSupportedException;
import com.ibm.ac.si.cm.hosts.UnableToModifyPropertyException;
import com.ibm.ac.si.cm.hosts.UnknownResourceException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.touchpoint.common.AbstractBaseManagedResource;
import com.ibm.ws.management.touchpoint.common.Configuration;
import com.ibm.ws.management.touchpoint.common.MessageHelper;
import com.ibm.ws.management.touchpoint.common.ServiceDataElementList;
import com.ibm.ws.management.touchpoint.common.TouchpointException;
import com.ibm.ws.management.touchpoint.common.UnknownResourceTypeException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.management.ObjectName;
import org.w3c.dom.Element;

public abstract class AbstractManagedResource
extends AbstractBaseManagedResource
implements ICommon,
IEndpoint {
    private static final String sccsId = "@(#)48    1.3  SERV1/ws/code/admin.wstp/src/com/ibm/ws/management/touchpoint/si/AbstractManagedResource.java, WAS.admin.wstp, WAS61.SERV1, cf311012.09  6/10/04  17:32:51";
    private static final String TRACE_GROUP = "SI.WebSphereTouchpoints";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(AbstractManagedResource.class, "SI.WebSphereTouchpoints", "com.ibm.ws.management.touchpoint.nls.WSTPMessages");
    static MessageHelper errorMessageHelper = new MessageHelper("com.ibm.ws.management.touchpoint.nls.WSTPMessages");
    private static final String CLASSNAME = "AbstractManagedResource";
    EndpointReference managerReference;
    static Configuration configuration;
    boolean is5X = false;

    public AbstractManagedResource() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "<init>");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "<init>");
        }
    }

    public void assignManager(EndpointReference endpointReference) throws ManagerAlreadySetException, ManagerRejectedException {
        this.managerReference = endpointReference;
    }

    public void assignManager(HostsCallOut hostsCallOut) throws ManagerAlreadySetException, ManagerRejectedException {
    }

    public void setReferenceProperties(HashMap hashMap) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setReferenceProperties");
        }
        this.referenceProperties = hashMap;
        this.managedResourceID = (String)this.referenceProperties.get("MRID");
        this.configID = (String)this.referenceProperties.get("ConfigID");
        if (this.referenceProperties.containsKey("WAS5")) {
            this.is5X = new Boolean((String)this.referenceProperties.get("WAS5"));
        }
        Session session = new Session();
        try {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Config ID is " + this.configID);
            }
            if (this.configID.equals("Cell")) {
                ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell");
                this.configData = this.getConfigService().queryConfigObjects(session, null, objectName, null)[0];
            } else {
                ObjectName objectName = ConfigServiceHelper.createObjectName(new ConfigDataId(this.configID));
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Config type is " + objectName);
                }
                this.configData = this.getConfigService().queryConfigObjects(session, null, objectName, null)[0];
            }
            this.getConfigService().discard(session);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setReferenceProperties", this.configData);
        }
    }

    public Element get(String string) throws InvalidResPropPathExprException, UnknownResourceException {
        ServiceDataElementList serviceDataElementList;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "get", new Object[]{string});
        }
        try {
            serviceDataElementList = super.getGenericProperty(this.configData, string);
        }
        catch (UnknownResourceTypeException unknownResourceTypeException) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Unknown Resource");
            }
            throw new UnknownResourceException((Object)CLASSNAME, "get", (Throwable)unknownResourceTypeException, null);
        }
        catch (Exception exception) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Exception caught while getting property");
            }
            throw new InvalidResPropPathExprException((Object)this, "get", (Throwable)exception, string);
        }
        Element element = serviceDataElementList.getElement();
        serviceDataElementList.clear();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "get", element);
        }
        return element;
    }

    public void set(String string) throws NotSupportedException, InvalidValueException, UnableToModifyPropertyException, InvalidResPropPathExprException, UnknownResourceException {
        throw new NotSupportedException((Object)CLASSNAME, "set", "set not supported", null);
    }

    public void set(Element element) throws NotSupportedException, InvalidValueException, UnableToModifyPropertyException, InvalidResPropPathExprException, UnknownResourceException {
        throw new NotSupportedException((Object)CLASSNAME, "set", "set not supported", null);
    }

    public List query(String string) throws NotSupportedException, InvalidResPropPathExprException, InvalidQueryExpressionException, UnknownResourceException {
        throw new NotSupportedException((Object)CLASSNAME, "query", "set not supported", null);
    }

    protected String getVersion() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getVersion");
        }
        String string = this.getBaseVersion();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getVersion", string);
        }
        return string;
    }

    protected void setConfiguration(Configuration configuration) {
        AbstractManagedResource.configuration = configuration;
    }

    protected Configuration getConfiguration() {
        if (configuration == null) {
            String string = (String)this.referenceProperties.get("ConfigRoot");
            if (configuration == null || string == null || !configuration.getRepositoryPath().equals(string)) {
                try {
                    if (string == null || string.equals("")) {
                        string = System.getProperty("was.repository.root");
                    }
                    configuration = new Configuration(string);
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Configuration is " + configuration);
                    }
                }
                catch (TouchpointException touchpointException) {
                    touchpointException.printStackTrace();
                }
            }
        }
        return configuration;
    }

    protected ConfigService getConfigService() {
        return configuration.getMasterConfigService();
    }

    protected AppManagement getAppManagement() throws TouchpointException {
        return configuration.getAppManagement();
    }

    protected String getAppVersion(String string, String string2) {
        Object object;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getAppVersion", new Object[]{string, string2});
        }
        AppDeploymentTask appDeploymentTask = null;
        try {
            object = this.getAppManagement();
            appDeploymentTask = (AppDeploymentTask)object.listModules(string, new Hashtable(), null);
        }
        catch (Exception exception) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Exception while getting appManagement " + exception);
            }
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Return default version");
            }
            return "13";
        }
        object = null;
        String string3 = appDeploymentTask.getName();
        String[] stringArray = appDeploymentTask.getColumnNames();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            String[][] stringArray2;
            if (stringArray[i].equals(string2) && (stringArray2 = appDeploymentTask.getTaskData()) != null && (n2 = 1) < stringArray2.length) {
                object = stringArray2[n2][i];
            }
            if (object != null && !((String)object).equals("")) break;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAppVersion", object);
        }
        return object;
    }
}

