/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.touchpoint.si;

import com.ibm.ac.si.cm.hosts.InvalidResPropPathExprException;
import com.ibm.ac.si.cm.hosts.UnknownResourceException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.touchpoint.common.CommonUtility;
import com.ibm.ws.management.touchpoint.common.Constants;
import com.ibm.ws.management.touchpoint.common.GetRelatedResourcesException;
import com.ibm.ws.management.touchpoint.si.AbstractManagedResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.w3c.dom.Element;

public class DeployableObject
extends AbstractManagedResource {
    private static final String sccsId = "@(#)49    1.3  SERV1/ws/code/admin.wstp/src/com/ibm/ws/management/touchpoint/si/DeployableObject.java, WAS.admin.wstp, WAS61.SERV1, cf311012.09  6/16/04  21:29:09";
    private static final String TRACE_GROUP = "SI.WebSphereTouchpoints";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(DeployableObject.class, "SI.WebSphereTouchpoints", "com.ibm.ws.management.touchpoint.nls.WSTPMessages");
    private boolean resolveResourceJNDIMap = true;
    private HashMap resourceJNDIMap = new HashMap();

    public DeployableObject() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "<init>");
        }
    }

    public void setReferenceProperties(HashMap hashMap) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setReferenceProperties");
        }
        super.setReferenceProperties(hashMap);
        if (hashMap.containsKey("ResolveResourceJNDIMap")) {
            this.resolveResourceJNDIMap = (Boolean)hashMap.get("ResolveResourceJNDIMap");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setReferenceProperties");
        }
    }

    public List getRelationships(String string, String string2, String string3, String string4) throws GetRelatedResourcesException {
        ArrayList<String> arrayList;
        block28: {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.entry(TRACE_COMPONENT, "getRelationships", new Object[]{string, string2, string3, string4});
            }
            arrayList = new ArrayList<String>();
            try {
                if (string.equals("deployedOn")) {
                    Session session = new Session();
                    List list = (List)this.getConfigService().getAttribute(session, this.configData, "targetMappings");
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "targetMappingList is " + list);
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        String string5;
                        Object object;
                        AttributeList attributeList = (AttributeList)list.get(i);
                        ObjectName objectName = ConfigServiceHelper.createObjectName(attributeList);
                        ObjectName objectName2 = (ObjectName)this.getConfigService().getAttribute(session, objectName, "target");
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "deploymentTarget is " + objectName2 + " Type is " + ConfigServiceHelper.getConfigDataType(objectName2));
                        }
                        String string6 = (String)this.getConfigService().getAttribute(session, objectName2, "name");
                        if (ConfigServiceHelper.getConfigDataType(objectName2).equals("ServerTarget")) {
                            object = (String)this.getConfigService().getAttribute(session, objectName2, "nodeName");
                            if (TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "targetName is " + string6 + " targetNodeName is " + (String)object);
                            }
                            string5 = "Node=" + (String)object + ":Server=" + string6;
                        } else {
                            string5 = "Cluster=" + string6;
                        }
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "target to resolve is " + string5);
                        }
                        object = this.getConfigService().resolve(session, string5)[0];
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "Target Object name is " + object);
                        }
                        String string7 = ConfigServiceHelper.getConfigDataId((ObjectName)object).toString();
                        arrayList.add(CommonUtility.createMRID(this.getHEMrid(), "DeploymentTarget", string7, false));
                    }
                    this.getConfigService().discard(session);
                    break block28;
                }
                if (string.equals("uses")) {
                    HashMap hashMap;
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Creating local AppManagementImpl");
                    }
                    AppManagement appManagement = this.getAppManagement();
                    Vector vector = appManagement.getApplicationInfo(CommonUtility.getAppNameFromDeployment(this.configData), new Hashtable(), null);
                    if (this.resourceJNDIMap == null || this.resourceJNDIMap.isEmpty() || this.resolveResourceJNDIMap) {
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "Construct new resourceJNDI map", new Object[]{new Boolean(this.resolveResourceJNDIMap)});
                        }
                        hashMap = this.constructResourceJNDIName();
                    } else {
                        hashMap = this.resourceJNDIMap;
                    }
                    Object var10_12 = null;
                    AppDeploymentTask appDeploymentTask = null;
                    for (int i = 0; i < vector.size(); ++i) {
                        appDeploymentTask = (AppDeploymentTask)vector.elementAt(i);
                        String string8 = appDeploymentTask.getName();
                        if (string8.equals("EmbeddedRar")) continue;
                        String[] stringArray = appDeploymentTask.getColumnNames();
                        int n = stringArray.length;
                        int n2 = -1;
                        int n3 = -1;
                        for (int j = 0; j < n; ++j) {
                            if ("module".equals(stringArray[j])) {
                                n3 = j;
                            }
                            if (!"JNDI".equals(stringArray[j])) continue;
                            n2 = j;
                        }
                        if (n2 == -1) continue;
                        String[][] stringArray2 = appDeploymentTask.getTaskData();
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "jndi column found.  task: " + string8);
                        }
                        if (stringArray2 == null) continue;
                        Object var19_30 = null;
                        String string9 = null;
                        boolean bl = false;
                        for (int j = 1; j < stringArray2.length; ++j) {
                            string9 = stringArray2[j][n2];
                            if (TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "jndi name  " + string9);
                            }
                            if (string9 == null || !hashMap.containsKey(string9)) continue;
                            String string10 = ConfigServiceHelper.getConfigDataId((ObjectName)hashMap.get(string9)).toString();
                            String string11 = CommonUtility.createMRID(this.getHEMrid(), "ResourceFactory", string10, false);
                            if (arrayList.contains(string11)) continue;
                            arrayList.add(string11);
                        }
                    }
                    break block28;
                }
                throw new GetRelatedResourcesException("Unsupported relationship type" + string);
            }
            catch (Exception exception) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "getRelationships", "Exception caught " + exception);
                }
                throw new GetRelatedResourcesException("Exception while getting relationship", exception);
            }
            finally {
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getRelationships", arrayList);
                }
            }
        }
        return arrayList;
    }

    public Element get(String string) throws InvalidResPropPathExprException, UnknownResourceException {
        Element element;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "get", new Object[]{string});
        }
        if (string.equalsIgnoreCase("Name")) {
            this.getSDEList().add(string, CommonUtility.getAppNameFromDeployment(this.configData));
            element = this.getSDEList().getElement();
        } else if (string.equalsIgnoreCase("installLocation")) {
            this.getSDEList().add(string, this.getAppLocation());
            element = this.getSDEList().getElement();
        } else {
            element = super.get(string);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "get", element);
        }
        return element;
    }

    protected String getVersion() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getVersion");
        }
        if (this.is5X) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WAS 5X.  Return default version");
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getVersion", "13");
            }
            return "13";
        }
        String string = this.getType();
        String string2 = null;
        string2 = string.equals(Constants.DEPLOYABLE_OBJECT_TYPE_LIST[0]) ? "AppVersion" : (string.equals(Constants.DEPLOYABLE_OBJECT_TYPE_LIST[1]) ? "EJBVersion" : "ModuleVersion");
        String string3 = this.getAppVersion(CommonUtility.getAppNameFromDeployment(this.configData), string2);
        if (string3 == null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Application version not found.  Return default application version");
            }
            string3 = "13";
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getVersion", string3);
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAppLocation() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getAppLocation");
        }
        Session session = new Session();
        String string = "";
        try {
            string = (String)this.getConfigService().getAttribute(session, this.configData, "binariesURL");
        }
        catch (Exception exception) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Exception while getting attribute binariesURL" + exception);
            }
        }
        finally {
            try {
                this.getConfigService().discard(session);
            }
            catch (Exception exception) {}
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAppLocation", string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap constructResourceJNDIName() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "constructResourceJNDIName");
        }
        Session session = new Session();
        try {
            for (int i = 0; i < Constants.RESOURCE_FACTORY_TYPE_LIST.length; ++i) {
                ObjectName[] objectNameArray = this.getConfigService().resolve(session, Constants.RESOURCE_FACTORY_TYPE_LIST[i]);
                for (int j = 0; j < objectNameArray.length; ++j) {
                    String string = (String)this.getConfigService().getAttribute(session, objectNameArray[j], "jndiName");
                    this.resourceJNDIMap.put(string, objectNameArray[j]);
                }
            }
        }
        catch (Exception exception) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Exception occured while resolve JNDI map." + exception);
            }
        }
        finally {
            try {
                this.getConfigService().discard(session);
            }
            catch (Exception exception) {}
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "constructResourceJNDIName", this.resourceJNDIMap);
        }
        return this.resourceJNDIMap;
    }

    private String getType() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getType");
        }
        String string = ConfigServiceHelper.getConfigDataType(this.configData);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getType", string);
        }
        return string;
    }
}

