/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.touchpoint.si;

import com.ibm.ac.si.relreg.Relationship;
import com.ibm.ac.si.relreg.RelationshipMember;
import com.ibm.ac.si.relreg.RelationshipRole;
import com.ibm.ac.si.tpif.TouchpointException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.touchpoint.common.CommonUtility;
import com.ibm.ws.management.touchpoint.common.GetRelatedResourcesException;
import com.ibm.ws.management.touchpoint.common.UnknownResourceTypeException;
import com.ibm.ws.management.touchpoint.si.DeployableObject;
import com.ibm.ws.management.touchpoint.si.InternalRelationship;
import com.ibm.ws.management.touchpoint.si.WSDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class RelationshipResolver {
    private static final String sccsId = "@(#)54    1.3  SERV1/ws/code/admin.wstp/src/com/ibm/ws/management/touchpoint/si/RelationshipResolver.java, WAS.admin.wstp, WAS61.SERV1, cf311012.09  6/10/04  17:32:57";
    private static final String TRACE_GROUP = "SI.WebSphereTouchpoints";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(RelationshipResolver.class, "SI.WebSphereTouchpoints", "com.ibm.ws.management.touchpoint.nls.WSTPMessages");
    WSDomain wsdomain;

    public RelationshipResolver(WSDomain wSDomain) throws TouchpointException {
        this.wsdomain = wSDomain;
    }

    public List listRelationships(List list, List list2, List list3) throws TouchpointException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "listRelationships");
        }
        List list4 = this.getAllRelationships();
        List list5 = RelationshipResolver.filterByRelationshipType(list4, list2);
        List list6 = RelationshipResolver.filterByMemberType(list5, list);
        List list7 = RelationshipResolver.filterByRoleList(list6, list3);
        List list8 = this.convertToRelationshipList(list7);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "listRelationships", list8);
        }
        return list8;
    }

    private List convertToRelationshipList(List list) {
        Iterator iterator = list.iterator();
        ArrayList<Relationship> arrayList = new ArrayList<Relationship>();
        while (iterator.hasNext()) {
            InternalRelationship internalRelationship = (InternalRelationship)iterator.next();
            Relationship relationship = internalRelationship.convertToRelationship();
            arrayList.add(relationship);
        }
        return arrayList;
    }

    public static List filterByRoleList(List list, List list2) {
        List<InternalRelationship> list3 = new ArrayList();
        if (null == list2 || list2.isEmpty()) {
            list3 = list;
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                InternalRelationship internalRelationship = (InternalRelationship)iterator.next();
                RelationshipMember relationshipMember = internalRelationship.getRelatedMember();
                RelationshipRole relationshipRole = relationshipMember.getRole();
                if (!list2.contains(relationshipRole)) continue;
                list3.add(internalRelationship);
            }
        }
        return list3;
    }

    public static List filterByRelationshipType(List list, List list2) {
        List<InternalRelationship> list3 = new ArrayList();
        if (null == list2 || list2.isEmpty()) {
            list3 = list;
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                InternalRelationship internalRelationship = (InternalRelationship)iterator.next();
                String string = internalRelationship.getType();
                if (!list2.contains(string)) continue;
                list3.add(internalRelationship);
            }
        }
        return list3;
    }

    public static List filterByMemberType(List list, List list2) {
        List<InternalRelationship> list3 = new ArrayList();
        if (null == list2 || list2.isEmpty()) {
            list3 = list;
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                InternalRelationship internalRelationship = (InternalRelationship)iterator.next();
                RelationshipMember relationshipMember = internalRelationship.getRelatedMember();
                String string = relationshipMember.getType();
                if (!list2.contains(string)) continue;
                list3.add(internalRelationship);
            }
        }
        return list3;
    }

    private List getAllRelationships() throws TouchpointException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getAllCellRelationships");
        }
        ArrayList<InternalRelationship> arrayList = new ArrayList<InternalRelationship>();
        try {
            List list;
            RelationshipMember relationshipMember = this.convertToRelationshipMember(this.wsdomain.getMrid(), RelationshipRole.SOURCE);
            try {
                list = this.wsdomain.getRelationships("hosts", null, null, null);
            }
            catch (GetRelatedResourcesException getRelatedResourcesException) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Error while getting relationship");
                }
                throw new TouchpointException("Error while getting relationship", (Exception)getRelatedResourcesException);
            }
            DeployableObject deployableObject = new DeployableObject();
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                RelationshipMember relationshipMember2 = this.convertToRelationshipMember(string, RelationshipRole.SINK);
                InternalRelationship internalRelationship = new InternalRelationship("hosts", relationshipMember, relationshipMember2, RelationshipRole.SINK);
                arrayList.add(internalRelationship);
                try {
                    String string2 = CommonUtility.getMridType(string);
                    if (!string2.equals("DeployableObject")) continue;
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("MRID", string);
                    hashMap.put("ConfigID", CommonUtility.getMridConfigID(string));
                    hashMap.put("ResolveResourceJNDIMap", new Boolean(false));
                    if (this.wsdomain.getIs5X()) {
                        hashMap.put("WAS5", "true");
                    }
                    deployableObject.setReferenceProperties(hashMap);
                    List list2 = this.getDeployableObjectRelationships(deployableObject, relationshipMember2, "uses");
                    List list3 = this.getDeployableObjectRelationships(deployableObject, relationshipMember2, "deployedOn");
                    arrayList.addAll(list2);
                    arrayList.addAll(list3);
                    continue;
                }
                catch (GetRelatedResourcesException getRelatedResourcesException) {
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Error while getting relationship");
                    }
                    throw new TouchpointException("Error while getting relationship", (Exception)getRelatedResourcesException);
                }
            }
        }
        catch (UnknownResourceTypeException unknownResourceTypeException) {
            throw new TouchpointException("Error while getting mrid type", (Exception)unknownResourceTypeException);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAllCellRelationships", arrayList);
        }
        return arrayList;
    }

    private List getDeployableObjectRelationships(DeployableObject deployableObject, RelationshipMember relationshipMember, String string) throws GetRelatedResourcesException, UnknownResourceTypeException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getUsesRelationships");
        }
        List list = deployableObject.getRelationships(string, "", "", "");
        ArrayList<InternalRelationship> arrayList = new ArrayList<InternalRelationship>();
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            RelationshipMember relationshipMember2 = this.convertToRelationshipMember(string2, RelationshipRole.SINK);
            InternalRelationship internalRelationship = new InternalRelationship(string, relationshipMember, relationshipMember2, RelationshipRole.SINK);
            arrayList.add(internalRelationship);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getUsesRelationships", arrayList);
        }
        return arrayList;
    }

    public RelationshipMember convertToRelationshipMember(String string, RelationshipRole relationshipRole) throws UnknownResourceTypeException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "convertToRelationshipMember", relationshipRole);
        }
        String string2 = CommonUtility.getMridType(string);
        RelationshipMember relationshipMember = new RelationshipMember(relationshipRole, string2, (Object)string);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "convertToRelationshipMember", relationshipMember);
        }
        return relationshipMember;
    }
}

