/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.touchpoint.si;

import com.ibm.ac.si.cm.hosts.InstalledSoftwareQueryParameters;
import com.ibm.ac.si.cm.hosts.InvalidResPropPathExprException;
import com.ibm.ac.si.tpif.Version;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.touchpoint.common.CommonUtility;
import com.ibm.ws.management.touchpoint.common.Constants;
import com.ibm.ws.management.touchpoint.common.GetRelatedResourcesException;
import com.ibm.ws.management.touchpoint.common.InvalidXPathExpressionException;
import com.ibm.ws.management.touchpoint.common.UnknownResourceTypeException;
import com.ibm.ws.management.touchpoint.si.AbstractManagedResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class WSDomain
extends AbstractManagedResource {
    private static final String sccsId = "@(#)94    1.4  SERV1/ws/code/admin.wstp/src/com/ibm/ws/management/touchpoint/si/WSDomain.java, WAS.admin.wstp, WAS61.SERV1, cf311012.09  6/16/04  21:29:17";
    private static final String TRACE_GROUP = "SI.WebSphereTouchpoints";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSDomain.class, "SI.WebSphereTouchpoints", "com.ibm.ws.management.touchpoint.nls.WSTPMessages");

    public WSDomain() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "<init>");
        }
    }

    public void setReferenceProperties(HashMap hashMap) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setReferenceProperties");
        }
        this.referenceProperties = hashMap;
        configuration = this.getConfiguration();
        super.setReferenceProperties(hashMap);
    }

    public List findManagedResource(String string, String string2) throws UnknownResourceTypeException, InvalidXPathExpressionException {
        return this.findManagedResource(string, string2, true);
    }

    public List findManagedResource(String string, String string2, boolean bl) throws UnknownResourceTypeException, InvalidXPathExpressionException {
        List list;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "findManagedResource", new Object[]{string, string2, new Boolean(bl)});
        }
        string = CommonUtility.convertManageableResourceType(string);
        String[] stringArray = null;
        try {
            for (int i = 0; i < Constants.MANAGED_RESOURCES_LIST.length; ++i) {
                String string3 = (String)Constants.MANAGED_RESOURCES_LIST[i][0];
                if (!string3.equalsIgnoreCase(string)) continue;
                stringArray = (String[])Constants.MANAGED_RESOURCES_LIST[i][1];
                break;
            }
            if (stringArray == null) {
                stringArray = new String[]{string};
            }
            list = this.findConfigObjectType(stringArray, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InvalidXPathExpressionException("Unknown resource");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "findManagedResource", list);
        }
        return list;
    }

    public List getRelationships(String string, String string2, String string3, String string4) throws GetRelatedResourcesException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getRelationships", new Object[]{string, string2, string3, string4});
        }
        if (!string.equals("hosts")) {
            throw new GetRelatedResourcesException("Unsupported relationship type" + string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Session session = new Session();
        if (string3 != null) {
            string3 = CommonUtility.convertManageableResourceType(string3);
        }
        try {
            for (int i = 0; i < Constants.MANAGED_RESOURCES_LIST.length; ++i) {
                String string5 = (String)Constants.MANAGED_RESOURCES_LIST[i][0];
                String[] stringArray = (String[])Constants.MANAGED_RESOURCES_LIST[i][1];
                for (int j = 0; j < stringArray.length; ++j) {
                    String string6 = stringArray[j];
                    if (string3 != null && !string3.equals("") && !string6.equals(string3)) continue;
                    ObjectName objectName = ConfigServiceHelper.createObjectName(null, string6);
                    ObjectName[] objectNameArray = this.getConfigService().queryConfigObjects(session, null, objectName, null);
                    for (int k = 0; k < objectNameArray.length; ++k) {
                        String string7 = ConfigServiceHelper.getConfigDataId(objectNameArray[k]).toString();
                        arrayList.add(CommonUtility.createMRID(this.getMrid(), string5, string7, false));
                    }
                }
            }
            this.getConfigService().discard(session);
        }
        catch (Exception exception) {
            Tr.error(TRACE_COMPONENT, "operation_failed", exception);
            String string8 = errorMessageHelper.getMessage("operation_failed", exception);
            throw new GetRelatedResourcesException(string8, exception);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getRelationships", arrayList);
        }
        return arrayList;
    }

    public List listInstalledSoftware(String string) throws ConfigServiceException, AttributeNotFoundException, ConnectorException, InvalidResPropPathExprException, UnknownResourceTypeException {
        String string2;
        Object object;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "listInstalledSoftware", string);
        }
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        Version version = null;
        Version version2 = null;
        if (string != null && !string.equals("")) {
            object = InstalledSoftwareQueryParameters.fromString((String)string);
            string2 = object.getName();
            if (string2 == null || string2.equals("")) {
                string2 = "*";
            }
            if ((version = object.getMinVersion()) != null) {
                n = Integer.valueOf(version.getVersion());
            }
            if ((version2 = object.getMaxVersion()) != null) {
                n2 = Integer.valueOf(version2.getVersion());
            }
        } else {
            string2 = "*";
        }
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "SoftwareName: " + string2 + "; minVersion " + n + "; maxVersion " + n2);
        }
        object = this.listInstalledSoftware(string2, n, n2);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "listInstalledSoftware", object);
        }
        return object;
    }

    protected List listInstalledSoftware(String string, int n, int n2) throws ConfigServiceException, AttributeNotFoundException, ConnectorException, InvalidResPropPathExprException, UnknownResourceTypeException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "listInstalledSoftware", new Object[]{string, new Integer(n), new Integer(n2)});
        }
        Session session = new Session();
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Deployment");
        ObjectName[] objectNameArray = this.getConfigService().queryConfigObjects(session, null, objectName, null);
        this.getConfigService().discard(session);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string2 = CommonUtility.getAppNameFromDeployment(objectNameArray[i]);
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "appName is " + string2);
            }
            if (!string.equals("*") && !CommonUtility.useWildcard(string, string2)) continue;
            int n3 = 0;
            if (n != 0 || n2 != Integer.MAX_VALUE) {
                n3 = this.getAppVersion(string2);
            }
            if (n > n3 || n3 > n2) continue;
            AttributeList attributeList = this.getConfigService().getAttributes(session, objectNameArray[i], new String[]{"deployedObject"}, false);
            ObjectName objectName2 = (ObjectName)ConfigServiceHelper.getAttributeValue(attributeList, "deployedObject");
            String string3 = ConfigServiceHelper.getConfigDataId(objectName2).toString();
            arrayList.add(CommonUtility.createMRID(this.getMrid(), "DeployableObject", string3, false));
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "listInstalledSoftware", arrayList);
        }
        return arrayList;
    }

    private int getAppVersion(String string) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getAppVersion", string);
        }
        int n = 0;
        if (this.is5X) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getAppVersion", "WAS 5X, return 0");
            }
            return n;
        }
        String string2 = super.getAppVersion(string, "AppVersion");
        if (string2 != null && !string2.equals("")) {
            n = Integer.parseInt(string2);
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Application version not found.  Return 0");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAppVersion", new Integer(n));
        }
        return n;
    }

    boolean getIs5X() {
        return this.is5X;
    }
}

