/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.touchpoint.tpru;

import com.ibm.ac.si.cm.hosts.EndpointReference;
import com.ibm.ac.si.tpif.TouchpointException;
import com.ibm.ac.si.tpreg.ITouchpointRegistry;
import com.ibm.ac.si.tpreg.ManageableResourceDefinition;
import com.ibm.ac.si.tpreg.TouchpointAlreadyRegisteredException;
import com.ibm.ac.si.tpreg.TpregRegistrationFailedException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.touchpoint.common.CommonUtility;
import com.ibm.ws.management.touchpoint.common.MessageHelper;
import com.ibm.ws.scripting.WasxShell;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;

public class RegisterTouchpoints {
    private static final String sccsId = "@(#)07    1.5  SERV1/ws/code/admin.wstp/src/com/ibm/ws/management/touchpoint/tpru/RegisterTouchpoints.java, WAS.admin.wstp, WAS602.SERV1, o0502.03  9/8/04  16:02:31";
    private static final String TRACE_GROUP = "SI.WebSphereTouchpoints";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(RegisterTouchpoints.class, "SI.WebSphereTouchpoints", "com.ibm.ws.management.touchpoint.nls.TRUMessages");
    private static final MessageHelper MSG_HELPER = new MessageHelper("com.ibm.ws.management.touchpoint.nls.TRUMessages");
    private static final String COMMAND_NAME = "registerwstp";
    private static final String WS_DOMAIN_MRID = "mrid:WSTP:WS_Domain";
    private static final String DEFAULT_DOMAIN_ADDRESS_CONTEXT = "/WebSphereTPHosts/services/HostsPort";
    private static final String DEFAULT_TP_REGISTRY_CLASSNAME = "com.ibm.ac.si.tpreg.TouchpointRegistryImpl";
    private boolean verbose = false;
    private ITouchpointRegistry touchpointRegistry = null;
    private String touchpointRegistryClassname = "com.ibm.ac.si.tpreg.TouchpointRegistryImpl";
    private static boolean verboseArgument = false;
    private static boolean register = false;
    private static boolean deploy = false;
    private static boolean is5X = false;
    private static String tpregclassArgument = null;
    private static String wsdlLocation = null;
    private static String configRootArgument = null;
    private static String xmlFileName = null;
    private static String wasInstallDir = null;
    private static String hostName = "localhost";
    private static String portNumber = "9080";
    private static String nodeName = null;
    private static String serverName = null;
    private static String appLocation = null;
    private static String appName = null;
    private static String jaclLocation = null;
    private static String[] siJars = new String[]{"/lib/si.jar", "/lib/jlog.jar", "/lib/cmserver.jar", "/dat/wstp/lib/iuddmodel.jar", "/dat/wstp/lib/mediamodel.jar"};

    public static void main(String[] stringArray) throws TouchpointException {
        if (RegisterTouchpoints.validateArguments(stringArray)) {
            RegisterTouchpoints registerTouchpoints = new RegisterTouchpoints();
            registerTouchpoints.setVerbose(verboseArgument);
            if (null != tpregclassArgument) {
                registerTouchpoints.setTouchpointRegistryClassname(tpregclassArgument);
            }
            if (register) {
                registerTouchpoints.registerTouchpoints();
            }
            if (deploy) {
                registerTouchpoints.deployApplication();
            }
        }
        System.exit(0);
    }

    private static boolean validateArguments(String[] stringArray) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "validateArguments", stringArray);
        }
        int n = 0;
        boolean bl = true;
        if (stringArray.length == 0) {
            System.out.println(MSG_HELPER.getMessage("usage", COMMAND_NAME));
            bl = false;
        }
        while (n < stringArray.length && bl) {
            String string = stringArray[n];
            if (string.equalsIgnoreCase("-?") | string.equalsIgnoreCase("-h")) {
                System.out.println(MSG_HELPER.getMessage("usage", COMMAND_NAME));
                bl = false;
            } else if (string.equalsIgnoreCase("-v")) {
                verboseArgument = true;
            } else if (string.equalsIgnoreCase("-register")) {
                register = true;
            } else if (string.equalsIgnoreCase("-deploy")) {
                deploy = true;
            } else if (string.equalsIgnoreCase("-tpregclass")) {
                if (n > stringArray.length - 2 || stringArray[n + 1].startsWith("-")) {
                    System.err.println("Argument -tpregclass needs a value");
                    bl = false;
                } else {
                    tpregclassArgument = stringArray[++n];
                }
            } else if (string.equalsIgnoreCase("-xmlfile")) {
                if (n > stringArray.length - 2 || stringArray[n + 1].startsWith("-")) {
                    System.err.println("Argument -xmlfile needs a value");
                    bl = false;
                } else {
                    xmlFileName = stringArray[++n];
                }
            } else if (string.equalsIgnoreCase("-repository")) {
                if (n > stringArray.length - 2 || stringArray[n + 1].startsWith("-")) {
                    System.err.println("Argument -repository needs a value");
                    bl = false;
                } else {
                    configRootArgument = stringArray[++n];
                }
            } else if (string.equalsIgnoreCase("-wsdllocation")) {
                if (n > stringArray.length - 2 || stringArray[n + 1].startsWith("-")) {
                    System.err.println("Argument -wsdllocation needs a value");
                    bl = false;
                } else {
                    wsdlLocation = stringArray[++n];
                }
            } else if (string.equalsIgnoreCase("-wasinstalldir")) {
                if (n > stringArray.length - 2 || stringArray[n + 1].startsWith("-")) {
                    System.err.println("Argument -wasinstalldir  needs a value");
                    bl = false;
                } else {
                    wasInstallDir = stringArray[++n];
                }
            } else if (string.equalsIgnoreCase("-hostname")) {
                if (n > stringArray.length - 2 || stringArray[n + 1].startsWith("-")) {
                    System.err.println("Argument -hostname  needs a value");
                    bl = false;
                } else {
                    hostName = stringArray[++n];
                }
            } else if (string.equalsIgnoreCase("-port")) {
                if (n > stringArray.length - 2 || stringArray[n + 1].startsWith("-")) {
                    System.err.println("Argument -port  needs a value");
                    bl = false;
                } else {
                    portNumber = stringArray[++n];
                }
            } else if (string.equalsIgnoreCase("-5")) {
                is5X = true;
            } else if (string.equalsIgnoreCase("-nodeName")) {
                if (n > stringArray.length - 2 || stringArray[n + 1].startsWith("-")) {
                    System.err.println("Argument -nodeName  needs a value");
                    bl = false;
                } else {
                    nodeName = stringArray[++n];
                }
            } else if (string.equalsIgnoreCase("-serverName")) {
                if (n > stringArray.length - 2 || stringArray[n + 1].startsWith("-")) {
                    System.err.println("Argument -serverName  needs a value");
                    bl = false;
                } else {
                    serverName = stringArray[++n];
                }
            } else if (string.equalsIgnoreCase("-appLocation")) {
                if (n > stringArray.length - 2 || stringArray[n + 1].startsWith("-")) {
                    System.err.println("Argument -appLocation  needs a value");
                    bl = false;
                } else {
                    appLocation = stringArray[++n];
                }
            } else if (string.equalsIgnoreCase("-appName")) {
                if (n > stringArray.length - 2 || stringArray[n + 1].startsWith("-")) {
                    System.err.println("Argument -appName  needs a value");
                    bl = false;
                } else {
                    appName = stringArray[++n];
                }
            } else if (string.equalsIgnoreCase("-scriptLocation")) {
                if (n > stringArray.length - 2 || stringArray[n + 1].startsWith("-")) {
                    System.err.println("Argument -scriptLocation  needs a value");
                    bl = false;
                } else {
                    jaclLocation = stringArray[++n];
                }
            } else {
                System.err.println(MSG_HELPER.getMessage("unrecognised_argument", string));
                System.err.println(MSG_HELPER.getMessage("usage", COMMAND_NAME));
                bl = false;
            }
            ++n;
        }
        if (register && (wsdlLocation == null || wasInstallDir == null || configRootArgument == null) && xmlFileName == null) {
            System.err.println(MSG_HELPER.getMessage("missing_required_registration_argument", COMMAND_NAME));
            bl = false;
        } else if (deploy && (appLocation == null || serverName == null || jaclLocation == null || nodeName == null)) {
            System.err.println(MSG_HELPER.getMessage("missing_required_deployment_argument", COMMAND_NAME));
            bl = false;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "validateArguments", "valid=" + (bl ? "true" : "false"));
        }
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, tpregclassArgument + " " + configRootArgument + " " + wsdlLocation);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "validateArguments", new Boolean(bl));
        }
        return bl;
    }

    private void loadTouchpointRegistry() throws TouchpointException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "loadTouchpointRegistry");
        }
        String string = this.getTouchpointRegistryClassname();
        if (this.isVerbose()) {
            System.out.println("Loading Touchpoint Registry as class " + string);
        }
        try {
            this.touchpointRegistry = (ITouchpointRegistry)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{string, exception};
            Tr.error(TRACE_COMPONENT, "class_newinstance_error", objectArray);
            String string2 = MSG_HELPER.getMessage("class_newinstance_error", objectArray);
            throw new TouchpointException(string2, exception);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "loadTouchpointRegistry");
        }
    }

    private String createEPRString() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createEPRString");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("MRID", this.constructDomainMRID());
        hashMap.put("ConfigID", "Cell");
        if (configRootArgument != null && !configRootArgument.equals("")) {
            hashMap.put("ConfigRoot", configRootArgument);
        }
        if (wasInstallDir != null && !wasInstallDir.equals("")) {
            hashMap.put("WASInstallDir", wasInstallDir);
        }
        hashMap.put("LocalBinding", "sijava:com.ibm.ws.management.touchpoint.si.WebSphereDomain");
        if (is5X) {
            hashMap.put("WAS5", "true");
        }
        StringBuffer stringBuffer = new StringBuffer("sisoap:http://");
        stringBuffer.append(hostName);
        stringBuffer.append(":");
        stringBuffer.append(portNumber);
        stringBuffer.append(DEFAULT_DOMAIN_ADDRESS_CONTEXT);
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "SOAP WebSphere Domain address is" + stringBuffer.toString());
        }
        EndpointReference endpointReference = new EndpointReference(stringBuffer.toString(), hashMap);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createEPRString", endpointReference.toString());
        }
        return endpointReference.toString();
    }

    private String constructDomainMRID() {
        String string;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "constructDomainMRID");
        }
        try {
            string = is5X ? InetAddress.getLocalHost().getHostName() : InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "localhost";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(WS_DOMAIN_MRID);
        stringBuffer.append(":" + string);
        stringBuffer.append(":" + wasInstallDir);
        stringBuffer.append(":" + this.getConfigInstanceName(configRootArgument));
        String string2 = stringBuffer.toString();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "constructDomainMRID", string2);
        }
        return string2;
    }

    public RegisterTouchpoints() {
    }

    public RegisterTouchpoints(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "init", new Object[]{string, string2, string3});
        }
        if (string != null && string != "") {
            this.setTouchpointRegistryClassname(string);
        }
        configRootArgument = string2;
        wsdlLocation = string3;
        wasInstallDir = string4;
        if (string5 != null && string5 != "") {
            hostName = string5;
        }
        if (string6 != null && string6 != "") {
            portNumber = string6;
        }
        is5X = bl;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "init");
        }
    }

    public RegisterTouchpoints(String string) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "init", string);
        }
        xmlFileName = string;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "init");
        }
    }

    public void registerTouchpoints() throws TouchpointException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "registerTouchpoints");
        }
        System.out.println("Registering...");
        this.loadTouchpointRegistry();
        ITouchpointRegistry iTouchpointRegistry = this.getTouchpointRegistry();
        if (xmlFileName != null) {
            try {
                System.out.println("Registering with xml " + xmlFileName);
                iTouchpointRegistry.registerTouchpoint(xmlFileName);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "registerTouchpoints");
            }
            return;
        }
        String string = this.createEPRString();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("WSRT:WS_Domain");
        System.out.println("Adding definitions to Touchpoint Registry...");
        ManageableResourceDefinition manageableResourceDefinition = new ManageableResourceDefinition(this.constructDomainMRID(), arrayList, wsdlLocation, string);
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, manageableResourceDefinition.toString());
        }
        if (this.isVerbose()) {
            System.out.println("...Adding " + manageableResourceDefinition);
        }
        try {
            iTouchpointRegistry.registerTouchpoint(manageableResourceDefinition, true);
        }
        catch (TouchpointAlreadyRegisteredException touchpointAlreadyRegisteredException) {
            System.out.println((Object)touchpointAlreadyRegisteredException);
        }
        catch (TpregRegistrationFailedException tpregRegistrationFailedException) {
            tpregRegistrationFailedException.printStackTrace();
            System.out.println((Object)tpregRegistrationFailedException);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "registerTouchpoints");
        }
    }

    public boolean deployApplication(String string, String string2, String string3, String string4, String string5) {
        System.out.println("Deploying Applications...");
        String[] stringArray = new String[10];
        int n = 0;
        stringArray[n++] = "-conntype";
        stringArray[n++] = "none";
        stringArray[n++] = "-f";
        stringArray[n++] = string;
        stringArray[n++] = string2;
        stringArray[n++] = string3;
        stringArray[n++] = string4;
        if (appName != null) {
            stringArray[n++] = string5;
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.println(stringArray2[i]);
        }
        WasxShell wasxShell = new WasxShell();
        wasxShell.run(stringArray2);
        if (!is5X) {
            if (wasxShell.getReturnCode() == 0) {
                if (this.setSIClasspath(string2, string3)) {
                    System.out.println(MSG_HELPER.getMessage("application_deployed_successfully", ""));
                    return true;
                }
                System.out.println(MSG_HELPER.getMessage("classpath_set_failed", ""));
                return false;
            }
            System.out.println(MSG_HELPER.getMessage("application_deploy_failed", ""));
            return false;
        }
        System.out.println();
        System.out.println(MSG_HELPER.getMessage("application_deployed", ""));
        return true;
    }

    public boolean deployApplication() {
        return this.deployApplication(jaclLocation, serverName, nodeName, appLocation, appName);
    }

    public void deregisterTouchpoints(String string) throws TouchpointException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "deregisterTouchpoints", string);
        }
        this.loadTouchpointRegistry();
        ITouchpointRegistry iTouchpointRegistry = this.getTouchpointRegistry();
        try {
            iTouchpointRegistry.deregister(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new TouchpointException("Cannot deregister", exception);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "deregisterTouchpoints");
        }
    }

    private String getConfigInstanceName(String string) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getConfigInstanceName", string);
        }
        String string2 = "default";
        int n = string.lastIndexOf("/");
        if (n != -1) {
            string2 = string.substring(n + 1);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getConfigInstanceName", string2);
        }
        return string2;
    }

    private boolean setSIClasspath(String string, String string2) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setSIClasspath");
        }
        boolean bl = true;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setSIClasspath", new Boolean(bl));
        }
        return bl;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public ITouchpointRegistry getTouchpointRegistry() {
        return this.touchpointRegistry;
    }

    public String getTouchpointRegistryClassname() {
        return this.touchpointRegistryClassname;
    }

    private void setTouchpointRegistryClassname(String string) {
        this.touchpointRegistryClassname = string;
    }

    static {
        CommonUtility.setupTrace();
    }
}

