/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.transform;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CompatibilityDocumentHandler
extends DefaultHandler {
    private static TraceComponent tc = Tr.register(CompatibilityDocumentHandler.class, "Transform", "com.ibm.ws.management.resources.sync");
    private StringBuffer charBuffer = null;
    private String beginningVersion;
    private String canonicalName;
    private Properties versionMappings = new Properties();
    private static String BEGINNING_VERSION = "beginningVersion";
    private static String CANONICAL_NAME = "canonicalName";
    private static String VERSION_GROUP = "versionGroup";

    protected CompatibilityDocumentHandler() {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes2) throws SAXException {
        this.charBuffer = new StringBuffer();
        if (string3.equals(VERSION_GROUP)) {
            int n = attributes2.getLength();
            for (int i = 0; i < n; ++i) {
                if (attributes2.getQName(i).equals(BEGINNING_VERSION)) {
                    this.beginningVersion = attributes2.getValue(i);
                    continue;
                }
                if (!attributes2.getQName(i).equals(CANONICAL_NAME)) continue;
                this.canonicalName = attributes2.getValue(i);
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.charBuffer.append(cArray, n, n2);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals(BEGINNING_VERSION)) {
            this.beginningVersion = this.charBuffer.toString();
        } else if (string3.equals(CANONICAL_NAME)) {
            this.canonicalName = this.charBuffer.toString();
        } else if (string3.equals(VERSION_GROUP)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "New canonical version mapping", new Object[]{this.beginningVersion, this.canonicalName});
            }
            this.versionMappings.setProperty(this.beginningVersion, this.canonicalName);
        }
    }

    protected Vector getVersionMappings() {
        Object object;
        Object[] objectArray = new String[this.versionMappings.size()];
        int n = 0;
        Enumeration<?> enumeration = this.versionMappings.propertyNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            objectArray[n++] = new String((String)object);
        }
        Arrays.sort(objectArray);
        object = new Vector(objectArray.length);
        for (n = 0; n < objectArray.length; ++n) {
            Properties properties = new Properties();
            properties.setProperty((String)objectArray[n], this.versionMappings.getProperty((String)objectArray[n]));
            ((Vector)object).add(n, properties);
        }
        return object;
    }
}

