/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.transform;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.transform.ConfigTransformer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.transform.NamespaceTransformer;
import com.ibm.ws.management.transform.RepositoryURIResolver;
import com.ibm.ws.management.transform.TransformException;
import com.ibm.ws.management.transform.TransformMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class DocumentTransformer {
    private RepositoryURIResolver uriResolver;
    private static final String UNINITIALIZED = "UNINITIALIZED";
    private static TraceComponent tc = Tr.register(DocumentTransformer.class, "Transform", "com.ibm.ws.management.resources.sync");

    public DocumentTransformer(RepositoryURIResolver repositoryURIResolver) {
        this.uriResolver = repositoryURIResolver;
    }

    public InputStream transform(InputStream inputStream, List list, NamespaceTransformer namespaceTransformer) throws TransformException {
        Object object;
        inputStream = this.fixNamespaces(namespaceTransformer, inputStream);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(list);
        boolean bl = false;
        while (!bl) {
            if (this.hasCustomTransformer(arrayList)) {
                inputStream = this.customTransform(inputStream, arrayList);
                arrayList.remove(0);
                if (arrayList.size() == 0) {
                    bl = true;
                }
            } else {
                Object object2;
                Object object3;
                Iterator iterator;
                object = new ArrayList();
                int n = 0;
                boolean bl2 = false;
                while (!bl2) {
                    iterator = arrayList.iterator();
                    if (!iterator.hasNext()) continue;
                    object3 = (TransformMap)iterator.next();
                    if (((TransformMap)object3).getCustomClassName() == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found XSL transform " + ((TransformMap)object3).getDocName());
                        }
                        object.add(n++, object3);
                        arrayList.remove(object3);
                        if (arrayList.size() != 0) continue;
                        bl2 = true;
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "All transforms found.");
                        continue;
                    }
                    bl2 = true;
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Found custom transform " + ((TransformMap)object3).getCustomClassName());
                }
                iterator = new ArrayList();
                n = 0;
                object3 = object.iterator();
                while (object3.hasNext()) {
                    object2 = (TransformMap)object3.next();
                    List list2 = ((TransformMap)object2).getTransformURIs();
                    if (list2 != null) {
                        for (int i = 0; i < list2.size(); ++i) {
                            String string = (String)list2.get(i);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "urlList element = " + string);
                            }
                            iterator.add(n++, string);
                        }
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No transformURIs found");
                }
                object2 = this.gatherTransformStreams((List)object);
                int n2 = 0;
                if (object2.size() > 0) {
                    Iterator iterator2 = object2.iterator();
                    while (iterator2.hasNext()) {
                        inputStream = this.transform(inputStream, (InputStream)iterator2.next(), (String)iterator.get(n2++));
                    }
                }
            }
            if (arrayList.size() != 0) continue;
            bl = true;
        }
        object = inputStream;
        return object;
    }

    private InputStream fixNamespaces(NamespaceTransformer namespaceTransformer, InputStream inputStream) throws TransformException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charset.forName("UTF-8"));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, Charset.forName("UTF-8"));
        try {
            namespaceTransformer.transform(inputStreamReader, outputStreamWriter);
            outputStreamWriter.close();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.transform.DocumentTransformer.fixNamespaces", "108", this);
            throw this.getTransformException(throwable);
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    ((Reader)inputStreamReader).close();
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.transform.DocumentTransformer.fixNamespaces", "129", this);
            }
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        return byteArrayInputStream;
    }

    private List gatherTransformStreams(List list) throws TransformException {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TransformMap transformMap = (TransformMap)iterator.next();
            if (transformMap.getTransformURIs() == null) continue;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "gatherTransformStreams adding " + transformMap.getTransformURIs());
                }
                arrayList.addAll(transformMap.getTransformStreams());
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.transform.DocumentTransformer.gatherTransformStreams", "131", this);
                throw new TransformException(throwable);
            }
        }
        return arrayList;
    }

    private TransformException getTransformException(Throwable throwable) {
        TransformException transformException = throwable instanceof TransformException ? (TransformException)throwable : new TransformException(throwable);
        return transformException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream transform(InputStream inputStream, InputStream inputStream2, String string) throws TransformException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "transform called with uri = " + string);
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            StreamSource streamSource = new StreamSource(inputStream2);
            StreamSource streamSource2 = new StreamSource(inputStream);
            byteArrayOutputStream = new ByteArrayOutputStream(2048);
            StreamResult streamResult = new StreamResult(byteArrayOutputStream);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            String string2 = this.extractVersion(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Version " + string2 + " was extracted from uri " + string);
            }
            String string3 = string2;
            synchronized (string3) {
                this.uriResolver.replaceVersion(string2);
                transformerFactory.setURIResolver(this.uriResolver);
                Transformer transformer = transformerFactory.newTransformer(streamSource);
                transformer.transform(streamSource2, streamResult);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.transform.DocumentTransformer.transform", "174", this);
            throw this.getTransformException(throwable);
        }
        inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        return inputStream;
    }

    private boolean hasCustomTransformer(List list) {
        if (list != null) {
            TransformMap transformMap = (TransformMap)list.get(0);
            return transformMap.getCustomClassName() != null;
        }
        return false;
    }

    private InputStream customTransform(InputStream inputStream, List list) {
        InputStream inputStream2 = null;
        TransformMap transformMap = (TransformMap)list.get(0);
        try {
            ConfigTransformer configTransformer = transformMap.getCustomTransformer();
            inputStream2 = configTransformer.transform(inputStream);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.transform.DocumentTransformer.customTransform", "275", this);
        }
        return inputStream2;
    }

    private String extractVersion(String string) {
        int n = string.indexOf(47);
        char[] cArray = string.toCharArray();
        if (cArray[n + 1] >= '0' && cArray[n + 1] <= '9') {
            int n2 = string.indexOf(47, n + 1);
            String string2 = string.substring(n + 1, n2);
            return string2;
        }
        n = string.indexOf(47, n + 1);
        int n3 = string.indexOf(47, n + 1);
        String string3 = string.substring(n + 1, n3);
        return string3;
    }
}

