/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.transform;

import com.ibm.ws.management.transform.TransformException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NamespaceTransformer {
    private Map namespaceMapping = new HashMap();

    public NamespaceTransformer(Reader reader) throws TransformException {
        this.parseConfigDoc(reader);
    }

    public NamespaceTransformer(List list) throws TransformException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.parseConfigDoc((Reader)iterator.next());
        }
    }

    public void transform(Reader reader, Writer writer) throws TransformException {
        try {
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            while ((n = reader.read()) != -1) {
                writer.write(n);
                if (n == 61) {
                    writer.write(this.convertAttribute(reader));
                    continue;
                }
                if (n == 60) {
                    if (bl) {
                        bl2 = true;
                        continue;
                    }
                    bl = true;
                    continue;
                }
                if (n != 62 || !bl2) continue;
            }
            while ((n = reader.read()) != -1) {
                writer.write(n);
            }
        }
        catch (IOException iOException) {
            throw new TransformException(iOException);
        }
    }

    private String convertAttribute(Reader reader) throws TransformException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        char c = ' ';
        try {
            while (true) {
                int n;
                if ((n = reader.read()) == -1) {
                    stringBuffer2.append(stringBuffer.toString());
                    break;
                }
                char c2 = (char)n;
                if (c == ' ') {
                    if (c2 == '\"' || c2 == '\'') {
                        c = c2;
                    }
                    stringBuffer2.append(c2);
                    continue;
                }
                if (c2 == c) {
                    String string = stringBuffer.toString().trim();
                    String string2 = (String)this.namespaceMapping.get(string);
                    if (string2 == null) {
                        string2 = string;
                    }
                    stringBuffer2.append(string2);
                    break;
                }
                stringBuffer.append(c2);
            }
        }
        catch (IOException iOException) {
            throw new TransformException(iOException);
        }
        stringBuffer2.append(c);
        return stringBuffer2.toString();
    }

    private void parseConfigDoc(Reader reader) throws TransformException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            InputSource inputSource = new InputSource(reader);
            NamespaceConfigDocumentHandler namespaceConfigDocumentHandler = new NamespaceConfigDocumentHandler();
            sAXParser.parse(inputSource, (DefaultHandler)namespaceConfigDocumentHandler);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new TransformException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new TransformException(sAXException);
        }
        catch (IOException iOException) {
            throw new TransformException(iOException);
        }
    }

    protected boolean mapIsEmpty() {
        return this.namespaceMapping.size() == 0;
    }

    class NamespaceConfigDocumentHandler
    extends DefaultHandler {
        private StringBuffer charBuffer = null;
        private String sourcens;
        private String resultns;

        NamespaceConfigDocumentHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes2) throws SAXException {
            this.charBuffer = new StringBuffer();
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.charBuffer.append(cArray, n, n2);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals("xmlns-source")) {
                this.sourcens = this.charBuffer.toString();
            } else if (string3.equals("xmlns-result")) {
                this.resultns = this.charBuffer.toString();
                NamespaceTransformer.this.namespaceMapping.put(this.sourcens, this.resultns);
            }
        }
    }
}

