/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.transform;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.DocumentNotFoundException;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.ResourceNameFilter;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.transform.DocumentTransformer;
import com.ibm.ws.management.transform.RepositoryURIResolver;
import com.ibm.ws.management.transform.TransformCacheInvalidator;
import com.ibm.ws.management.transform.TransformMetadata;
import com.ibm.ws.management.transform.VersionMetadata;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class RepositoryAdapter {
    private static Map adapters = new HashMap();
    private ConfigRepository repository;
    private String nodeCanonicalVersion;
    private static ManagedObjectMetadataHelper momHelper;
    private TransformMetadata xformMetadata;
    private DocumentTransformer transformer;
    private static ManagedObjectMetadataAccessor metadataAccessor;
    private static HashMap nodeNameMap;
    private static HashMap nodePropertiesMap;
    protected static final String BASE_PRODUCT_NAME = "base";
    private static HashMap aggregatedKeyMap;
    private String instanceNodeKey;
    private static final String PRODUCT_VERSION_SEPARATOR = "_";
    private static TraceComponent tc;

    public static synchronized RepositoryAdapter getRepositoryAdapter(ConfigRepository configRepository, String string) throws AdminException {
        Object object;
        Object object2;
        Object object3;
        String string2;
        Object object4;
        if (momHelper == null) {
            object4 = AdminServiceFactory.getAdminService();
            string2 = object4.getCellName();
            object3 = new Properties();
            ((Properties)object3).setProperty("local.cell", string2);
            momHelper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor((Properties)object3));
        }
        object4 = AdminServiceFactory.getAdminService().getNodeName();
        string2 = momHelper.getNodeBaseProductVersion((String)object4);
        string2 = VersionMetadata.getCanonicalVersion(string2);
        object3 = momHelper.getNodeMajorVersion(string);
        object3 = ((String)object3).equals("5") ? "5.0.0.0" : momHelper.getNodeBaseProductVersion(string);
        object3 = VersionMetadata.getCanonicalVersion((String)object3);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "masterVersion = " + string2 + " nodeVersion = " + (String)object3);
        }
        if (!nodeNameMap.containsKey(object4)) {
            object2 = momHelper.getNodeProductsAndVersions((String)object4);
            nodePropertiesMap.put(object4, object2);
            if (!aggregatedKeyMap.containsKey(object4)) {
                object = RepositoryAdapter.createAggregatedKey((Properties)object2);
                if ((object = RepositoryAdapter.processAggregatedKey((String)object)) == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "dmgrKey is null; RepositoryAdapter cannot be obtained.");
                    }
                    return null;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Putting key " + (String)object + " for dmgr " + (String)object4);
                }
                aggregatedKeyMap.put(object4, object);
            }
            nodeNameMap.put(object4, string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added dmgr node " + string + " at version " + (String)object3 + " to node name map");
            }
        }
        object2 = null;
        if (!nodeNameMap.containsKey(string)) {
            object = momHelper.getNodeProductsAndVersions(string);
            nodePropertiesMap.put(string, object);
            object2 = RepositoryAdapter.createAggregatedKey((Properties)object);
            object2 = RepositoryAdapter.processAggregatedKey((String)object2);
            if (object2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "nodeKey is null; RepositoryAdapter cannot be obtained.");
                }
                return null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Putting key " + (String)object2 + " for node " + string);
            }
            aggregatedKeyMap.put(string, object2);
            nodeNameMap.put(string, object3);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added node " + string + " at version " + (String)object3 + " to node name map");
            }
        } else {
            object = momHelper.getNodeProductsAndVersions(string);
            String string3 = RepositoryAdapter.createAggregatedKey((Properties)object);
            if ((string3 = RepositoryAdapter.processAggregatedKey(string3)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "newNodeKey is null; RepositoryAdapter cannot be obtained.");
                }
                return null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "New node key " + string3 + " for node " + string);
            }
            String string4 = (String)aggregatedKeyMap.get(string);
            if ((string4 = RepositoryAdapter.processAggregatedKey(string4)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "oldNodeKey is null; RepositoryAdapter cannot be obtained.");
                }
                return null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Previous node key " + string4 + " for node " + string);
            }
            if (!string4.equals(string3)) {
                nodePropertiesMap.put(string, object);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Replacing key with " + string3 + " for node " + string);
                }
                aggregatedKeyMap.put(string, string3);
                object2 = string3;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No node product changes found.");
                }
                object2 = string4;
            }
        }
        object = (RepositoryAdapter)adapters.get(object2);
        if (object == null) {
            object = new RepositoryAdapter(configRepository, string2, (String)object3, (String)object4, string);
            adapters.put(object2, object);
        }
        return object;
    }

    private RepositoryAdapter(ConfigRepository configRepository, String string, String string2, String string3, String string4) throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating RepositoryAdapter for version " + string2);
        }
        this.repository = configRepository;
        this.nodeCanonicalVersion = new String(string2);
        String string5 = (String)aggregatedKeyMap.get(string3);
        this.instanceNodeKey = (String)aggregatedKeyMap.get(string4);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dmgrKey = " + string5 + ", instanceNodeKey = " + this.instanceNodeKey + " for node " + string4);
        }
        if (this.instanceNodeKey.compareTo(string5) == 0) {
            this.transformer = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Versions are compatible: ", new Object[]{string5, this.instanceNodeKey});
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Versions are not compatible: ", new Object[]{string5, this.instanceNodeKey});
            }
            this.xformMetadata = TransformMetadata.getTransformMetadata(string2, string5, this.instanceNodeKey);
            TransformCacheInvalidator.addRelease(this.instanceNodeKey);
            RepositoryURIResolver repositoryURIResolver = new RepositoryURIResolver(string2);
            this.transformer = new DocumentTransformer(repositoryURIResolver);
        }
    }

    public DocumentDigest getDigest(String string) throws AdminException, RepositoryException {
        DocumentDigest documentDigest = null;
        if (this.transformer == null) {
            documentDigest = this.repository.getDigest(string);
        } else {
            List list = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "docURI = " + string);
            }
            if ((list = this.xformMetadata.getTransforms(string)) != null) {
                String string2 = this.getTransformedDocURI(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "xformDocURI = " + string2);
                }
                try {
                    documentDigest = this.repository.getDigest(string2);
                }
                catch (DocumentNotFoundException documentNotFoundException) {
                    documentDigest = this.transform(string, list);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating " + string);
                    }
                }
            } else {
                documentDigest = this.repository.getDigest(string);
            }
        }
        return documentDigest;
    }

    public DocumentContentSource extract(String string) throws AdminException, RepositoryException {
        DocumentContentSource documentContentSource = null;
        if (this.transformer == null) {
            documentContentSource = this.repository.extract(string);
        } else {
            List list = null;
            list = this.xformMetadata.getTransforms(string);
            if (list != null) {
                String string2 = this.getTransformedDocURI(string);
                while (documentContentSource == null) {
                    try {
                        documentContentSource = this.repository.extract(string2);
                        documentContentSource.getDocument().setURI(string);
                    }
                    catch (DocumentNotFoundException documentNotFoundException) {
                        this.transform(string, list);
                    }
                }
            } else {
                documentContentSource = this.repository.extract(string);
            }
        }
        return documentContentSource;
    }

    public String[] listResourceNames(String string, int n, int n2, ResourceNameFilter resourceNameFilter) {
        String[] stringArray = null;
        if (this.transformer == null) {
            stringArray = this.repository.listResourceNames(string, n, n2, resourceNameFilter);
        } else {
            RepositoryFilter repositoryFilter = new RepositoryFilter(resourceNameFilter);
            stringArray = this.repository.listResourceNames(string, n, n2, repositoryFilter);
        }
        return stringArray;
    }

    private String getTransformedDocURI(String string) {
        String string2 = new String(this.instanceNodeKey + "/" + string);
        String string3 = "xformed/" + string2;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTransformedDocURI returns " + string3);
        }
        return string3;
    }

    private static String processAggregatedKey(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processAggregatedKey", string);
        }
        String string2 = new String(string);
        int n = 0;
        int n2 = -1;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) != '+') continue;
            if (n2 == -1) {
                n2 = i;
            }
            ++n;
        }
        String string3 = null;
        if (n == 1) {
            string3 = string2.substring(0, n2);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string3);
            stringBuffer.append(PRODUCT_VERSION_SEPARATOR);
            String string4 = string2.substring(n2 + 1, string2.length());
            string4 = VersionMetadata.getCanonicalVersion(string4);
            stringBuffer.append(string4);
            string2 = stringBuffer.toString();
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = string2.indexOf(43);
            int n4 = string2.indexOf(43, n3 + 1);
            int n5 = 0;
            String string5 = null;
            for (int i = 0; i < n - 1; i += 2) {
                block14: {
                    string3 = string2.substring(n5, n3);
                    string5 = string2.substring(n3 + 1, n4);
                    try {
                        string5 = string3.equals(BASE_PRODUCT_NAME) ? VersionMetadata.getCanonicalVersion(string5) : VersionMetadata.getCanonicalVersion(string5, string3);
                        if (string5 != "NONE") {
                            stringBuffer.append(string3);
                            stringBuffer.append(PRODUCT_VERSION_SEPARATOR);
                            stringBuffer.append(string5 + "/");
                        }
                    }
                    catch (AdminException adminException) {
                        if (!tc.isDebugEnabled()) break block14;
                        Tr.debug(tc, adminException.getMessage() + " occurred in " + "getTransformedDocURI when processing " + string);
                    }
                }
                n5 = n4 + 1;
                n3 = string2.indexOf(43, n5);
                n4 = string2.indexOf(43, n3 + 1);
                if (n4 != -1) continue;
                string3 = string2.substring(n5, n3);
                string5 = string2.substring(n3 + 1, string2.length());
                try {
                    string5 = VersionMetadata.getCanonicalVersion(string5, string3);
                    if (string5 != "NONE") {
                        stringBuffer.append(string3);
                        stringBuffer.append(PRODUCT_VERSION_SEPARATOR);
                        stringBuffer.append(string5);
                    }
                    string2 = stringBuffer.toString();
                    continue;
                }
                catch (AdminException adminException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, adminException.getMessage() + " occurred in " + "getTransformedDocURI when processing " + string);
                }
            }
        }
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processAggregatedKey", string2);
        }
        return string2;
    }

    private DocumentDigest transform(String string, List list) throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Transforming " + string);
        }
        DocumentContentSource documentContentSource = null;
        try {
            documentContentSource = this.repository.extract(string);
        }
        catch (AdminException adminException) {
            FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.transform.RepositoryAdapter.transform", "242", this);
            throw adminException;
        }
        InputStream inputStream = null;
        try {
            inputStream = this.transformer.transform(documentContentSource.getSource(), list, this.xformMetadata.getNamespaceTransformer());
        }
        catch (AdminException adminException) {
            FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.transform.RepositoryAdapter.transform", "260", this);
            throw adminException;
        }
        Document document = new Document(this.getTransformedDocURI(string));
        DocumentContentSource documentContentSource2 = new DocumentContentSource(document, inputStream);
        DocumentDigest documentDigest = null;
        try {
            documentDigest = this.repository.create(documentContentSource2);
        }
        catch (AdminException adminException) {
            FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.transform.RepositoryAdapter.transform", "276", this);
            throw adminException;
        }
        return documentDigest;
    }

    public static String[] getNodeNames() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeNames");
        }
        String[] stringArray = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Size of nodeNameMap = " + nodeNameMap.size());
        }
        if (nodeNameMap.size() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>(nodeNameMap.size());
            Set set = nodeNameMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                arrayList.add(string);
            }
            stringArray = new String[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                stringArray[i] = new String((String)arrayList.get(i));
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "nodeNameMap contains node " + stringArray[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeNames");
        }
        return stringArray;
    }

    public static Properties getNodeFeaturePackProps(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeFeaturePackProps", string);
        }
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNodeFeaturePackProps", string);
            }
            return null;
        }
        String string2 = (String)nodeNameMap.get(string);
        if (string2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNodeFeaturePackProps", "Did not find node " + string);
            }
            return null;
        }
        Properties properties = (Properties)nodePropertiesMap.get(string);
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Product properties for " + string + " has " + properties2.size() + " elements");
            Enumeration<?> enumeration = properties2.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                String string4 = (String)properties2.get(string3);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Found key " + string3 + " and value " + string4);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeFeaturePackProps", string);
        }
        return properties2;
    }

    protected static String createAggregatedKey(Properties properties) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAggregatedKey", properties);
        }
        if (properties == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createAggregatedKey");
            }
            return new String();
        }
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        StringBuffer stringBuffer = new StringBuffer();
        String string = (String)properties2.get(BASE_PRODUCT_NAME);
        stringBuffer.append("base+" + string + "+");
        properties2.remove(BASE_PRODUCT_NAME);
        TreeSet<String> treeSet = new TreeSet<String>();
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            string = (String)properties.get(object);
            treeSet.add((String)object + "+" + string);
        }
        object = treeSet.iterator();
        while (object.hasNext()) {
            stringBuffer.append((String)object.next() + "+");
        }
        int n = stringBuffer.length();
        stringBuffer.deleteCharAt(n - 1);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAggregatedKey", stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    protected static String getAggregatedKey(String string) {
        if (string == null) {
            return null;
        }
        if (!aggregatedKeyMap.containsKey(string)) {
            return null;
        }
        return (String)aggregatedKeyMap.get(string);
    }

    private String replaceVersionString(String string, String string2, String string3) {
        int n = string3.indexOf(string);
        StringBuffer stringBuffer = new StringBuffer(string3);
        stringBuffer.replace(n, n + string.length(), string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Replacing " + string3 + " with " + stringBuffer.toString());
        }
        string3 = stringBuffer.toString();
        return string3;
    }

    static {
        nodeNameMap = new HashMap();
        nodePropertiesMap = new HashMap();
        aggregatedKeyMap = new HashMap();
        tc = Tr.register(RepositoryAdapter.class, "Transform", "com.ibm.ws.management.resources.sync");
    }

    private class RepositoryFilter
    implements ResourceNameFilter {
        ResourceNameFilter filter;

        public RepositoryFilter(ResourceNameFilter resourceNameFilter) {
            this.filter = resourceNameFilter;
        }

        public boolean accept(String string, String string2) {
            boolean bl = true;
            try {
                bl = RepositoryAdapter.this.xformMetadata.filteredDoc(string, string2) ? false : this.filter.accept(string, string2);
                if (tc.isDebugEnabled()) {
                    if (string.equals("/")) {
                        Tr.debug(tc, "Accept preliminary result = " + bl + " for " + string + string2);
                    } else {
                        Tr.debug(tc, "Accept preliminary result = " + bl + " for " + string + "/" + string2);
                    }
                }
                if (!bl) {
                    bl = RepositoryAdapter.this.xformMetadata.getTransforms(string + "/" + string2) != null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Transform precedence over filter for " + string + "/" + string2 + " = " + bl);
                    }
                }
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.transform.RepositoryAdapter.RepositoryFilter.accept", "313", this);
            }
            return bl;
        }
    }
}

