/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.transform;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.DocumentNotFoundException;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import java.util.Iterator;

public class TransformCacheInvalidator {
    private static ArrayList releases = new ArrayList();
    private static ConfigRepository repository = null;
    private static boolean initialized = false;
    private static TraceComponent tc = Tr.register(TransformCacheInvalidator.class, "Transform", "com.ibm.ws.management.resources.sync");

    public static void initialize(ConfigRepository configRepository) {
        if (!initialized) {
            repository = configRepository;
            TransformCacheInvalidator.invalidateAll();
            initialized = true;
        }
    }

    public static void initialize(ConfigRepository configRepository, boolean bl) {
        if (!initialized) {
            repository = configRepository;
            if (!bl) {
                TransformCacheInvalidator.invalidateAll();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TransformCacheInvalidator: save the transformed cache instead of removing it.");
                }
            }
            initialized = true;
        }
    }

    static void addRelease(String string) {
        String string2 = "xformed/" + string + "/";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding folder to release list: " + string2);
        }
        releases.add(string2);
    }

    public static void invalidate(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invalidate transform cache for " + string);
        }
        if (!string.startsWith("xformed")) {
            Iterator iterator = releases.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Attempting to delete " + string2 + string);
                    }
                    repository.delete(string2 + string);
                }
                catch (DocumentNotFoundException documentNotFoundException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Did not exist: " + string2 + string);
                }
                catch (RepositoryException repositoryException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unable to delete " + string2 + string);
                    }
                    FFDCFilter.processException(repositoryException, "com.ibm.ws.management.transform.TransformCacheInvalidator.invalidate", "93");
                }
            }
        }
    }

    public static void invalidateAll() {
        String[] stringArray = repository.listResourceNames("xformed", 1, Integer.MAX_VALUE);
        if (stringArray.length > 0) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deleting " + stringArray.length + " cached transformed documents");
                }
                repository.delete(stringArray);
            }
            catch (RepositoryException repositoryException) {
                FFDCFilter.processException(repositoryException, "com.ibm.ws.management.transform.TransformCacheInvalidator.invalidateAll", "120");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "no cached transformed documents to delete");
        }
    }
}

