/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.transform;

import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.transform.ConfigTransformer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.transform.TransformRepository;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class TransformMap {
    private String docName;
    private List transformURIs;
    private List scopes;
    private String customClassName;
    private String customClassPath;
    private TransformClassLoader customClassLoader;
    private boolean transformNamespaces = false;

    public TransformMap(String string, List list, List list2, boolean bl) {
        this.docName = string;
        this.transformURIs = list;
        this.scopes = list2;
        this.transformNamespaces = bl;
    }

    public TransformMap(String string, List list, String string2, String string3, boolean bl) {
        this.docName = string;
        this.scopes = list;
        this.customClassName = string2;
        this.customClassPath = string3;
        this.transformNamespaces = bl;
        this.customClassLoader = new TransformClassLoader();
        this.customClassLoader.addPath(string3);
    }

    public String getDocName() {
        return this.docName;
    }

    public List getTransformURIs() {
        return this.transformURIs;
    }

    public List getTransformStreams() throws RepositoryException {
        ArrayList<InputStream> arrayList = new ArrayList<InputStream>();
        Iterator iterator = this.transformURIs.iterator();
        while (iterator.hasNext()) {
            InputStream inputStream = TransformRepository.extract((String)iterator.next());
            arrayList.add(inputStream);
        }
        return arrayList;
    }

    public List getScopes() {
        return this.scopes;
    }

    public boolean transformNamespaces() {
        return this.transformNamespaces;
    }

    public String getCustomClassName() {
        return this.customClassName;
    }

    public String getCustomClassPath() {
        return this.customClassPath;
    }

    public ConfigTransformer getCustomTransformer() {
        ConfigTransformer configTransformer = null;
        try {
            Class<?> clazz = this.customClassLoader.loadClass(this.customClassName);
            configTransformer = (ConfigTransformer)clazz.newInstance();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.transform.TransformMap.TransformClassLoader.getCustomTransformer", "160", this);
        }
        return configTransformer;
    }

    class TransformClassLoader
    extends URLClassLoader {
        private ArrayList descriptorPath;

        TransformClassLoader() {
            super(new URL[0], Thread.currentThread().getContextClassLoader());
            this.descriptorPath = new ArrayList();
        }

        public void addPath(String string) {
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    File file = new File(stringTokenizer.nextToken());
                    try {
                        file = file.getCanonicalFile();
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.transform.TransformMap.TransformClassLoader.addPath", "188", this);
                    }
                    try {
                        URL uRL = file.toURL();
                        if (this.descriptorPath.contains(uRL)) continue;
                        this.descriptorPath.add(uRL);
                        super.addURL(uRL);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.transform.TransformMap.TransformClassLoader.addPath", "203", this);
                    }
                }
            }
        }
    }
}

