/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.transform;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.management.repository.ResourceNameFilter;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.transform.AggregatedKeyIterator;
import com.ibm.ws.management.transform.AggregatedKeyValuePair;
import com.ibm.ws.management.transform.NamespaceTransformer;
import com.ibm.ws.management.transform.NamespaceTransformerFactory;
import com.ibm.ws.management.transform.TransformException;
import com.ibm.ws.management.transform.TransformMap;
import com.ibm.ws.management.transform.TransformRepository;
import com.ibm.ws.util.lock.WriterPriorityReadersWriterLock;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TransformMetadata
implements ResourceNameFilter,
ConfigRepositoryListener {
    public static final String XFORMS_FOLDER = "xforms";
    public static final String XFORMED_FOLDER = "xformed";
    public static final String XFORM_METADATA_DOCNAME = "transformMetadata.xml";
    public static final String XFORM_METADATA_BASENAME = "transformMetadata";
    public static final String XFORM_METADATA_EXTENSION = ".xml";
    public static final String NO_PRODUCT = "noproduct";
    private static Map metadata = new HashMap();
    private Map documentTransforms;
    private Map documentFilters;
    private NamespaceTransformer nsTransformer;
    private String version;
    WriterPriorityReadersWriterLock lock;
    private boolean needsReload = true;
    private Properties properties;
    private String dmgrKey;
    private String nodeKey;
    private static TraceComponent tc = Tr.register(TransformMetadata.class, "Transform", "com.ibm.ws.management.resources.sync");

    public static synchronized TransformMetadata getTransformMetadata(String string, String string2, String string3) throws AdminException {
        TransformMetadata transformMetadata;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTransformMetadata", new Object[]{string2, string3});
        }
        if ((transformMetadata = (TransformMetadata)metadata.get(string3)) == null) {
            transformMetadata = new TransformMetadata(string, string2, string3);
            metadata.put(string3, transformMetadata);
        }
        return transformMetadata;
    }

    public TransformMetadata(String string, String string2, String string3) throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating TransformMetadata for ", string + " " + string2 + " " + string3);
        }
        this.version = string;
        this.dmgrKey = new String(string2);
        this.nodeKey = new String(string3);
        this.lock = new WriterPriorityReadersWriterLock();
        this.load(string, string2, string3);
    }

    private synchronized void load(String string, String string2, String string3) throws AdminException {
        if (this.needsReload) {
            this.lockForWriting();
            try {
                AggregatedKeyIterator aggregatedKeyIterator = this.getAggregatedKeyIterator(string2);
                AggregatedKeyIterator aggregatedKeyIterator2 = this.getAggregatedKeyIterator(string3);
                AggregatedKeyValuePair aggregatedKeyValuePair = (AggregatedKeyValuePair)aggregatedKeyIterator.next();
                AggregatedKeyValuePair aggregatedKeyValuePair2 = (AggregatedKeyValuePair)aggregatedKeyIterator2.next();
                String string4 = aggregatedKeyValuePair.getKey();
                String string5 = aggregatedKeyValuePair.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "load", "dmgrProduct = " + string4 + " dmgrVersion = " + string5);
                }
                String string6 = aggregatedKeyValuePair2.getKey();
                String string7 = aggregatedKeyValuePair2.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "load", "nodeProduct = " + string6 + " nodeVersion = " + string7);
                }
                if (string5.compareTo(string7) == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "load", "Base product versions are compatible");
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "load", "Base product versions are not compatible");
                    }
                    this.loadMetadataHelper(string7, string6);
                }
                while (aggregatedKeyIterator.hasNext()) {
                    aggregatedKeyValuePair = (AggregatedKeyValuePair)aggregatedKeyIterator.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The next dmgr product is " + aggregatedKeyValuePair.getKey() + " at version " + aggregatedKeyValuePair.getValue());
                    }
                    if (aggregatedKeyIterator2.hasNext()) {
                        aggregatedKeyValuePair2 = (AggregatedKeyValuePair)aggregatedKeyIterator2.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The next node product is " + aggregatedKeyValuePair2.getKey() + " at version " + aggregatedKeyValuePair2.getValue());
                        }
                        boolean bl = false;
                        while (!bl) {
                            if (aggregatedKeyValuePair.getKey().equals(aggregatedKeyValuePair2.getKey())) {
                                if (aggregatedKeyValuePair.getValue().equals(aggregatedKeyValuePair2.getValue())) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Product " + aggregatedKeyValuePair.getKey() + " on dmgr and node are compatible");
                                    }
                                } else {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Product " + aggregatedKeyValuePair.getKey() + " is downlevel at version " + aggregatedKeyValuePair2.getValue() + " on node; they are not compatible");
                                    }
                                    String string8 = aggregatedKeyValuePair2.getValue();
                                    this.loadMetadataHelper(string8, aggregatedKeyValuePair2.getKey());
                                }
                                bl = true;
                                continue;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "dmgr will filter out product " + aggregatedKeyValuePair.getKey());
                            }
                            this.loadMetadataHelper(NO_PRODUCT, aggregatedKeyValuePair.getKey());
                            aggregatedKeyValuePair = (AggregatedKeyValuePair)aggregatedKeyIterator.next();
                        }
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "dmgr will filter out product " + aggregatedKeyValuePair.getKey());
                    }
                    this.loadMetadataHelper(NO_PRODUCT, aggregatedKeyValuePair.getKey());
                }
                if (aggregatedKeyIterator2.hasNext()) {
                    aggregatedKeyValuePair2 = (AggregatedKeyValuePair)aggregatedKeyIterator2.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The next node product not installed on the dmgr is " + aggregatedKeyValuePair2.getKey() + " at version " + aggregatedKeyValuePair2.getValue());
                    }
                    String string9 = aggregatedKeyValuePair2.getValue();
                    this.loadMetadataHelper(string9, aggregatedKeyValuePair2.getKey());
                }
                this.needsReload = false;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.transform.TransformMetadata.load", "148", this);
                throw this.getAdminException(throwable);
            }
            finally {
                this.unlockForWriting();
            }
        }
    }

    private void loadProductMetadata(String string, String string2) throws AdminException {
        InputStream inputStream;
        String string3 = "xforms/" + string2 + "/" + string;
        String string4 = string3 + "/" + XFORM_METADATA_DOCNAME;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadProductMetadata tries " + string4);
        }
        try {
            inputStream = TransformRepository.extract2(string4);
        }
        catch (Throwable throwable) {
            string4 = "xforms/" + string + "/" + XFORM_METADATA_DOCNAME;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadProductMetadata retries " + string4);
            }
            try {
                inputStream = TransformRepository.extract(string4);
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException(throwable2, "com.ibm.ws.management.transform.TransformMetadata.loadProductMetadata", "172", this);
                throw this.getAdminException(throwable2);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loading product transform metadata", string4);
        }
        this.loadMetadata(inputStream, string2, string);
    }

    private void loadExtensionsMetadata(String string, String string2) {
        String[] stringArray;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadExtensionsMetadata version = " + string + " product = " + string2);
        }
        if ((stringArray = TransformRepository.getExtensionMetadata(string, string2)) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "loading extensions transform metadata", stringArray[i]);
                }
                try {
                    InputStream inputStream = TransformRepository.extract(stringArray[i]);
                    this.loadMetadata(inputStream, string);
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.management.transform.TransformMetadata.loadExtensionsMetadata", "209", this);
                }
            }
        }
    }

    private void loadMetadata(InputStream inputStream, String string, String string2) throws TransformException {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            InputSource inputSource = new InputSource(inputStreamReader);
            TransformMetadataDocumentHandler transformMetadataDocumentHandler = new TransformMetadataDocumentHandler(string, string2);
            sAXParser.parse(inputSource, (DefaultHandler)transformMetadataDocumentHandler);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.transform.TransformMetadata.loadMetadata", "229", this);
            throw new TransformException(throwable);
        }
    }

    private void loadMetadata(InputStream inputStream, String string) throws TransformException {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            InputSource inputSource = new InputSource(inputStreamReader);
            TransformMetadataDocumentHandler transformMetadataDocumentHandler = new TransformMetadataDocumentHandler(null, string);
            sAXParser.parse(inputSource, (DefaultHandler)transformMetadataDocumentHandler);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.transform.TransformMetadata.loadMetadata", "229", this);
            throw new TransformException(throwable);
        }
    }

    private void loadNamespaceMetadata(String string, String string2) throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadNamespaceMetadata version = " + string + " product = " + string2);
        }
        String string3 = "xforms/" + string;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadNamespaceMetadata tries with " + string3);
        }
        this.nsTransformer = NamespaceTransformerFactory.getNamespaceTransformer(string3);
        if (this.nsTransformer.mapIsEmpty()) {
            string3 = "xforms/" + string2 + "/" + string;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadNamespaceMetadata retries with " + string3);
            }
            this.nsTransformer = NamespaceTransformerFactory.getNamespaceTransformer(string3);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mapIsEmpty = " + this.nsTransformer.mapIsEmpty());
            }
        }
    }

    public NamespaceTransformer getNamespaceTransformer() {
        return this.nsTransformer;
    }

    public boolean accept(String string, String string2) {
        boolean bl = false;
        if (string2.startsWith(XFORM_METADATA_BASENAME) && string2.endsWith(XFORM_METADATA_EXTENSION) && !string2.equals(XFORM_METADATA_DOCNAME)) {
            bl = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "accept", new Object[]{string, string2, bl ? Boolean.TRUE : Boolean.FALSE});
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filteredDoc(String string, String string2) throws AdminException {
        boolean bl = false;
        if (this.needsReload) {
            this.load(this.version, this.dmgrKey, this.nodeKey);
        }
        this.lockForReading();
        try {
            if (this.documentFilters != null && this.documentFilters.containsKey(string2)) {
                List list = (List)this.documentFilters.get(string2);
                bl = list == null ? true : list.contains(this.getDocScope(string + "/" + string2));
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.transform.TransformMetadata.filteredDoc", "300", this);
        }
        finally {
            this.unlockForReading();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTransforms(String string) throws AdminException {
        if (this.needsReload) {
            this.load(this.version, this.dmgrKey, this.nodeKey);
        }
        this.lockForReading();
        ArrayList<TransformMap> arrayList = null;
        try {
            if (this.documentTransforms != null) {
                List list;
                String string2 = this.getDocName(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "docname = " + string2 + " from docURI " + string);
                }
                if ((list = (List)this.documentTransforms.get(string2)) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Mappings are not null.");
                    }
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        TransformMap transformMap = (TransformMap)iterator.next();
                        List list2 = transformMap.getScopes();
                        if (list2 == null) {
                            if (arrayList == null) {
                                arrayList = new ArrayList<TransformMap>();
                            }
                            arrayList.add(transformMap);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "matching tmap with all scopes; transform list is", transformMap.getTransformURIs());
                            continue;
                        }
                        String string3 = this.getDocScope(string);
                        if (!list2.contains(string3)) continue;
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                        }
                        arrayList.add(transformMap);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "matching tmap with specific scope; transform list is", transformMap.getTransformURIs());
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "no entries for", string2);
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.transform.TransformMetadata.getTransforms", "372", this);
        }
        finally {
            this.unlockForReading();
        }
        return arrayList;
    }

    private String getDocName(String string) {
        String string2 = string;
        int n = string.lastIndexOf("/");
        if (n != -1) {
            string2 = string.substring(string.lastIndexOf("/") + 1);
        }
        return string2;
    }

    private String getDocScope(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        int n = stringTokenizer.countTokens() - 2;
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            string2 = stringTokenizer.nextToken();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDocScope", new Object[]{string, string2});
        }
        return string2;
    }

    private void lockForReading() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "lockForReading", this.version);
        }
        boolean bl = false;
        while (!bl) {
            try {
                this.lock.startReading();
                bl = true;
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.management.transform.TransformMetadata.lockForReading", "421", this);
            }
        }
    }

    private void unlockForReading() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unlockForReading", this.version);
        }
        this.lock.stopReading();
    }

    private void lockForWriting() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "lockForWriting", this.version);
        }
        boolean bl = false;
        while (!bl) {
            try {
                this.lock.startWriting();
                bl = true;
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.management.transform.TransformMetadata.lockForWriting", "448", this);
            }
        }
    }

    private void unlockForWriting() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unlockForWriting", this.version);
        }
        this.lock.stopWriting();
    }

    public void onChangeCompletion(ConfigRepositoryEvent configRepositoryEvent) {
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        if (configChangeNotifierArray != null) {
            for (int i = 0; i < configChangeNotifierArray.length && !this.needsReload; ++i) {
                String string = configChangeNotifierArray[i].getUri();
                if (!this.getDocName(string).startsWith(XFORM_METADATA_BASENAME) || string.indexOf(this.version) == -1) continue;
                this.lockForWriting();
                this.needsReload = true;
                this.unlockForWriting();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "needsReload onChangeCompletion", string);
            }
        }
    }

    public void onChangeStart(ConfigRepositoryEvent configRepositoryEvent) {
    }

    public void onRepositoryEpochRefresh() {
        this.lockForWriting();
        this.needsReload = true;
        this.unlockForWriting();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "needsReload onRepositoryEpochRefresh", this.version);
        }
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    private AdminException getAdminException(Throwable throwable) {
        AdminException adminException = throwable instanceof AdminException ? (AdminException)throwable : new AdminException(throwable);
        return adminException;
    }

    private void loadMetadataHelper(String string, String string2) throws AdminException {
        if (this.documentTransforms == null) {
            this.documentTransforms = new HashMap();
            this.documentFilters = new HashMap();
        }
        this.loadProductMetadata(string, string2);
        this.loadExtensionsMetadata(string, string2);
        this.loadNamespaceMetadata(string, string2);
    }

    protected AggregatedKeyIterator getAggregatedKeyIterator(String string) {
        AggregatedKeyIterator aggregatedKeyIterator = new AggregatedKeyIterator(string);
        return aggregatedKeyIterator;
    }

    static /* synthetic */ String access$100(TransformMetadata transformMetadata) {
        return transformMetadata.version;
    }

    private class TransformMetadataDocumentHandler
    extends DefaultHandler {
        private StringBuffer charBuffer = null;
        private String document;
        private List transforms;
        private List scopes;
        private String className;
        private String classPath;
        private List transformMappings = new ArrayList();
        private List transformFilters = new ArrayList();
        private String folder = "xforms/" + TransformMetadata.access$100(TransformMetadata.this) + "/";
        private String product;

        private TransformMetadataDocumentHandler(String string, String string2) {
            if (string == null) {
                this.product = null;
            } else {
                this.product = new String(string);
                if (!string.equals("base")) {
                    this.folder = "xforms/" + string + "/" + string2 + "/";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Redefining folder to " + this.folder);
                    }
                }
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes2) throws SAXException {
            this.charBuffer = new StringBuffer();
            if (string3.equals("transformMap") || string3.equals("transformFilter")) {
                this.document = null;
                this.transforms = null;
                this.scopes = null;
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.charBuffer.append(cArray, n, n2);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals("document")) {
                this.document = this.charBuffer.toString();
            } else if (string3.equals("transform")) {
                if (this.transforms == null) {
                    this.transforms = new ArrayList();
                }
                this.transforms.add(this.folder + this.charBuffer.toString());
            } else if (string3.equals("scope")) {
                if (this.scopes == null) {
                    this.scopes = new ArrayList();
                }
                this.scopes.add(this.charBuffer.toString());
            } else if (string3.equals("className")) {
                this.className = this.charBuffer.toString();
            } else if (string3.equals("classPath")) {
                this.classPath = this.charBuffer.toString();
            } else if (string3.equals("transformMap")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "New transformMap", new Object[]{this.document, this.transforms, this.scopes});
                }
                TransformMap transformMap = new TransformMap(this.document, this.transforms, this.scopes, true);
                this.transformMappings = (List)TransformMetadata.this.documentTransforms.get(this.document);
                if (this.transformMappings == null) {
                    this.transformMappings = new ArrayList();
                    TransformMetadata.this.documentTransforms.put(this.document, this.transformMappings);
                }
                this.transformMappings.add(transformMap);
            } else if (string3.equals("customTransform")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "New customTransform", new Object[]{this.document, this.className, this.classPath});
                }
                TransformMap transformMap = new TransformMap(this.document, this.scopes, this.className, this.classPath, true);
                this.transformMappings = (List)TransformMetadata.this.documentTransforms.get(this.document);
                if (this.transformMappings == null) {
                    this.transformMappings = new ArrayList();
                    TransformMetadata.this.documentTransforms.put(this.document, this.transformMappings);
                }
                this.transformMappings.add(transformMap);
            } else if (string3.equals("transformFilter")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "New transformFilter", new Object[]{this.document, this.scopes});
                }
                if (TransformMetadata.this.documentFilters.containsKey(this.document)) {
                    List list = (List)TransformMetadata.this.documentFilters.get(this.document);
                    if (list == null) {
                        TransformMetadata.this.documentFilters.put(this.document, this.scopes);
                    } else if (this.scopes != null) {
                        list.addAll(this.scopes);
                        TransformMetadata.this.documentFilters.put(this.document, list);
                    }
                } else {
                    TransformMetadata.this.documentFilters.put(this.document, this.scopes);
                }
            }
        }
    }
}

