/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.transform;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.transform.NSTransformFilter;
import com.ibm.ws.management.transform.TransformFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class TransformRepository {
    private static String wasInstallRoot = null;
    private static String configRoot = null;
    private static String configRoot2 = null;
    private static final String CONFIG = "/profileTemplates/dmgr/documents/config/";
    private static final String CONFIG2 = "/etc/config/";
    private static TraceComponent tc = Tr.register(TransformRepository.class, "Transform", "com.ibm.ws.management.resources.sync");

    protected static String[] getReleaseFolderList() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReleaseFolderList");
        }
        File[] fileArray = null;
        int n = 0;
        String[] stringArray = null;
        String string = "xforms";
        File file = new File(TransformRepository.getConfigRoot() + string);
        if (file != null) {
            fileArray = file.listFiles();
            if (fileArray != null) {
                n = fileArray.length;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The number of old folders in " + file + " = " + n);
                }
                stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = fileArray[i].getName();
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, TransformRepository.getConfigRoot() + " " + string + " does not exist.");
            }
        }
        if ((file = new File(TransformRepository.getConfigRoot2() + string)) != null) {
            fileArray = file.listFiles();
            if (fileArray != null) {
                n = fileArray.length;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The number of new folders in " + file + " = " + n);
                }
                if (n > 0) {
                    String[] stringArray2 = new String[n];
                    for (int i = 0; i < n; ++i) {
                        stringArray2[i] = fileArray[i].getName();
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "New folder name = " + stringArray2[i]);
                    }
                    stringArray = TransformRepository.mergeArrays(stringArray, stringArray2);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, TransformRepository.getConfigRoot2() + " " + string + " does not exist.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReleaseFolderList", stringArray);
        }
        return stringArray;
    }

    protected static String[] mergeArrays(String[] stringArray, String[] stringArray2) {
        int n;
        int n2;
        int n3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeArrays");
        }
        if (stringArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mergeArrays", stringArray2);
            }
            return stringArray2;
        }
        if (stringArray2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mergeArrays", stringArray);
            }
            return stringArray;
        }
        int n4 = stringArray.length;
        int n5 = stringArray2.length;
        String[] stringArray3 = new String[n4 + n5];
        int n6 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            stringArray3[n6++] = stringArray[n3];
        }
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = 0;
            for (n = 0; n < n6; ++n) {
                if (stringArray3[n].compareTo(stringArray2[n3]) != 0) continue;
                n2 = 1;
            }
            if (n2 == 0) {
                stringArray3[n6++] = stringArray2[n3];
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Not copying duplicate element " + stringArray2[n3]);
        }
        if (n6 < stringArray3.length) {
            String[] stringArray4 = new String[n6];
            n2 = 0;
            for (n = 0; n < stringArray3.length; ++n) {
                if (stringArray3[n] == null) continue;
                stringArray4[n2++] = stringArray3[n];
            }
            stringArray3 = stringArray4;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeArrays", stringArray3);
        }
        return stringArray3;
    }

    protected static String[] getExtensionMetadata(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExtensionMetadata", string + " " + string2);
        }
        File[] fileArray = null;
        int n = 0;
        String[] stringArray = null;
        String string3 = "xforms/" + string;
        File file = new File(TransformRepository.getConfigRoot() + "/" + string3);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Config root dir is " + file);
        }
        if (file != null) {
            fileArray = file.listFiles(TransformFilter.getInstance());
            if (fileArray != null) {
                n = fileArray.length;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The number of old filtered extension folders in " + file + " = " + n);
                }
                if (n > 0) {
                    stringArray = new String[n];
                    for (int i = 0; i < n; ++i) {
                        stringArray[i] = string3 + "/" + fileArray[i].getName();
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, TransformRepository.getConfigRoot() + " " + string3 + " does not exist.");
            }
        }
        string3 = "xforms/" + string2 + "/" + string;
        file = new File(TransformRepository.getConfigRoot2() + string3);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Config root 2 dir is " + file);
        }
        if (file != null) {
            fileArray = file.listFiles(TransformFilter.getInstance());
            if (fileArray != null) {
                n = fileArray.length;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The number of new filtered extension folders in " + file + " = " + n);
                }
                if (n > 0) {
                    String[] stringArray2 = new String[n];
                    for (int i = 0; i < n; ++i) {
                        stringArray2[i] = string3 + "/" + fileArray[i].getName();
                    }
                    stringArray = TransformRepository.mergeArrays(stringArray, stringArray2);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, file + " does not exist.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExtensionMetadata", stringArray);
        }
        return stringArray;
    }

    protected static String[] getNamespaceTransforms(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNamespaceTransforms", string);
        }
        File[] fileArray = null;
        int n = 0;
        String[] stringArray = null;
        File file = new File(TransformRepository.getConfigRoot() + string);
        if (file != null) {
            fileArray = file.listFiles(NSTransformFilter.getInstance());
            if (fileArray != null) {
                n = fileArray.length;
                stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = string + "/" + fileArray[i].getName();
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, TransformRepository.getConfigRoot() + string + " does not exist.");
            }
        }
        if ((file = new File(TransformRepository.getConfigRoot2() + string)) != null) {
            fileArray = file.listFiles(NSTransformFilter.getInstance());
            if (fileArray != null) {
                n = fileArray.length;
                String[] stringArray2 = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray2[i] = string + "/" + fileArray[i].getName();
                }
                stringArray = TransformRepository.mergeArrays(stringArray, stringArray2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, TransformRepository.getConfigRoot2() + string + " does not exist.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNamespaceTransforms", string);
        }
        return stringArray;
    }

    protected static InputStream extract(String string) {
        int n;
        FileInputStream fileInputStream = null;
        File file = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Extract uri = " + string);
        }
        if ((n = string.indexOf("/base/")) != -1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.replace(n, n + 6, "/");
            string = stringBuffer.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Revised extract uri = " + string);
            }
        }
        try {
            file = new File(TransformRepository.getConfigRoot() + string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "extract() looking for file " + file);
            }
            fileInputStream = new FileInputStream(file);
        }
        catch (Throwable throwable) {
            file = new File(TransformRepository.getConfigRoot2() + string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrying with file " + file);
            }
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.transform.TransformRepository.extract", "84", null);
            }
        }
        return fileInputStream;
    }

    protected static InputStream extract2(String string) throws FileNotFoundException {
        FileInputStream fileInputStream = null;
        File file = null;
        file = new File(TransformRepository.getConfigRoot2() + string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "extract2() trying file " + file);
        }
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "File was not found");
            }
            throw new FileNotFoundException(fileNotFoundException.getMessage());
        }
        return fileInputStream;
    }

    protected static InputStream extract3(String string) throws FileNotFoundException {
        FileInputStream fileInputStream = null;
        File file = null;
        try {
            file = new File(TransformRepository.getConfigRoot() + string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "extract3() trying file " + file);
            }
            fileInputStream = new FileInputStream(file);
        }
        catch (Throwable throwable) {
            file = new File(TransformRepository.getConfigRoot2() + string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrying with file " + file);
            }
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileNotFoundException(fileNotFoundException.getMessage());
            }
        }
        return fileInputStream;
    }

    private static String getConfigRoot() {
        if (configRoot == null) {
            configRoot = TransformRepository.getWasInstallRoot() + CONFIG;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "configRoot: " + configRoot);
            }
        }
        return configRoot;
    }

    private static String getConfigRoot2() {
        if (configRoot2 == null) {
            configRoot2 = TransformRepository.getWasInstallRoot() + CONFIG2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "configRoot2: " + configRoot2);
            }
        }
        return configRoot2;
    }

    private static String getWasInstallRoot() {
        if (wasInstallRoot == null) {
            wasInstallRoot = System.getProperty("was.install.root");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "wasInstallRoot: " + wasInstallRoot);
            }
        }
        return wasInstallRoot;
    }
}

