/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.transform;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.transform.CompatibilityDocumentHandler;
import com.ibm.ws.management.transform.TransformException;
import com.ibm.ws.management.transform.TransformRepository;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class VersionMetadata {
    private static TraceComponent tc = Tr.register(VersionMetadata.class, "Transform", "com.ibm.ws.management.resources.sync");
    private static final String COMPATIBILITY_DOCNAME = "compatibility.xml";
    private static HashMap productCompatibilityInformation = new HashMap();

    public static String getCanonicalVersion(String string) {
        String string2 = string.startsWith("7.") ? "7.x" : (string.startsWith("6.1") ? "6.1.x" : (string.startsWith("6.0.2") ? "6.0.2.x" : (string.startsWith("6.0") ? "6.0.x" : (string.startsWith("5.") ? "5.x" : (string.equals("5") ? "5.x" : string)))));
        return string2;
    }

    private static String getCanonicalVersion(String string, Vector vector) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCanonicalVersion", string);
        }
        String string2 = null;
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            Properties properties = (Properties)vector.get(i);
            Enumeration<?> enumeration = properties.propertyNames();
            String string3 = (String)enumeration.nextElement();
            String string4 = (String)properties.get(string3);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found key " + string3 + " and value " + string4);
            }
            if (string2 == null) {
                string2 = new String(string4);
            }
            if (string.equals(string3)) {
                string2 = new String(string4);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCanonicalVersion", string2);
                }
                return string4;
            }
            boolean bl2 = false;
            int n = 0;
            int n2 = 0;
            while (!bl2) {
                int n3;
                String string5 = VersionMetadata.getNextSubcomponent(string, n, 46);
                String string6 = VersionMetadata.getNextSubcomponent(string3, n2, 46);
                if (string5 == null && string6 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Version and key are the same");
                    }
                    string2 = new String(string4);
                    bl2 = true;
                    bl = true;
                    break;
                }
                if (string5 == null && string6 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string3 + " is greater than " + string);
                    }
                    bl2 = true;
                    bl = true;
                    break;
                }
                if (string5 != null && string6 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string + " is greater than " + string3);
                    }
                    string2 = new String(string4);
                    bl2 = true;
                    break;
                }
                Integer n4 = new Integer(string5);
                Integer n5 = new Integer(string6);
                int n6 = n4;
                if (n6 > (n3 = n5.intValue())) {
                    string2 = new String(string4);
                    bl2 = true;
                    break;
                }
                if (n6 < n3) {
                    bl2 = true;
                    bl = true;
                    break;
                }
                n += string5.length() + 1;
                n2 += string6.length() + 1;
            }
            if (bl) break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCanonicalVersion", string2);
        }
        return string2;
    }

    private static String getNextSubcomponent(String string, int n, int n2) {
        if (n >= string.length()) {
            return null;
        }
        int n3 = string.indexOf(n2, n);
        if (n3 > 0) {
            String string2 = string.substring(n, n3);
            return string2;
        }
        String string3 = string.substring(n);
        return string3;
    }

    protected static String getCanonicalVersion(String string, String string2) throws AdminException {
        InputStream inputStream;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCanonicalVersion", " version = " + string + ", product = " + string2);
        }
        Vector vector = null;
        if (productCompatibilityInformation.containsKey(string2) && (object = (Vector)productCompatibilityInformation.get(string2)) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The canonical versions for this product have already been processed.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCanonicalVersion", " version " + string + " product + " + string2 + ": " + VersionMetadata.getCanonicalVersion(string, (Vector)object));
            }
            return VersionMetadata.getCanonicalVersion(string, (Vector)object);
        }
        object = "xforms/" + string2 + "/" + COMPATIBILITY_DOCNAME;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCanonicalVersion() tries " + (String)object);
        }
        try {
            inputStream = TransformRepository.extract2((String)object);
        }
        catch (Throwable throwable) {
            string = "NONE";
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCanonicalVersion", " version " + string + " product + " + string2 + "; no compatibility.xml");
            }
            return string;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing compatibility file ", object);
        }
        VersionMetadata.processCompatibilityXML(inputStream, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCanonicalVersion", " version " + string + " product " + string2);
        }
        vector = (Vector)productCompatibilityInformation.get(string2);
        return VersionMetadata.getCanonicalVersion(string, vector);
    }

    private static void processCompatibilityXML(InputStream inputStream, String string) throws TransformException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processCompatibilityXML", "Product " + string);
        }
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            InputSource inputSource = new InputSource(inputStreamReader);
            CompatibilityDocumentHandler compatibilityDocumentHandler = new CompatibilityDocumentHandler();
            sAXParser.parse(inputSource, (DefaultHandler)compatibilityDocumentHandler);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding " + string + " compatibility data to product storage: " + compatibilityDocumentHandler.getVersionMappings());
            }
            productCompatibilityInformation.put(string, compatibilityDocumentHandler.getVersionMappings());
        }
        catch (Throwable throwable) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processCompatibilityXML", "Product " + string);
            }
            FFDCFilter.processException(throwable, "com.ibm.ws.management.transform.TransformMetadata.loadMetadata", "229");
            throw new TransformException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processCompatibilityXML", "Product " + string);
        }
    }

    private static AdminException getAdminException(Throwable throwable) {
        AdminException adminException = throwable instanceof AdminException ? (AdminException)throwable : new AdminException(throwable);
        return adminException;
    }
}

