/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.websphere.management.authorizer.service.AdminAuthzServiceEvent;
import com.ibm.websphere.management.authorizer.service.AdminAuthzServiceListener;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.util.SecurityServiceMonitor;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.role.RoleBasedConfiguratorNullImpl;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.security.auth.Subject;

public final class SecurityHelper
implements SecurityServiceListener,
AdminAuthzServiceListener,
SecurityServiceMonitor {
    private static final TraceComponent tc = Tr.register(SecurityHelper.class);
    public static final String isInternal = "isInternal";
    public static final String loginMethod = "LoginMethod";
    public static final String tokenBasedAuth = "TokenBased";
    public static final String basicAuth = "BasicAuth";
    public static final String tokeElement = "token";
    public static final String trustStoreProp = "javax.net.ssl.trustStore";
    public static final String keyStoreProp = "javax.net.ssl.keyStore";
    public static final String trustStorePasswordProp = "javax.net.ssl.trustStorePassword";
    public static final String keyStorePasswordProp = "javax.net.ssl.keyStorePassword";
    public static final String trustStoreTypeProp = "javax.net.ssl.trustStoreType";
    public static final String keyStoreTypeProp = "javax.net.ssl.keyStoreType";
    public static final String sslHandlerProp = "java.protocol.handler.pkgs";
    public static final String defaultSslHandler = "com.ibm.net.ssl.internal.www.protocol";
    public static final String FIPSProvider = "ssl.SocketFactory.provider";
    public static final String contextProvider = "com.ibm.ssl.contextProvider";
    private boolean securityEnabled = false;
    private boolean securityServiceEnabled = false;
    private boolean securityServiceStopped = false;
    private RoleBasedConfigurator configurator = new RoleBasedConfiguratorNullImpl();
    private static String realm = null;
    private SecurityService securityService = null;
    private static final WebSphereRuntimePermission perm = new WebSphereRuntimePermission("SecOwnCredentials");
    private static ContextManager contextMgr = null;
    private WSSecurityContext securityContext = null;
    private String clientSSLAlias = null;
    private static SecurityHelper myself = new SecurityHelper();
    private AdminAuthorizer authorizer = null;
    private static String URL_HANDLER_PROP = "java.protocol.handler.pkgs";
    private static final String PKGNAME_DELIMITER = "|";

    private SecurityHelper() {
    }

    public static SecurityHelper getHelper() {
        return myself;
    }

    public String getClientSSLAlias() {
        return this.clientSSLAlias;
    }

    public void setClientSSLAlias(String string) {
        this.clientSSLAlias = string;
    }

    public void stateChanged(AdminAuthzServiceEvent adminAuthzServiceEvent) {
        block5: {
            int n;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stateChanged", adminAuthzServiceEvent);
            }
            if ((n = adminAuthzServiceEvent.getState()) == 1) {
                try {
                    this.authorizer = AdminAuthorizerFactory.getAdminAuthorizer();
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "AdminAuthorizer not initialized");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateChanged");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stateChanged(SecurityServiceEvent securityServiceEvent) {
        block20: {
            int n;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stateChanged");
            }
            if ((n = securityServiceEvent.getState()) == 1) {
                try {
                    block19: {
                        realm = this.securityService.getRealm();
                        try {
                            this.securityContext = this.securityService.getWSSecurityContext();
                            contextMgr = ContextManagerFactory.getInstance();
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) break block19;
                            Tr.debug(tc, "Error getting contextManager from security component.");
                        }
                    }
                    try {
                        this.configurator = this.securityService.getConfigurator();
                        break block20;
                    }
                    catch (RoleBasedAppException roleBasedAppException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "RoleBasedConfigurator not initialized");
                        }
                        break block20;
                    }
                    finally {
                        this.securityService = null;
                    }
                }
                finally {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Marking the Security Service as having been started.");
                    }
                    this.securityServiceEnabled = true;
                    this.securityServiceStopped = false;
                }
            }
            if (n == 2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Marking the Security Service as having been stopped.");
                }
                this.securityServiceStopped = true;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security service state change to: " + n);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateChanged");
        }
    }

    public WSSecurityContext getWSSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
        this.securityEnabled = this.securityService.isSecurityEnabled();
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public AdminAuthorizer getAdminAuthorizer() {
        return this.authorizer;
    }

    public boolean isSecurityServiceStarted() {
        return this.securityServiceEnabled;
    }

    public boolean isSecurityServiceStopped() {
        return this.securityServiceStopped;
    }

    public RoleBasedConfigurator getConfigurator() {
        return this.configurator;
    }

    public String getRealm() {
        return realm;
    }

    public static Subject authenticate(String string, String string2) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authenticate");
        }
        Subject subject = null;
        try {
            subject = SecurityHelper.getContextManager().login(SecurityHelper.getContextManager().getDefaultRealm(), string, string2);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "fail to authenticate", exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "authenticate - failed");
            }
            if (exception instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)exception;
            }
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "authenticate");
        }
        return subject;
    }

    public static Subject validate(byte[] byArray) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        Subject subject = null;
        try {
            subject = SecurityHelper.getContextManager().login(SecurityHelper.getContextManager().getDefaultRealm(), byArray);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "fail to validate", exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate - failed");
            }
            if (exception instanceof WSLoginFailedException) {
                throw (WSLoginFailedException)exception;
            }
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
        return subject;
    }

    public static Subject createBasicAuthSubject(String string, String string2) {
        Subject subject;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createBasicAuthSubject");
            }
            subject = null;
            try {
                subject = SubjectHelper.createBasicAuthSubject(SecurityHelper.getContextManager().getDefaultRealm(), string, string2);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "fail to create basic auth subject", exception);
                }
                if (!tc.isEntryEnabled()) break block5;
                Tr.exit(tc, "authenticate - failed");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createBasicAuthSubject");
        }
        return subject;
    }

    public static void removeSubjectFromThreadTable(Subject subject) {
        block2: {
            try {
                SecurityHelper.getContextManager().initializeCallerContext((Subject)null);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Failed to initialize caller context.", exception);
            }
        }
    }

    public static Subject pushInvocationSubject(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pushInvocationSubject");
        }
        Subject subject2 = null;
        try {
            subject2 = SecurityHelper.getContextManager().pushInvocationSubject(subject);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.connector.util.SecurityHelper.pushInvocationSubject", "226");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pushInvocationSubject");
        }
        return subject2;
    }

    public static void popInvocationSubject(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "popInvocationSubject");
        }
        try {
            SecurityHelper.getContextManager().popInvocationSubject(subject);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.connector.util.SecurityHelper.popInvocationSubject", "239");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "popInvocationSubject");
        }
    }

    public static Subject getOwnedSubject() {
        return SecurityHelper.getServerSubject();
    }

    public static Subject retrieveSubject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveSubject");
        }
        Subject subject = SecurityHelper.getInvocationSubject();
        WSCredential wSCredential = null;
        if (subject != null) {
            wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
        }
        if (subject == null || wSCredential != null && wSCredential.isUnauthenticated()) {
            subject = SecurityHelper.getReceivedSubject();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveSubject");
        }
        return subject;
    }

    public static Subject getInvocationSubject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInvocationSubject");
        }
        Subject subject = null;
        WSCredential wSCredential = null;
        boolean bl = false;
        try {
            subject = SecurityHelper.getContextManager().getInvocationSubject();
            wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
            if (wSCredential != null && !(bl = SecurityHelper.getContextManager().getWSCredTokenMapper().checkValidityOfAllTokensAndRefresh(subject)) && tc.isDebugEnabled()) {
                Tr.debug(tc, "Non-server invocation subject could not be refreshed.");
            }
            if (!bl && subject != null && SecurityHelper.getContextManager().isServerSubject(subject)) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server subject is expired, logging in to get a new one.");
                    }
                    subject = SecurityHelper.getContextManager().getServerSubject();
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.management.connector.util.SecurityHelper.getInvocationSubject", "450");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "unable to obtain invocation subject or subject expired", exception);
                    }
                    subject = null;
                }
            } else if (!bl && subject != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Non-server invocation subject is invalid or expired.");
                }
            } else if (subject == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invocation subject is null.");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.connector.util.SecurityHelper.getInvocationSubject", "394");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to obtain invocation subject from ContextManager.", exception);
            }
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInvocationSubject");
        }
        return subject;
    }

    public static void resetContext() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "resetContext");
            }
            try {
                SecurityHelper.getContextManager().initializeCallerContext((Subject)null);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "fail to initialize caller context.", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetContext");
        }
    }

    public static void setInvocationSubject(Subject subject) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setInvocationSubject");
            }
            try {
                SecurityHelper.getContextManager().setInvocationSubject(subject);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "fail to set invocation subject.", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInvocationSubject");
        }
    }

    public static void setReceivedSubject(Subject subject) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setReceivedSubject");
            }
            try {
                SecurityHelper.getContextManager().setCallerSubject(subject);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Failed to set caller subject.", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setReceivedSubject");
        }
    }

    public static Subject getReceivedSubject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReceivedSubject");
        }
        Subject subject = null;
        WSCredential wSCredential = null;
        boolean bl = false;
        try {
            subject = SecurityHelper.getContextManager().getCallerSubject();
            if (subject != null) {
                wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
            }
            if (wSCredential != null) {
                bl = wSCredential.isCurrent();
            }
            if (!bl && subject != null && SecurityHelper.getContextManager().isServerSubject(subject)) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server subject is expired, logging in to get a new one.");
                    }
                    subject = SecurityHelper.getContextManager().getServerSubject();
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.management.connector.util.SecurityHelper.getReceivedSubject", "557");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "unable to obtain received subject or subject is expired", exception);
                    }
                    subject = null;
                }
            } else if (!bl && subject != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Non-server received subject is invalid or expired.");
                }
                subject = null;
            } else if (subject == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Received subject is null.");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to obtain received subject from ContextManager.", exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.connector.util.SecurityHelper.getReceivedSubject", "504");
            bl = false;
        }
        if (bl && subject != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getReceivedSubject");
            }
            return subject;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReceivedSubject");
        }
        return null;
    }

    public static Subject getActualSubject(Subject subject) {
        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
        if (wSCredential.isBasicAuth()) {
            Subject subject2 = null;
            try {
                subject2 = SecurityHelper.getContextManager().login(wSCredential);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "LoginFailed exception getting server cred.", new Object[]{exception});
                }
                FFDCFilter.processException(exception, "com.ibm.ws.management.connector.util.SecurityHelper.getActualSubject", "566");
                subject2 = null;
            }
            return subject2;
        }
        return subject;
    }

    public static Subject getServerSubject() {
        Subject subject = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...Expecting : " + perm.toString());
            }
            securityManager.checkPermission(perm);
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting server subject.");
            }
            subject = SecurityHelper.getContextManager().getServerSubject();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to obtain own subject or subject is expired", exception);
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.connector.util.SecurityHelper.getServerCredential", "1001");
            subject = null;
        }
        return subject;
    }

    public static String getUserName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserName");
        }
        String string = null;
        try {
            Subject subject = SecurityHelper.retrieveSubject();
            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
            if (wSCredential != null) {
                string = wSCredential.getRealmSecurityName();
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception attempting to getUserName from credential.", new Object[]{exception});
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.connector.util.SecurityHelper.getUserName", "637");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserName");
        }
        return string;
    }

    public static String getAuditUserName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuditUserName");
        }
        String string = null;
        try {
            string = SecurityHelper.getContextManager().getUserBeforeRunAs();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception attempting to getAuditUserName from Context Manager.", new Object[]{exception});
            }
            FFDCFilter.processException(exception, "com.ibm.ws.management.connector.util.SecurityHelper.getAuditUserName", "648");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuditUserName");
        }
        return string;
    }

    public static ContextManager getContextManager() {
        if (contextMgr == null) {
            contextMgr = ContextManagerFactory.getInstance();
        }
        return contextMgr;
    }

    public static synchronized void registerPackage(String string) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = System.getProperty(URL_HANDLER_PROP);
        if (string2 != null) {
            object = new StringTokenizer(string2, PKGNAME_DELIMITER);
            while (((StringTokenizer)object).hasMoreTokens()) {
                arrayList.add(((StringTokenizer)object).nextToken());
            }
        }
        if (arrayList.contains(string)) {
            return;
        }
        arrayList.add(string);
        object = new StringBuffer();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            ((StringBuffer)object).append(string3);
            if (!iterator.hasNext()) continue;
            ((StringBuffer)object).append('|');
        }
        System.setProperty(URL_HANDLER_PROP, ((StringBuffer)object).toString());
    }
}

