/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util.zos;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.util.PlatformClusterConfigHelper;
import com.ibm.ws.management.util.zos.PlatformConfigHelperUtil;
import com.ibm.ws.sm.workspace.ContextResourceSet;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class PlatformClusterConfigHelperImpl
implements PlatformClusterConfigHelper {
    private static TraceComponent tc = Tr.register(PlatformClusterConfigHelperImpl.class, "Admin", null);

    public void configureServerClusterFromServer(ServerCluster serverCluster, Server server2) {
        RepositoryContext repositoryContext = ((ContextResourceSet)serverCluster.eResource().getResourceSet()).getContext().getParent();
        this.configureServerClusterFromServer(repositoryContext, serverCluster, server2);
    }

    public void configureServerClusterFromServer(RepositoryContext repositoryContext, ServerCluster serverCluster, Server server2) {
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "configureServerClusterFromServer", new Object[]{serverCluster, server2});
            }
            Session session = new Session();
            Resource resource = null;
            ServerIndex serverIndex = null;
            List list = repositoryContext.getChildren();
            LinkedList<ServerIndex> linkedList = new LinkedList<ServerIndex>();
            Iterator iterator = list.iterator();
            RepositoryContextType repositoryContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("nodes");
            RepositoryContext repositoryContext2 = ((ContextResourceSet)server2.eResource().getResourceSet()).getContext().getParent();
            try {
                String string;
                Object object;
                if (!PlatformConfigHelperUtil.isNodeZOS(session, repositoryContext2)) break block21;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "configureServerClusterFromServer: node --> zOS");
                }
                while (iterator.hasNext()) {
                    object = (RepositoryContext)iterator.next();
                    if (object.getType() != repositoryContextType) continue;
                    try {
                        string = URI.createURI((String)"serverindex.xml");
                        resource = object.getResourceSet().getResource((URI)string, true);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.util.zos.PlatformClusterConfigHelperImpl.configureServerClusterFromServer", "107", this);
                    }
                    string = resource.getContents();
                    serverIndex = (ServerIndex)resource.getContents().get(0);
                    linkedList.add(serverIndex);
                }
                object = PlatformConfigHelperUtil.findNextValidServerShortName(linkedList);
                string = PlatformConfigHelperUtil.findNextValidClusterShortName(linkedList);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "shortName ", object);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "clusterShortName ", string);
                }
                if (server2 != null) {
                    Property property;
                    List list2 = PlatformConfigHelperUtil.getApplicationServerProperties(server2);
                    for (int i = 0; i < list2.size(); ++i) {
                        property = (Property)list2.get(i);
                        if (property.getName().equals("was.ClusterTransitionUUID")) {
                            serverCluster.setUniqueId(property.getValue());
                            list2.remove(i);
                            --i;
                            continue;
                        }
                        if (!property.getName().equals("ClusterTransitionName")) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "setting cluster shortname  from server transition name", property.getValue());
                        }
                        if (serverCluster.getShortName() == null) {
                            serverCluster.setShortName(property.getValue());
                        }
                        list2.remove(i);
                        --i;
                    }
                    try {
                        URI uRI = URI.createURI((String)"server.xml");
                        property = server2.eResource().getResourceSet().getResource(uRI, true);
                        property.save(new HashMap());
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.util.zos.PlatformClusterConfigHelperImpl.configureServerClusterFromServer", "141", this);
                        exception.printStackTrace();
                    }
                } else {
                    String string2 = null;
                    if (!AdminHelper.getPlatformHelper().isZOS()) {
                        ConfigService configService = ConfigServiceFactory.getConfigService();
                        string2 = PlatformConfigHelperUtil.getNodeAgentUuid(session, configService, repositoryContext2);
                    } else {
                        string2 = AdminHelper.getPlatformHelper().getUniqueId();
                    }
                    serverCluster.setUniqueId(string2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setting cluster shortname ", string);
                    }
                    serverCluster.setShortName(string);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.util.zos.PlatformClusterConfigHelperImpl.configureServerClusterFromServer", "163", this);
                Tr.error(tc, "Error during configureServerClusterFromServer", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configureServerClusterFromServer", serverCluster);
        }
    }

    public String calculatedServerClusterShortName() {
        return null;
    }

    public void modifyClusterShortName(ServerCluster serverCluster) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyClusterShortName", new Object[]{serverCluster});
        }
        String string = serverCluster.getShortName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "shortname", string);
        }
        RepositoryContext repositoryContext = ((ContextResourceSet)serverCluster.eResource().getResourceSet()).getContext().getParent();
        EList eList = serverCluster.getMembers();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            URI uRI;
            ClusterMember clusterMember = (ClusterMember)iterator.next();
            String string2 = clusterMember.getNodeName();
            RepositoryContextType repositoryContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("nodes");
            Resource resource = null;
            try {
                RepositoryContext repositoryContext2 = repositoryContext.getChild(repositoryContextType, string2);
                uRI = URI.createURI((String)"serverindex.xml");
                resource = repositoryContext2.getResourceSet().getResource(uRI, true);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.util.zos.PlatformClusterConfigHelperImpl.modifyClusterShortName", "201", this);
                exception.printStackTrace();
            }
            uRI = (ServerIndex)resource.getContents().get(0);
            ServerEntry serverEntry = PlatformConfigHelperUtil.lookupServerEntry((ServerIndex)uRI, clusterMember.getMemberName());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "modifying server entry for node=" + string2 + " server=" + clusterMember.getMemberName());
            }
            serverEntry.setGenericShortName(string);
            try {
                resource.save(new HashMap());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.util.zos.PlatformClusterConfigHelperImpl.modifyClusterShortName", "211", this);
                exception.printStackTrace();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modifyClusterShortName");
        }
    }
}

