/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util.zos;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.util.PlatformClusterMemberConfigHelper;
import com.ibm.ws.management.util.zos.PlatformConfigHelperUtil;
import com.ibm.ws.sm.workspace.ContextResourceSet;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class PlatformClusterMemberHelperImpl
implements PlatformClusterMemberConfigHelper {
    private static TraceComponent tc = Tr.register(PlatformClusterMemberHelperImpl.class, "Admin", null);

    public void configureClusterMember(ClusterMember clusterMember, Server server2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configureClusterMember", new Object[]{clusterMember, server2});
        }
        Session session = new Session();
        if (server2 != null) {
            RepositoryContext repositoryContext = ((ContextResourceSet)server2.eResource().getResourceSet()).getContext().getParent();
            try {
                if (PlatformConfigHelperUtil.isNodeZOS(session, repositoryContext)) {
                    VariableSubstitutionEntry variableSubstitutionEntry;
                    int n;
                    Property property;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "configureClusterMember: node --> zOS");
                    }
                    List list = PlatformConfigHelperUtil.getApplicationServerProperties(server2);
                    for (int i = 0; i < list.size(); ++i) {
                        property = (Property)list.get(i);
                        if (property.getName().equals("was.ClusterTransitionUUID")) {
                            list.remove(i);
                            --i;
                            continue;
                        }
                        if (!property.getName().equals("ClusterTransitionName")) continue;
                        list.remove(i);
                        --i;
                    }
                    clusterMember.setUniqueId(server2.getUniqueId());
                    RepositoryContext repositoryContext2 = ((ContextResourceSet)server2.eResource().getResourceSet()).getContext();
                    property = URI.createURI((String)"server.xml");
                    Resource resource = repositoryContext2.getResourceSet().getResource((URI)property, true);
                    resource.save(new HashMap());
                    Resource resource2 = null;
                    Resource resource3 = null;
                    URI uRI = URI.createURI((String)"serverindex.xml");
                    resource2 = repositoryContext.getResourceSet().getResource(uRI, true);
                    ServerIndex serverIndex = (ServerIndex)resource2.getContents().get(0);
                    ServerEntry serverEntry = PlatformConfigHelperUtil.lookupServerEntry(serverIndex, server2.getName());
                    ServerCluster serverCluster = clusterMember.getCluster();
                    if (server2.getClusterName() == null || server2.getClusterName().equals("")) {
                        server2.setClusterName(serverCluster.getName());
                    }
                    serverEntry.setGenericShortName(serverCluster.getShortName());
                    resource2.save(new HashMap());
                    URI uRI2 = URI.createURI((String)"variables.xml");
                    resource3 = repositoryContext.getResourceSet().getResource(uRI2, true);
                    VariableMap variableMap = (VariableMap)resource3.getContents().get(0);
                    EList eList = variableMap.getEntries();
                    String string = null;
                    String string2 = null;
                    for (n = 0; n < eList.size(); ++n) {
                        variableSubstitutionEntry = (VariableSubstitutionEntry)eList.get(n);
                        string = variableSubstitutionEntry.getSymbolicName();
                        string2 = null;
                        if (!string.equals("WAS_DAEMON_ONLY_server_configured_system_name")) continue;
                        string2 = variableSubstitutionEntry.getValue();
                        break;
                    }
                    for (n = 0; n < list.size(); ++n) {
                        variableSubstitutionEntry = (Property)list.get(n);
                        if (!variableSubstitutionEntry.getName().equals("WAS_DAEMON_ONLY_server_configured_system_name")) continue;
                        variableSubstitutionEntry.setValue(string2);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.util.zos.PlatformClusterMemberHelperImpl.configureClusterMember", "146", this);
                exception.printStackTrace();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configureClusterMember");
        }
    }
}

