/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util.zos;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;

public class PlatformConfigHelperUtil {
    private static TraceComponent tc = Tr.register(PlatformConfigHelperUtil.class, "Admin", null);
    protected static String SERVER_PREFIX = "BBOS";
    protected static String CLUSTER_PREFIX = "BBOC";
    protected static String NODEAGENT_PREFIX = "BBON";
    protected static String PROXY_PREFIX = "BBOX";

    private PlatformConfigHelperUtil() {
    }

    static List getApplicationServerProperties(Server server2) {
        EList eList = server2.getComponents();
        Component component2 = null;
        for (int i = 0; i < eList.size() && !((component2 = (Component)eList.get(i)) instanceof ApplicationServer); ++i) {
        }
        EList eList2 = component2.getProperties();
        return eList2;
    }

    static List getAdminServiceProperties(Server server2) {
        EList eList = server2.getServices();
        Service service = null;
        for (int i = 0; i < eList.size() && !((service = (Service)eList.get(i)) instanceof AdminService); ++i) {
        }
        EList eList2 = service.getProperties();
        return eList2;
    }

    public static String findNextValidClusterShortName(ServerIndex serverIndex) {
        return PlatformConfigHelperUtil.findNextShortName_help(serverIndex, CLUSTER_PREFIX);
    }

    public static String findNextValidClusterShortName(List list) {
        return PlatformConfigHelperUtil.findNextShortName_help(list, CLUSTER_PREFIX);
    }

    public static String findNextValidServerShortName(ServerIndex serverIndex) {
        return PlatformConfigHelperUtil.findNextShortName_help(serverIndex, SERVER_PREFIX);
    }

    public static String findNextValidServerShortName(List list) {
        return PlatformConfigHelperUtil.findNextShortName_help(list, SERVER_PREFIX);
    }

    public static String findNextNodeAgentShortName(ServerIndex serverIndex) {
        return PlatformConfigHelperUtil.findNextShortName_help(serverIndex, NODEAGENT_PREFIX);
    }

    public static String findNextNodeAgentShortName(List list) {
        return PlatformConfigHelperUtil.findNextShortName_help(list, NODEAGENT_PREFIX);
    }

    public static String findNextShortName_help(ServerIndex serverIndex, String string) {
        Object object;
        EList eList = serverIndex.getServerEntries();
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = "";
        Object var5_5 = null;
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            if (iterator == null || (object = (ServerEntry)iterator.next()) == null) continue;
            if (string.equals(SERVER_PREFIX) || string.equals(NODEAGENT_PREFIX) || string.equals(PROXY_PREFIX)) {
                string2 = object.getServerShortName();
            } else if (string.equals(CLUSTER_PREFIX)) {
                string2 = object.getGenericShortName();
            }
            if (string2 == null || string2.length() <= 0) continue;
            hashSet.add(string2);
        }
        int n = 1;
        if (hashSet != null) {
            for (int i = 0; i < hashSet.size() + 2; ++i) {
                object = String.valueOf(n);
                while (((String)object).length() < 3) {
                    object = "0" + (String)object;
                }
                String string3 = string + (String)object;
                if (!hashSet.contains(string3)) {
                    return string3;
                }
                ++n;
            }
        } else {
            return string + "001";
        }
        return null;
    }

    public static String findNextShortName_help(List list, String string) {
        String string2;
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        String string3 = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ServerIndex serverIndex = (ServerIndex)iterator.next();
            object = serverIndex.getServerEntries();
            string2 = null;
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                ServerEntry serverEntry;
                if (iterator2 == null || (serverEntry = (ServerEntry)iterator2.next()) == null) continue;
                if (string.equals(SERVER_PREFIX) || string.equals(NODEAGENT_PREFIX) || string.equals(PROXY_PREFIX)) {
                    string3 = serverEntry.getServerShortName();
                } else if (string.equals(CLUSTER_PREFIX)) {
                    string3 = serverEntry.getGenericShortName();
                }
                if (string3 == null || string3.length() <= 0) continue;
                hashSet.add(string3);
            }
        }
        int n = 1;
        if (hashSet != null) {
            for (int i = 0; i < hashSet.size() + 2; ++i) {
                object = String.valueOf(n);
                while (((String)object).length() < 3) {
                    object = "0" + (String)object;
                }
                string2 = string + (String)object;
                if (!hashSet.contains(string2)) {
                    return string2;
                }
                ++n;
            }
        } else {
            return string + "001";
        }
        return null;
    }

    public static ServerEntry lookupServerEntry(ServerIndex serverIndex, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookupServerEntry", serverIndex);
        }
        EList eList = serverIndex.getServerEntries();
        ServerEntry serverEntry = null;
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry2 = (ServerEntry)iterator.next();
            if (!serverEntry2.getServerName().equals(string)) continue;
            serverEntry = serverEntry2;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookupServerEntry", serverEntry);
        }
        return serverEntry;
    }

    public static String getNodeAgentUuid(Session session, ConfigService configService, RepositoryContext repositoryContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeAgentUuid", repositoryContext);
        }
        String string = null;
        String string2 = repositoryContext.getName();
        ObjectName objectName = configService.resolve(session, "Node=" + string2)[0];
        ObjectName objectName2 = configService.getRelationship(session, objectName, "ServerIndex")[0];
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, "ServerEntry");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName2, objectName3, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string3 = (String)configService.getAttribute(session, objectNameArray[i], "serverType");
            if (string3 == null || string3.length() <= 0 || !string3.equals("NODE_AGENT")) continue;
            string = (String)configService.getAttribute(session, objectNameArray[i], "serverUniqueId");
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeAgentUuid", string);
        }
        return string;
    }

    public static boolean isNodeZOS(Session session, RepositoryContext repositoryContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isNodeZOS", repositoryContext);
        }
        String string = repositoryContext.getName();
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        ManagedObjectMetadataHelper managedObjectMetadataHelper = workSpace.getMetadataHelper();
        boolean bl = managedObjectMetadataHelper.isNodeZOS(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isNodeZOS", new Boolean(bl));
        }
        return bl;
    }
}

