/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util.zos;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.processexec.ProcessDef;
import com.ibm.websphere.models.config.properties.PropertiesFactory;
import com.ibm.websphere.models.config.properties.PropertiesPackage;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.serverindex.ServerindexFactory;
import com.ibm.websphere.models.config.serverindex.ServerindexPackage;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.util.PlatformServerConfigHelper;
import com.ibm.ws.management.util.zos.PlatformConfigHelperUtil;
import com.ibm.ws.sm.workspace.ContextResourceSet;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;

public class PlatformServerConfigHelperImpl
implements PlatformServerConfigHelper {
    private PropertiesFactory factory = null;
    private static final TraceComponent tc = Tr.register(PlatformServerConfigHelperImpl.class, null, null);

    public PlatformServerConfigHelperImpl() {
        PropertiesPackage propertiesPackage = (PropertiesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/properties.xmi");
        this.factory = propertiesPackage.getPropertiesFactory();
    }

    public void configureServer(Server server2) {
        RepositoryContext repositoryContext = ((ContextResourceSet)server2.eResource().getResourceSet()).getContext().getParent();
        RepositoryContext repositoryContext2 = repositoryContext.getParent();
        this.configureServer(repositoryContext2, server2);
    }

    public void configureServer(RepositoryContext repositoryContext, Server server2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Entering configureServer", server2);
        }
        try {
            Session session = new Session();
            RepositoryContext repositoryContext2 = ((ContextResourceSet)server2.eResource().getResourceSet()).getContext().getParent();
            if (PlatformConfigHelperUtil.isNodeZOS(session, repositoryContext2)) {
                Object object;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "configureServer: node --> zOS");
                }
                ServerIndex serverIndex = null;
                URI uRI = URI.createURI((String)"serverindex.xml");
                Resource resource = repositoryContext2.getResourceSet().getResource(uRI, true);
                serverIndex = (ServerIndex)resource.getContents().iterator().next();
                ServerEntry serverEntry = PlatformConfigHelperUtil.lookupServerEntry(serverIndex, server2.getName());
                String string = serverEntry.getServerType();
                String string2 = null;
                String string3 = null;
                String string4 = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server Type", string);
                }
                String[] stringArray = this.getShortNames(repositoryContext, string);
                String string5 = stringArray[0];
                String string6 = stringArray[1];
                server2.setShortName(string5);
                server2.setClusterName(null);
                if (!AdminHelper.getPlatformHelper().isZOS()) {
                    object = ConfigServiceFactory.getConfigService();
                    string3 = PlatformConfigHelperUtil.getNodeAgentUuid(session, (ConfigService)object, repositoryContext2);
                    string2 = AdminHelper.getPlatformHelper().getUniqueId(string3);
                    string4 = AdminHelper.getPlatformHelper().getUniqueId(string3);
                } else {
                    string2 = AdminHelper.getPlatformHelper().getUniqueId();
                    string4 = AdminHelper.getPlatformHelper().getUniqueId();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "UUID from PlatformHelper: " + string2);
                }
                server2.setUniqueId(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server UUID: " + server2.getUniqueId());
                }
                if (!"GENERIC_SERVER".equals(string)) {
                    object = this.buildStartCommands(server2, repositoryContext2, string5);
                    this.addServerProperties(server2, string6, string4, (String)object);
                }
                this.configureServerIndex(server2, repositoryContext2, string5, string6);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.util.zos.PlatformServerConfigHelperImpl.configureServer", "149", this);
            throwable.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Exit configureServer");
        }
    }

    public void modifyShortName(Server server2, String string) {
        URI uRI;
        Object object;
        Object object2;
        URI uRI2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyShortName()", new Object[]{server2, string});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = new Session();
        String string2 = server2.getShortName();
        RepositoryContext repositoryContext = ((ContextResourceSet)server2.eResource().getResourceSet()).getContext();
        RepositoryContext repositoryContext2 = repositoryContext.getParent();
        RepositoryContext repositoryContext3 = repositoryContext2.getParent();
        Resource resource = null;
        Resource resource2 = null;
        Resource resource3 = null;
        Resource resource4 = null;
        Cell cell = null;
        Node node = null;
        ServerIndex serverIndex = null;
        try {
            uRI2 = URI.createURI((String)"serverindex.xml");
            resource = repositoryContext2.getResourceSet().getResource(uRI2, true);
            serverIndex = (ServerIndex)resource.getContents().iterator().next();
            object2 = URI.createURI((String)"node.xml");
            resource2 = repositoryContext2.getResourceSet().getResource((URI)object2, true);
            object = URI.createURI((String)"cell.xml");
            resource3 = repositoryContext3.getResourceSet().getResource((URI)object, true);
            uRI = URI.createURI((String)"server.xml");
            resource4 = repositoryContext.getResourceSet().getResource(uRI, true);
            cell = (Cell)resource3.getContents().get(0);
            node = (Node)resource2.getContents().get(0);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.util.zos.PlatformServerConfigHelperImpl.modifyShortName", "195", this);
            Tr.error(tc, "Error trying to load resources", exception);
            exception.printStackTrace();
        }
        uRI2 = PlatformConfigHelperUtil.lookupServerEntry(serverIndex, server2.getName());
        uRI2.setServerShortName(server2.getShortName().toString());
        if (!string.equals("Server")) {
            uRI2.setGenericShortName(server2.getShortName().toString());
            object2 = null;
            object2 = string.equals("Node Agent") ? PlatformConfigHelperUtil.getAdminServiceProperties(server2) : PlatformConfigHelperUtil.getApplicationServerProperties(server2);
            object = null;
            for (int i = 0; i < object2.size(); ++i) {
                object = (Property)object2.get(i);
                if (!object.getName().equals("ClusterTransitionName")) continue;
                object.setValue(server2.getShortName().toString());
            }
        }
        try {
            resource.save(new HashMap());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.util.zos.PlatformServerConfigHelperImpl.modifyShortName", "226", this);
            exception.printStackTrace();
        }
        object2 = cell.getShortName();
        object = node.getShortName();
        uRI = server2.getProcessDefinitions();
        Iterator iterator = uRI.iterator();
        ProcessDef processDef = null;
        while (iterator.hasNext()) {
            processDef = (ProcessDef)iterator.next();
            if (!processDef.getProcessType().equals("Control")) continue;
            String string3 = string2.trim();
            String string4 = ((String)object2).trim() + "." + ((String)object).trim() + "." + string2.trim();
            String string5 = "STOP " + string2.trim() + "; CANCEL " + string2.trim();
            String string6 = "FORCE " + string2.trim();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Original Start Command" + processDef.getStartCommandArgs());
            }
            Map map = this.parseStartCommandArgs((String)processDef.getStartCommandArgs().get(0));
            map.put("JOBNAME", string3);
            map.put("ENV", string4);
            String string7 = this.generateStartCommandArgs(map);
            processDef.getStartCommandArgs().clear();
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(string7);
            processDef.getStartCommandArgs().addAll(linkedList);
            processDef.setStopCommand(string5);
            processDef.setTerminateCommand(string6);
        }
        try {
            resource4.save(new HashMap());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.util.zos.PlatformServerConfigHelperImpl.modifyShortName", "255", this);
            exception.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modifyShortName()", server2);
        }
    }

    public void configureServerIndex(Server server2, RepositoryContext repositoryContext, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configureServerIndex", new Object[]{server2, repositoryContext, string, string2});
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configureServerIndex()", server2);
        }
        ServerindexPackage serverindexPackage = (ServerindexPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/serverindex.xmi");
        ServerindexFactory serverindexFactory = serverindexPackage.getServerindexFactory();
        URI uRI = URI.createURI((String)"serverindex.xml");
        Resource resource = repositoryContext.getResourceSet().getResource(uRI, true);
        ServerIndex serverIndex = (ServerIndex)resource.getContents().iterator().next();
        ServerEntry serverEntry = PlatformConfigHelperUtil.lookupServerEntry(serverIndex, server2.getName());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server Entry: ", serverEntry);
        }
        if (serverEntry == null) {
            serverEntry = serverindexFactory.createServerEntry();
            serverIndex.getServerEntries().add((Object)serverEntry);
        }
        serverEntry.setServerName(server2.getName());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting Server Name: " + server2.getName());
        }
        serverEntry.setServerDisplayName(server2.getName());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting Server Display Name: " + server2.getName());
        }
        serverEntry.setServerShortName(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting Server Short  Name: " + string);
        }
        serverEntry.setGenericShortName(string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting Server Cluster Name: " + string2);
        }
        serverEntry.setServerUniqueId(server2.getUniqueId());
        EList eList = serverEntry.getSpecialEndpoints();
        NamedEndPoint namedEndPoint = null;
        NamedEndPoint namedEndPoint2 = null;
        NamedEndPoint namedEndPoint3 = null;
        NamedEndPoint namedEndPoint4 = null;
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            namedEndPoint4 = (NamedEndPoint)iterator.next();
            if (namedEndPoint4.getEndPointName().equals("ORB_LISTENER_ADDRESS")) {
                namedEndPoint = namedEndPoint4;
                continue;
            }
            if (namedEndPoint4.getEndPointName().equals("BOOTSTRAP_ADDRESS")) {
                namedEndPoint2 = namedEndPoint4;
                continue;
            }
            if (!namedEndPoint4.getEndPointName().equals("ORB_SSL_LISTENER_ADDRESS")) continue;
            namedEndPoint3 = namedEndPoint4;
        }
        if (namedEndPoint2 != null && namedEndPoint != null) {
            namedEndPoint.getEndPoint().setHost("*");
            namedEndPoint.getEndPoint().setPort(namedEndPoint2.getEndPoint().getPort());
        }
        if (namedEndPoint3 != null) {
            namedEndPoint3.getEndPoint().setHost("*");
        }
        try {
            resource.save(new HashMap());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.util.zos.PlatformServerConfigHelperImpl.configureServerIndex", "328", this);
            exception.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configureServerIndex()", serverEntry);
        }
    }

    private void addServerProperties(Server server2, String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addServerProperties", new Object[]{server2, string, string2, string3});
        }
        List list = PlatformConfigHelperUtil.getApplicationServerProperties(server2);
        Property property = null;
        for (int i = 0; i < list.size(); ++i) {
            property = (Property)list.get(i);
            if (property.getName().equals("was.ClusterTransitionUUID")) {
                list.remove(i);
                --i;
                continue;
            }
            if (property.getName().equals("ClusterTransitionName")) {
                list.remove(i);
                --i;
                continue;
            }
            if (!property.getName().equals("was.ConfiguredSystemName")) continue;
            list.remove(i);
            --i;
        }
        Property property2 = this.factory.createProperty();
        property2.setName("ClusterTransitionName");
        property2.setValue(string);
        list.add(property2);
        property2 = this.factory.createProperty();
        property2.setName("was.ClusterTransitionUUID");
        property2.setValue(string2);
        list.add(property2);
        property2 = this.factory.createProperty();
        property2.setName("was.ConfiguredSystemName");
        property2.setValue(string3);
        list.add(property2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addServerProperties", list);
        }
    }

    private String[] getShortNames(RepositoryContext repositoryContext, String string) {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getShortNames", repositoryContext);
        }
        String[] stringArray = new String[2];
        RepositoryContextType repositoryContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("nodes");
        List list = repositoryContext.getChildren(repositoryContextType);
        LinkedList<ServerIndex> linkedList = new LinkedList<ServerIndex>();
        Iterator iterator = list.iterator();
        Resource resource = null;
        ServerIndex serverIndex = null;
        RepositoryContext repositoryContext2 = null;
        while (iterator.hasNext()) {
            resource = null;
            serverIndex = null;
            repositoryContext2 = (RepositoryContext)iterator.next();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Iterating Context: ", repositoryContext2);
            }
            try {
                string2 = URI.createURI((String)"serverindex.xml");
                resource = repositoryContext2.getResourceSet().getResource((URI)string2, true);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.util.zos.PlatformServerConfigHelperImpl.getShortNames", "407", this);
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Error occured while iterating nodes: ", exception);
                }
                exception.printStackTrace();
            }
            serverIndex = (ServerIndex)resource.getContents().get(0);
            linkedList.add(serverIndex);
        }
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "Server indexes ", linkedList);
        }
        string2 = "";
        String string3 = "";
        if ("PROXY_SERVER".equals(string) || "ONDEMAND_ROUTER".equals(string)) {
            string3 = string2 = PlatformConfigHelperUtil.findNextShortName_help(linkedList, PlatformConfigHelperUtil.PROXY_PREFIX);
        } else if ("NODE_AGENT".equals(string)) {
            string3 = string2 = PlatformConfigHelperUtil.findNextShortName_help(linkedList, PlatformConfigHelperUtil.NODEAGENT_PREFIX);
        } else {
            string2 = PlatformConfigHelperUtil.findNextValidServerShortName(linkedList);
            string3 = PlatformConfigHelperUtil.findNextValidClusterShortName(linkedList);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server Short Name: " + string2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cluster Short Name: " + string3);
        }
        stringArray[0] = string2;
        stringArray[1] = string3;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getShortNames", stringArray);
        }
        return stringArray;
    }

    public String buildStartCommands(Server server2, RepositoryContext repositoryContext, String string) {
        Object object;
        URI uRI;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildStartCommands", new Object[]{server2, repositoryContext, string});
        }
        Resource resource = null;
        Resource resource2 = null;
        Resource resource3 = null;
        Resource resource4 = null;
        Cell cell = null;
        Node node = null;
        VariableMap variableMap = null;
        ServerIndex serverIndex = null;
        RepositoryContext repositoryContext2 = repositoryContext.getParent();
        try {
            object3 = URI.createURI((String)"node.xml");
            resource = repositoryContext.getResourceSet().getResource((URI)object3, true);
            object2 = URI.createURI((String)"cell.xml");
            resource2 = repositoryContext2.getResourceSet().getResource((URI)object2, true);
            uRI = URI.createURI((String)"serverindex.xml");
            resource3 = repositoryContext.getResourceSet().getResource(uRI, true);
            object = URI.createURI((String)"variables.xml");
            resource4 = repositoryContext.getResourceSet().getResource(object, true);
            node = (Node)resource.getContents().get(0);
            cell = (Cell)resource2.getContents().get(0);
            serverIndex = (ServerIndex)resource3.getContents().get(0);
            variableMap = (VariableMap)resource4.getContents().get(0);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.util.zos.PlatformServerConfigHelperImpl.buildStartCommands", "466", this);
            exception.printStackTrace();
        }
        object3 = cell.getShortName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell Short Name: " + (String)object3);
        }
        object2 = node.getShortName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Node Short Name: " + (String)object2);
        }
        uRI = variableMap.getEntries();
        object = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        VariableSubstitutionEntry variableSubstitutionEntry = null;
        String string6 = null;
        for (int i = 0; i < uRI.size(); ++i) {
            variableSubstitutionEntry = (VariableSubstitutionEntry)uRI.get(i);
            string6 = variableSubstitutionEntry.getSymbolicName();
            if (string6.equalsIgnoreCase("WAS_DEFAULT_CONTROL_PROC_NAME")) {
                object = variableSubstitutionEntry.getValue();
                continue;
            }
            if (string6.equalsIgnoreCase("WAS_DEFAULT_SERVANT_PROC_NAME")) {
                string2 = variableSubstitutionEntry.getValue();
                continue;
            }
            if (string6.equalsIgnoreCase("WAS_DEFAULT_ADJUNCT_PROC_NAME")) {
                string3 = variableSubstitutionEntry.getValue();
                continue;
            }
            if (string6.equalsIgnoreCase("WAS_DEFAULT_SERVER_PROC_NAME")) {
                string5 = variableSubstitutionEntry.getValue();
                continue;
            }
            if (!string6.equals("WAS_DAEMON_ONLY_server_configured_system_name")) continue;
            string4 = variableSubstitutionEntry.getValue();
        }
        if (tc.isDebugEnabled() && (object == null || string2 == null || string3 == null || string5 == null)) {
            Tr.debug(tc, "ctrl_proc: " + (String)object);
            Tr.debug(tc, "servant_proc: " + string2);
            Tr.debug(tc, "adjunct_proc: " + string3);
            Tr.debug(tc, "server_proc: " + string5);
        }
        EList eList = server2.getProcessDefinitions();
        Iterator iterator = eList.iterator();
        ProcessDef processDef = null;
        while (iterator.hasNext()) {
            LinkedList<String> linkedList;
            String string7;
            Object object4;
            String string8;
            String string9;
            processDef = (ProcessDef)iterator.next();
            if (processDef.getProcessType() == null || processDef.getProcessType().trim().equals("") || processDef.getProcessType().equals("Distributed")) {
                string9 = "START " + string5;
                string8 = "JOBNAME=" + string.trim() + ",ENV=" + ((String)object3).trim() + "." + ((String)object2).trim() + "." + string.trim();
                object4 = "STOP " + string.trim() + "; CANCEL " + string.trim();
                string7 = "FORCE " + string.trim();
                processDef.setStartCommand(string9);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Original Start Command" + processDef.getStartCommandArgs());
                }
                processDef.getStartCommandArgs().clear();
                linkedList = new LinkedList();
                linkedList.add(string8);
                processDef.getStartCommandArgs().addAll(linkedList);
                processDef.setStopCommand((String)object4);
                processDef.setTerminateCommand(string7);
                continue;
            }
            if (processDef.getProcessType().equals("Control")) {
                string9 = "START " + (String)object;
                string8 = string.trim();
                object4 = ((String)object3).trim() + "." + ((String)object2).trim() + "." + string.trim();
                string7 = "STOP " + string.trim() + "; CANCEL " + string.trim();
                linkedList = "FORCE " + string.trim();
                processDef.setStartCommand(string9);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Original Start Command" + processDef.getStartCommandArgs());
                }
                Map map = this.parseStartCommandArgs((String)processDef.getStartCommandArgs().get(0));
                map.put("JOBNAME", string8);
                map.put("ENV", object4);
                String string10 = this.generateStartCommandArgs(map);
                processDef.getStartCommandArgs().clear();
                LinkedList<String> linkedList2 = new LinkedList<String>();
                linkedList2.add(string10);
                processDef.getStartCommandArgs().addAll(linkedList2);
                processDef.setStopCommand(string7);
                processDef.setTerminateCommand(linkedList);
                continue;
            }
            if (processDef.getProcessType().equals("Servant")) {
                processDef.setStartCommand(string2);
                string9 = "&IWMSSNM.S";
                string8 = ((String)object3).trim() + "." + ((String)object2).trim() + ".&IWMSSNM.";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Original Start Command" + processDef.getStartCommandArgs());
                }
                object4 = this.parseStartCommandArgs((String)processDef.getStartCommandArgs().get(0));
                object4.put("JOBNAME", string9);
                object4.put("ENV", string8);
                string7 = this.generateStartCommandArgs((Map)object4);
                processDef.getStartCommandArgs().clear();
                linkedList = new LinkedList<String>();
                linkedList.add(string7);
                processDef.getStartCommandArgs().addAll(linkedList);
                continue;
            }
            if (!processDef.getProcessType().equals("Adjunct")) continue;
            processDef.setStartCommand(string3);
            string9 = "&IWMSSNM.A";
            string8 = ((String)object3).trim() + "." + ((String)object2).trim() + ".&IWMSSNM.";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Original Start Command" + processDef.getStartCommandArgs());
            }
            object4 = this.parseStartCommandArgs((String)processDef.getStartCommandArgs().get(0));
            object4.put("JOBNAME", string9);
            object4.put("ENV", string8);
            string7 = this.generateStartCommandArgs((Map)object4);
            processDef.getStartCommandArgs().clear();
            linkedList = new LinkedList();
            linkedList.add(string7);
            processDef.getStartCommandArgs().addAll(linkedList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildStartCommands", new Object[]{string4});
        }
        return string4;
    }

    private Map parseStartCommandArgs(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseStartCommandArgs", string);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Token", string2);
            }
            int n = string2.indexOf(61);
            String string3 = null;
            String string4 = null;
            if (n > 0) {
                string3 = string2.substring(0, n);
                string4 = string2.substring(n + 1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Key", string3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Value", string4);
                }
                hashMap.put(string3, string4);
                continue;
            }
            hashMap.put(string3, "");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Map", hashMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseStartCommandArgs", string);
        }
        return hashMap;
    }

    private String generateStartCommandArgs(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateStartCommandArgs", map);
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Key", entry.getKey());
                Tr.debug(tc, "Value", entry.getValue());
            }
            stringBuffer.append(entry.getKey());
            if (entry.getValue() == null || ((String)entry.getValue()).trim().length() <= 0) continue;
            stringBuffer.append("=");
            stringBuffer.append(entry.getValue());
            stringBuffer.append(",");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateStartCommandArgs", stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public String calculatedDefaultServerShortName() {
        return "null";
    }

    public void modifyClusterShortName(Server server2, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyClusterShortName()", new Object[]{server2, string, string2});
        }
        RepositoryContext repositoryContext = ((ContextResourceSet)server2.eResource().getResourceSet()).getContext().getParent();
        ServerindexPackage serverindexPackage = (ServerindexPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/serverindex.xmi");
        ServerindexFactory serverindexFactory = serverindexPackage.getServerindexFactory();
        URI uRI = URI.createURI((String)"serverindex.xml");
        Resource resource = repositoryContext.getResourceSet().getResource(uRI, true);
        ServerIndex serverIndex = (ServerIndex)resource.getContents().iterator().next();
        ServerEntry serverEntry = PlatformConfigHelperUtil.lookupServerEntry(serverIndex, server2.getName());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server Entry: ", serverEntry);
        }
        if (serverEntry == null) {
            return;
        }
        serverEntry.setGenericShortName(string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting Server Cluster Name: " + string2);
        }
        try {
            resource.save(new HashMap());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.commands.server.ServerConfigCommands.configureServerIndex", "696", this);
            exception.printStackTrace();
        }
        List list = PlatformConfigHelperUtil.getApplicationServerProperties(server2);
        Property property = null;
        for (int i = 0; i < list.size(); ++i) {
            property = (Property)list.get(i);
            if (!property.getName().equals("ClusterTransitionName")) continue;
            list.remove(i);
            --i;
        }
        Property property2 = this.factory.createProperty();
        property2.setName("ClusterTransitionName");
        property2.setValue(string2);
        list.add(property2);
        try {
            resource = server2.eResource();
            resource.save(new HashMap());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.commands.server.ServerConfigCommands.configureServerIndex", "696", this);
            exception.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modifyClusterShortName()");
        }
    }
}

