/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.webserver;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.runtime.ServerName;
import com.ibm.ws.exception.WsNestedException;
import com.ibm.ws.management.webserver.OperationFailedException;
import com.ibm.ws.management.webserver.RemoteIhsWebServerControl;
import com.ibm.ws.management.webserver.ServerNotAvailableException;
import com.ibm.ws.management.webserver.TransferFailedException;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;

public class ISeriesIhsWebServerControl
extends RemoteIhsWebServerControl {
    private static final TraceComponent tc = Tr.register(ISeriesIhsWebServerControl.class, "management", null);
    public static final String COMMANDER_PROCESSOR_KEY = "CommandProcessor";
    public static final String SEND_PROCESSOR = "send-processor";
    public static final String SERVER_ID_KEY = "serverID";

    public ISeriesIhsWebServerControl(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "iSeries Contructor pluginURL before- " + this.pluginUri);
        }
        this.pluginUri = "/HTTPAdmin/wasadmin";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "iSeries Contructor pluginURL after- " + this.pluginUri);
        }
    }

    public boolean startWebServer() throws OperationFailedException, ServerNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startWebServer");
        }
        Properties properties = new Properties();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ISeriesIhsWebServerControl server id key: " + this.getIdentifier());
        }
        properties.setProperty(SERVER_ID_KEY, this.getIdentifier());
        boolean bl = false;
        try {
            bl = super.startWebServer(properties);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ISeriesIhsWebServerControl result super.startWebServer: " + bl);
            }
        }
        catch (ServerNotAvailableException serverNotAvailableException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ISeriesIhsWebServerControl OperationFailedException: " + serverNotAvailableException.getMessage());
            }
            if (this.transmitIfNecessary(serverNotAvailableException)) {
                bl = super.startWebServer(properties);
            }
            throw serverNotAvailableException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startWebServer", String.valueOf(bl));
        }
        return bl;
    }

    public boolean stopWebServer() throws OperationFailedException, ServerNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopWebServer");
        }
        Properties properties = new Properties();
        properties.setProperty(SERVER_ID_KEY, this.getIdentifier());
        boolean bl = false;
        try {
            bl = super.stopWebServer(properties);
        }
        catch (ServerNotAvailableException serverNotAvailableException) {
            if (this.transmitIfNecessary(serverNotAvailableException)) {
                bl = super.stopWebServer(properties);
            }
            throw serverNotAvailableException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopWebServer", String.valueOf(bl));
        }
        return bl;
    }

    public boolean restartWebServer() throws OperationFailedException, ServerNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restartWebServer");
        }
        Properties properties = new Properties();
        properties.setProperty(SERVER_ID_KEY, this.getIdentifier());
        boolean bl = false;
        try {
            bl = super.restartWebServer(properties);
        }
        catch (ServerNotAvailableException serverNotAvailableException) {
            if (this.transmitIfNecessary(serverNotAvailableException)) {
                bl = super.restartWebServer(properties);
            }
            throw serverNotAvailableException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restartWebServer", String.valueOf(bl));
        }
        return bl;
    }

    public String getWebServerStatus() throws OperationFailedException, ServerNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWebServerStatus");
        }
        Properties properties = new Properties();
        properties.setProperty(SERVER_ID_KEY, this.getIdentifier());
        String string = null;
        try {
            string = super.getWebServerStatus(properties);
        }
        catch (ServerNotAvailableException serverNotAvailableException) {
            if (this.transmitIfNecessary(serverNotAvailableException)) {
                string = super.getWebServerStatus(properties);
            }
            throw serverNotAvailableException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWebServerStatus", string);
        }
        return string;
    }

    public void uploadFile(InputStream inputStream, String string) throws TransferFailedException, ServerNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uploadFile(is,S)", string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ISeriesIhsWebServerControl: src/dest: " + inputStream + " -- " + string);
        }
        Properties properties = new Properties();
        properties.setProperty(SERVER_ID_KEY, this.getIdentifier());
        try {
            super.uploadFile(inputStream, string, properties);
        }
        catch (TransferFailedException transferFailedException) {
            if (this.transmitIfNecessary(transferFailedException)) {
                super.uploadFile(inputStream, string, properties);
            }
            throw transferFailedException;
        }
        catch (ServerNotAvailableException serverNotAvailableException) {
            if (this.transmitIfNecessary(serverNotAvailableException)) {
                super.uploadFile(inputStream, string, properties);
            }
            throw serverNotAvailableException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uploadFile(is,S)");
        }
    }

    public void uploadFile(File file, String string) throws TransferFailedException, ServerNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uploadFile(File,S)", new Object[]{file.getAbsolutePath(), string});
        }
        Properties properties = new Properties();
        properties.setProperty(SERVER_ID_KEY, this.getIdentifier());
        try {
            super.uploadFile(file, string, properties);
        }
        catch (TransferFailedException transferFailedException) {
            if (this.transmitIfNecessary(transferFailedException)) {
                super.uploadFile(file, string, properties);
            }
            throw transferFailedException;
        }
        catch (ServerNotAvailableException serverNotAvailableException) {
            if (this.transmitIfNecessary(serverNotAvailableException)) {
                super.uploadFile(file, string, properties);
            }
            throw serverNotAvailableException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uploadFile(File,S)");
        }
    }

    public InputStream downloadFile(String string, long l, long l2) throws TransferFailedException, ServerNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "downloadFile(S,l,l)", new Object[]{string, String.valueOf(l), String.valueOf(l2)});
        }
        Properties properties = new Properties();
        properties.setProperty(SERVER_ID_KEY, this.getIdentifier());
        InputStream inputStream = null;
        try {
            inputStream = super.downloadFile(string, l, l2, properties);
        }
        catch (TransferFailedException transferFailedException) {
            if (this.transmitIfNecessary(transferFailedException)) {
                inputStream = super.downloadFile(string, l, l2, properties);
            }
            throw transferFailedException;
        }
        catch (ServerNotAvailableException serverNotAvailableException) {
            if (this.transmitIfNecessary(serverNotAvailableException)) {
                inputStream = super.downloadFile(string, l, l2, properties);
            }
            throw serverNotAvailableException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "downloadFile(S,l,l)");
        }
        return inputStream;
    }

    public void downloadFile(String string, File file, long l, long l2) throws TransferFailedException, ServerNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "downloadFile(S,File,l,l)", new Object[]{string, file.getAbsolutePath(), String.valueOf(l), String.valueOf(l2)});
        }
        Properties properties = new Properties();
        properties.setProperty(SERVER_ID_KEY, this.getIdentifier());
        try {
            super.downloadFile(string, file, l, l2, properties);
        }
        catch (TransferFailedException transferFailedException) {
            if (this.transmitIfNecessary(transferFailedException)) {
                super.downloadFile(string, file, l, l2, properties);
            }
            throw transferFailedException;
        }
        catch (ServerNotAvailableException serverNotAvailableException) {
            if (this.transmitIfNecessary(serverNotAvailableException)) {
                super.downloadFile(string, file, l, l2, properties);
            }
            throw serverNotAvailableException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "downloadFile(S,File,l,l)");
        }
    }

    public Long getLineCount(String string) throws TransferFailedException, ServerNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLineCount", string);
        }
        Long l = null;
        Properties properties = new Properties();
        properties.setProperty(SERVER_ID_KEY, this.getIdentifier());
        try {
            l = super.getLineCount(string, properties);
        }
        catch (TransferFailedException transferFailedException) {
            if (this.transmitIfNecessary(transferFailedException)) {
                l = super.getLineCount(string, properties);
            }
            throw transferFailedException;
        }
        catch (ServerNotAvailableException serverNotAvailableException) {
            if (this.transmitIfNecessary(serverNotAvailableException)) {
                l = super.getLineCount(string, properties);
            }
            throw serverNotAvailableException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLineCount", l);
        }
        return l;
    }

    private boolean transmitIfNecessary(Throwable throwable) throws ServerNotAvailableException {
        WsNestedException wsNestedException;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transmitIfNecessary", throwable.getClass().getName());
        }
        boolean bl = false;
        if (throwable instanceof ServerNotAvailableException) {
            ServerNotAvailableException serverNotAvailableException = (ServerNotAvailableException)throwable;
            if (serverNotAvailableException.getResponseCode() == 412) {
                this.sendCommandProcessor();
                bl = true;
            }
        } else if (throwable instanceof WsNestedException && (wsNestedException = (WsNestedException)((Object)throwable)) != null) {
            bl = this.transmitIfNecessary(wsNestedException.getCause());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transmitIfNecessary", String.valueOf(bl));
        }
        return bl;
    }

    private void sendCommandProcessor() throws ServerNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendCommandProcessor");
        }
        try {
            URL uRL = new URL(this.protocol, this.host, this.port, this.pluginUri);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestProperty(SERVER_ID_KEY, this.getIdentifier());
            httpURLConnection.setRequestProperty(COMMANDER_PROCESSOR_KEY, "true");
            this.addAuthHeader(httpURLConnection);
            this.connectToServer(httpURLConnection);
            DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("com/ibm/ws/os400/admin/CommandRequestHandlerImpl.class");
            byte[] byArray = new byte[this.defaultBufferSize];
            int n = inputStream.read(byArray);
            while (n != -1) {
                ((OutputStream)dataOutputStream).write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            inputStream.close();
            ((OutputStream)dataOutputStream).flush();
            ((OutputStream)dataOutputStream).close();
            int n2 = httpURLConnection.getResponseCode();
            if (n2 == 403 || n2 == 401) {
                throw new ServerNotAvailableException("Not Authorized to transmit command processor.  Response code: " + n2);
            }
            if (n2 != 200) {
                Tr.warning(tc, "Unexpected response received from server: ", String.valueOf(n2));
            }
        }
        catch (IOException iOException) {
            Tr.warning(tc, "Unexpected IOException while transmitting command processor: ", iOException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendCommandProcessor");
        }
    }

    private String getIdentifier() {
        String string = ServerName.getFullName();
        if (string == null) {
            ServerName.initialize(this.targetCell, this.targetNode, this.targetServer);
            string = ServerName.getFullName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getIdentifier", string);
        }
        return string;
    }
}

