/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.webserver;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.management.webserver.OperationFailedException;
import com.ibm.ws.management.webserver.ServerNotAvailableException;
import com.ibm.ws.management.webserver.TransferFailedException;
import com.ibm.ws.management.webserver.WebServerControl;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Iterator;
import javax.management.ObjectName;

public class ManagedWebServerControl
extends WebServerControl {
    private static TraceComponent tc = Tr.register(ManagedWebServerControl.class);
    private static AdminService adminService;
    String server = "";
    String node = "";

    public ManagedWebServerControl(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
        this.server = string4;
        this.node = string3;
    }

    public boolean startWebServer() throws OperationFailedException, ServerNotAvailableException {
        ObjectName objectName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ManagedIHS - Start for web server-> " + this.server + " on hostname " + this.getWebHost() + " on port:" + this.getWebPort());
        }
        if ((objectName = this.setObjectName("NodeAgent")) == null) {
            System.out.println("START request for web server " + this.server + " on managed node " + this.node + " ,can not be performed because MBean is not found on NodeAgent or NodeAgent is not running.");
            throw new ServerNotAvailableException("MBean not found");
        }
        try {
            Object object = adminService.invoke(objectName, "launchProcess", new Object[]{this.targetServer}, new String[]{"java.lang.String"});
            if (object != null) {
                Boolean bl = (Boolean)object;
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "START request for web server " + this.server + " on managed node " + this.node + " ,LaunchProcess returned " + object.toString());
                }
                return bl;
            }
            System.out.println("START request for web server " + this.server + " on managed node " + this.node + " ,can not be performed because LaunchProcess failed");
            return false;
        }
        catch (Exception exception) {
            System.out.println("START request for web server " + this.server + " on managed node " + this.node + " ,can not be performed because LaunchProcess failed");
            throw new OperationFailedException(exception.getMessage());
        }
    }

    public boolean stopWebServer() throws OperationFailedException, ServerNotAvailableException {
        ObjectName objectName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ManagedIHS- Stop for web server-> " + this.server + " on hostname " + this.getWebHost() + " on port:" + this.getWebPort());
        }
        if ((objectName = this.setObjectName("NodeAgent")) == null) {
            System.out.println("STOP request for web server " + this.server + " on managed node " + this.node + " ,can not be performed because MBean is not found on NodeAgent or NodeAgent is not running.");
            throw new ServerNotAvailableException("MBean not found");
        }
        try {
            Object object = adminService.invoke(objectName, "stopProcess", new Object[]{this.targetServer}, new String[]{"java.lang.String"});
            if (object != null) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "STOP request for web server " + this.server + " on managed node " + this.node + " ,LaunchProcess returned " + object.toString());
                }
                return true;
            }
            System.out.println("STOP request for web server " + this.server + " on managed node " + this.node + " ,can not be performed because LaunchProcess failed");
            return false;
        }
        catch (Exception exception) {
            System.out.println("STOP request for web server " + this.server + " on managed node " + this.node + " ,can not be performed because LaunchProcess failed");
            throw new OperationFailedException(exception.getMessage());
        }
    }

    public boolean restartWebServer() throws OperationFailedException, ServerNotAvailableException {
        return false;
    }

    public String getWebServerStatus() throws OperationFailedException, ServerNotAvailableException {
        String string = "STOPPED";
        return this.ping();
    }

    public void uploadFile(InputStream inputStream, String string) throws TransferFailedException {
    }

    public void uploadFile(File file, String string) throws ServerNotAvailableException, TransferFailedException {
        ObjectName objectName = this.setObjectName("FileTransferClient");
        if (objectName == null) {
            throw new ServerNotAvailableException("MBean not found");
        }
        try {
            File file2 = new File(string);
            String string2 = file.toString();
            adminService.invoke(objectName, "downloadFile", new Object[]{string2, file2}, new String[]{"java.lang.String", "java.io.File"});
        }
        catch (Exception exception) {
            throw new TransferFailedException(exception.getMessage());
        }
    }

    public InputStream downloadFile(String string, long l, long l2) throws TransferFailedException {
        try {
            File file = new File("c:\\tempfile");
            this.downloadFile(string, file, l, l2);
            return new FileInputStream(file);
        }
        catch (Exception exception) {
            throw new TransferFailedException("download failed");
        }
    }

    public void downloadFile(String string, File file, long l, long l2) throws ServerNotAvailableException, TransferFailedException {
        ObjectName objectName = this.setObjectName("FileTransferClient");
        if (objectName == null) {
            throw new ServerNotAvailableException("MBean not found");
        }
        try {
            File file2 = new File(string);
            String string2 = file.toString();
            if (l == 0L && l2 == 0L) {
                adminService.invoke(objectName, "uploadFile", new Object[]{file2, string2}, new String[]{"java.io.File", "java.lang.String"});
            } else {
                long[] lArray = new long[]{Math.min(l, l2), Math.max(l, l2)};
                long[] lArray2 = this.translateLineNumbersToOffsets(file2.toString(), lArray);
                if (lArray2 == null) {
                    throw new TransferFailedException("Failed to obtain offsets");
                }
                adminService.invoke(objectName, "uploadFile", new Object[]{file2, string2, new Long(lArray2[0]), new Long(lArray2[1])}, new String[]{"java.io.File", "java.lang.String", "long", "long"});
            }
        }
        catch (Exception exception) {
            throw new TransferFailedException("Upload failed " + exception.getMessage());
        }
    }

    public Long getLineCount(String string) throws TransferFailedException, ServerNotAvailableException {
        ObjectName objectName = this.setObjectName("FileBrowser");
        if (objectName == null) {
            throw new ServerNotAvailableException("MBean not found");
        }
        try {
            Object object = adminService.invoke(objectName, "getLineCount", new Object[]{string}, new String[]{"java.lang.String"});
            return (Long)object;
        }
        catch (Exception exception) {
            return new Long(-1L);
        }
    }

    public String ping() {
        String string;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ManagedIHS - Ping for web server-> " + this.server + " on hostname " + this.getWebHost() + " on port:" + this.getWebPort());
            }
            string = "STOPPED";
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.getWebHost(), this.getWebPort());
            if (inetSocketAddress.isUnresolved()) {
                System.out.println("socketAddress unresolved - return status UNAVAILABLE");
                System.out.println("Status for web server-> " + this.server + " on hostname " + this.getWebHost() + " on port:" + this.getWebPort() + " =UNAVAILABLE");
                return "UNAVAILABLE";
            }
            Socket socket = new Socket();
            try {
                socket.connect(inetSocketAddress, 5000);
                boolean bl = socket.isConnected();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isConnected returns: " + bl);
                }
                if (bl) {
                    string = "RUNNING";
                    InetAddress inetAddress = socket.getInetAddress();
                    if (tc.isDebugEnabled()) {
                        int n = socket.getPort();
                        boolean bl2 = socket.isBound();
                        Tr.debug(tc, "Socket Port  " + n);
                        Tr.debug(tc, "isBound   " + bl2);
                        Tr.debug(tc, "InetAddress   " + inetAddress);
                    }
                    if (inetAddress != null) {
                        if (!inetAddress.toString().contains(this.getWebHost())) {
                            System.out.println("WebHost is not found in Socket.getInetAddress, this may indicate that the Web server status should be set to STOPPED");
                            System.out.println("WebHost" + this.getWebHost());
                            System.out.println("InetAddress from socket " + inetAddress);
                        }
                    } else {
                        System.out.println("Socket.getInetAddr returned null, this may indicate that the Web server status should be set to STOPPED");
                    }
                }
                socket.close();
                if (!socket.isClosed() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Socket Still Open after a close " + bl);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Status for web server-> " + this.server + " on hostname " + this.getWebHost() + " on port:" + this.getWebPort() + " status: " + string);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, "Expected Exception - status is STOPPED - " + exception);
                Tr.debug(tc, "Status for web server-> " + this.server + " on hostname " + this.getWebHost() + " on port:" + this.getWebPort() + " status: " + string);
            }
        }
        return string;
    }

    private long[] translateLineNumbersToOffsets(String string, long[] lArray) throws TransferFailedException {
        block5: {
            string = string.replace('\\', '/');
            ObjectName objectName = this.setObjectName("FileBrowser");
            if (objectName == null) {
                throw new TransferFailedException("MBean not found");
            }
            try {
                Object object = adminService.invoke(objectName, "translateLineNumbersToOffsets", new Object[]{string, lArray}, new String[]{"java.lang.String", "[J"});
                if (object != null) {
                    return (long[])object;
                }
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Size returned was null");
                }
            }
            catch (Exception exception) {
                if (!tc.isEntryEnabled()) break block5;
                Tr.debug(tc, "Error while trying to find MBean!!! 1");
            }
        }
        return null;
    }

    protected ObjectName setObjectName(String string) {
        boolean bl = false;
        Object var3_3 = null;
        ObjectName objectName = null;
        try {
            String string2;
            ObjectName objectName2;
            Iterator iterator;
            adminService = AdminServiceFactory.getAdminService();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Retrieved from context: nodeName = " + this.targetNode);
            }
            if ((iterator = adminService.queryNames(objectName2 = new ObjectName(string2 = "WebSphere:cell=" + this.targetCell + ",type=" + string + ",name=" + string + ",node=" + this.targetNode + ",process=nodeagent,*"), null).iterator()).hasNext()) {
                objectName = (ObjectName)iterator.next();
                bl = true;
            }
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error while trying to find MBean!!!");
            }
            exception.printStackTrace();
        }
        if (bl) {
            return objectName;
        }
        return null;
    }
}

