/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.webserver;

import com.ibm.ISecurityUtilityImpl.InvalidPasswordDecodingException;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.jsse.IBMJSSEProvider;
import com.ibm.ws.management.webserver.OperationFailedException;
import com.ibm.ws.management.webserver.ResponseHandler;
import com.ibm.ws.management.webserver.ServerNotAvailableException;
import com.ibm.ws.management.webserver.TransferFailedException;
import com.ibm.ws.management.webserver.WebServerControl;
import com.ibm.ws.security.util.Base64Coder;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class RemoteIhsWebServerControl
extends WebServerControl {
    private static TraceComponent tc = Tr.register(RemoteIhsWebServerControl.class, "management", "com.ibm.ws.management.webserver");
    private static String UTF_ENCODING = "UTF-8";
    String host = "";
    String server = "";
    String node = "";
    String protocol = "";
    int port = 0;
    String userid = "";
    String password = "";
    String service = "";
    private String command = "";
    private String args = "";
    int defaultBufferSize = 8192;
    String pluginUri = "/wasadmin";

    public RemoteIhsWebServerControl() {
    }

    public RemoteIhsWebServerControl(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
        this.server = string4;
        this.node = string3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RemoteIHS Constructor pluginURL2 - " + this.pluginUri);
        }
    }

    public void setHost(String string) {
        this.host = string != null ? string : "";
    }

    public void setProtocol(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("HTTPS")) {
                this.setSecurityEnabled();
            }
            this.protocol = string;
        } else {
            this.protocol = "HTTP";
        }
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setUserid(String string) {
        this.userid = string != null ? string : "";
    }

    public void setPassword(String string) {
        this.password = string != null ? string : "";
    }

    public void setService(String string) {
        this.service = string != null ? string : "";
    }

    public String getHost() {
        return this.host;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getPort() {
        return this.port;
    }

    public String getPassword() {
        return this.password;
    }

    public String getService() {
        return this.service;
    }

    public String getUserid() {
        return this.userid;
    }

    public boolean startWebServer() throws OperationFailedException, ServerNotAvailableException {
        return this.startWebServer(null);
    }

    public boolean startWebServer(Properties properties) throws OperationFailedException, ServerNotAvailableException {
        ResponseHandler responseHandler = this.ihsOperation("start", properties);
        String string = responseHandler.getResponseID();
        if (string.equals("AC_START_OK") || string.equals("AC_START_RUNNING")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "START request was successful for web server-> " + this.server + " on unmanaged node " + this.node + " on host " + this.getWebHost() + " adminhost " + this.getHost() + " response= " + string);
            }
            return true;
        }
        System.out.println("START request for web server " + this.server + " on unmanaged node " + this.node + " and host " + this.getWebHost() + " adminhost " + this.getHost() + " failed with response= " + string + "." + " Check the IHS Administration Server error log");
        return false;
    }

    public boolean stopWebServer() throws OperationFailedException, ServerNotAvailableException {
        return this.stopWebServer(null);
    }

    public boolean stopWebServer(Properties properties) throws OperationFailedException, ServerNotAvailableException {
        ResponseHandler responseHandler = this.ihsOperation("stop", properties);
        String string = responseHandler.getResponseID();
        if (string.equals("AC_STOP_OK") || string.equals("AC_STOP_STOPPED")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "STOP request was successful for web server-> " + this.server + " on unmanaged node " + this.node + " on host " + this.getWebHost() + " adminhost " + this.getHost() + " response= " + string);
            }
            return true;
        }
        System.out.println("STOP request for web server " + this.server + " on unmanaged node " + this.node + " and host " + this.getWebHost() + " adminhost " + this.getHost() + " failed with response= " + string + "." + " Check the IHS Administration Server error log");
        return false;
    }

    public boolean restartWebServer() throws OperationFailedException, ServerNotAvailableException {
        return this.restartWebServer(null);
    }

    public boolean restartWebServer(Properties properties) throws OperationFailedException, ServerNotAvailableException {
        ResponseHandler responseHandler = this.ihsOperation("restart", properties);
        String string = responseHandler.getResponseID();
        return string.equals("AC_RESTART_OK") || string.equals("AC_START_RUNNING");
    }

    public String getWebServerStatus() throws OperationFailedException, ServerNotAvailableException {
        return this.getWebServerStatus(null);
    }

    public String getWebServerStatus(Properties properties) throws OperationFailedException, ServerNotAvailableException {
        ResponseHandler responseHandler;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RemoteIHS getWebServerStatus - This is DEAD code - adminhost " + this.getHost() + " adminport " + this.getPort());
        }
        if ((string = (responseHandler = this.ihsOperation("status", properties)).getResponseID()).equals("AC_START_RUNNING")) {
            return "RUNNING";
        }
        return "STOPPED";
    }

    public void uploadFile(File file, String string) throws TransferFailedException, ServerNotAvailableException {
        this.uploadFile(file, string, null);
    }

    public void uploadFile(File file, String string, Properties properties) throws TransferFailedException, ServerNotAvailableException {
        String string2 = this.repositoryRoot + File.separatorChar + file.toString();
        try {
            FileInputStream fileInputStream = new FileInputStream(string2);
            this.uploadFile(fileInputStream, string, properties);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Upload request for web server " + this.server + " on unmanaged node " + this.node + " and host " + this.getWebHost() + " adminhost " + this.getHost() + " failed. File = " + file + " not found");
            throw new TransferFailedException("File not found.");
        }
    }

    public void uploadFile(InputStream inputStream, String string) throws TransferFailedException, ServerNotAvailableException {
        this.uploadFile(inputStream, string, null);
    }

    public void uploadFile(InputStream inputStream, String string, Properties properties) throws TransferFailedException, ServerNotAvailableException {
        URL uRL = null;
        HttpURLConnection httpURLConnection = null;
        int n = 0;
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(this.pluginUri);
        try {
            Object object;
            Object object2;
            uRL = new URL(this.protocol, this.getHost(), this.getPort(), stringBuffer.toString());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "uploadFile from adminhost " + this.getHost() + " adminport " + this.getPort());
                Tr.debug(tc, "uploadFile URL - " + uRL);
            }
            if (this.getClass().getName().equals("com.ibm.ws.management.webserver.ISeriesIhsWebServerControl")) {
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setRequestProperty("SAILCmd", "IsHandlerClassLoaded");
                httpURLConnection.setRequestProperty("sailArgs", string);
                httpURLConnection.setRequestProperty("Alias", this.service);
                httpURLConnection.setRequestProperty("InstallRoot", this.installRoot);
                httpURLConnection.setRequestProperty("cfgfile", this.configFile);
                if (properties != null) {
                    object2 = properties.propertyNames();
                    while (object2.hasMoreElements()) {
                        object = (String)object2.nextElement();
                        httpURLConnection.setRequestProperty((String)object, properties.getProperty((String)object));
                    }
                }
                this.addAuthHeader(httpURLConnection);
                this.connectToServer(httpURLConnection);
                n = httpURLConnection.getResponseCode();
                if (n == 403 || n == 401) {
                    System.out.println("Unauthorized: Write request for file destination " + string + " failed for web server " + this.server + " on node " + this.node + " for host " + this.getWebHost() + " through adminhost " + this.getHost());
                    throw new ServerNotAvailableException(this.command + " Unauthorized");
                }
                if (n == 412) {
                    bl = false;
                    throw new ServerNotAvailableException(this.command + " Non 200 response receive response code " + n, n);
                }
            }
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestProperty("SAILCmd", "WriteFile");
            httpURLConnection.setRequestProperty("sailArgs", string);
            httpURLConnection.setRequestProperty("Alias", this.service);
            httpURLConnection.setRequestProperty("InstallRoot", this.installRoot);
            httpURLConnection.setRequestProperty("cfgfile", this.configFile);
            if (properties != null) {
                object2 = properties.propertyNames();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    httpURLConnection.setRequestProperty((String)object, properties.getProperty((String)object));
                }
            }
            this.addAuthHeader(httpURLConnection);
            this.connectToServer(httpURLConnection);
            object2 = new DataOutputStream(httpURLConnection.getOutputStream());
            object = new byte[this.defaultBufferSize];
            int n2 = inputStream.read((byte[])object);
            while (n2 != -1) {
                ((OutputStream)object2).write((byte[])object, 0, n2);
                n2 = inputStream.read((byte[])object);
            }
            ((OutputStream)object2).flush();
            ((OutputStream)object2).close();
            n = httpURLConnection.getResponseCode();
            if (n == 403 || n == 401) {
                System.out.println("Write request for file destination " + string + " failed for web server " + this.server + " on node " + this.node + " for host " + this.getWebHost() + " through adminhost " + this.getHost());
                throw new ServerNotAvailableException(this.command + " Unauthorized");
            }
            if (n != 200) {
                System.out.println("Write request for file destination " + string + " failed for web server " + this.server + " on node " + this.node + " for host " + this.getWebHost() + " through adminhost " + this.getHost());
                throw new ServerNotAvailableException(this.command + " Non 200 response receive response code " + n, n);
            }
            InputStream inputStream2 = httpURLConnection.getInputStream();
            ResponseHandler responseHandler = new ResponseHandler(inputStream2);
            responseHandler.parse();
            if (!responseHandler.getResponseID().equals("AC_OK")) {
                System.out.println("Write request for file destination " + string + " failed for web server " + this.server + " on node " + this.node + " for host " + this.getWebHost() + " through adminhost " + this.getHost());
                throw new TransferFailedException("Error occurred during upload - message " + responseHandler.getResponseMsg());
            }
        }
        catch (TransferFailedException transferFailedException) {
            throw transferFailedException;
        }
        catch (IOException iOException) {
            throw new ServerNotAvailableException(this.command + " No Connection", 503);
        }
        catch (Throwable throwable) {
            throw new TransferFailedException("Error occurred during upload.", throwable);
        }
        finally {
            try {
                if (this.getClass().getName().equals("com.ibm.ws.management.webserver.ISeriesIhsWebServerControl")) {
                    if (bl) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "uploadFile, os400 remote node, closing the uploaded file Input Stream.");
                        }
                        inputStream.close();
                    }
                } else {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uploadFile ");
        }
    }

    public InputStream downloadFile(String string, long l, long l2) throws TransferFailedException, ServerNotAvailableException {
        return this.downloadFile(string, l, l2, null);
    }

    public InputStream downloadFile(String string, long l, long l2, Properties properties) throws TransferFailedException, ServerNotAvailableException {
        Object object;
        HttpURLConnection httpURLConnection;
        int n;
        block13: {
            Object object2;
            URL uRL = null;
            n = 0;
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append(this.pluginUri);
            uRL = new URL(this.protocol, this.getHost(), this.getPort(), stringBuffer.toString());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "downloadFile from adminhost " + this.getHost() + " adminport " + this.getPort());
                Tr.debug(tc, "DownloadFile URL - " + uRL);
            }
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setDoOutput(false);
            httpURLConnection.setRequestProperty("SAILCmd", "ReadFile");
            StringBuffer stringBuffer2 = new StringBuffer(2048);
            stringBuffer2.append("src=");
            stringBuffer2.append(string);
            stringBuffer2.append("&linestart=" + l + "&lineend=" + l2);
            httpURLConnection.setRequestProperty("sailArgs", stringBuffer2.toString());
            httpURLConnection.setRequestProperty("Alias", this.service);
            httpURLConnection.setRequestProperty("InstallRoot", this.installRoot);
            httpURLConnection.setRequestProperty("cfgfile", this.configFile);
            if (properties != null) {
                object2 = properties.propertyNames();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    httpURLConnection.setRequestProperty((String)object, properties.getProperty((String)object));
                }
            }
            this.addAuthHeader(httpURLConnection);
            this.connectToServer(httpURLConnection);
            n = httpURLConnection.getResponseCode();
            if (n == 403 || n == 401) {
                System.out.println("Read request for file " + string + " failed for web server " + this.server + " on node " + this.node + " for host " + this.getWebHost() + " through adminhost " + this.getHost());
                throw new ServerNotAvailableException(this.command + " Unauthorized");
            }
            if (n == 204) {
                System.out.println("Read request for file " + string + " failed for web server " + this.server + " on node " + this.node + " for host " + this.getWebHost() + " through adminhost " + this.getHost());
                throw new TransferFailedException("Transfer failed");
            }
            if (n != 200) {
                System.out.println("Read request for file " + string + " failed for web server " + this.server + " on node " + this.node + " for host " + this.getWebHost() + " through adminhost " + this.getHost());
                throw new ServerNotAvailableException(this.command + " Non 200 response receive response code " + n, n);
            }
            object2 = httpURLConnection.getInputStream();
            if (object2 == null) break block13;
            object = object2 = new DataInputStream((InputStream)object2);
            return object;
        }
        try {
            n = httpURLConnection.getResponseCode();
            object = httpURLConnection.getResponseMessage();
            throw new TransferFailedException("File download failed [" + n + "]." + "Message: " + (String)object);
        }
        catch (TransferFailedException transferFailedException) {
            throw transferFailedException;
        }
        catch (IOException iOException) {
            throw new ServerNotAvailableException(this.command + " No Connection", 503);
        }
        catch (Throwable throwable) {
            throw new TransferFailedException("Exception occurred during " + this.command + " " + throwable.getMessage(), throwable);
        }
    }

    public void downloadFile(String string, File file, long l, long l2) throws TransferFailedException, ServerNotAvailableException {
        this.downloadFile(string, file, l, l2, null);
    }

    public void downloadFile(String string, File file, long l, long l2, Properties properties) throws TransferFailedException, ServerNotAvailableException {
        String string2 = file.toString();
        if (string2 != null) {
            string2 = string2.replace('/', File.separatorChar);
            string2 = string2.replace('\\', File.separatorChar);
        }
        int n = 0;
        try {
            File file2;
            InputStream inputStream = this.downloadFile(string, l, l2, properties);
            String string3 = this.repositoryRoot + File.separatorChar + string2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DownloadFile - fileName " + string3);
            }
            if (!(file2 = new File(string3)).getParentFile().exists()) {
                file2.getParentFile().mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file2.getAbsolutePath());
            byte[] byArray = new byte[this.defaultBufferSize];
            int n2 = inputStream.read(byArray);
            while (n2 != -1) {
                n += n2;
                fileOutputStream.write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
            }
            inputStream.close();
            fileOutputStream.flush();
            fileOutputStream.close();
            inputStream = null;
            fileOutputStream = null;
        }
        catch (IOException iOException) {
            throw new TransferFailedException("Download failed " + iOException.getMessage(), iOException);
        }
        catch (Exception exception) {
            throw new TransferFailedException("Download failed  " + exception.getMessage(), exception);
        }
    }

    private ResponseHandler ihsOperation(String string, Properties properties) throws OperationFailedException, ServerNotAvailableException {
        URL uRL = null;
        int n = 0;
        boolean bl = false;
        try {
            Object object;
            Object object2;
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append(this.pluginUri);
            uRL = new URL(this.protocol, this.getHost(), this.getPort(), stringBuffer.toString());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RemoteIHS ihsOperation - " + string + " to adminhost " + this.getHost() + " adminport " + this.getPort());
                Tr.debug(tc, "RemoteIHS LineCount - URL " + uRL);
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setDoOutput(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("SAILCmd", "ServerControl");
            httpURLConnection.setRequestProperty("sailArgs", string);
            httpURLConnection.setRequestProperty("Alias", this.service);
            httpURLConnection.setRequestProperty("InstallRoot", this.installRoot);
            httpURLConnection.setRequestProperty("cfgfile", this.configFile);
            if (properties != null) {
                object2 = properties.propertyNames();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    httpURLConnection.setRequestProperty((String)object, properties.getProperty((String)object));
                }
            }
            this.addAuthHeader(httpURLConnection);
            this.connectToServer(httpURLConnection);
            n = httpURLConnection.getResponseCode();
            if (n == 403 || n == 401) {
                System.out.println("Request-> " + string + " failed for web server " + this.server + " on node " + this.node + " for host " + this.getWebHost() + " through adminhost " + this.getHost());
                System.out.println("Response Code " + n);
                throw new ServerNotAvailableException(string + " Unauthorized-", n);
            }
            if (n != 200) {
                System.out.println("Request-> " + string + " failed for web server " + this.server + " on node " + this.node + " for host " + this.getWebHost() + " through adminhost " + this.getHost());
                System.out.println("Response Code " + n);
                throw new ServerNotAvailableException(string + " Non 200 response receive response code " + n, n);
            }
            object2 = httpURLConnection.getInputStream();
            object = new ResponseHandler((InputStream)object2);
            try {
                ((ResponseHandler)object).parse();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                System.out.println("Request-> " + string + " failed for web server " + this.server + " on node " + this.node + " for host " + this.getWebHost() + " through adminhost " + this.getHost());
                throw new OperationFailedException("Exception occurred during " + string + "" + ((ResponseHandler)object).getResponseMsg());
            }
            catch (SAXException sAXException) {
                System.out.println("Request-> " + string + " failed for web server " + this.server + " on node " + this.node + " for host " + this.getWebHost() + " through adminhost " + this.getHost());
                throw new OperationFailedException("Exception occurred during " + string + "" + ((ResponseHandler)object).getResponseMsg());
            }
            catch (IOException iOException) {
                System.out.println("Request-> " + string + " failed for web server " + this.server + " on node " + this.node + " for host " + this.getWebHost() + " through adminhost " + this.getHost());
                throw new OperationFailedException("Exception occurred during " + string + "" + ((ResponseHandler)object).getResponseMsg());
            }
            Object object3 = object;
            return object3;
        }
        catch (IOException iOException) {
            System.out.println("Request-> " + string + " failed for web server " + this.server + " on node " + this.node + " for host " + this.getWebHost() + " through adminhost " + this.getHost());
            throw new ServerNotAvailableException(string + " No Connection", 503);
        }
    }

    public Long getLineCount(String string) throws TransferFailedException, ServerNotAvailableException {
        return this.getLineCount(string, null);
    }

    public Long getLineCount(String string, Properties properties) throws TransferFailedException, ServerNotAvailableException {
        Object object;
        block17: {
            Object object2;
            URL uRL = null;
            int n = 0;
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append(this.pluginUri);
            uRL = new URL(this.protocol, this.getHost(), this.getPort(), stringBuffer.toString());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RemoteIHS LineCount - from adminhost " + this.getHost() + " adminport " + this.getPort());
                Tr.debug(tc, "RemoteIHS LineCount - URL " + uRL);
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setDoOutput(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("SAILCmd", "NumberOfLines");
            httpURLConnection.setRequestProperty("sailArgs", string);
            httpURLConnection.setRequestProperty("Alias", this.service);
            httpURLConnection.setRequestProperty("InstallRoot", this.installRoot);
            httpURLConnection.setRequestProperty("cfgfile", this.configFile);
            if (properties != null) {
                object2 = properties.propertyNames();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    httpURLConnection.setRequestProperty((String)object, properties.getProperty((String)object));
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Config File " + this.configFile);
            }
            this.addAuthHeader(httpURLConnection);
            this.connectToServer(httpURLConnection);
            n = httpURLConnection.getResponseCode();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Administration Server Response Code  " + n);
            }
            if (n == 403 || n == 401) {
                System.out.println("Line count request for file " + string + " failed for web server " + this.server + " on node " + this.node + " for host " + this.getWebHost() + " through adminhost " + this.getHost());
                throw new ServerNotAvailableException(this.command + " Unauthorized-", n);
            }
            if (n != 200) {
                System.out.println("Line count request for file " + string + " failed for web server " + this.server + " on node " + this.node + " for host " + this.getWebHost() + " through adminhost " + this.getHost());
                throw new ServerNotAvailableException(this.command + " Non 200 response receive response code " + n, n);
            }
            object2 = httpURLConnection.getInputStream();
            object = new ResponseHandler((InputStream)object2);
            try {
                ((ResponseHandler)object).parse();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new TransferFailedException("Download failed  " + ((ResponseHandler)object).getResponseMsg());
            }
            catch (SAXException sAXException) {
                throw new TransferFailedException("Download failed  " + ((ResponseHandler)object).getResponseMsg());
            }
            catch (IOException iOException) {
                throw new TransferFailedException("Download failed  " + ((ResponseHandler)object).getResponseMsg());
            }
            if (!((ResponseHandler)object).getResponseID().equals("AC_OPENFILE")) break block17;
            Long l = new Long(-1L);
            return l;
        }
        try {
            if (!((ResponseHandler)object).getResponseID().equals("AC_OK")) {
                throw new TransferFailedException("Download failed  " + ((ResponseHandler)object).getResponseMsg());
            }
            Long l = new Long(((ResponseHandler)object).getResponseMsg());
            return l;
        }
        catch (IOException iOException) {
            System.out.println("IOException " + iOException);
            throw new ServerNotAvailableException(this.command + " No Connection", 503);
        }
    }

    public String ping() {
        String string;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "RemoteIHS - Ping for web server-> " + this.server + " on hostname " + this.getWebHost() + " on port:" + this.getWebPort());
            }
            string = "STOPPED";
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.getWebHost(), this.getWebPort());
            if (inetSocketAddress.isUnresolved()) {
                System.out.println("socketAddress unresolved - return status UNAVAILABLE");
                System.out.println("Status for web server-> " + this.server + " on hostname " + this.getWebHost() + " on port:" + this.getWebPort() + " =UNAVAILABLE");
                return "UNAVAILABLE";
            }
            Socket socket = new Socket();
            try {
                socket.connect(inetSocketAddress, 5000);
                boolean bl = socket.isConnected();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isConnected returns: " + bl);
                }
                if (bl) {
                    string = "RUNNING";
                    InetAddress inetAddress = socket.getInetAddress();
                    if (tc.isDebugEnabled()) {
                        int n = socket.getPort();
                        boolean bl2 = socket.isBound();
                        Tr.debug(tc, "Socket Port  " + n);
                        Tr.debug(tc, "isBound   " + bl2);
                        Tr.debug(tc, "InetAddress   " + inetAddress);
                    }
                    if (inetAddress != null) {
                        if (!inetAddress.toString().contains(this.getWebHost())) {
                            System.out.println("WebHost is not found in Socket.getInetAddress, this may indicate that the Web server status should be set to STOPPED");
                            System.out.println("WebHost" + this.getWebHost());
                            System.out.println("InetAddress from socket " + inetAddress);
                        }
                    } else {
                        System.out.println("Socket.getInetAddr returned null, this may indicate that the Web server status should be set to STOPPED");
                    }
                }
                socket.close();
                if (!socket.isClosed() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Socket Still Open after a close " + bl);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Status for web server-> " + this.server + " on hostname " + this.getWebHost() + " on port:" + this.getWebPort() + " status: " + string);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, "Expected Exception - status is STOPPED - " + exception);
                Tr.debug(tc, "Status for web server-> " + this.server + " on hostname " + this.getWebHost() + " on port:" + this.getWebPort() + " status: " + string);
            }
        }
        return string;
    }

    protected void connectToServer(HttpURLConnection httpURLConnection) throws IOException {
        httpURLConnection.connect();
        if (!this.protocol.equals("https")) {
            // empty if block
        }
    }

    protected void addAuthHeader(HttpURLConnection httpURLConnection) {
        String string = Base64Coder.base64Encode(this.userid + ":" + this.password);
        httpURLConnection.setRequestProperty("Authorization", "Basic " + string);
    }

    public void setSecurityEnabled() {
        try {
            String string;
            String string2;
            String string3;
            Object object;
            if (Security.getProvider("com.ibm.jsse.IBMJSSEProvider") == null) {
                Security.addProvider((Provider)new IBMJSSEProvider());
            }
            Properties properties = System.getProperties();
            String string4 = System.getProperty("java.protocol.handler.pkgs");
            if (string4 == null) {
                properties.put("java.protocol.handler.pkgs", "com.ibm.net.ssl.internal.www.protocol");
            } else if (string4.indexOf("com.ibm.net.ssl.internal.www.protocol") == -1) {
                properties.put("java.protocol.handler.pkgs", "com.ibm.net.ssl.internal.www.protocol|".concat(string4));
            }
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = System.getProperty("com.ibm.CORBA.ConfigURL");
            InputStream inputStream = null;
            try {
                if (string9 != null) {
                    object = new URL(string9);
                    inputStream = ((URL)object).openStream();
                } else {
                    object = Thread.currentThread().getContextClassLoader().getResourceAsStream("sas.client.props");
                    inputStream = new DataInputStream((InputStream)object);
                }
                if (inputStream != null) {
                    object = new Properties();
                    ((Properties)object).load(inputStream);
                    string5 = ((Properties)object).getProperty("com.ibm.ssl.keyStore");
                    string6 = ((Properties)object).getProperty("com.ibm.ssl.keyStorePassword");
                    string7 = ((Properties)object).getProperty("com.ibm.ssl.trustStore");
                    string8 = ((Properties)object).getProperty("com.ibm.ssl.trustStorePassword");
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            object = System.getProperty("javax.net.ssl.keyStore");
            if (object == null) {
                properties.put("javax.net.ssl.keyStore", string5);
            }
            if ((string3 = System.getProperty("javax.net.ssl.keyStorePassword")) == null) {
                string3 = this.decriptPassword(string6);
                properties.put("javax.net.ssl.keyStorePassword", string3);
            }
            if ((string2 = System.getProperty("javax.net.ssl.trustStore")) == null) {
                properties.put("javax.net.ssl.trustStore", string7);
            }
            if ((string = System.getProperty("javax.net.ssl.trustStorePassword")) == null) {
                string = this.decriptPassword(string8);
                properties.put("javax.net.ssl.trustStorePassword", string);
            }
            System.setProperties(properties);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String decriptPassword(String string) {
        String string2 = null;
        try {
            string2 = PasswordUtil.decode(string);
        }
        catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
            string2 = string;
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }
}

