/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.webserver;

import com.ibm.ws.management.webserver.OperationFailedException;
import com.ibm.ws.management.webserver.ServerNotAvailableException;
import com.ibm.ws.management.webserver.TransferFailedException;
import java.io.File;
import java.io.InputStream;

public abstract class WebServerControl {
    String targetCell = "";
    String targetNode = "";
    String targetServer = "";
    String targetRootURI = "";
    String logFile = "";
    String configFile = "";
    String installRoot = "";
    String serverType = "";
    String repositoryRoot = "";
    String webHost = "";
    String webProtocol = "HTTP";
    int webPort = 0;

    public WebServerControl() {
    }

    public WebServerControl(String string, String string2, String string3, String string4) {
        this.targetCell = string2;
        this.targetNode = string3;
        this.targetServer = string4;
        this.targetRootURI = string;
    }

    public void setRepositoryRoot(String string) {
        this.repositoryRoot = string;
    }

    public void setLogFile(String string) {
        this.logFile = string != null ? string : "";
    }

    public void setConfigFile(String string) {
        this.configFile = string != null ? string : "";
    }

    public void setInstallRoot(String string) {
        this.installRoot = string != null ? string : "";
    }

    public void setServerType(String string) {
        this.serverType = string != null ? string : "";
    }

    public void setWebHost(String string) {
        this.webHost = string != null ? string : "";
    }

    public void setWebProtocol(String string) {
        if (string != null) {
            this.webProtocol = string;
        }
    }

    public void setWebPort(int n) {
        this.webPort = n < 0 ? 0 : n;
    }

    public int getWebPort() {
        return this.webPort;
    }

    public String getWebProtocol() {
        return this.webProtocol;
    }

    public String getWebHost() {
        return this.webHost;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getInstallRoot() {
        return this.installRoot;
    }

    public String getServerType() {
        return this.serverType;
    }

    public String getRepositoryRoot() {
        return this.repositoryRoot;
    }

    public abstract boolean startWebServer() throws OperationFailedException, ServerNotAvailableException;

    public abstract boolean stopWebServer() throws OperationFailedException, ServerNotAvailableException;

    public abstract boolean restartWebServer() throws OperationFailedException, ServerNotAvailableException;

    public abstract String getWebServerStatus() throws OperationFailedException, ServerNotAvailableException;

    public abstract void uploadFile(InputStream var1, String var2) throws TransferFailedException, ServerNotAvailableException;

    public abstract void uploadFile(File var1, String var2) throws TransferFailedException, ServerNotAvailableException;

    public abstract InputStream downloadFile(String var1, long var2, long var4) throws TransferFailedException, ServerNotAvailableException;

    public abstract void downloadFile(String var1, File var2, long var3, long var5) throws TransferFailedException, ServerNotAvailableException;

    public abstract Long getLineCount(String var1) throws TransferFailedException, ServerNotAvailableException;

    public abstract String ping();
}

