/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.webserver;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.websphere.models.config.webserver.WebServer;
import com.ibm.websphere.models.config.webserver.WebserverTypeKind;
import com.ibm.ws.management.repository.ConfigStructureHelper;
import com.ibm.ws.management.webserver.ConfigurationException;
import com.ibm.ws.management.webserver.ISeriesIhsWebServerControl;
import com.ibm.ws.management.webserver.ManagedWebServerControl;
import com.ibm.ws.management.webserver.RemoteIhsWebServerControl;
import com.ibm.ws.management.webserver.WebServerControl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import java.io.File;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class WebServerControlFactory {
    protected static TraceComponent tc = Tr.register(WebServerControlFactory.class);
    static String repositoryRoot;
    static NamedEndPoint webNamedEndPoint;
    static NamedEndPoint adminNamedEndPoint;

    public static WebServerControl getWebServerInstance(String string, String string2, String string3, String string4) throws ConfigurationException {
        return WebServerControlFactory.getWebServerInstance(string, string2, string3, string4, null);
    }

    public static WebServerControl getWebServerInstance(String string, String string2, String string3, String string4, String string5) throws ConfigurationException {
        boolean bl = false;
        try {
            if (!WebServerControlFactory.serverExists(string2, string3, string4)) {
                throw new ConfigurationException("Server not found");
            }
        }
        catch (Exception exception) {
            throw new ConfigurationException("Server not found --- " + exception.getMessage());
        }
        Repository repository2 = RepositoryFactory.createRepository("ws-server", string, string2, string3, string4);
        ConfigRoot configRoot = repository2.getConfigRoot();
        Resource resource = null;
        Resource resource2 = null;
        String string6 = "";
        String string7 = configRoot.setValue(4, string4);
        try {
            String string8;
            ServerEntry serverEntry;
            String string9;
            resource = configRoot.getResource(4, "server.xml");
            resource2 = configRoot.getResource(4, "variables.xml");
            string6 = WebServerControlFactory.getVariable(resource2, "WEB_INSTALL_ROOT");
            Server server2 = WebServerControlFactory.getServer(resource);
            if (server2 == null) {
                throw new ConfigurationException("Server not defined");
            }
            WebServer webServer = WebServerControlFactory.getWebServer(server2);
            if (webServer == null) {
                System.out.println("WebServerControlFactory throw ConfigException  Web server not defined");
                throw new ConfigurationException("WebServer not defined");
            }
            WebserverTypeKind webserverTypeKind = webServer.getWebserverType();
            String string10 = "";
            if (webserverTypeKind != null) {
                string10 = webserverTypeKind.toString();
            }
            boolean bl2 = (string9 = WebServerControlFactory.getNodeOS(repositoryRoot, string2, string3)) != null && string9.equals("os400");
            WebServerControl webServerControl = null;
            webServerControl = bl2 ? new ISeriesIhsWebServerControl(string, string2, string3, string4) : (string5 != null ? (string5.equals("MANAGED") ? new ManagedWebServerControl(string, string2, string3, string4) : new RemoteIhsWebServerControl(string, string2, string3, string4)) : (WebServerControlFactory.isNodeManaged(string, string2, string3) ? new ManagedWebServerControl(string, string2, string3, string4) : new RemoteIhsWebServerControl(string, string2, string3, string4)));
            if (webserverTypeKind != null) {
                webServerControl.setServerType(webserverTypeKind.toString());
            }
            if (string10.equals("IHS")) {
                webServerControl.setRepositoryRoot(repositoryRoot);
                webServerControl.setInstallRoot(webServer.getWebserverInstallRoot());
                if (webServer.getConfigurationFilename() != null) {
                    if (webServer.getConfigurationFilename().startsWith("${WEB_INSTALL_ROOT}")) {
                        webServerControl.setConfigFile(webServer.getConfigurationFilename().replaceAll("\\$\\{WEB_INSTALL_ROOT\\}", string6));
                    } else {
                        webServerControl.setConfigFile(webServer.getConfigurationFilename());
                    }
                } else {
                    webServerControl.setConfigFile(webServer.getConfigurationFilename());
                }
                if (webServer.getLogFilenameAccess() != null) {
                    if (webServer.getLogFilenameAccess().startsWith("${WEB_INSTALL_ROOT}")) {
                        webServerControl.setLogFile(webServer.getLogFilenameAccess().replaceAll("\\$\\{WEB_INSTALL_ROOT\\}", string6));
                    } else {
                        webServerControl.setLogFile(webServer.getLogFilenameAccess());
                    }
                } else {
                    webServerControl.setLogFile(webServer.getLogFilenameAccess());
                }
            }
            ConfigRoot configRoot2 = repository2.getConfigRoot();
            String string11 = configRoot2.setValue(3, string3);
            resource = configRoot2.getResource(3, "serverindex.xml");
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            for (int i = 0; i < eList.size(); ++i) {
                String string12;
                serverEntry = (ServerEntry)eList.get(i);
                string8 = serverEntry.getServerType();
                if (!string8.equals("WEB_SERVER") || !(string12 = serverEntry.getServerName()).equals(string4)) continue;
                EList eList2 = serverEntry.getSpecialEndpoints();
                for (int j = 0; j < eList2.size(); ++j) {
                    NamedEndPoint namedEndPoint = (NamedEndPoint)eList2.get(j);
                    if (namedEndPoint.getEndPointName().equals("WEBSERVER_ADDRESS")) {
                        webNamedEndPoint = namedEndPoint;
                        webServerControl.setWebHost(webNamedEndPoint.getEndPoint().getHost());
                        webServerControl.setWebPort(webNamedEndPoint.getEndPoint().getPort());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "setWebHost from WEBSERVER_ADDRESS endpoint " + webServerControl.getWebHost());
                            Tr.debug(tc, "setWebPort from WEBSERVER_ADDRESS endpoint " + webServerControl.getWebPort());
                        }
                    }
                    if (!namedEndPoint.getEndPointName().equals("WEBSERVER_ADMIN_ADDRESS")) continue;
                    adminNamedEndPoint = namedEndPoint;
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "set adminNamedEndpoint");
                }
                if (webServerControl.getWebHost() != null && !webServerControl.getWebHost().equals("")) continue;
                System.out.println("WebHost is null or blank for server " + string12);
            }
            if (string10.equals("IHS") && webServerControl instanceof RemoteIhsWebServerControl) {
                RemoteIhsWebServerControl remoteIhsWebServerControl = (RemoteIhsWebServerControl)webServerControl;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ServerControl instance is RemoteIHSWebServerControl");
                }
                remoteIhsWebServerControl.setService(webServer.getServiceName());
                serverEntry = webServer.getWebserverAdminProtocol();
                if (serverEntry != null) {
                    remoteIhsWebServerControl.setProtocol(serverEntry.toString());
                }
                if ((serverEntry = webServer.getWebserverProtocol()) != null) {
                    remoteIhsWebServerControl.setWebProtocol(serverEntry.toString());
                }
                if ((string8 = webServer.getAdminServerAuthentication()) != null) {
                    remoteIhsWebServerControl.setUserid(string8.getUserid());
                    remoteIhsWebServerControl.setPassword(string8.getPassword());
                }
                if (adminNamedEndPoint.getEndPointName().equals("WEBSERVER_ADMIN_ADDRESS")) {
                    remoteIhsWebServerControl.setHost(adminNamedEndPoint.getEndPoint().getHost());
                    remoteIhsWebServerControl.setPort(adminNamedEndPoint.getEndPoint().getPort());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setHost from WEBSERVER_ADMIN_ADDRESS endpoint " + remoteIhsWebServerControl.getHost());
                        Tr.debug(tc, "setPort from WEBSERVER_ADMIN_ADDRESS endpoint " + remoteIhsWebServerControl.getPort());
                    }
                }
            }
            return webServerControl;
        }
        catch (Exception exception) {
            throw new ConfigurationException("Error creating management class " + exception.getStackTrace());
        }
    }

    private static boolean serverExists(String string, String string2, String string3) throws AdminException {
        String string4;
        ConfigRepository configRepository = WebServerControlFactory.getLocalRepository();
        String[] stringArray = configRepository.listResourceNames(string4 = ConfigStructureHelper.getURI(string, string2, string3, "server.xml"), 1, 0);
        return stringArray.length != 0;
    }

    private static synchronized ConfigRepository getLocalRepository() throws AdminException {
        ConfigRepository configRepository;
        Properties properties = new Properties();
        properties.setProperty("location", "local");
        try {
            configRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient(properties);
            Properties properties2 = configRepository.getConfig();
            repositoryRoot = properties2.getProperty("was.repository.temp");
            repositoryRoot = repositoryRoot.replace('/', File.separatorChar);
            repositoryRoot = repositoryRoot.replace('\\', File.separatorChar);
            if (repositoryRoot.endsWith(File.separator)) {
                repositoryRoot = repositoryRoot.substring(0, repositoryRoot.length() - 1);
            }
        }
        catch (Exception exception) {
            throw new AdminException(exception, "Unable to create repository client: " + exception);
        }
        return configRepository;
    }

    protected static Server getServer(Resource resource) throws Exception {
        Server server2 = null;
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            Object e2 = eList.get(i);
            if (!(e2 instanceof Server)) continue;
            server2 = (Server)e2;
        }
        return server2;
    }

    protected static WebServer getWebServer(Server server2) throws Exception {
        WebServer webServer = null;
        EList eList = server2.getComponents();
        for (int i = 0; i < eList.size(); ++i) {
            Object e2 = eList.get(i);
            if (!(e2 instanceof WebServer)) continue;
            webServer = (WebServer)e2;
        }
        return webServer;
    }

    private static boolean isNodeManaged(String string, String string2, String string3) {
        boolean bl = false;
        ServerIndex serverIndex = WebServerControlFactory.getServerIndexForGivenNode(string, string2, string3);
        if (serverIndex == null) {
            return false;
        }
        EList eList = serverIndex.getServerEntries();
        for (int i = 0; i < eList.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            if (!serverEntry.getServerType().equalsIgnoreCase("NODE_AGENT") && !serverEntry.getServerType().equalsIgnoreCase("DEPLOYMENT_MANAGER")) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static String getNodeOS(String string, String string2, String string3) throws AdminException {
        Properties properties = new Properties();
        properties.setProperty("was.repository.root", string);
        properties.setProperty("local.cell", string2);
        ManagedObjectMetadataAccessor managedObjectMetadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(properties);
        return managedObjectMetadataAccessor.getMetadataProperty(string3, "com.ibm.websphere.nodeOperatingSystem");
    }

    private static ServerIndex getServerIndexForGivenNode(String string, String string2, String string3) {
        Resource resource = null;
        Repository repository2 = null;
        try {
            repository2 = RepositoryFactory.createRepository(string, string2, string3, null);
            resource = repository2.getConfigRoot().getResource(3, "serverindex.xml");
        }
        catch (Throwable throwable) {
            return null;
        }
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        return serverIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getVariable(Resource resource, String string) {
        String string2 = null;
        EList eList = resource.getContents();
        VariableMap variableMap = null;
        Iterator iterator = eList.iterator();
        if (iterator.hasNext()) {
            variableMap = (VariableMap)iterator.next();
        }
        VariableSubstitutionEntry variableSubstitutionEntry = null;
        if (variableMap == null) return null;
        EList eList2 = variableMap.getEntries();
        if (eList2 == null) return null;
        Iterator iterator2 = eList2.iterator();
        do {
            if (!iterator2.hasNext()) return string2;
        } while (!(variableSubstitutionEntry = (VariableSubstitutionEntry)iterator2.next()).getSymbolicName().equals("WEB_INSTALL_ROOT"));
        return variableSubstitutionEntry.getValue();
    }

    static {
        webNamedEndPoint = null;
        adminNamedEndPoint = null;
    }
}

