/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.webserver.commands;

import [Ljava.lang.String;;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandStepData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.MetadataNotAvailableException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.product.WASDirectory;
import com.ibm.websphere.product.WASProductInfo;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.tools.UnmanagedNode;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.wsspi.management.commands.server.CreateServer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateWebServer
extends CreateServer {
    private static String BUNDLE_NAME = "com.ibm.ws.management.webserver.resources.webserver";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(CreateWebServer.class, "management", "com.ibm.ws.management.webserver");
    ObjectName[] matches = null;
    ObjectName pattern = null;
    private ObjectName targetObj = null;
    private ObjectName serverObj = null;
    private ObjectName nodeObj = null;
    private static String SERVER_CONFIG_STEP = "serverConfig";
    private static String REMOTE_SERVER_CONFIG_STEP = "remoteServerConfig";
    private static String WEBSERVER_TEMPLATE_PARAM = "templateName";
    private static String WEBSERVER_NAME_PARAM = "name";
    private static String CONFIG_FILE_PARAM = "configurationFile";
    private static String LOGFILE_ERROR_PARAM = "errorLogfile";
    private static String LOGFILE_ACCESS_PARAM = "accessLogfile";
    private static String WEB_INSTALLROOT_PARAM = "webInstallRoot";
    private static String PLUGIN_INSTALLROOT_PARAM = "pluginInstallRoot";
    private static String WEB_PROTOCOL_PARAM = "webProtocol";
    private static String ADMIN_PROTOCOL_PARAM = "adminProtocol";
    private static String SERVICE_NAME_PARAM = "serviceName";
    private static String WEB_APPMAPPING_PARAM = "webAppMapping";
    private static String WEB_PORT_PARAM = "webPort";
    private static String ADMIN_PORT_PARAM = "adminPort";
    private static String ADMIN_USERID_PARAM = "adminUserID";
    private static String ADMIN_PASSWD_PARAM = "adminPasswd";
    private String taskName = null;
    private String serverConfigStep = null;
    private String remoteServerConfigStep = null;
    private String templateName = null;
    private String nodeName = null;
    private String platformOS = null;
    private String hostName = null;
    private String webserverType = null;
    private String cellName = null;
    private String cellType = null;
    public String serverName = null;
    private Integer webPort = null;
    private Integer adminPort = null;
    private String configFile = null;
    private String errorLogfile = null;
    private String accessLogfile = null;
    public String webInstallRoot = null;
    public String pluginInstallRoot = null;
    public String webProtocol = null;
    public String adminProtocol = null;
    public String serviceName = null;
    public String adminUserID = null;
    public String adminPasswd = null;
    public String webAppMapping = null;
    ObjectName webserver = null;
    List specialEndPts = new ArrayList();

    public CreateWebServer(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public CreateWebServer(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String setdefaultRoot(String string, String string2) {
        String string3 = null;
        if (this.webInstallRoot == null || this.webInstallRoot.equals("")) {
            if (string2.equals("windows")) {
                string3 = "C:\\Program Files\\IBM\\HTTPServer";
            }
            if (string2.equals("aix")) {
                string3 = "/usr/IBM/HTTPServer";
            }
            if (string2.equals("hpux")) {
                string3 = "/opt/IBM/HTTPServer";
            }
            if (string2.equals("linux")) {
                string3 = "/opt/IBM/HTTPServer";
            }
            if (string2.equals("solaris")) {
                string3 = "/opt/IBM/HTTPServer";
            }
            if (string2.equals("os390")) {
                if (string.equals("IHS")) {
                    string3 = "/usr/lpp/IBMIHS";
                } else if (string.equals("HTTPSERVER_ZOS")) {
                    string3 = "/usr/lpp/internet";
                }
            }
            if (string2.equals("os400")) {
                string3 = "/www/" + this.serverName;
            }
            return string3;
        }
        return this.webInstallRoot;
    }

    private void deleteSrv(String string, String string2) {
        Session session = this.getConfigSession();
        try {
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            AdminCommand adminCommand = commandMgr.createCommand("deleteServer");
            adminCommand.setConfigSession(session);
            adminCommand.setParameter("serverName", this.serverName);
            adminCommand.setParameter("nodeName", string);
            System.out.println("Issue Command deleteServer" + string + this.serverName);
            adminCommand.execute();
            boolean bl = false;
            Throwable throwable = null;
            if (!adminCommand.getCommandResult().isSuccessful()) {
                System.out.println("return from Command deleteServer->" + adminCommand.getCommandResult().isSuccessful());
                throwable = adminCommand.getCommandResult().getException();
                System.out.println("return from Command deleteServer" + throwable);
                bl = false;
            } else {
                System.out.println("return from Command deleteServer->" + adminCommand.getCommandResult().isSuccessful());
                bl = true;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception on DeleteServer " + exception.toString());
        }
    }

    public boolean check4MgrNode(String string) {
        boolean bl = false;
        Exception exception = null;
        try {
            Session session = this.getConfigSession();
            List list = UnmanagedNode.listManagedNodes(session);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.equalsIgnoreCase(string)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "This node is type managed ", string2);
                }
                bl = true;
            }
        }
        catch (WorkSpaceException workSpaceException) {
            exception = workSpaceException;
            System.out.println(" Exception " + workSpaceException.toString());
        }
        catch (ConfigServiceException configServiceException) {
            exception = configServiceException;
            System.out.println(" Exception " + configServiceException.toString());
            return false;
        }
        catch (IOException iOException) {
            exception = iOException;
            System.out.println(" Exception " + iOException.toString());
            return false;
        }
        catch (AdminException adminException) {
            exception = adminException;
            System.out.println(" Exception " + adminException.toString());
            return false;
        }
        return bl;
    }

    public boolean isDummyNode(String string) {
        ArrayList arrayList = null;
        boolean bl = false;
        Exception exception = null;
        try {
            Session session = this.getConfigSession();
            List list = UnmanagedNode.listUnmanagedNodes(session);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.equalsIgnoreCase(string)) continue;
                try {
                    arrayList = null;
                    arrayList = this.metadataHelper.getNodeDeployedFeatures(string);
                }
                catch (MetadataNotAvailableException metadataNotAvailableException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "This node is type UnManaged/Dummy ", string);
                    }
                    bl = true;
                }
                if (arrayList == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "This node is type Unmanaged/Standalone ", string);
                }
                bl = false;
            }
        }
        catch (WorkSpaceException workSpaceException) {
            exception = workSpaceException;
            System.out.println(" Exception " + workSpaceException.toString());
        }
        catch (ConfigServiceException configServiceException) {
            exception = configServiceException;
            System.out.println(" Exception " + configServiceException.toString());
            return false;
        }
        catch (IOException iOException) {
            exception = iOException;
            System.out.println(" Exception " + iOException.toString());
            return false;
        }
        catch (AdminException adminException) {
            exception = adminException;
            System.out.println(" Exception " + adminException.toString());
            return false;
        }
        return bl;
    }

    public boolean isStandAlone(ObjectName objectName) {
        boolean bl = false;
        try {
            Session session = this.getConfigSession();
            ConfigService configService = ConfigServiceFactory.getConfigService();
            this.matches = configService.getRelationship(session, objectName, "parent");
            if (this.matches.length < 1) {
                System.out.println("ERROR No cell for this node");
            }
            ObjectName objectName2 = this.matches[0];
            this.matches = null;
            String string = (String)configService.getAttribute(session, objectName2, "cellType");
            System.out.println("CEllType " + string);
            System.out.println("nodeName " + this.nodeName);
            bl = string.equals("STANDALONE");
        }
        catch (ConfigServiceException configServiceException) {
            ConfigServiceException configServiceException2 = configServiceException;
            System.out.println(" Exception " + configServiceException.toString());
        }
        catch (ConnectorException connectorException) {
            ConnectorException connectorException2 = connectorException;
            System.out.println(" Exception " + connectorException.toString());
        }
        return bl;
    }

    public List getWebserverfromNode(String string) {
        boolean bl = false;
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        try {
            Session session = this.getConfigSession();
            ConfigService configService = ConfigServiceFactory.getConfigService();
            ObjectName[] objectNameArray = configService.resolve(session, "Node=" + string + ":Server=");
            System.out.println("# of WebServers " + objectNameArray.length);
            for (int i = 0; i < objectNameArray.length; ++i) {
                ObjectName objectName = objectNameArray[i];
                String string2 = (String)configService.getAttribute(session, objectName, "serverType");
                String string3 = (String)configService.getAttribute(session, objectName, "name");
                System.out.println("ServerType " + string2);
                if (!string2.equals("WEB_SERVER")) continue;
                arrayList.add(objectName);
                System.out.println("Name " + string3);
                System.out.println("ServerName " + this.serverName);
            }
        }
        catch (ConfigServiceException configServiceException) {
            ConfigServiceException configServiceException2 = configServiceException;
            System.out.println(" Exception " + configServiceException.toString());
            return null;
        }
        catch (ConnectorException connectorException) {
            ConnectorException connectorException2 = connectorException;
            System.out.println(" Exception " + connectorException.toString());
            return null;
        }
        System.out.println("Return # of webserver on node ->  " + arrayList.size());
        return arrayList;
    }

    private void createMapping(String string, String string2) throws Exception {
        String string3 = "WebSphere:cell=" + this.cellName + ",node=" + this.nodeName + ",server=" + this.serverName;
        AppManagement appManagement = null;
        appManagement = AdminServiceFactory.getAdminService() != null ? AppManagementProxy.getJMXProxyForServer() : AppManagementProxy.getLocalProxy();
        Vector vector = appManagement.listApplications(new Hashtable(), string2);
        for (int i = 0; i < vector.size(); ++i) {
            String string4 = (String)vector.elementAt(i);
            if (string4.equalsIgnoreCase("isclite") || !string.equalsIgnoreCase("all") && (!string.equalsIgnoreCase("default") || !string4.equalsIgnoreCase("DefaultApplication.ear"))) continue;
            Vector vector2 = appManagement.getApplicationInfo(string4, new Hashtable(), string2);
            for (int j = 0; j < vector2.size(); ++j) {
                AppDeploymentTask appDeploymentTask = (AppDeploymentTask)vector2.elementAt(j);
                if (!appDeploymentTask.getName().equals("MapModulesToServers")) continue;
                String[][] stringArray = appDeploymentTask.getTaskData();
                for (int k = 1; k < stringArray.length; ++k) {
                    String[] stringArray2 = stringArray[k];
                    stringArray2[2] = stringArray2[2] + "+" + string3;
                }
                appDeploymentTask.setTaskData(stringArray);
            }
            appManagement.setApplicationInfo(string4, new Hashtable(), string2, vector2);
        }
    }

    public Object[] getChoices(String string) {
        Serializable serializable;
        List list;
        Object[] objectArray;
        block16: {
            objectArray = null;
            boolean bl = true;
            list = Collections.EMPTY_LIST;
            String string2 = "";
            try {
                ConfigService configService = ConfigServiceFactory.getConfigService();
                serializable = this.getConfigSession();
                String string3 = (String)this.getTargetObject();
                String string4 = "WEB_SERVER";
                String string5 = string;
                String[] stringArray = null;
                stringArray = !bl ? new String[3] : new String[2];
                if (string5.equals("os390")) {
                    stringArray[0] = "com.ibm.websphere.nodeOperatingSystem=os390";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ZOS Platform Query", stringArray);
                    }
                } else {
                    stringArray[0] = "com.ibm.websphere.nodeOperatingSystem!=os390";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Distributed Platform Query", stringArray);
                    }
                }
                if (!bl) {
                    stringArray[1] = this.templateName == null || this.templateName.equals("") ? "isDefaultTemplate=true" : "name=" + this.templateName;
                }
                if (string3 != null && !string3.equals("")) {
                    string2 = this.metadataHelper.getNodeBaseProductVersion(string3);
                    string2 = string2.startsWith("6.1") ? "6.1" : this.metadataHelper.getNodeMajorVersion(string3);
                } else {
                    string2 = Utils.getProductVersion();
                    if (string2.startsWith("6.1")) {
                        string2 = "6.1";
                    }
                }
                if (!bl) {
                    stringArray[2] = "com.ibm.websphere.baseProductMajorVersion=" + string2;
                } else {
                    stringArray[1] = "com.ibm.websphere.baseProductMajorVersion=" + string2;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Call ListServerTEmplates [" + string4 + "-" + stringArray + "]");
                }
                list = this.listServerTemplates(string4, stringArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "templates [" + list + "]");
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.wsspi.management.commands.server.CreateServer.taskCommandExecuted", "242");
                if (!tc.isDebugEnabled()) break block16;
                Tr.debug(tc, "Exception occured during getChoices", throwable);
            }
        }
        objectArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            serializable = (ObjectName)list.get(i);
            objectArray[i] = ConfigServiceHelper.getDisplayName((ObjectName)serializable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChoices", objectArray);
        }
        return objectArray;
    }

    protected List listServerTemplates(String string, String[] stringArray) throws Throwable {
        List list = null;
        try {
            Method method2 = this.implClass.getMethod("listServerTemplates", ConfigService.class, Session.class, String.class, String;.class);
            list = (List)method2.invoke(null, ConfigServiceFactory.getConfigService(), this.getConfigSession(), string, stringArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unexpected exception", throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.wsspi.management.commands.server.ServerCommandBase.setConfigSession", "69");
        }
        return list;
    }

    protected void updateVariables(ObjectName objectName, String string, String string2, String string3) {
        WsException wsException = null;
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        try {
            ObjectName objectName2 = configService.getRelationship(session, objectName, "VariableMap")[0];
            AttributeList attributeList = new AttributeList();
            ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName2, "entries", false);
            for (int i = 0; i < arrayList.size(); ++i) {
                ObjectName objectName3 = (ObjectName)arrayList.get(i);
                String string4 = (String)configService.getAttribute(session, objectName3, "symbolicName");
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Existing Varibales in variables.xml[" + string4 + "]");
            }
            AttributeList attributeList2 = new AttributeList();
            attributeList2.add(new Attribute("symbolicName", string));
            attributeList2.add(new Attribute("value", string2));
            attributeList2.add(new Attribute("description", string3));
            ConfigServiceHelper.setAttributeValue(attributeList2, "symbolicName", "WEB_INSTALL_ROOT");
            configService.createConfigData(session, objectName2, "entries", "VariableSubstitutionEntry", attributeList2);
        }
        catch (ConfigServiceException configServiceException) {
            wsException = configServiceException;
            System.out.println(" Exception " + configServiceException.toString());
        }
        catch (ConnectorException connectorException) {
            wsException = connectorException;
            System.out.println(" Exception " + connectorException.toString());
        }
    }

    static /* synthetic */ String access$1802(CreateWebServer createWebServer, String string) {
        createWebServer.serverConfigStep = string;
        return createWebServer.serverConfigStep;
    }

    static /* synthetic */ String access$1900() {
        return WEB_PORT_PARAM;
    }

    static /* synthetic */ String access$2000() {
        return WEB_INSTALLROOT_PARAM;
    }

    static /* synthetic */ ManagedObjectMetadataHelper access$2100(CreateWebServer createWebServer) {
        return createWebServer.metadataHelper;
    }

    static /* synthetic */ ManagedObjectMetadataHelper access$2200(CreateWebServer createWebServer) {
        return createWebServer.metadataHelper;
    }

    static /* synthetic */ String access$2300(CreateWebServer createWebServer, String string, String string2) {
        return createWebServer.setdefaultRoot(string, string2);
    }

    static /* synthetic */ String access$2400() {
        return PLUGIN_INSTALLROOT_PARAM;
    }

    static /* synthetic */ String access$1402(CreateWebServer createWebServer, String string) {
        createWebServer.configFile = string;
        return createWebServer.configFile;
    }

    static /* synthetic */ String access$2500() {
        return CONFIG_FILE_PARAM;
    }

    static /* synthetic */ ManagedObjectMetadataHelper access$2600(CreateWebServer createWebServer) {
        return createWebServer.metadataHelper;
    }

    static /* synthetic */ ManagedObjectMetadataHelper access$2700(CreateWebServer createWebServer) {
        return createWebServer.metadataHelper;
    }

    static /* synthetic */ ManagedObjectMetadataHelper access$2800(CreateWebServer createWebServer) {
        return createWebServer.metadataHelper;
    }

    static /* synthetic */ ManagedObjectMetadataHelper access$2900(CreateWebServer createWebServer) {
        return createWebServer.metadataHelper;
    }

    static /* synthetic */ ManagedObjectMetadataHelper access$3000(CreateWebServer createWebServer) {
        return createWebServer.metadataHelper;
    }

    static /* synthetic */ String access$3100() {
        return SERVICE_NAME_PARAM;
    }

    static /* synthetic */ ManagedObjectMetadataHelper access$3200(CreateWebServer createWebServer) {
        return createWebServer.metadataHelper;
    }

    static /* synthetic */ ManagedObjectMetadataHelper access$3300(CreateWebServer createWebServer) {
        return createWebServer.metadataHelper;
    }

    static /* synthetic */ String access$3400() {
        return WEB_PROTOCOL_PARAM;
    }

    static /* synthetic */ String access$3500() {
        return WEB_APPMAPPING_PARAM;
    }

    static /* synthetic */ String access$1502(CreateWebServer createWebServer, String string) {
        createWebServer.errorLogfile = string;
        return createWebServer.errorLogfile;
    }

    static /* synthetic */ String access$3600() {
        return LOGFILE_ERROR_PARAM;
    }

    static /* synthetic */ ManagedObjectMetadataHelper access$3700(CreateWebServer createWebServer) {
        return createWebServer.metadataHelper;
    }

    static /* synthetic */ String access$1602(CreateWebServer createWebServer, String string) {
        createWebServer.accessLogfile = string;
        return createWebServer.accessLogfile;
    }

    static /* synthetic */ String access$3800() {
        return LOGFILE_ACCESS_PARAM;
    }

    static /* synthetic */ ManagedObjectMetadataHelper access$3900(CreateWebServer createWebServer) {
        return createWebServer.metadataHelper;
    }

    public class RemoteServerConfigStep
    extends AbstractCommandStep {
        private String stepName;
        private AbstractTaskCommand taskCmd;
        CommandResultImpl thisCmdResult;

        public RemoteServerConfigStep(AbstractTaskCommand abstractTaskCommand, CommandStepMetadata commandStepMetadata) throws CommandNotFoundException {
            super(abstractTaskCommand, commandStepMetadata);
            this.stepName = null;
            this.taskCmd = null;
            this.thisCmdResult = null;
            this.stepName = commandStepMetadata.getName();
            this.taskCmd = abstractTaskCommand;
        }

        public RemoteServerConfigStep(AbstractTaskCommand abstractTaskCommand, CommandStepData commandStepData) throws CommandNotFoundException, CommandLoadException {
            super(abstractTaskCommand, commandStepData);
            this.stepName = null;
            this.taskCmd = null;
            this.thisCmdResult = null;
            this.stepName = commandStepData.getName();
            this.taskCmd = abstractTaskCommand;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void executeStep() {
            block16: {
                try {
                    block17: {
                        Session session;
                        ConfigService configService;
                        ObjectName objectName;
                        AttributeList attributeList;
                        AttributeList attributeList2;
                        block18: {
                            attributeList2 = new AttributeList();
                            attributeList = new AttributeList();
                            objectName = null;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Execute step RemoteServerConfigStep ");
                            }
                            configService = ConfigServiceFactory.getConfigService();
                            session = this.getConfigSession();
                            if (!CreateWebServer.this.webserverType.equals("IHS")) break block17;
                            String string = CreateWebServer.this.platformOS;
                            CreateWebServer.this.metadataHelper;
                            if (string.equals("os390")) break block17;
                            if (!CreateWebServer.this.check4MgrNode(CreateWebServer.this.nodeName)) break block18;
                            String string2 = CreateWebServer.this.platformOS;
                            CreateWebServer.this.metadataHelper;
                            if (!string2.equals("os400")) break block17;
                        }
                        this.validateRemoteParms();
                        if (CreateWebServer.this.adminPort == null) {
                            String string = CreateWebServer.this.platformOS;
                            CreateWebServer.this.metadataHelper;
                            if (string.equals("os400")) {
                                CreateWebServer.this.adminPort = new Integer(2001);
                            } else {
                                CreateWebServer.this.adminPort = new Integer(8008);
                            }
                        }
                        ConfigServiceHelper.setAttributeValue(attributeList, "host", CreateWebServer.this.hostName);
                        ConfigServiceHelper.setAttributeValue(attributeList, "port", CreateWebServer.this.adminPort);
                        objectName = (ObjectName)CreateWebServer.this.specialEndPts.get(1);
                        configService.setAttributes(session, objectName, attributeList);
                        AttributeList attributeList3 = new AttributeList();
                        if (CreateWebServer.this.adminProtocol != null) {
                            ConfigServiceHelper.setAttributeValue(attributeList3, "webserverAdminProtocol", CreateWebServer.this.adminProtocol.toUpperCase());
                            configService.setAttributes(session, CreateWebServer.this.webserver, attributeList3);
                        }
                        if (CreateWebServer.this.adminUserID != null && CreateWebServer.this.adminPasswd != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "AdminUserID = ", CreateWebServer.this.adminUserID);
                            }
                            attributeList2 = null;
                            AttributeList attributeList4 = new AttributeList();
                            attributeList2 = configService.getAttributes(session, CreateWebServer.this.webserver, new String[]{"adminServerAuthentication"}, false);
                            for (int i = 0; i < attributeList2.size(); ++i) {
                                Object e2 = attributeList2.get(i);
                            }
                            ObjectName objectName2 = (ObjectName)((Attribute)attributeList2.get(0)).getValue();
                            ConfigServiceHelper.setAttributeValue(attributeList4, "userid", CreateWebServer.this.adminUserID);
                            ConfigServiceHelper.setAttributeValue(attributeList4, "password", CreateWebServer.this.adminPasswd);
                            configService.setAttributes(session, objectName2, attributeList4);
                            CreateWebServer.this.adminUserID = (String)configService.getAttribute(session, objectName2, "userid");
                            CreateWebServer.this.adminPasswd = (String)configService.getAttribute(session, objectName2, "password");
                            break block16;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "AdminUserID or AdminPasswd is null ");
                        }
                        break block16;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Non-IHS webserver or Managed node ");
                    }
                }
                catch (ConnectorException connectorException) {
                    ConnectorException connectorException2 = connectorException;
                    System.out.println(" Exception " + connectorException.toString());
                }
                catch (CommandValidationException commandValidationException) {
                    this.thisCmdResult.setException(commandValidationException);
                    this.thisCmdResult.addWarnings("cve");
                    this.thisCmdResult.setResult(commandValidationException);
                }
                catch (ConfigServiceException configServiceException) {
                    ConfigServiceException configServiceException2 = configServiceException;
                    System.out.println(" Exception " + configServiceException.toString());
                }
            }
            System.out.println("Step RemoteServerConfigStep successful for Web server definition " + CreateWebServer.this.serverName);
        }

        public void validateRemoteParms() throws CommandValidationException {
            super.validate();
            ConfigService configService = ConfigServiceFactory.getConfigService();
            CreateWebServer.this.adminPort = (Integer)this.getParameter(ADMIN_PORT_PARAM);
            if (CreateWebServer.this.adminPort != null && (CreateWebServer.this.adminPort.compareTo(new Integer(0)) < 0 || CreateWebServer.this.adminPort.compareTo(new Integer(65536)) > 0)) {
                String string = TraceNLS.getFormattedMessage(BUNDLE_NAME, "WADM0042E", new Object[]{CreateWebServer.this.adminPort.toString()}, null);
                throw new CommandValidationException(string);
            }
            CreateWebServer.this.adminProtocol = (String)this.getParameter(ADMIN_PROTOCOL_PARAM);
            if (CreateWebServer.this.adminProtocol == null || CreateWebServer.this.adminProtocol.equals("")) {
                CreateWebServer.this.webProtocol = "HTTP";
            }
            if (CreateWebServer.this.webserverType.equals("IHS")) {
                CreateWebServer.this.adminUserID = (String)this.getParameter(ADMIN_USERID_PARAM);
                if (CreateWebServer.this.adminUserID == null || !CreateWebServer.this.adminUserID.equals("")) {
                    // empty if block
                }
                CreateWebServer.this.adminPasswd = (String)this.getParameter(ADMIN_PASSWD_PARAM);
                if (CreateWebServer.this.adminPasswd != null && !CreateWebServer.this.adminPasswd.equals("")) {
                    // empty if block
                }
            } else {
                CreateWebServer.this.adminUserID = null;
                CreateWebServer.this.adminPasswd = null;
            }
        }
    }

    public class ServerConfigStep
    extends AbstractCommandStep {
        private String stepName;
        private AbstractTaskCommand taskCmd;
        CommandResultImpl thisCmdResult;
        boolean Base;
        boolean ND;
        boolean Express;

        public ServerConfigStep(AbstractTaskCommand abstractTaskCommand, CommandStepMetadata commandStepMetadata) throws CommandNotFoundException {
            super(abstractTaskCommand, commandStepMetadata);
            this.stepName = null;
            this.taskCmd = null;
            this.thisCmdResult = null;
            this.Base = false;
            this.ND = false;
            this.Express = false;
            this.stepName = commandStepMetadata.getName();
            this.taskCmd = abstractTaskCommand;
        }

        public ServerConfigStep(AbstractTaskCommand abstractTaskCommand, CommandStepData commandStepData) throws CommandNotFoundException, CommandLoadException {
            super(abstractTaskCommand, commandStepData);
            this.stepName = null;
            this.taskCmd = null;
            this.thisCmdResult = null;
            this.Base = false;
            this.ND = false;
            this.Express = false;
            this.stepName = commandStepData.getName();
            this.taskCmd = abstractTaskCommand;
        }

        protected void executeStep() {
            Object object;
            WsException wsException = null;
            CreateWebServer.this.matches = null;
            CreateWebServer.this.serverObj = CreateWebServer.this.targetObj;
            AttributeList attributeList = new AttributeList();
            ObjectName objectName = null;
            ObjectName objectName2 = null;
            ObjectName objectName3 = null;
            ObjectName objectName4 = null;
            String string = null;
            WASDirectory wASDirectory = new WASDirectory(System.getProperty("was.install.root"));
            this.Base = wASDirectory.isThisProductInstalled("BASE");
            this.ND = wASDirectory.isThisProductInstalled("ND");
            this.Express = wASDirectory.isThisProductInstalled("EXPRESS");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Execute createWebServer-ServerConfigStep ");
                Tr.debug(tc, "Base = [" + this.Base + "]");
                Tr.debug(tc, "Express = [" + this.Express + "]");
                Tr.debug(tc, "ND = [" + this.ND + "]");
            }
            WASProductInfo[] wASProductInfoArray = wASDirectory.getWASProductInfoInstances();
            for (int i = 0; i < wASProductInfoArray.length; ++i) {
                object = wASProductInfoArray[i].getName();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "ProductName = [" + (String)object + "]");
            }
            this.thisCmdResult = (CommandResultImpl)this.taskCmd.getCommandResult();
            ObjectName objectName5 = (ObjectName)this.thisCmdResult.getResult();
            CreateWebServer.this.serverName = ConfigServiceHelper.getDisplayName(objectName5);
            object = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            try {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                String string2;
                Object object7;
                block66: {
                    block68: {
                        block67: {
                            Object object8;
                            String string3;
                            Serializable serializable;
                            Object object9;
                            Object object10;
                            CreateWebServer.this.matches = object.getRelationship(session, objectName5, "parent");
                            if (CreateWebServer.this.matches.length < 1) {
                                // empty if block
                            }
                            CreateWebServer.this.nodeObj = CreateWebServer.this.matches[0];
                            CreateWebServer.this.hostName = (String)object.getAttribute(session, CreateWebServer.this.nodeObj, "hostName");
                            CreateWebServer.this.nodeName = (String)object.getAttribute(session, CreateWebServer.this.nodeObj, "name");
                            for (int i = 0; i < CreateWebServer.this.serverName.length(); ++i) {
                                char c = CreateWebServer.this.serverName.charAt(i);
                                if (Character.isLetterOrDigit(c) || c == '-' || c == '_') continue;
                                CreateWebServer.this.deleteSrv(CreateWebServer.this.nodeName, CreateWebServer.this.serverName);
                                string = TraceNLS.getFormattedMessage(BUNDLE_NAME, "WADM0043E", new Object[]{CreateWebServer.this.serverName}, null);
                                throw new CommandValidationException(string);
                            }
                            ObjectName[] objectNameArray = object.getRelationship(session, CreateWebServer.this.nodeObj, "parent");
                            if (objectNameArray.length < 1) {
                                // empty if block
                            }
                            ObjectName objectName6 = objectNameArray[0];
                            CreateWebServer.this.cellName = (String)object.getAttribute(session, objectName6, "name");
                            CreateWebServer.this.cellType = (String)object.getAttribute(session, objectName6, "cellType");
                            WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
                            ManagedObjectMetadataHelper managedObjectMetadataHelper = workSpace.getMetadataHelper();
                            CreateWebServer.this.platformOS = managedObjectMetadataHelper.getNodePlatformOS(CreateWebServer.this.nodeName);
                            String string4 = "Node=" + CreateWebServer.this.nodeName + ":Server=" + CreateWebServer.this.serverName;
                            CreateWebServer.this.matches = object.resolve(session, string4);
                            if (CreateWebServer.this.matches.length > 0) {
                                CreateWebServer.this.serverObj = CreateWebServer.this.matches[0];
                            }
                            CreateWebServer.this.serverName = (String)object.getAttribute(session, CreateWebServer.this.serverObj, "name");
                            attributeList = null;
                            attributeList = object.getAttributes(session, CreateWebServer.this.serverObj, new String[]{"components"}, false);
                            for (int i = 0; i < attributeList.size(); ++i) {
                                object10 = attributeList.get(i);
                            }
                            List list = (List)((Attribute)attributeList.get(0)).getValue();
                            object10 = list.iterator();
                            while (object10.hasNext()) {
                                CreateWebServer.this.webserver = (ObjectName)object10.next();
                            }
                            CreateWebServer.this.webserverType = (String)object.getAttribute(session, CreateWebServer.this.webserver, "webserverType");
                            CreateWebServer.this.matches = object.resolve(session, "ServerEntry=" + CreateWebServer.this.serverName);
                            for (int i = 0; i < CreateWebServer.this.matches.length; ++i) {
                                object9 = object.getRelationship(session, CreateWebServer.this.matches[i], "parent")[0];
                                serializable = object.getRelationship(session, (ObjectName)object9, "parent")[0];
                                string3 = (String)object.getAttribute(session, CreateWebServer.this.matches[i], "serverType");
                                if (string3 == null || string3.length() <= 0 || !string3.equals("WEB_SERVER") || !((String)(object7 = (String)object.getAttribute(session, (ObjectName)serializable, "name"))).equals(CreateWebServer.this.nodeName)) continue;
                                objectName = CreateWebServer.this.matches[i];
                            }
                            if (objectName == null) {
                                String string5 = "Can not get access to ServerEnrty";
                                string = TraceNLS.getFormattedMessage(BUNDLE_NAME, "WADM9250E", new Object[]{this.stepName, this.taskCmd.getName(), string5}, null);
                                System.out.println(" " + string5);
                                throw new CommandValidationException(string);
                            }
                            attributeList = object.getAttributes(session, objectName, new String[]{"specialEndpoints"}, false);
                            List list2 = (List)((Attribute)attributeList.get(0)).getValue();
                            object9 = list2.iterator();
                            while (object9.hasNext()) {
                                objectName2 = (ObjectName)object9.next();
                                serializable = new AttributeList();
                                serializable = object.getAttributes(session, objectName2, new String[]{"endPoint"}, false);
                                CreateWebServer.this.specialEndPts.add((ObjectName)((Attribute)((ArrayList)serializable).get(0)).getValue());
                            }
                            this.validateParms();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Return from validateParms");
                            }
                            if (CreateWebServer.this.hostName != null && CreateWebServer.this.specialEndPts.size() > 0) {
                                object9 = new AttributeList();
                                ConfigServiceHelper.setAttributeValue((AttributeList)object9, "host", CreateWebServer.this.hostName);
                                if (CreateWebServer.this.webPort == null) {
                                    CreateWebServer.this.webPort = new Integer(80);
                                }
                                ConfigServiceHelper.setAttributeValue((AttributeList)object9, "port", CreateWebServer.this.webPort);
                                objectName3 = (ObjectName)CreateWebServer.this.specialEndPts.get(0);
                                object.setAttributes(session, objectName3, (AttributeList)object9);
                                if (CreateWebServer.this.platformOS.equals("os400") && CreateWebServer.this.adminPort == null && CreateWebServer.this.specialEndPts.size() > 1) {
                                    serializable = new AttributeList();
                                    ConfigServiceHelper.setAttributeValue((AttributeList)serializable, "host", CreateWebServer.this.hostName);
                                    CreateWebServer.this.adminPort = new Integer(2001);
                                    ConfigServiceHelper.setAttributeValue((AttributeList)serializable, "port", CreateWebServer.this.adminPort);
                                    objectName4 = (ObjectName)CreateWebServer.this.specialEndPts.get(1);
                                    object.setAttributes(session, objectName4, (AttributeList)serializable);
                                }
                            } else {
                                System.out.println(" Invalid  node no hostname  or no Endpoint");
                            }
                            object9 = (String)object.getAttribute(session, objectName3, "host");
                            serializable = (Integer)object.getAttribute(session, objectName3, "port");
                            string3 = "Web Server Install Root for " + CreateWebServer.this.serverName + ".";
                            CreateWebServer.this.updateVariables(CreateWebServer.this.serverObj, "WEB_INSTALL_ROOT", CreateWebServer.this.webInstallRoot, string3);
                            object7 = new AttributeList();
                            if (CreateWebServer.this.webInstallRoot != null) {
                                ConfigServiceHelper.setAttributeValue((AttributeList)object7, "webserverInstallRoot", CreateWebServer.this.webInstallRoot);
                            }
                            string2 = "plugin-key.kdb";
                            attributeList = null;
                            attributeList = object.getAttributes(session, CreateWebServer.this.webserver, new String[]{"pluginProperties"}, false);
                            for (int i = 0; i < attributeList.size(); ++i) {
                                object8 = attributeList.get(i);
                            }
                            ObjectName objectName7 = null;
                            if (attributeList.size() > 0) {
                                object8 = (List)((Attribute)attributeList.get(0)).getValue();
                                object6 = object8.iterator();
                                while (object6.hasNext()) {
                                    objectName7 = (ObjectName)object6.next();
                                    object5 = (String)object.getAttribute(session, objectName7, "PluginInstallRoot");
                                    string2 = (String)object.getAttribute(session, objectName7, "KeyRingFilename");
                                }
                            }
                            object8 = new AttributeList();
                            if (CreateWebServer.this.pluginInstallRoot != null) {
                                ConfigServiceHelper.setAttributeValue((AttributeList)object8, "PluginInstallRoot", CreateWebServer.this.pluginInstallRoot);
                                this.setupPluginProperties(managedObjectMetadataHelper, (AttributeList)object8);
                                object.setAttributes(session, objectName7, (AttributeList)object8);
                            }
                            if (CreateWebServer.this.webProtocol != null) {
                                ConfigServiceHelper.setAttributeValue((AttributeList)object7, "webserverProtocol", CreateWebServer.this.webProtocol.toUpperCase());
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Web server  type = [" + CreateWebServer.this.webserverType + "]");
                            }
                            if (!CreateWebServer.this.webserverType.equals("IHS") && !CreateWebServer.this.webserverType.equals("HTTPSERVER_ZOS")) break block66;
                            if (CreateWebServer.this.configFile != null) {
                                ConfigServiceHelper.setAttributeValue((AttributeList)object7, "configurationFilename", CreateWebServer.this.configFile);
                            }
                            if (CreateWebServer.this.platformOS.equals("windows")) break block67;
                            if (!CreateWebServer.this.platformOS.equals("os400")) break block68;
                        }
                        if (CreateWebServer.this.serviceName != null) {
                            ConfigServiceHelper.setAttributeValue((AttributeList)object7, "serviceName", CreateWebServer.this.serviceName);
                        }
                    }
                    ConfigServiceHelper.setAttributeValue((AttributeList)object7, "name", CreateWebServer.this.serverName);
                    if (CreateWebServer.this.errorLogfile != null) {
                        ConfigServiceHelper.setAttributeValue((AttributeList)object7, "logFilenameError", CreateWebServer.this.errorLogfile);
                    }
                    if (CreateWebServer.this.accessLogfile != null) {
                        ConfigServiceHelper.setAttributeValue((AttributeList)object7, "logFilenameAccess", CreateWebServer.this.accessLogfile);
                    }
                    if (CreateWebServer.this.check4MgrNode(CreateWebServer.this.nodeName) || !CreateWebServer.this.isDummyNode(CreateWebServer.this.nodeName)) {
                        attributeList = null;
                        object6 = new AttributeList();
                        attributeList = object.getAttributes(session, CreateWebServer.this.serverObj, new String[]{"processDefinitions"}, false);
                        for (int i = 0; i < attributeList.size(); ++i) {
                            object4 = attributeList.get(i);
                        }
                        object5 = null;
                        if (attributeList.size() > 0) {
                            object4 = (List)((Attribute)attributeList.get(0)).getValue();
                            object3 = object4.iterator();
                            while (object3.hasNext()) {
                                object5 = (ObjectName)object3.next();
                            }
                        }
                        if (object5 != null) {
                            String string6;
                            int n;
                            object4 = "";
                            object3 = "";
                            object2 = "";
                            String string7 = "${WEB_INSTALL_ROOT}";
                            String string8 = "";
                            String string9 = "";
                            String string10 = "";
                            String string11 = "";
                            String string12 = "";
                            String[] stringArray = new String[]{"-k start", "-f", CreateWebServer.this.configFile};
                            String[] stringArray2 = new String[]{"-k stop", "-f", CreateWebServer.this.configFile};
                            String[] stringArray3 = new String[]{"-k", "stop", "-n", CreateWebServer.this.serviceName, "-f", CreateWebServer.this.configFile};
                            String[] stringArray4 = new String[]{"-k", "start", "-n", CreateWebServer.this.serviceName, "-f", CreateWebServer.this.configFile};
                            if (CreateWebServer.this.platformOS.equals("windows")) {
                                object4 = "${WEB_INSTALL_ROOT}/bin/apache.exe";
                                object3 = "${WEB_INSTALL_ROOT}/bin/apache.exe";
                                string8 = "apache.exe";
                            } else if (CreateWebServer.this.platformOS.equals("os390")) {
                                if (CreateWebServer.this.webserverType.equals("HTTPSERVER_ZOS")) {
                                    object4 = "START IMWEBSRV,";
                                    object3 = "STOP IMWEBSRV";
                                    object2 = "Cancel IMWEBSRV";
                                    string11 = "LEPARM='ENVAR(\"_CEE_ENVFILE=/etc/httpd.envvars\")',ICSPARM='-r " + CreateWebServer.this.configFile + " '";
                                    ConfigServiceHelper.setAttributeValue((AttributeList)object6, "terminateCommand", object2);
                                } else if (CreateWebServer.this.webserverType.equals("IHS")) {
                                    object4 = "START IWOAPROC,";
                                    object3 = "START IWOAPROC,";
                                    object2 = "";
                                    string11 = "ACTION='start',DIR='${WEB_INSTALL_ROOT}',CONF='" + CreateWebServer.this.configFile + "'";
                                    string12 = "ACTION='stop',DIR='${WEB_INSTALL_ROOT}',CONF='" + CreateWebServer.this.configFile + "'";
                                    ConfigServiceHelper.setAttributeValue((AttributeList)object6, "terminateCommand", object2);
                                }
                            } else {
                                object4 = "${WEB_INSTALL_ROOT}/bin/apachectl";
                                object3 = "${WEB_INSTALL_ROOT}/bin/apachectl";
                                string8 = "$(WEB_INSTALL_ROOT}/bin/apachectl";
                            }
                            ConfigServiceHelper.setAttributeValue((AttributeList)object6, "startCommand", object4);
                            ConfigServiceHelper.setAttributeValue((AttributeList)object6, "stopCommand", object3);
                            ConfigServiceHelper.setAttributeValue((AttributeList)object6, "workingDirectory", string7);
                            ConfigServiceHelper.setAttributeValue((AttributeList)object6, "executableName", string8);
                            attributeList = object.getAttributes(session, (ObjectName)object5, new String[]{"startCommandArgs"}, false);
                            List list = (List)((Attribute)attributeList.get(0)).getValue();
                            list.clear();
                            if (CreateWebServer.this.platformOS.equals("windows")) {
                                for (n = 0; n < stringArray4.length; ++n) {
                                    string6 = new String(stringArray4[n]);
                                    list.add(n, string6);
                                }
                            } else if (CreateWebServer.this.platformOS.equals("os390")) {
                                list.add(0, string11);
                            } else {
                                for (n = 0; n < stringArray.length; ++n) {
                                    string6 = new String(stringArray[n]);
                                    list.add(n, string6);
                                }
                            }
                            ConfigServiceHelper.setAttributeValue((AttributeList)object6, "startCommandArgs", list);
                            attributeList = object.getAttributes(session, (ObjectName)object5, new String[]{"stopCommandArgs"}, false);
                            List list3 = (List)((Attribute)attributeList.get(0)).getValue();
                            list3.clear();
                            if (CreateWebServer.this.platformOS.equals("windows")) {
                                for (int i = 0; i < stringArray3.length; ++i) {
                                    string6 = new String(stringArray3[i]);
                                    list3.add(i, string6);
                                }
                            } else if (CreateWebServer.this.platformOS.equals("os390")) {
                                if (CreateWebServer.this.webserverType.equals("IHS")) {
                                    list3.add(0, string12);
                                }
                            } else {
                                for (int i = 0; i < stringArray2.length; ++i) {
                                    string6 = new String(stringArray2[i]);
                                    list3.add(i, string6);
                                }
                            }
                            ConfigServiceHelper.setAttributeValue((AttributeList)object6, "stopCommandArgs", list3);
                            object.setAttributes(session, (ObjectName)object5, (AttributeList)object6);
                        }
                    }
                }
                object.setAttributes(session, CreateWebServer.this.webserver, (AttributeList)object7);
                if (!CreateWebServer.this.webAppMapping.equalsIgnoreCase("none")) {
                    CreateWebServer.this.createMapping(CreateWebServer.this.webAppMapping, session.toString());
                }
                object6 = "/config/cells/" + CreateWebServer.this.cellName + "/nodes/" + CreateWebServer.this.nodeName + "/servers/" + CreateWebServer.this.serverName + "/" + string2;
                object5 = CommandMgr.getCommandMgr();
                object4 = ((CommandMgr)object5).createCommand("createCMSKeyStore");
                object4.setConfigSession(session);
                object4.setParameter("cmsKeyStoreURI", object6);
                object4.setParameter("pluginHostName", CreateWebServer.this.hostName);
                object4.execute();
                object3 = null;
                object2 = null;
                if (!object4.getCommandResult().isSuccessful()) {
                    object2 = object4.getCommandResult().getException();
                    throw new AdminException((Throwable)object2);
                }
                System.out.println("Step ServerConfigStep successful for Web server definition " + CreateWebServer.this.serverName);
            }
            catch (ConnectorException connectorException) {
                wsException = connectorException;
                System.out.println(" Exception " + connectorException.toString());
            }
            catch (CommandValidationException commandValidationException) {
                this.thisCmdResult.setException(commandValidationException);
                this.thisCmdResult.addWarnings("cve");
                this.thisCmdResult.setResult(commandValidationException);
            }
            catch (ConfigServiceException configServiceException) {
                wsException = configServiceException;
                System.out.println(" Exception " + configServiceException.toString());
            }
            catch (AdminException adminException) {
                wsException = adminException;
                System.out.println(" Exception " + adminException.toString());
            }
            catch (Exception exception) {
                System.out.println(" Exception " + exception.toString());
            }
        }

        private void setupPluginProperties(ManagedObjectMetadataHelper managedObjectMetadataHelper, AttributeList attributeList) {
            char c = CreateWebServer.this.platformOS.equals("windows") ? (char)'\\' : '/';
            String string = null;
            String string2 = "logs" + c + CreateWebServer.this.serverName + c + "http_plugin.log";
            string = CreateWebServer.this.pluginInstallRoot.endsWith(String.valueOf(c)) ? CreateWebServer.this.pluginInstallRoot + string2 : CreateWebServer.this.pluginInstallRoot + c + string2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "plugin log file name[" + string + "]");
            }
            ConfigServiceHelper.setAttributeValue(attributeList, "LogFilename", string);
            String string3 = null;
            String string4 = "config" + c + CreateWebServer.this.serverName + c + "plugin-cfg.xml";
            string3 = CreateWebServer.this.pluginInstallRoot.endsWith(String.valueOf(c)) ? CreateWebServer.this.pluginInstallRoot + string4 : CreateWebServer.this.pluginInstallRoot + c + string4;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remote plugin config file name[" + string3 + "]");
            }
            ConfigServiceHelper.setAttributeValue(attributeList, "RemoteConfigFilename", string3);
            String string5 = null;
            String string6 = "config" + c + CreateWebServer.this.serverName + c + "plugin-key.kdb";
            string5 = CreateWebServer.this.pluginInstallRoot.endsWith(String.valueOf(c)) ? CreateWebServer.this.pluginInstallRoot + string6 : CreateWebServer.this.pluginInstallRoot + c + string6;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remote plugin keystore file name[" + string5 + "]");
            }
            ConfigServiceHelper.setAttributeValue(attributeList, "RemoteKeyRingFilename", string5);
        }

        public String getDefaultIHSPluginInstallRoot() {
            String string = null;
            string = CreateWebServer.this.platformOS.equals("windows") ? "c:\\Program Files\\IBM\\HTTPServer\\Plugins" : (CreateWebServer.this.platformOS.equals("aix") ? "/usr/IBM/HTTPServer/Plugins" : (CreateWebServer.this.platformOS.equals("os400") || CreateWebServer.this.platformOS.equals("os390") ? System.getProperty("user.install.root") : "/opt/IBM/HTTPServer/Plugins"));
            return string;
        }

        public String getDefaultPluginInstallRoot() {
            String string = null;
            string = CreateWebServer.this.platformOS.equals("windows") ? "c:\\Program Files\\IBM\\WebSphere\\Plugins" : (CreateWebServer.this.platformOS.equals("aix") ? "/usr/IBM/WebSphere/Plugins" : (CreateWebServer.this.platformOS.equals("os400") || CreateWebServer.this.platformOS.equals("os390") ? System.getProperty("user.install.root") : "/opt/IBM/WebSphere/Plugins"));
            return string;
        }

        public void validate() throws CommandValidationException {
        }

        /*
         * Unable to fully structure code
         */
        public void validateParms() throws CommandValidationException {
            block45: {
                block44: {
                    block42: {
                        block43: {
                            block41: {
                                CreateWebServer.access$1802(CreateWebServer.this, null);
                                if (CreateWebServer.access$200().isDebugEnabled()) {
                                    Tr.debug(CreateWebServer.access$200(), "validateParms");
                                }
                                super.validate();
                                var1_1 = ConfigServiceFactory.getConfigService();
                                var2_2 = null;
                                var3_3 = null;
                                var4_4 = new AttributeList();
                                CreateWebServer.access$1202(CreateWebServer.this, (Integer)this.getParameter(CreateWebServer.access$1900()));
                                if (CreateWebServer.access$1200(CreateWebServer.this) == null) {
                                    CreateWebServer.access$1202(CreateWebServer.this, new Integer(80));
                                }
                                if (CreateWebServer.access$1200(CreateWebServer.this).compareTo(new Integer(0)) < 0 || CreateWebServer.access$1200(CreateWebServer.this).compareTo(new Integer(65536)) > 0) {
                                    var5_5 = TraceNLS.getFormattedMessage(CreateWebServer.access$700(), "WADM0041E", new Object[]{CreateWebServer.access$1200(CreateWebServer.this).toString()}, null);
                                    throw new CommandValidationException(var5_5);
                                }
                                CreateWebServer.this.webInstallRoot = (String)this.getParameter(CreateWebServer.access$2000());
                                if (CreateWebServer.this.webInstallRoot != null && CreateWebServer.this.webInstallRoot.length() != 0) {
                                    CreateWebServer.this.webInstallRoot = CreateWebServer.this.webInstallRoot.replace('\\', '/');
                                    v0 = CreateWebServer.access$1000(CreateWebServer.this);
                                    CreateWebServer.access$2100(CreateWebServer.this);
                                    if (!v0.equals("windows")) {
                                        if (!CreateWebServer.this.webInstallRoot.startsWith("/")) {
                                            var5_6 = TraceNLS.getFormattedMessage(CreateWebServer.access$700(), "WADM0048E", new Object[]{CreateWebServer.this.webInstallRoot, CreateWebServer.access$1000(CreateWebServer.this)}, null);
                                            CreateWebServer.access$600(CreateWebServer.this, CreateWebServer.access$500(CreateWebServer.this), CreateWebServer.this.serverName);
                                            throw new CommandValidationException(var5_6);
                                        }
                                    } else {
                                        v1 = CreateWebServer.access$1000(CreateWebServer.this);
                                        CreateWebServer.access$2200(CreateWebServer.this);
                                        if (v1.equals("windows") && CreateWebServer.this.webInstallRoot.indexOf(":") == -1) {
                                            var5_7 = TraceNLS.getFormattedMessage(CreateWebServer.access$700(), "WADM0048E", new Object[]{CreateWebServer.this.webInstallRoot, CreateWebServer.access$1000(CreateWebServer.this)}, null);
                                            CreateWebServer.access$600(CreateWebServer.this, CreateWebServer.access$500(CreateWebServer.this), CreateWebServer.this.serverName);
                                            throw new CommandValidationException(var5_7);
                                        }
                                    }
                                    if (CreateWebServer.this.webInstallRoot.lastIndexOf("/") == CreateWebServer.this.webInstallRoot.length() - 1) {
                                        CreateWebServer.this.webInstallRoot = CreateWebServer.this.webInstallRoot.substring(0, CreateWebServer.this.webInstallRoot.length() - 1);
                                    }
                                } else if (CreateWebServer.access$1100(CreateWebServer.this).equals("IHS") || CreateWebServer.access$1100(CreateWebServer.this).equals("HTTPSERVER_ZOS")) {
                                    CreateWebServer.this.webInstallRoot = CreateWebServer.access$2300(CreateWebServer.this, CreateWebServer.access$1100(CreateWebServer.this), CreateWebServer.access$1000(CreateWebServer.this));
                                }
                                CreateWebServer.this.pluginInstallRoot = (String)this.getParameter(CreateWebServer.access$2400());
                                if (CreateWebServer.this.pluginInstallRoot == null || CreateWebServer.this.pluginInstallRoot.equals("")) {
                                    CreateWebServer.this.pluginInstallRoot = CreateWebServer.access$1100(CreateWebServer.this).equals("IHS") != false ? this.getDefaultIHSPluginInstallRoot() : this.getDefaultPluginInstallRoot();
                                }
                                CreateWebServer.access$1402(CreateWebServer.this, (String)this.getParameter(CreateWebServer.access$2500()));
                                if (CreateWebServer.access$1400(CreateWebServer.this) == null || CreateWebServer.access$1400(CreateWebServer.this).length() == 0) break block41;
                                if (!CreateWebServer.this.webInstallRoot.startsWith("$")) {
                                    v2 = CreateWebServer.access$1000(CreateWebServer.this);
                                    CreateWebServer.access$2600(CreateWebServer.this);
                                    if (!v2.equals("windows")) {
                                        if (!CreateWebServer.access$1400(CreateWebServer.this).startsWith("/")) {
                                            CreateWebServer.access$600(CreateWebServer.this, CreateWebServer.access$500(CreateWebServer.this), CreateWebServer.this.serverName);
                                            var5_8 = TraceNLS.getFormattedMessage(CreateWebServer.access$700(), "WADM0047E", new Object[]{CreateWebServer.access$1400(CreateWebServer.this).toString(), CreateWebServer.access$1000(CreateWebServer.this)}, null);
                                            throw new CommandValidationException(var5_8);
                                        }
                                    } else {
                                        v3 = CreateWebServer.access$1000(CreateWebServer.this);
                                        CreateWebServer.access$2700(CreateWebServer.this);
                                        if (v3.equals("windows") && CreateWebServer.access$1400(CreateWebServer.this).indexOf(":") == -1) {
                                            CreateWebServer.access$600(CreateWebServer.this, CreateWebServer.access$500(CreateWebServer.this), CreateWebServer.this.serverName);
                                            var5_9 = TraceNLS.getFormattedMessage(CreateWebServer.access$700(), "WADM0047E", new Object[]{CreateWebServer.access$1400(CreateWebServer.this).toString(), CreateWebServer.access$1000(CreateWebServer.this)}, null);
                                            throw new CommandValidationException(var5_9);
                                        }
                                    }
                                }
                                break block42;
                            }
                            if (!CreateWebServer.access$1100(CreateWebServer.this).equals("HTTPSERVER_ZOS")) break block43;
                            CreateWebServer.access$1402(CreateWebServer.this, "/etc/httpd.conf");
                            break block42;
                        }
                        if (!CreateWebServer.access$1100(CreateWebServer.this).equals("IHS")) ** GOTO lbl-1000
                        v4 = CreateWebServer.access$1000(CreateWebServer.this);
                        CreateWebServer.access$2800(CreateWebServer.this);
                        if (v4.equals("os390")) {
                            var5_10 = "${WEB_INSTALL_ROOT}";
                            CreateWebServer.access$1402(CreateWebServer.this, var5_10.concat("/conf/httpd.conf"));
                        } else if (CreateWebServer.access$1100(CreateWebServer.this).equals("IHS")) {
                            var5_10 = "${WEB_INSTALL_ROOT}";
                            CreateWebServer.access$1402(CreateWebServer.this, var5_10.concat("/conf/httpd.conf"));
                        } else {
                            CreateWebServer.access$1402(CreateWebServer.this, null);
                        }
                    }
                    v5 = CreateWebServer.access$1000(CreateWebServer.this);
                    CreateWebServer.access$2900(CreateWebServer.this);
                    if (v5.equals("windows")) break block44;
                    v6 = CreateWebServer.access$1000(CreateWebServer.this);
                    CreateWebServer.access$3000(CreateWebServer.this);
                    if (!v6.equals("os400")) break block45;
                }
                if (CreateWebServer.access$1100(CreateWebServer.this).equals("IHS")) {
                    CreateWebServer.this.serviceName = (String)this.getParameter(CreateWebServer.access$3100());
                    if (CreateWebServer.this.serviceName == null || CreateWebServer.this.serviceName.equals("")) {
                        v7 = CreateWebServer.access$1000(CreateWebServer.this);
                        CreateWebServer.access$3200(CreateWebServer.this);
                        if (v7.equals("windows")) {
                            CreateWebServer.this.serviceName = "IBMHTTPServer6.1";
                        }
                        v8 = CreateWebServer.access$1000(CreateWebServer.this);
                        CreateWebServer.access$3300(CreateWebServer.this);
                        if (v8.equals("os400")) {
                            CreateWebServer.this.serviceName = CreateWebServer.this.serverName;
                        }
                    }
                }
            }
            CreateWebServer.this.webProtocol = (String)this.getParameter(CreateWebServer.access$3400());
            if (CreateWebServer.this.webProtocol == null || CreateWebServer.this.webProtocol.equals("")) {
                CreateWebServer.this.webProtocol = "HTTP";
            }
            CreateWebServer.this.webAppMapping = (String)this.getParameter(CreateWebServer.access$3500());
            if (CreateWebServer.this.webAppMapping == null || CreateWebServer.this.webAppMapping.equals("")) {
                CreateWebServer.this.webAppMapping = "none";
            }
            CreateWebServer.access$1502(CreateWebServer.this, (String)this.getParameter(CreateWebServer.access$3600()));
            if (CreateWebServer.access$1500(CreateWebServer.this) == null || CreateWebServer.access$1500(CreateWebServer.this).equals("")) {
                if (CreateWebServer.access$1100(CreateWebServer.this).equals("IHS") || CreateWebServer.access$1100(CreateWebServer.this).equals("HTTPSERVER_ZOS")) {
                    var5_10 = "${WEB_INSTALL_ROOT}";
                    v9 = CreateWebServer.access$1000(CreateWebServer.this);
                    CreateWebServer.access$3700(CreateWebServer.this);
                    if (v9.equals("windows")) {
                        CreateWebServer.access$1502(CreateWebServer.this, var5_10.concat("/logs/error.log"));
                    } else {
                        CreateWebServer.access$1502(CreateWebServer.this, var5_10.concat("/logs/error_log"));
                    }
                } else {
                    CreateWebServer.access$1502(CreateWebServer.this, null);
                }
            }
            CreateWebServer.access$1602(CreateWebServer.this, (String)this.getParameter(CreateWebServer.access$3800()));
            if (CreateWebServer.access$1600(CreateWebServer.this) == null || CreateWebServer.access$1600(CreateWebServer.this).equals("")) {
                if (CreateWebServer.access$1100(CreateWebServer.this).equals("IHS")) {
                    var5_10 = "${WEB_INSTALL_ROOT}";
                    v10 = CreateWebServer.access$1000(CreateWebServer.this);
                    CreateWebServer.access$3900(CreateWebServer.this);
                    if (v10.equals("windows")) {
                        CreateWebServer.access$1602(CreateWebServer.this, var5_10.concat("/logs/access.log"));
                    } else {
                        CreateWebServer.access$1602(CreateWebServer.this, var5_10.concat("/logs/access_log"));
                    }
                } else {
                    CreateWebServer.access$1602(CreateWebServer.this, null);
                }
            }
        }
    }
}

