/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.webserver.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.MetadataNotAvailableException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.tools.UnmanagedNode;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.ObjectName;

public class CreateWebServerByHostName {
    private static String BUNDLE_NAME = "com.ibm.ws.management.webserver.resources.webserver";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private WorkSpace ws = null;
    private Session session = null;
    private String nodeName = null;
    private String webserverName = null;
    private String hostName = null;
    private String platform = null;
    private String templateName = null;
    private String serviceName = null;
    private String webInstallRoot = null;
    private String webProtocol = null;
    private String webAppMapping = null;
    private String pluginInstallRoot = null;
    private String errorLogfile = null;
    private String accessLogfile = null;
    private Integer webPort = null;
    private Integer adminPort = null;
    private String adminUserID = null;
    private String adminPasswd = null;
    private String adminProtocol = null;
    private boolean noError;
    private String cellName = null;
    private RepositoryContext cellContext = null;
    private RepositoryContext nodeContext = null;
    private static final String nodeXML = "node.xml";
    private static final String serverIndexXML = "serverindex.xml";
    static final String NODE_PROPERTIES = "node-metadata.properties";
    private Properties nodeProperties = new Properties();
    private static TraceComponent tc = Tr.register(CreateWebServerByHostName.class, "management", "com.ibm.ws.management.webserver");

    CreateWebServerByHostName(Session session, String string) throws WorkSpaceException, AdminException, IOException {
        this.session = session;
        this.ws = WorkspaceHelper.getWorkspace(session);
        this.cellName = null;
    }

    CreateWebServerByHostName(Session session, String string, String string2, String string3, String string4, Integer n, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, Integer n2, String string13, String string14, String string15) throws WorkSpaceException, FileNotFoundException, IOException, AdminException, ConnectorException, CommandValidationException {
        Object object;
        AdminCommand adminCommand;
        CommandMgr commandMgr;
        ObjectName objectName = null;
        Throwable throwable = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CreateWebServerByHostName()");
        }
        this.session = session;
        this.hostName = string;
        this.webserverName = string3;
        this.platform = string2;
        this.webProtocol = string7;
        this.webAppMapping = string8;
        this.webInstallRoot = string6;
        this.pluginInstallRoot = string9;
        this.serviceName = string5;
        this.errorLogfile = string11;
        this.accessLogfile = string12;
        this.webPort = n;
        this.adminPort = n2;
        this.adminUserID = string13;
        this.adminPasswd = string14;
        Object var21_21 = null;
        ConfigService configService = ConfigServiceFactory.getConfigService();
        this.ws = WorkspaceHelper.getWorkspace(session);
        ManagedObjectMetadataHelper managedObjectMetadataHelper = this.ws.getMetadataHelper();
        this.nodeName = CreateWebServerByHostName.getManagedNodefromHost(session, string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nodeName [" + this.nodeName + "]");
            Tr.debug(tc, "HostName [" + string + "]");
        }
        if (this.nodeName.equals("")) {
            this.nodeName = CreateWebServerByHostName.getUnmanagedNodefromHost(session, string);
        }
        if (this.nodeName == null || this.nodeName.equals("")) {
            this.nodeName = string + "-node";
            commandMgr = CommandMgr.getCommandMgr();
            adminCommand = commandMgr.createCommand("createUnmanagedNode");
            adminCommand.setConfigSession(session);
            adminCommand.setParameter("nodeName", this.nodeName);
            adminCommand.setParameter("hostName", string);
            adminCommand.setParameter("nodeOperatingSystem", string2);
            System.out.println("CreateUnmanagedNode  call createUnmanagedNode");
            adminCommand.execute();
            System.out.println("CreateUnamnagedNode  return createUnmanagedNode");
            objectName = null;
            throwable = null;
            if (!adminCommand.getCommandResult().isSuccessful()) {
                throwable = adminCommand.getCommandResult().getException();
                this.noError = false;
                System.out.println("ERROR");
                throw new AdminException(throwable);
            }
            object = (String)adminCommand.getCommandResult().getResult();
            System.out.println("NO ERROR");
            this.noError = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Ready to execute CreateWebServer command ");
        }
        commandMgr = CommandMgr.getCommandMgr();
        adminCommand = (TaskCommand)commandMgr.createCommand("createWebServer");
        adminCommand.setConfigSession(session);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "webserverName [" + string3 + "]");
            Tr.debug(tc, "nodeName [" + this.nodeName + "]");
            Tr.debug(tc, "templateName [" + string4 + "]");
        }
        adminCommand.setTargetObject(this.nodeName);
        adminCommand.setParameter("name", string3);
        adminCommand.setParameter("templateName", string4);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "templateName " + string4);
        }
        object = adminCommand.getCommandStep("serverConfig");
        object.setParameter("webPort", n);
        object.setParameter("serviceName", string5);
        object.setParameter("webInstallRoot", string6);
        object.setParameter("pluginInstallRoot", string9);
        object.setParameter("webProtocol", string7);
        object.setParameter("webAppMapping", string8);
        object.setParameter("configurationFile", string10);
        object.setParameter("errorLogfile", string11);
        object.setParameter("accessLogfile", string12);
        CommandStep commandStep = adminCommand.getCommandStep("remoteServerConfig");
        commandStep.setParameter("adminPort", n2);
        commandStep.setParameter("adminUserID", string13);
        commandStep.setParameter("adminPasswd", string14);
        commandStep.setParameter("adminProtocol", string15);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "call CreateWebServer command");
        }
        adminCommand.execute();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "return from CreateWebServer command");
        }
        objectName = null;
        throwable = null;
        if (!adminCommand.getCommandResult().isSuccessful()) {
            CreateWebServerByHostName.deleteNode(this.nodeName, configService, this.ws, session);
            throwable = adminCommand.getCommandResult().getException();
            System.out.println("ERROR " + throwable);
            this.noError = false;
            throw new CommandValidationException(throwable.toString());
        }
        objectName = (ObjectName)adminCommand.getCommandResult().getResult();
        this.noError = true;
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "CreateWebServerByHostName()-noError [" + this.noError + "]");
        }
    }

    public static String getServerNamefromHost(Session session, String string, String string2) throws ConfigServiceException, WorkSpaceException, ConnectorException, IOException, AdminException {
        String string3 = "";
        ObjectName objectName = null;
        WorkSpace workSpace = null;
        ConfigService configService = ConfigServiceFactory.getConfigService();
        workSpace = WorkspaceHelper.getWorkspace(session);
        ManagedObjectMetadataHelper managedObjectMetadataHelper = workSpace.getMetadataHelper();
        string3 = CreateWebServerByHostName.getManagedNodefromHost(session, string);
        if (string3.equals("")) {
            string3 = CreateWebServerByHostName.getUnmanagedNodefromHost(session, string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getserverNamefromHost - nodeName [" + string3 + "]");
        }
        if (!string3.equals("") && (objectName = configService.resolve(session, "Node=" + string3 + ":Server=" + string2)[0]) != null) {
            return string2;
        }
        return "";
    }

    public static String getNodefromHost(Session session, String string) throws ConfigServiceException, WorkSpaceException, ConnectorException, IOException, AdminException {
        String string2 = "";
        string2 = CreateWebServerByHostName.getManagedNodefromHost(session, string);
        if (string2.equals("") && (string2 = CreateWebServerByHostName.getUnmanagedNodefromHost(session, string)).equals("")) {
            return "";
        }
        return string2;
    }

    public static boolean deleteNode(String string, ConfigService configService, WorkSpace workSpace, Session session) throws WorkSpaceException, FileNotFoundException, IOException, AdminException, ConnectorException, CommandValidationException {
        boolean bl;
        block5: {
            ArrayList arrayList = null;
            Object var5_5 = null;
            Throwable throwable = null;
            bl = true;
            ManagedObjectMetadataHelper managedObjectMetadataHelper = workSpace.getMetadataHelper();
            try {
                arrayList = managedObjectMetadataHelper.getNodeDeployedFeatures(string);
                if (arrayList != null) {
                    bl = true;
                }
            }
            catch (MetadataNotAvailableException metadataNotAvailableException) {
                ObjectName[] objectNameArray = configService.resolve(session, "Node=" + string + ":Server=");
                System.out.println("# of WebServers " + objectNameArray.length);
                System.out.println("ServerList " + objectNameArray);
                if (objectNameArray.length >= 1) break block5;
                CommandMgr commandMgr = CommandMgr.getCommandMgr();
                AdminCommand adminCommand = commandMgr.createCommand("removeUnmanagedNode");
                adminCommand.setConfigSession(session);
                adminCommand.setParameter("nodeName", string);
                System.out.println("RemoveUnmanagedNode  call createUnmanagedNode");
                adminCommand.execute();
                System.out.println("RemoveUnamnagedNode  return createUnmanagedNode");
                var5_5 = null;
                throwable = null;
                if (!adminCommand.getCommandResult().isSuccessful()) {
                    throwable = adminCommand.getCommandResult().getException();
                    bl = false;
                    System.out.println("ERROR");
                    throw new AdminException(throwable);
                }
                String string2 = (String)adminCommand.getCommandResult().getResult();
                System.out.println("NO ERROR");
                bl = true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "deleteNode()-retr [" + bl + "]");
        }
        return bl;
    }

    public static String getManagedNodefromHost(Session session, String string) throws ConfigServiceException, WorkSpaceException, ConnectorException, IOException {
        InetAddress inetAddress = null;
        InetAddress inetAddress2 = null;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        ObjectName objectName = null;
        WorkSpace workSpace = null;
        ConfigService configService = ConfigServiceFactory.getConfigService();
        workSpace = WorkspaceHelper.getWorkspace(session);
        ManagedObjectMetadataHelper managedObjectMetadataHelper = workSpace.getMetadataHelper();
        System.out.println("getManagedNodefrom Host " + string);
        List list = UnmanagedNode.listManagedNodes(session);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            string4 = (String)iterator.next();
            objectName = configService.resolve(session, "Node=" + string4)[0];
            ObjectName objectName2 = configService.getRelationship(session, objectName, "ServerIndex")[0];
            String string5 = (String)configService.getAttribute(session, objectName2, "hostName");
            if (string.equalsIgnoreCase(string5)) {
                string2 = string5;
                break;
            }
            try {
                inetAddress2 = InetAddress.getByName(string5);
            }
            catch (UnknownHostException unknownHostException) {
                inetAddress2 = null;
                System.out.println("Can't get CanonicalName for nodehost " + string5);
            }
            if (string.equalsIgnoreCase("localhost")) {
                try {
                    inetAddress = InetAddress.getLocalHost();
                }
                catch (UnknownHostException unknownHostException) {
                    inetAddress = null;
                    System.out.println("Can't get CanonicalName for localhost " + string5);
                }
            } else {
                try {
                    inetAddress = InetAddress.getByName(string);
                }
                catch (UnknownHostException unknownHostException) {
                    inetAddress = null;
                    System.out.println("Can't get CanonicalName for hostname " + string);
                }
            }
            if (inetAddress2 == null || inetAddress == null || !inetAddress.equals(inetAddress2)) continue;
            string2 = string5;
            break;
        }
        string3 = string2 != null && !string2.equals("") ? string4 : "";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Return -Managed [" + string3 + "]");
        }
        return string3;
    }

    public static String getUnmanagedNodefromHost(Session session, String string) throws ConfigServiceException, WorkSpaceException, ConnectorException, IOException, AdminException {
        InetAddress inetAddress = null;
        InetAddress inetAddress2 = null;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        ArrayList arrayList = null;
        ObjectName objectName = null;
        WorkSpace workSpace = null;
        ConfigService configService = ConfigServiceFactory.getConfigService();
        workSpace = WorkspaceHelper.getWorkspace(session);
        ManagedObjectMetadataHelper managedObjectMetadataHelper = workSpace.getMetadataHelper();
        System.out.println("getUNmanagedNodefrom Host " + string);
        List list = UnmanagedNode.listUnmanagedNodes(session);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            objectName = configService.resolve(session, "Node=" + string3)[0];
            ObjectName objectName2 = configService.getRelationship(session, objectName, "ServerIndex")[0];
            String string7 = (String)configService.getAttribute(session, objectName2, "hostName");
            string2 = "";
            if (string.equalsIgnoreCase(string7)) {
                string2 = string7;
            } else {
                try {
                    inetAddress2 = InetAddress.getByName(string7);
                }
                catch (UnknownHostException unknownHostException) {
                    inetAddress2 = null;
                    System.out.println("Can't get CanonicalName for nodehost " + string7);
                }
                if (string.equalsIgnoreCase("localhost")) {
                    try {
                        inetAddress = InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException unknownHostException) {
                        inetAddress = null;
                        System.out.println("Can't get CanonicalName for localhost " + string7);
                    }
                } else {
                    try {
                        inetAddress = InetAddress.getByName(string);
                    }
                    catch (UnknownHostException unknownHostException) {
                        inetAddress = null;
                        System.out.println("Can't get CanonicalName for hostname " + string);
                    }
                }
                if (inetAddress2 != null && inetAddress != null && inetAddress.equals(inetAddress2)) {
                    string2 = string7;
                }
            }
            if (string2 == null || string2.equals("")) continue;
            try {
                arrayList = null;
                arrayList = managedObjectMetadataHelper.getNodeDeployedFeatures(string3);
            }
            catch (MetadataNotAvailableException metadataNotAvailableException) {
                string5 = string3;
            }
            if (arrayList == null) continue;
            string6 = string3;
        }
        if (string6 != null && !string6.equals("")) {
            string4 = string6;
        } else if (string5 != null && !string5.equals("")) {
            string4 = string5;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Return -Unmanaged [" + string4 + "]");
        }
        return string4;
    }

    public static boolean validateServer(Session session, String string, String string2, String string3, String string4) throws ConfigServiceException, CommandValidationException {
        Object object;
        Object object2;
        boolean bl = false;
        WorkSpace workSpace = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverName [" + string2 + "]");
            Tr.debug(tc, "HostName [" + string + "]");
        }
        boolean bl2 = false;
        String string5 = "";
        try {
            object2 = CreateWebServerByHostName.getManagedNodefromHost(session, string);
            if (((String)object2).equals("")) {
                object2 = CreateWebServerByHostName.getUnmanagedNodefromHost(session, string);
            }
            if (!((String)object2).equals("")) {
                object = WorkspaceHelper.getWorkspace(session);
                String string6 = CreateWebServerByHostName.getExistingNodePlatform(((String)object2).trim(), (WorkSpace)object);
                if (!string4.trim().equals(string6)) {
                    bl2 = true;
                    string5 = TraceNLS.getFormattedMessage(BUNDLE_NAME, "WADM0046E", new Object[]{string, string4, object2, string6}, null);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl2) {
            throw new CommandValidationException(string5);
        }
        object2 = ConfigServiceFactory.getConfigService();
        workSpace = WorkspaceHelper.getWorkspace(session);
        object = workSpace.getMetadataHelper();
        if (string3.equals("IHS")) {
            bl = false;
        } else if (string3.equals("APACHE")) {
            if (string4.equals("os390")) {
                bl = true;
            }
        } else if (string3.equals("IIS")) {
            if (!string4.equals("windows")) {
                bl = true;
            }
        } else if (string3.equals("DOMINO")) {
            if (!string4.equals("os400")) {
                bl = true;
            }
        } else if (string3.equals("SUNJAVASYSTEM")) {
            if (string4.equals("os400") || string4.equals("os390")) {
                bl = true;
            }
        } else if (string3.equals("HTTPSERVER_ZOS") && !string4.equals("os390")) {
            bl = true;
        }
        return bl;
    }

    public static String getExistingNodePlatform(String string, WorkSpace workSpace) {
        ManagedObjectMetadataHelper managedObjectMetadataHelper = workSpace.getMetadataHelper();
        try {
            return managedObjectMetadataHelper.getNodePlatformOS(string);
        }
        catch (Exception exception) {
            return "";
        }
    }
}

