/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.webserver.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.webserver.commands.CreateWebServerByHostName;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.wsspi.management.commands.server.DeleteServer;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DeleteWebServer
extends DeleteServer {
    private static TraceComponent tc = Tr.register(DeleteWebServer.class, "management", "com.ibm.ws.management.webserver");
    private boolean isItAWebServer = false;

    public DeleteWebServer(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public DeleteWebServer(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        block7: {
            ConfigService configService;
            Session session;
            String string = "";
            String string2 = "";
            try {
                session = this.getConfigSession();
                configService = this.getConfigService();
                string = (String)this.getParameter("nodeName");
                string2 = (String)this.getParameter("serverName");
                if (this.isServerAWebServer(string, string2, session, configService)) {
                    this.isItAWebServer = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                session = this.getConfigSession();
                configService = this.getConfigService();
                ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Cell");
                ObjectName objectName2 = configService.queryConfigObjects(session, null, objectName, null)[0];
                String string3 = ConfigServiceHelper.getDisplayName(objectName2);
                String string4 = (String)this.getParameter("nodeName");
                String string5 = (String)this.getParameter("serverName");
                String string6 = "(cell):" + string3 + ":(node):" + string4 + ":(server):" + string5;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ScopeName:" + string6);
                }
                this.deleteKeyStore("CMSKeyStore", string6, session, configService);
                String string7 = this.retrieveKeyStoreName(string4, string5, session, configService);
                if (!string7.equals("")) {
                    this.deleteKeyStore(string7, string6, session, configService);
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Received exception: " + throwable.getMessage());
            }
        }
    }

    public void taskCommandExecuted(boolean bl) {
        if (!bl || !this.isItAWebServer) {
            return;
        }
        String string = null;
        String string2 = null;
        try {
            string = (String)this.getParameter("nodeName");
            string2 = (String)this.getParameter("serverName");
        }
        catch (Exception exception) {
            return;
        }
        this.deleteUnmanagedNode(string, string2);
    }

    private boolean deleteKeyStore(String string, String string2, Session session, ConfigService configService) {
        block7: {
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            try {
                AdminCommand adminCommand = commandMgr.createCommand("deleteKeyStore");
                adminCommand.setConfigSession(session);
                adminCommand.setParameter("keyStoreName", string);
                adminCommand.setParameter("removeKeyStoreFile", Boolean.FALSE);
                adminCommand.setParameter("scopeName", string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deleteKeyStoreCmdCmd  call deleteKeyStore name " + string);
                }
                adminCommand.execute();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deleteKeyStoreCmd  return deleteKeyStore name " + string);
                }
                Throwable throwable = null;
                if (!adminCommand.getCommandResult().isSuccessful()) {
                    throwable = adminCommand.getCommandResult().getException();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Deletion of key store " + string + " is NOT successful. Received exception: " + throwable.getMessage());
                    }
                    return false;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Deletion of key store " + string + " successful");
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Received exception during keyFile delete: " + throwable.getMessage());
            }
        }
        return true;
    }

    private String retrieveKeyStoreName(String string, String string2, Session session, ConfigService configService) {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "retrieveKeyStoreName", new Object[]{string, string2});
            }
            ObjectName objectName = null;
            ObjectName[] objectNameArray = configService.resolve(session, "Node=" + string + ":Server=" + string2);
            if (objectNameArray.length == 1) {
                objectName = objectNameArray[0];
            }
            if (objectNameArray.length == 0) {
                return "";
            }
            AttributeList attributeList = configService.getAttributes(session, objectName, new String[]{"components"}, false);
            ObjectName objectName2 = null;
            List list = (List)((Attribute)attributeList.get(0)).getValue();
            Object object = list.iterator();
            while (object.hasNext()) {
                objectName2 = (ObjectName)object.next();
            }
            if (objectName2 == null) {
                return "";
            }
            object = null;
            object = configService.getAttributes(session, objectName2, new String[]{"keyStoreFiles"}, false);
            if (object == null) {
                return "";
            }
            if (((ArrayList)object).size() == 0) {
                return "";
            }
            List list2 = (List)((Attribute)((ArrayList)object).get(0)).getValue();
            ObjectName objectName3 = null;
            Object object2 = list2.iterator();
            while (object2.hasNext()) {
                objectName3 = (ObjectName)object2.next();
            }
            if (objectName3 == null) {
                return "";
            }
            object2 = (String)configService.getAttribute(session, objectName3, "name");
            if (object2 == null) {
                return "";
            }
            return object2;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private boolean deleteUnmanagedNode(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteUnmanagedNode", new Object[]{string, string2});
        }
        try {
            Session session = this.getConfigSession();
            ConfigService configService = this.getConfigService();
            if (this.isServerBaseOrExpress(string, session, configService) && this.getNumberOfServersOnNode(string, session) == 0) {
                WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
                CreateWebServerByHostName.deleteNode(string, configService, workSpace, session);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "deleteUnmanagedNode", "SUCCESS");
                }
                return true;
            }
        }
        catch (Exception exception) {
            System.out.println("Failed to delete Unmanaged node " + string + ". Exception: " + exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteUnmanagedNode", "Unmanaged node not deleted, either servers remain, or not on standalone node");
        }
        return false;
    }

    private boolean isServerAWebServer(String string, String string2, Session session, ConfigService configService) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerAWebServer", new Object[]{string, string2});
        }
        try {
            ObjectName[] objectNameArray = configService.resolve(session, "ServerEntry=" + string2);
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string3;
                ObjectName objectName = configService.getRelationship(session, objectNameArray[i], "parent")[0];
                ObjectName objectName2 = configService.getRelationship(session, objectName, "parent")[0];
                String string4 = (String)configService.getAttribute(session, objectNameArray[i], "serverType");
                if (string4 == null || string4.length() <= 0 || !string4.equals("WEB_SERVER") || !(string3 = (String)configService.getAttribute(session, objectName2, "name")).equals(string)) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isServerAWebServer", "true");
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerAWebServer", "false");
        }
        return false;
    }

    private boolean isServerBaseOrExpress(String string, Session session, ConfigService configService) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerBaseOrExpress", string);
        }
        try {
            String string2;
            ObjectName objectName;
            ObjectName objectName2 = configService.resolve(session, "Node=")[0];
            if (objectName2 != null && (objectName = configService.getRelationship(session, objectName2, "parent")[0]) != null && (string2 = (String)configService.getAttribute(session, objectName, "cellType")) != null && string2.equals("STANDALONE")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isServerBaseOrExpress", "true");
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerBaseOrExpress", "false");
        }
        return false;
    }

    private int getNumberOfServersOnNode(String string, Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNumberOfServersOnNode", string);
        }
        try {
            ConfigService configService = ConfigServiceFactory.getConfigService();
            ObjectName[] objectNameArray = configService.resolve(session, "Node=" + string + ":Server=");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNumberOfServersOnNode", String.valueOf(objectNameArray.length));
            }
            return objectNameArray.length;
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNumberOfServersOnNode", "1");
            }
            return 1;
        }
    }
}

