/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wlm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.ClusterDescription;
import com.ibm.websphere.cluster.topography.ClusterMemberDescription;
import com.ibm.websphere.cluster.topography.Contract;
import com.ibm.websphere.cluster.topography.DescriptionCallback;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.websphere.cluster.topography.DescriptionManager;
import com.ibm.websphere.cluster.topography.DescriptionManagerFactory;
import com.ibm.websphere.cluster.topography.DescriptionModificationListener;
import com.ibm.websphere.cluster.topography.KeyRepository;
import com.ibm.websphere.cluster.topography.KeyRepositoryFactory;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.wlm.ClusterData;
import com.ibm.websphere.management.wlm.ClusterMemberData;
import com.ibm.websphere.management.wlm.ClusterWeightTableEntry;
import com.ibm.websphere.wlm.exception.ClusterException;
import com.ibm.websphere.wlm.exception.InvalidParameterException;
import com.ibm.websphere.wlm.exception.InvalidRegistrationKeyException;
import com.ibm.websphere.wlm.exception.WeightTableEntryOutOfRangeException;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.cluster.topography.ClusterDescriptionImpl;
import com.ibm.ws.cluster.topography.ConcernImpl;
import com.ibm.ws.cluster.topography.ContractImpl;
import com.ibm.ws.cluster.topography.FormatImpl;
import com.ibm.ws.cluster.topography.TriggerInfoImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.management.wlm.ClusterMgr;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.wlm.TypeConversion;
import com.ibm.ws.wlm.dopriv.FileOutputStreamPrivileged;
import com.ibm.wsspi.cluster.ClusterManagement;
import com.ibm.wsspi.cluster.ClusterManagementFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class Cluster
implements DescriptionCallback,
DescriptionModificationListener {
    private static final TraceComponent tc = Tr.register(Cluster.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private int weightChgSeq = 1;
    private final int weightTableEntryStreamVersion = 0;
    private final int weightTableStreamVersion = 0;
    private final int selectionPolicyStreamVersion = 0;
    private final int backupCellNameStreamVersion = 0;
    private final int memberStateStreamVersion = 0;
    protected DefaultRuntimeCollaborator rtc = null;
    private String wlcID = null;
    private Long wlcKey = null;
    protected ClusterData cluster = null;
    public static final String ClusterMBeanType = "Cluster";
    public static final String wlmID = "com.ibm.ws.wlm.cluster";
    public static final String TYPE_USABLE = "cluster.member.usable";
    public static final String TYPE_UNUSABLE = "cluster.member.unusable";
    public static final String TYPE_CLUSTER_CONTROLLER_REGISTERED = "websphere.cluster.controller.registered";
    public static final String TYPE_CLUSTER_BACKUP_SET = "websphere.cluster.backup.set";
    private final String BackupClusterSubject = "BackupClusterSubject";
    private String ivBackupClusterSubject = null;
    private final String SelectionPolicySubject = "SelectionPolicySubject";
    private String ivSelectionPolicySubject = null;
    private final String MemberStateSubject = "MemberStateSubject";
    private String ivMemberStateSubject = null;
    private String ivRouteTableSubject = null;
    private String clusterKeyToString = null;
    private final String colon = ":";
    private final String runtime = "runtime";
    private final String config = "config";
    private String backupClusterName = null;
    private String backupHost = null;
    private Integer backupPort = new Integer(0);
    private KeyRepository keyRepository = KeyRepositoryFactory.getInstance().getKeyRepository();
    private DescriptionManager descMgr;
    private ClusterManagement ClusterMgmt;
    private ClusterDescription clusterDescription;
    private Set clusterNames;
    private Map memberKeyMapping;
    private byte[] ivWeightTableEntryStreamVersion;
    private byte[] ivWeightTableStreamVersion;
    private byte[] ivSelectionPolicyStreamVersion;
    private byte[] ivBackupCellNameStreamVersion;
    private byte[] ivMemberStateStreamVersion;
    private String state;
    private Map stateChangeQueue;
    private boolean rippleStart;
    private final String rippleStrt = "RippleStart";
    private boolean stopping;
    private final String stop = "Stop";
    private boolean starting;
    private final String start = "Start";
    private AdminService adminService;
    private long notifySeqNum;
    private static Integer NODE_AGENT_LISTENER;
    private static Integer DEPLOYMENT_MANAGER_LISTENER;
    protected static int ripplestartTimeoutWait;
    private static final int FIVE_MINUTES = 300000;
    private RippleStarter rippleObject;
    private String rippleMember;
    private ContextManager contextManager;
    private Object stateChangeMutex;

    public Cluster() {
        DescriptionManagerFactory.getInstance();
        this.descMgr = DescriptionManagerFactory.getDescriptionManager();
        this.ClusterMgmt = ClusterManagementFactory.getClusterManagement();
        this.clusterNames = new HashSet();
        this.memberKeyMapping = new HashMap();
        this.ivWeightTableEntryStreamVersion = new byte[4];
        this.ivWeightTableStreamVersion = new byte[4];
        this.ivSelectionPolicyStreamVersion = new byte[4];
        this.ivBackupCellNameStreamVersion = new byte[4];
        this.ivMemberStateStreamVersion = new byte[4];
        this.state = "websphere.cluster.stopped";
        this.stateChangeQueue = new HashMap();
        this.rippleStart = false;
        this.rippleStrt = "RippleStart";
        this.stopping = false;
        this.stop = "Stop";
        this.starting = false;
        this.start = "Start";
        this.adminService = null;
        this.notifySeqNum = 1L;
        this.rippleObject = null;
        this.rippleMember = null;
        this.contextManager = null;
        this.stateChangeMutex = new Object();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, ClusterMBeanType);
        }
        try {
            this.contextManager = ContextManagerFactory.getInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.wlm.Cluster.start", "291", this);
            Tr.service(tc, "WLMKEY_NOTIFICATION_ERROR", exception);
        }
        TypeConversion.intToBytes(0, this.ivWeightTableStreamVersion, 0);
        TypeConversion.intToBytes(0, this.ivWeightTableEntryStreamVersion, 0);
        TypeConversion.intToBytes(0, this.ivSelectionPolicyStreamVersion, 0);
        TypeConversion.intToBytes(0, this.ivBackupCellNameStreamVersion, 0);
        TypeConversion.intToBytes(0, this.ivMemberStateStreamVersion, 0);
        this.loadRippleStartTimeout();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, ClusterMBeanType);
        }
    }

    public Cluster(ClusterData clusterData) {
        DescriptionManagerFactory.getInstance();
        this.descMgr = DescriptionManagerFactory.getDescriptionManager();
        this.ClusterMgmt = ClusterManagementFactory.getClusterManagement();
        this.clusterNames = new HashSet();
        this.memberKeyMapping = new HashMap();
        this.ivWeightTableEntryStreamVersion = new byte[4];
        this.ivWeightTableStreamVersion = new byte[4];
        this.ivSelectionPolicyStreamVersion = new byte[4];
        this.ivBackupCellNameStreamVersion = new byte[4];
        this.ivMemberStateStreamVersion = new byte[4];
        this.state = "websphere.cluster.stopped";
        this.stateChangeQueue = new HashMap();
        this.rippleStart = false;
        this.rippleStrt = "RippleStart";
        this.stopping = false;
        this.stop = "Stop";
        this.starting = false;
        this.start = "Start";
        this.adminService = null;
        this.notifySeqNum = 1L;
        this.rippleObject = null;
        this.rippleMember = null;
        this.contextManager = null;
        this.stateChangeMutex = new Object();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, ClusterMBeanType, clusterData);
        }
        TypeConversion.intToBytes(0, this.ivWeightTableStreamVersion, 0);
        TypeConversion.intToBytes(0, this.ivWeightTableEntryStreamVersion, 0);
        TypeConversion.intToBytes(0, this.ivSelectionPolicyStreamVersion, 0);
        TypeConversion.intToBytes(0, this.ivBackupCellNameStreamVersion, 0);
        TypeConversion.intToBytes(0, this.ivMemberStateStreamVersion, 0);
        this.setClusterData(clusterData);
        this.loadRippleStartTimeout();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, ClusterMBeanType);
        }
    }

    protected void loadRippleStartTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadRippleStartTimeout");
        }
        ProcessProperties processProperties = ProcessProperties.getInstance();
        Integer n = new Integer(300000);
        try {
            n = Integer.valueOf((String)processProperties.get("IBM_CLUSTER_RIPPLESTART_NOTIFICATION_TIMEOUT"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ripplestartTimeoutWait = n;
        if (ripplestartTimeoutWait < 0) {
            ripplestartTimeoutWait = 0;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadRippleStartTimeout " + ripplestartTimeoutWait);
        }
    }

    protected synchronized void setClusterObjName(ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClusterObjName", objectName);
        }
        this.cluster.clusterObjectName = objectName;
        ClusterMemberData[] clusterMemberDataArray = this.cluster.clusterMembers;
        for (int i = 0; i < clusterMemberDataArray.length; ++i) {
            clusterMemberDataArray[i].clusterObjectName = objectName;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClusterObjName");
        }
    }

    protected synchronized void setMemberObjName(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMemberObjName", string);
        }
        for (int i = 0; i < this.cluster.clusterMembers.length; ++i) {
            ObjectName objectName;
            if (!string.equals(this.cluster.clusterMembers[i].memberName) || !string2.equals(this.cluster.clusterMembers[i].nodeName)) continue;
            this.cluster.clusterMembers[i].memberObjectName = objectName = ClusterMgr.getObjName(string, "Server", string2, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMemberObjName");
        }
    }

    protected synchronized void setMemberObjName(String string, String string2, ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMemberObjName", new Object[]{string, objectName});
        }
        for (int i = 0; i < this.cluster.clusterMembers.length; ++i) {
            if (!string.equals(this.cluster.clusterMembers[i].memberName) || !string2.equals(this.cluster.clusterMembers[i].nodeName)) continue;
            this.cluster.clusterMembers[i].memberObjectName = objectName;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMemberObjName");
        }
    }

    protected synchronized void setClusterData(ClusterData clusterData) {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setClusterData", clusterData);
            }
            this.cluster = clusterData;
            ProcessProperties processProperties = ProcessProperties.getInstance();
            processProperties.put(clusterData.clusterName, clusterData);
            try {
                Object object;
                Object object2;
                Object object3;
                AdminService adminService = AdminServiceFactory.getAdminService();
                String string = adminService.getCellName();
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                treeMap.put("CELLNAME", string);
                treeMap.put("CLUSTERNAME", clusterData.clusterName);
                DescriptionKey descriptionKey = null;
                try {
                    descriptionKey = this.keyRepository.getDescriptionKey(treeMap);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, Cluster.class.getName() + ".setClusterData", "432", this, new Object[]{treeMap, clusterData});
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "unexpected exception ", exception);
                    }
                    return;
                }
                this.clusterKeyToString = descriptionKey.toString();
                this.clusterNames.add(clusterData.clusterName);
                this.clusterDescription = (ClusterDescription)this.descMgr.getDescription(descriptionKey, ClusterDescription.class.getName());
                this.clusterDescription.registerNotificationListener(this, "type.cluster.weight.update", null);
                this.setPreferLocal(clusterData.preferLocal);
                ClusterManagement clusterManagement = ClusterManagementFactory.getClusterManagement();
                byte[][] byArrayArray = new byte[2][];
                byte[] byArray = new byte[]{clusterData.preferLocal != false ? (byte)0 : 1};
                if (this.ivSelectionPolicySubject == null) {
                    object3 = new StringBuffer();
                    ((StringBuffer)object3).append(this.clusterKeyToString);
                    ((StringBuffer)object3).append(":");
                    ((StringBuffer)object3).append("SelectionPolicySubject");
                    this.ivSelectionPolicySubject = ((StringBuffer)object3).toString();
                }
                byArrayArray[0] = this.ivSelectionPolicyStreamVersion;
                byArrayArray[1] = byArray;
                this.descMgr.publish(this.ivSelectionPolicySubject, TypeConversion.doubleToSingleBytes(byArrayArray));
                object3 = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object3);
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(clusterData.clusterMembers.length);
                for (int i = 0; i < clusterData.clusterMembers.length; ++i) {
                    object2 = new HashMap<String, String>(4);
                    object = clusterData.clusterMembers[i].nodeName;
                    String string2 = clusterData.clusterMembers[i].memberName;
                    object2.put("CELLNAME", string);
                    object2.put("NODENAME", object);
                    object2.put("MEMBERNAME", string2);
                    DescriptionKey descriptionKey2 = this.keyRepository.getDescriptionKey((Map)object2);
                    this.memberKeyMapping.put((String)object + ":" + string2, descriptionKey2);
                    processProperties.put(clusterData.clusterMembers[i].uniqueID, descriptionKey2);
                    Integer n = clusterData.clusterMembers[i].weightTableEntry.weight;
                    clusterManagement.setDesiredWeight(this.clusterDescription.getKey(), descriptionKey2, n);
                    this.keyRepository.exportToStream(dataOutputStream, descriptionKey2);
                    dataOutputStream.writeInt(n);
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.clusterKeyToString);
                stringBuffer.append(":");
                stringBuffer.append("config");
                object2 = stringBuffer.toString();
                object = ((ByteArrayOutputStream)object3).toByteArray();
                this.descMgr.publish((String)object2, (byte[])object);
                this.loadBackupConfig();
                this.setClusterDescriptionBackup(this.backupClusterName, this.backupHost, this.backupPort);
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException(classCastException, Cluster.class.getName() + ".setClusterData", "455", this, new Object[]{clusterData});
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, Cluster.class.getName() + ".setClusterData", "457", this, new Object[]{clusterData});
                if (!tc.isEventEnabled()) break block10;
                Tr.event(tc, "unexpected", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClusterData");
        }
    }

    protected ClusterData getClusterData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterData");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterData");
        }
        return this.cluster;
    }

    protected synchronized void removeMember(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeMember", string);
        }
        if (this.getClusterMember(string, string2) != null) {
            int n;
            ClusterWeightTableEntry[] clusterWeightTableEntryArray = new ClusterWeightTableEntry[this.cluster.weightTable.length - 1];
            ClusterMemberData[] clusterMemberDataArray = new ClusterMemberData[this.cluster.clusterMembers.length - 1];
            int n2 = 0;
            for (n = 0; n < this.cluster.weightTable.length; ++n) {
                if (this.cluster.weightTable[n].memberName.equals(string) && this.cluster.weightTable[n].nodeName.equals(string2)) continue;
                clusterWeightTableEntryArray[n2++] = this.cluster.weightTable[n];
            }
            n2 = 0;
            for (n = 0; n < this.cluster.clusterMembers.length; ++n) {
                if (this.cluster.clusterMembers[n].memberName.equals(string) && this.cluster.clusterMembers[n].nodeName.equals(string2)) continue;
                clusterMemberDataArray[n2++] = this.cluster.clusterMembers[n];
            }
            this.cluster.weightTable = clusterWeightTableEntryArray;
            this.cluster.clusterMembers = clusterMemberDataArray;
        } else if (tc.isEventEnabled()) {
            Tr.event(tc, "No matching member found", string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeMember");
        }
    }

    public void activate() {
        block2: {
            try {
                this.rtc = new DefaultRuntimeCollaborator(this);
                this.setClusterState();
                this.cluster.clusterObjectName = AdminServiceFactory.getMBeanFactory().activateMBean(ClusterMBeanType, this.rtc, this.cluster.clusterName, null);
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.wlm.ClusterMgr.activateCluster", "558", this);
                Tr.warning(tc, "WLMKEY_UNABLE_TO_ACTIVATE_CLUSTER_MBEAN", new Object[]{this.cluster.clusterName, adminException});
                if (!tc.isEventEnabled()) break block2;
                Tr.event(tc, "unable to activate the Cluster MBean", adminException);
            }
        }
    }

    public void deactivate() {
        block2: {
            try {
                AdminServiceFactory.getMBeanFactory().deactivateMBean(this.cluster.clusterObjectName);
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.wlm.ClusterMgr.loadRefreshClusters", "572", this);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, this.cluster.clusterObjectName + " MBean Deactivate Failed", adminException);
            }
        }
    }

    public String getClusterName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterName");
        }
        return this.cluster.clusterName;
    }

    public synchronized void setPreferLocal(Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPreferLocal", bl);
        }
        this.cluster.preferLocal = bl;
        if (bl.booleanValue()) {
            this.clusterDescription.setSelectionDescription(ClusterDescriptionImpl.WEIGHTED_PREFER_LOCAL);
        } else {
            this.clusterDescription.setSelectionDescription(ClusterDescriptionImpl.WEIGHTED);
        }
        byte[][] byArrayArray = new byte[2][];
        byArrayArray[0] = this.ivSelectionPolicyStreamVersion;
        byte[] byArray = new byte[]{bl != false ? (byte)0 : 1};
        if (this.ivSelectionPolicySubject == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.clusterKeyToString == null) {
                return;
            }
            stringBuffer.append(this.clusterKeyToString);
            stringBuffer.append(":");
            stringBuffer.append("SelectionPolicySubject");
            this.ivSelectionPolicySubject = stringBuffer.toString();
        }
        byArrayArray[1] = byArray;
        this.descMgr.publish(this.ivSelectionPolicySubject, TypeConversion.doubleToSingleBytes(byArrayArray));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPreferLocal");
        }
    }

    public Boolean getPreferLocal() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPreferLocal");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPreferLocal");
        }
        return this.cluster.preferLocal;
    }

    public String getWLCid() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWLCid");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWLCid");
        }
        return this.wlcID;
    }

    public ClusterMemberData[] getClusterMembers() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterMembers");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterMembers");
        }
        return this.cluster.clusterMembers;
    }

    public ClusterMemberData getClusterMember(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterMember", string);
        }
        ClusterMemberData clusterMemberData = null;
        for (int i = 0; i < this.cluster.clusterMembers.length; ++i) {
            if (!this.cluster.clusterMembers[i].memberName.equals(string) || !this.cluster.clusterMembers[i].nodeName.equals(string2)) continue;
            clusterMemberData = this.cluster.clusterMembers[i];
            break;
        }
        if (clusterMemberData == null && tc.isEventEnabled()) {
            Tr.event(tc, "No matching member found", string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterMember");
        }
        return clusterMemberData;
    }

    public ClusterWeightTableEntry[] getWeightTable() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWeightTable");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWeightTable", this.cluster.weightTable);
        }
        return this.cluster.weightTable;
    }

    public ClusterWeightTableEntry getWeightTableEntry(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWeightTableEntry", new Object[]{string, string2});
        }
        ClusterWeightTableEntry clusterWeightTableEntry = null;
        for (int i = 0; i < this.cluster.weightTable.length; ++i) {
            if (!this.cluster.weightTable[i].memberName.equals(string) || !this.cluster.weightTable[i].nodeName.equals(string2)) continue;
            clusterWeightTableEntry = this.cluster.weightTable[i];
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWeightTableEntry", clusterWeightTableEntry.weight);
        }
        return clusterWeightTableEntry;
    }

    public synchronized void setWeightTable(Long l, ClusterWeightTableEntry[] clusterWeightTableEntryArray) throws ClusterException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setWeightTable", clusterWeightTableEntryArray);
        }
        if (this.wlcKey != null && l.equals(this.wlcKey)) {
            int n;
            if (this.cluster.weightTable.length != clusterWeightTableEntryArray.length) {
                throw new InvalidParameterException("Invalid weight table - length mismatch. \nCluster weight table length = " + this.cluster.weightTable.length + "\nProvided weight table length = " + clusterWeightTableEntryArray.length);
            }
            for (n = 0; n < clusterWeightTableEntryArray.length; ++n) {
                if (this.getClusterMember(clusterWeightTableEntryArray[n].memberName, clusterWeightTableEntryArray[n].nodeName) == null) {
                    throw new InvalidParameterException("Invalid weight table - member mismatch. \nMember name: " + clusterWeightTableEntryArray[n].memberName + ", not found in cluster.");
                }
                Integer n2 = clusterWeightTableEntryArray[n].weight;
                if (n2 == null) {
                    throw new InvalidParameterException("Invalid weight table entry #" + n + ", weight value is NULL");
                }
                if (n2 >= 0) continue;
                throw new WeightTableEntryOutOfRangeException("Invalid weight table entry #" + n + ", " + n2 + " not in range");
            }
            this.cluster.weightTable = clusterWeightTableEntryArray;
            block3: for (n = 0; n < clusterWeightTableEntryArray.length; ++n) {
                ClusterWeightTableEntry clusterWeightTableEntry = clusterWeightTableEntryArray[n];
                for (int i = 0; i < this.cluster.clusterMembers.length; ++i) {
                    if (!clusterWeightTableEntry.memberName.equals(this.cluster.clusterMembers[i].memberName) || !clusterWeightTableEntry.nodeName.equals(this.cluster.clusterMembers[i].nodeName)) continue;
                    if (this.cluster.clusterMembers[i].weightTableEntry.weight.equals(clusterWeightTableEntry.weight)) continue block3;
                    this.cluster.clusterMembers[i].weightTableEntry = clusterWeightTableEntry;
                    DescriptionKey descriptionKey = (DescriptionKey)this.memberKeyMapping.get(clusterWeightTableEntry.nodeName + ":" + clusterWeightTableEntry.memberName);
                    ClusterManagement clusterManagement = ClusterManagementFactory.getClusterManagement();
                    if (descriptionKey == null) continue block3;
                    clusterManagement.setDesiredWeight(this.clusterDescription.getKey(), descriptionKey, clusterWeightTableEntry.weight);
                    continue block3;
                }
            }
            try {
                Notification notification = new Notification("websphere.cluster.weight.table.change", this.cluster.clusterObjectName, this.weightChgSeq++);
                notification.setUserData(this.cluster.weightTable);
                this.rtc.sendNotification(notification);
            }
            catch (MBeanException mBeanException) {
                FFDCFilter.processException(mBeanException, "com.ibm.ws.management.wlm.Cluster.setWeightTable", "883", this, new Object[]{this.rtc, l, clusterWeightTableEntryArray});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "weight table change notification failure", mBeanException);
                }
            }
        } else {
            throw new InvalidRegistrationKeyException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setWeightTable");
        }
    }

    public synchronized void setWeightTableEntry(Long l, ClusterWeightTableEntry clusterWeightTableEntry) throws ClusterException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setWeightTableEntry", clusterWeightTableEntry);
        }
        if (this.wlcKey != null && l.equals(this.wlcKey)) {
            String string = clusterWeightTableEntry.memberName;
            String string2 = clusterWeightTableEntry.nodeName;
            Integer n = clusterWeightTableEntry.weight;
            ClusterWeightTableEntry clusterWeightTableEntry2 = this.getWeightTableEntry(string, string2);
            if (clusterWeightTableEntry2 == null) {
                throw new InvalidParameterException("Invalid weight table entry - member mismatch. \nMember name: " + string + ", not found in weight table.");
            }
            ClusterMemberData clusterMemberData = this.getClusterMember(string, string2);
            if (this.getClusterMember(string, string2) == null) {
                throw new InvalidParameterException("Invalid weight table entry - member mismatch. \nMember name: " + string + ", not found in cluster.");
            }
            if (n == null) {
                throw new InvalidParameterException("Invalid weight table entry, weight value is NULL");
            }
            if (n < 0) {
                throw new WeightTableEntryOutOfRangeException("Invalid weight table entry, weight value=" + n + " out of valid range");
            }
            if (!clusterMemberData.weightTableEntry.weight.equals(clusterWeightTableEntry.weight)) {
                for (int i = 0; i < this.cluster.weightTable.length; ++i) {
                    if (!string.equals(this.cluster.weightTable[i].memberName) || !string2.equals(this.cluster.weightTable[i].nodeName)) continue;
                    this.cluster.weightTable[i] = clusterWeightTableEntry;
                    break;
                }
                clusterMemberData.weightTableEntry = clusterWeightTableEntry;
                DescriptionKey descriptionKey = (DescriptionKey)this.memberKeyMapping.get(string2 + ":" + string);
                ClusterManagement clusterManagement = ClusterManagementFactory.getClusterManagement();
                if (descriptionKey != null) {
                    clusterManagement.setDesiredWeight(this.clusterDescription.getKey(), descriptionKey, n);
                }
                try {
                    Notification notification = new Notification("websphere.cluster.weight.table.entry.change", this.cluster.clusterObjectName, this.weightChgSeq++);
                    notification.setUserData(clusterWeightTableEntry);
                    this.rtc.sendNotification(notification);
                }
                catch (MBeanException mBeanException) {
                    FFDCFilter.processException(mBeanException, "com.ibm.ws.management.wlm.Cluster.setWeightTable", "1032", this, new Object[]{this.rtc, l, clusterWeightTableEntry});
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "weight table entry change notification failure", mBeanException);
                    }
                }
            }
        } else {
            throw new InvalidRegistrationKeyException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setWeightTableEntry");
        }
    }

    public Long register(String string) throws ClusterException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "register", string);
        }
        if (string == null) {
            throw new InvalidParameterException("Workload Controller name parameter is NULL");
        }
        if (string.equals(this.wlcID)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "register");
            }
            return this.wlcKey;
        }
        String string2 = this.wlcID;
        this.wlcID = string;
        this.wlcKey = new Long(new Date().getTime());
        if (string2 == null) {
            Tr.audit(tc, "WLMKEY_WLC_REGISTRATION_NEW", new Object[]{this.cluster.clusterName, this.wlcID});
        } else {
            Tr.audit(tc, "WLMKEY_WLC_REGISTRATION_UPDATE", new Object[]{this.cluster.clusterName, string2, this.wlcID});
        }
        Notification notification = new Notification(TYPE_CLUSTER_CONTROLLER_REGISTERED, this.cluster.clusterObjectName, -1L);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("clusterName", this.cluster.clusterName);
        hashMap.put("wlcName", string);
        notification.setUserData(hashMap);
        try {
            this.rtc.sendNotification(notification);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, Cluster.class.getName() + ".register", "1080", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "register");
        }
        return this.wlcKey;
    }

    public ClusterData refresh() throws ClusterException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refresh");
        }
        ClusterData clusterData = this.cluster;
        AdminService adminService = AdminServiceFactory.getAdminService();
        ObjectName objectName = ClusterMgr.getObjName("ClusterMgr", "ClusterMgr", adminService.getNodeName(), adminService.getProcessName());
        if (objectName != null) {
            try {
                clusterData = (ClusterData)adminService.invoke(objectName, "retrieveCluster", new Object[]{this.cluster.clusterName}, new String[]{"java.lang.String"});
            }
            catch (JMException jMException) {
                FFDCFilter.processException(jMException, "com.ibm.ws.management.wlm.Cluster.refresh", "1108", this, new Object[]{objectName, adminService, clusterData});
                throw new ClusterException(jMException);
            }
        } else {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "could not find ClusterMgr MBean");
            }
            throw new ClusterException("could not find ClusterMgr MBean");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refresh");
        }
        return clusterData;
    }

    public String getBackupName() {
        return this.backupClusterName;
    }

    public String getBackupBootstrapHost() {
        return this.backupHost;
    }

    public Integer getBackupBootstrapPort() {
        return this.backupPort;
    }

    public synchronized void setBackup(String string, String string2, Integer n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setBackup", new Object[]{string, string2, n});
        }
        this.setClusterDescriptionBackup(string, string2, n);
        this.backupClusterName = string;
        this.backupHost = string2;
        this.backupPort = n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setBackup", this);
        }
    }

    private void setClusterDescriptionBackup(String string, String string2, Integer n) {
        Serializable serializable;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setClusterDescriptionBackup", new Object[]{string, string2, n});
            }
            if (string == null || string.trim().equals("")) {
                this.clusterDescription.setBackupCluster(null);
            } else {
                this.validateBackupParms(string, string2, n);
                try {
                    serializable = new ContractImpl();
                    serializable.addEvent(TriggerInfoImpl.TRIGGER_STRUCTURE);
                    serializable.setInterest(new ConcernImpl(Integer.MAX_VALUE));
                    this.descMgr.lookupClusterCallback(string, (Contract)serializable, new URL("http", string2, n, "/ClusterRegistrarService"), this, string2);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, Cluster.class.getName() + ".setClusterDescriptionBackup", "1193", this, new Object[]{string, string2, n});
                    if (!tc.isEventEnabled()) break block9;
                    Tr.event(tc, "unexpected", exception);
                }
            }
        }
        if (this.cluster.clusterObjectName != null) {
            serializable = new Notification(TYPE_CLUSTER_BACKUP_SET, this.cluster.clusterObjectName, -1L);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("clusterName", string);
            hashMap.put("host", string2);
            hashMap.put("port", n);
            ((Notification)serializable).setUserData(hashMap);
            try {
                this.rtc.sendNotification((Notification)serializable);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, Cluster.class.getName() + ".setBackup", "1224", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClusterDescriptionBackup");
        }
    }

    private void validateBackupParms(String string, String string2, Integer n) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateBackupParms", new Object[]{string, string2, n});
        }
        if (string != null && !string.trim().equals("")) {
            if (!this.clusterNames.contains(string)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateBackupParms", new Object[]{"Extended cluster and it's backup cluster must have the same name."});
                }
                throw new IllegalArgumentException("Backup Cluster " + string + " does not have the same name as its primary cluster.");
            }
            if (string2 == null || string2.trim().equals("")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateBackupParms", new Object[]{"Host name must be set for backup cluster.", string, string2});
                }
                throw new IllegalArgumentException("Host name must be set for backup cluster " + string);
            }
            if (n == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateBackupParms", new Object[]{"Port must be set for backup cluster.", string, n});
                }
                throw new IllegalArgumentException("Port must be set for backup cluster " + string);
            }
            if (n < 1) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateBackupParms", new Object[]{"Port for backup cluster is not valid.", string, n});
                }
                throw new IllegalArgumentException("Backup cluster port must be greater than 0");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateBackupParms");
        }
    }

    public void receiveClusterDescription(ClusterDescription clusterDescription, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receiveClusterDescription", new Object[]{clusterDescription, object});
        }
        if (object != null && object == this.backupHost) {
            try {
                this.clusterDescription.setBackupCluster(clusterDescription);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, Cluster.class.getName() + ".receiveClusterDescription", "1302", this, new Object[]{clusterDescription, object});
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "unexpected", exception);
                }
            }
        } else if (tc.isEventEnabled()) {
            Tr.event(tc, "Returned cluster is not for the current backup cluster.", new Object[]{clusterDescription, object, this.backupClusterName, this.backupHost, this.backupPort});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receiveClusterDescription", this);
        }
    }

    /*
     * Exception decompiling
     */
    private synchronized void loadBackupConfig() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setAvailable(String string, String string2) throws InvalidAttributeValueException {
        Serializable serializable;
        DescriptionKey descriptionKey;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAvailable", new Object[]{string, string2});
        }
        if ((descriptionKey = (DescriptionKey)this.memberKeyMapping.get(string2 + ":" + string)) == null) {
            throw new InvalidAttributeValueException("Invalid member " + string2 + " " + string + ".");
        }
        ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)this.descMgr.getDescription(descriptionKey);
        if (clusterMemberDescription == null) {
            throw new InvalidAttributeValueException("Description for member " + string2 + " " + string + " not found.");
        }
        clusterMemberDescription.setState((byte)0);
        byte[][] byArrayArray = new byte[][]{this.ivMemberStateStreamVersion, this.serializeKey(descriptionKey), {0}};
        if (this.ivMemberStateSubject == null) {
            if (this.clusterKeyToString != null) {
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append(this.clusterKeyToString);
                ((StringBuffer)serializable).append(":");
                ((StringBuffer)serializable).append("MemberStateSubject");
                this.ivMemberStateSubject = ((StringBuffer)serializable).toString();
            } else {
                return;
            }
        }
        this.descMgr.publish(this.ivMemberStateSubject, TypeConversion.doubleToSingleBytes(byArrayArray));
        serializable = new Notification(TYPE_USABLE, this.cluster.clusterObjectName, -1L);
        ((Notification)serializable).setUserData(new String[]{this.cluster.clusterName, string2, string});
        try {
            this.rtc.sendNotification((Notification)serializable);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, Cluster.class.getName() + ".setAvailable", "1481", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAvailable");
        }
    }

    public void setUnavailable(String string, String string2) throws InvalidAttributeValueException {
        Serializable serializable;
        DescriptionKey descriptionKey;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setUnavailable", new Object[]{string, string2});
        }
        if ((descriptionKey = (DescriptionKey)this.memberKeyMapping.get(string2 + ":" + string)) == null) {
            throw new InvalidAttributeValueException("Invalid member " + string2 + " " + string + ".");
        }
        ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)this.descMgr.getDescription(descriptionKey);
        if (clusterMemberDescription == null) {
            throw new InvalidAttributeValueException("Description for member " + string2 + " " + string + " not found.");
        }
        clusterMemberDescription.setState((byte)2);
        byte[][] byArrayArray = new byte[][]{this.ivMemberStateStreamVersion, this.serializeKey(descriptionKey), {2}};
        if (this.ivMemberStateSubject == null) {
            if (this.clusterKeyToString != null) {
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append(this.clusterKeyToString);
                ((StringBuffer)serializable).append(":");
                ((StringBuffer)serializable).append("MemberStateSubject");
                this.ivMemberStateSubject = ((StringBuffer)serializable).toString();
            } else {
                return;
            }
        }
        this.descMgr.publish(this.ivMemberStateSubject, TypeConversion.doubleToSingleBytes(byArrayArray));
        serializable = new Notification(TYPE_UNUSABLE, this.cluster.clusterObjectName, -1L);
        ((Notification)serializable).setUserData(new String[]{this.cluster.clusterName, string2, string});
        try {
            this.rtc.sendNotification((Notification)serializable);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, Cluster.class.getName() + ".setUnavailable", "1525", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setUnavailable");
        }
    }

    public Boolean getAvailable(String string, String string2) throws InvalidAttributeValueException {
        DescriptionKey descriptionKey;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAvailable", new Object[]{string, string2});
        }
        if ((descriptionKey = (DescriptionKey)this.memberKeyMapping.get(string2 + ":" + string)) == null) {
            throw new InvalidAttributeValueException("Invalid member " + string2 + " " + string + ".");
        }
        ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)this.descMgr.getDescription(descriptionKey);
        byte by = ((ClusterMemberDescription.Memento)clusterMemberDescription.getMemento()).getState();
        if (tc.isEventEnabled()) {
            Tr.event(tc, "state is " + by);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAvailable");
        }
        return new Boolean(by == 0);
    }

    private ClusterMemberDescription getMember(String string, String string2) throws InvalidAttributeValueException {
        if (string == null || string.length() == 0) {
            throw new InvalidAttributeValueException("The memberName attribute, " + string + ", is invalid.");
        }
        if (string2 == null || string2.length() == 0) {
            throw new InvalidAttributeValueException("The nodeName attribute, " + string2 + ", is invalid.");
        }
        DescriptionKey descriptionKey = (DescriptionKey)this.memberKeyMapping.get(string2 + ":" + string);
        ClusterMemberDescription clusterMemberDescription = null;
        if (descriptionKey != null) {
            DescriptionManagerFactory.getInstance();
            clusterMemberDescription = (ClusterMemberDescription)DescriptionManagerFactory.getDescriptionManager().getDescription(descriptionKey);
        }
        if (clusterMemberDescription == null) {
            throw new InvalidAttributeValueException("The memberName, " + string + ", and nodeName, " + string2 + ", do not match any server in the cluster " + this.cluster.clusterName + ".");
        }
        return clusterMemberDescription;
    }

    private byte[] serializeKey(DescriptionKey descriptionKey) {
        byte[] byArray;
        block2: {
            byArray = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                this.keyRepository.exportToStream(objectOutputStream, descriptionKey);
                objectOutputStream.flush();
                byteArrayOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                objectOutputStream.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, Cluster.class.getName() + ".serializeKey", "1572", this, new Object[]{descriptionKey});
                if (!tc.isEventEnabled()) break block2;
                Tr.event(tc, "unexpected", exception);
            }
        }
        return byArray;
    }

    public String toString() {
        return super.toString() + "[" + this.backupClusterName + ":" + this.backupHost + ":" + this.backupPort + "]";
    }

    public void receiveBackupCellName(String string) {
        Object object;
        if (this.ivBackupClusterSubject == null) {
            object = new StringBuffer();
            if (this.clusterKeyToString == null) {
                return;
            }
            ((StringBuffer)object).append(this.clusterKeyToString);
            ((StringBuffer)object).append(":");
            ((StringBuffer)object).append(this.BackupClusterSubject);
            this.ivBackupClusterSubject = ((StringBuffer)object).toString();
        }
        object = new byte[2][];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(":");
        stringBuffer.append(this.cluster.clusterName);
        object[0] = this.ivBackupCellNameStreamVersion;
        object[1] = stringBuffer.toString().getBytes();
        this.descMgr.publish(this.ivBackupClusterSubject, TypeConversion.doubleToSingleBytes((byte[][])object));
    }

    public String exportRouteTable() {
        String string = ClusterMgr.configPath + File.separator + "clusters" + File.separator + this.cluster.clusterName + File.separator + this.cluster.clusterName + ".wsrttbl";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "exportRouteTable", string);
        }
        try {
            FileOutputStreamPrivileged fileOutputStreamPrivileged = new FileOutputStreamPrivileged(string);
            FileOutputStream fileOutputStream = (FileOutputStream)AccessController.doPrivileged(fileOutputStreamPrivileged);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            ConcernImpl concernImpl = new ConcernImpl(Integer.MAX_VALUE);
            FormatImpl formatImpl = new FormatImpl(concernImpl, 3);
            this.clusterDescription.exportToStream(objectOutputStream, formatImpl);
            objectOutputStream.flush();
            fileOutputStream.flush();
            return string;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, Cluster.class.getName() + ".exportRouteTable", "1637", this, new Object[]{string});
            Tr.error(tc, "NLSKEY_UNEXPECTED_EXCEPTION", new Object[]{"exportRouteTable", exception});
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unexpected exception", new Object[]{string, exception});
            }
            return null;
        }
    }

    public void handleNotification(DescriptionKey descriptionKey, String string, Object object, Object object2) {
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleNotification", new Object[]{descriptionKey, string, object, object2});
            }
            if (descriptionKey != null) {
                try {
                    DescriptionKey descriptionKey2 = (DescriptionKey)object;
                    ClusterMemberDescription clusterMemberDescription = (ClusterMemberDescription)this.descMgr.getDescription(descriptionKey2, ClusterMemberDescription.class.getName());
                    for (int i = 0; i < this.cluster.weightTable.length; ++i) {
                        DescriptionKey descriptionKey3;
                        String string2 = this.cluster.weightTable[i].memberName;
                        String string3 = this.cluster.weightTable[i].nodeName;
                        DescriptionKey descriptionKey4 = (DescriptionKey)this.memberKeyMapping.get(string3 + ":" + string2);
                        if (descriptionKey4 != (descriptionKey3 = clusterMemberDescription.getKey())) continue;
                        ClusterWeightTableEntry clusterWeightTableEntry = this.cluster.weightTable[i];
                        clusterWeightTableEntry.weight = new Integer(this.ClusterMgmt.getDesiredWeight(this.clusterDescription.getKey(), descriptionKey3));
                        Notification notification = new Notification("websphere.cluster.weight.table.entry.change", this.cluster.clusterObjectName, this.weightChgSeq++);
                        notification.setUserData(clusterWeightTableEntry);
                        this.rtc.sendNotification(notification);
                        this.cluster.weightTable[i] = clusterWeightTableEntry;
                        for (int j = 0; j < this.cluster.clusterMembers.length; ++j) {
                            if (!string2.equals(this.cluster.clusterMembers[i].memberName) || !string3.equals(this.cluster.clusterMembers[i].nodeName)) continue;
                            this.cluster.clusterMembers[i].weightTableEntry = clusterWeightTableEntry;
                            break block15;
                        }
                        break;
                    }
                }
                catch (MBeanException mBeanException) {
                    FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.management.wlm.Cluster.handleNotification", "1666", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "weight table entry change notification failure", mBeanException);
                    }
                }
                catch (InstantiationException instantiationException) {
                    FFDCFilter.processException((Throwable)instantiationException, "com.ibm.ws.management.wlm.Cluster.handleNotification", "1666", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "weight table entry change notification failure", instantiationException);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.management.wlm.Cluster.handleNotification", "1666", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "weight table entry change notification failure", illegalAccessException);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    FFDCFilter.processException((Throwable)invocationTargetException, "com.ibm.ws.management.wlm.Cluster.handleNotification", "1666", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "weight table entry change notification failure", invocationTargetException);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    FFDCFilter.processException((Throwable)noSuchMethodException, "com.ibm.ws.management.wlm.Cluster.handleNotification", "1666", this);
                    if (!tc.isDebugEnabled()) break block15;
                    Tr.debug(tc, "weight table entry change notification failure", noSuchMethodException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    public String getState() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getState");
            Tr.exit(tc, "getState", this.state);
        }
        return this.state;
    }

    private synchronized void setState(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setState", string);
        }
        this.state = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setState");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws ClusterException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start " + this.getClusterName());
        }
        ClusterMemberData[] clusterMemberDataArray = this;
        synchronized (this) {
            if ("websphere.cluster.running".equals(this.state)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cluster " + this.getClusterName() + " already in the running state");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "start " + this.getClusterName());
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            try {
                this.throwException("Start");
            }
            catch (ClusterException clusterException) {
                FFDCFilter.processException((Throwable)clusterException, "com.ibm.ws.management.wlm.ClusterAdmin.start", "232", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "start - failed other operation already in progress");
                }
                throw clusterException;
            }
            this.starting = true;
            this.stateChangeQueue.clear();
            this.setStateAndNotify("websphere.cluster.starting");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            AdminHelper.getInstance().audit("ADMN1012I", "ADMN1013I", new Object[]{this.getClusterName(), null});
            clusterMemberDataArray = this.getClusterMembers();
            ClusterMemberData clusterMemberData = null;
            Object var3_5 = null;
            if (clusterMemberDataArray != null) {
                boolean bl = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cluster members size=" + clusterMemberDataArray.length);
                }
                for (int i = 0; i < clusterMemberDataArray.length; ++i) {
                    clusterMemberData = clusterMemberDataArray[i];
                    String string = ClusterMgr.getDomainName() + ":*,type=" + "NodeAgent" + ",node=" + clusterMemberData.nodeName;
                    ObjectName objectName = ClusterMgr.getObjectName(string);
                    String string2 = clusterMemberData.nodeName + ":" + clusterMemberData.memberName;
                    if (objectName != null) {
                        bl = true;
                        Thread thread = new Thread((Cluster)this.new MemberStateChange((Cluster)this, clusterMemberData, objectName, "start"));
                        thread.setDaemon(true);
                        thread.start();
                        this.stateChangeQueue.put(string2, thread);
                        continue;
                    }
                    Tr.warning(tc, "WLMKEY_NODEAGENT_NOT_STARTED", clusterMemberData.memberName);
                }
                if (!bl) {
                    this.starting = false;
                    if (!"websphere.cluster.stopped".equals(this.getState())) {
                        super.setStateAndNotify("websphere.cluster.stopped");
                    }
                } else if (!"websphere.cluster.running".equals(this.getState())) {
                    super.setStateAndNotify("websphere.cluster.partial.start");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The cluster has no members");
                }
                this.starting = false;
                super.setStateAndNotify("websphere.cluster.stopped");
                throw new ClusterException("There are no cluster members to start");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "start " + this.getClusterName());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void launchMember(ClusterMemberData clusterMemberData, ObjectName objectName) throws ClusterException {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "launchMember " + clusterMemberData.memberName);
            }
            try {
                if (clusterMemberData.memberObjectName != null) break block10;
                try {
                    Object[] objectArray;
                    if (objectName == null) {
                        objectArray = ClusterMgr.getDomainName() + ":*,type=" + "NodeAgent" + ",node=" + clusterMemberData.nodeName;
                        objectName = ClusterMgr.getObjectName((String)objectArray);
                    }
                    if (objectName != null) {
                        objectArray = new Object[]{clusterMemberData.memberName};
                        String[] stringArray = new String[]{"java.lang.String"};
                        this.getAdminService().invoke(objectName, "launchProcess", objectArray, stringArray);
                        break block10;
                    }
                    Tr.warning(tc, "WLMKEY_NODEAGENT_NOT_STARTED", clusterMemberData.memberName);
                    throw new ClusterException("The NodeAgent is not available.");
                }
                catch (JMException jMException) {
                    FFDCFilter.processException((Throwable)jMException, "com.ibm.ws.management.wlm.ClusterAdmin.start", "338", this);
                    Tr.error(tc, "WLMKEY_CLUSTER_MEMBER_START_FAILED", new Object[]{clusterMemberData.memberName, jMException});
                    throw new ClusterException("The cluster can not be started", jMException);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.wlm.ClusterAdmin.start", "344", this);
                    Tr.error(tc, "WLMKEY_CLUSTER_MEMBER_START_FAILED", new Object[]{clusterMemberData.memberName, exception});
                    throw new ClusterException("The cluster can not be started", exception);
                }
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "launchMember " + clusterMemberData.memberName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws ClusterException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop " + this.getClusterName());
        }
        ClusterMemberData[] clusterMemberDataArray = this;
        synchronized (this) {
            if ("websphere.cluster.stopped".equals(this.state)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cluster " + this.getClusterName() + " already in the stopped state");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "stop " + this.getClusterName());
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            try {
                this.throwException("Stop");
            }
            catch (ClusterException clusterException) {
                FFDCFilter.processException((Throwable)clusterException, "com.ibm.ws.management.wlm.ClusterAdmin.stop", "380", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "stop - failed other operation already in progress");
                }
                throw clusterException;
            }
            this.stopping = true;
            this.stateChangeQueue.clear();
            this.setStateAndNotify("websphere.cluster.stopping");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            AdminHelper.getInstance().audit("ADMN1014I", "ADMN1015I", new Object[]{this.getClusterName(), null});
            clusterMemberDataArray = this.getClusterMembers();
            ClusterMemberData clusterMemberData = null;
            Object var3_5 = null;
            if (clusterMemberDataArray != null) {
                boolean bl = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cluster members size = " + clusterMemberDataArray.length);
                }
                for (int i = 0; i < clusterMemberDataArray.length; ++i) {
                    clusterMemberData = clusterMemberDataArray[i];
                    String string = clusterMemberData.nodeName + ":" + clusterMemberData.memberName;
                    bl = true;
                    Thread thread = new Thread((Cluster)this.new MemberStateChange((Cluster)this, clusterMemberData, null, "stop"));
                    thread.setDaemon(true);
                    thread.start();
                    this.stateChangeQueue.put(string, thread);
                }
                if (!bl) {
                    this.stopping = false;
                    if (!"websphere.cluster.stopped".equals(this.getState())) {
                        super.setStateAndNotify("websphere.cluster.stopped");
                    }
                } else if (!"websphere.cluster.running".equals(this.getState())) {
                    super.setStateAndNotify("websphere.cluster.partial.stop");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The cluster has no members");
                }
                this.stopping = false;
                super.setStateAndNotify("websphere.cluster.stopped");
                throw new ClusterException("There are no cluster members to stop");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stop " + this.getClusterName());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopImmediate() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopImmediate " + this.getClusterName());
        }
        ClusterMemberData[] clusterMemberDataArray = this;
        synchronized (this) {
            if ("websphere.cluster.stopped".equals(this.state)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cluster " + this.getClusterName() + " already in the stopped state");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "stopImmediate " + this.getClusterName());
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            try {
                this.throwException("Stop");
            }
            catch (ClusterException clusterException) {
                FFDCFilter.processException((Throwable)clusterException, "com.ibm.ws.management.wlm.ClusterAdmin.stopImmediate", "456", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "stopImmediate - failed other operation already in progress");
                }
                throw new RuntimeException(clusterException);
            }
            this.stopping = true;
            this.stateChangeQueue.clear();
            this.setStateAndNotify("websphere.cluster.stopping");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            AdminHelper.getInstance().audit("ADMN1016I", "ADMN1017I", new Object[]{this.getClusterName(), null});
            clusterMemberDataArray = this.getClusterMembers();
            ClusterMemberData clusterMemberData = null;
            Object var3_5 = null;
            if (clusterMemberDataArray != null) {
                boolean bl = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cluster members size = " + clusterMemberDataArray.length);
                }
                for (int i = 0; i < clusterMemberDataArray.length; ++i) {
                    clusterMemberData = clusterMemberDataArray[i];
                    String string = clusterMemberData.nodeName + ":" + clusterMemberData.memberName;
                    bl = true;
                    Thread thread = new Thread((Cluster)this.new MemberStateChange((Cluster)this, clusterMemberData, null, "stopImmediate"));
                    thread.setDaemon(true);
                    thread.start();
                    this.stateChangeQueue.put(string, thread);
                }
                if (!bl) {
                    this.stopping = false;
                    if (!"websphere.cluster.stopped".equals(this.getState())) {
                        super.setStateAndNotify("websphere.cluster.stopped");
                    }
                } else if (!"websphere.cluster.running".equals(this.getState())) {
                    super.setStateAndNotify("websphere.cluster.partial.stop");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The cluster has no members");
                }
                this.stopping = false;
                super.setStateAndNotify("websphere.cluster.stopped");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stopImmediate " + this.getClusterName());
            }
            return;
        }
    }

    private boolean stopMember(ClusterMemberData clusterMemberData, String string) throws ClusterException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopMember", new Object[]{clusterMemberData, string});
        }
        boolean bl = false;
        try {
            if (clusterMemberData.memberObjectName != null) {
                this.getAdminService().invoke(clusterMemberData.memberObjectName, string, null, null);
                bl = true;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stop not issued. Object name is not available for the server", clusterMemberData.memberObjectName);
            }
        }
        catch (JMException jMException) {
            FFDCFilter.processException((Throwable)jMException, "com.ibm.ws.management.wlm.ClusterAdmin.stop", "533", this);
            Tr.error(tc, "WLMKEY_CLUSTER_MEMBER_STOP_FAILED", new Object[]{clusterMemberData.memberName, jMException});
            throw new ClusterException("Member stop failed", jMException);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stopMember");
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rippleStart() throws ClusterException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rippleStart " + this.getClusterName());
        }
        Object object = this;
        synchronized (object) {
            this.throwException("RippleStart");
            this.rippleStart = true;
            this.setStateAndNotify("websphere.cluster.starting");
        }
        AdminHelper.getInstance().audit("ADMN1018I", "ADMN1019I", new Object[]{this.getClusterName(), null});
        this.rippleObject = new RippleStarter(this);
        object = new Thread(this.rippleObject);
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rippleStart " + this.getClusterName());
        }
    }

    private void throwException(String string) throws ClusterException {
        boolean bl = false;
        String string2 = null;
        if (this.rippleStart) {
            string2 = "RippleStart";
            bl = true;
        } else if (this.starting) {
            string2 = "Start";
            bl = true;
        } else if (this.stopping) {
            string2 = "Stop";
            bl = true;
        }
        if (bl) {
            Tr.warning(tc, "WLMKEY_CLUSTER_OPERATION_FAILED", new Object[]{string, this.getClusterName(), " "});
            throw new ClusterException(string + " operation failed because another administrative operation: " + string2 + " is already in progress.");
        }
    }

    private AdminService getAdminService() {
        if (this.adminService == null) {
            this.adminService = AdminServiceFactory.getAdminService();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adminService reference was null. ClusterAdmin=" + this);
            }
        }
        return this.adminService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStateNotification(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendStateNotification", string);
        }
        try {
            if (this.rtc == null) {
                this.activate();
            }
            this.rtc.sendNotification(new Notification(string, this.rtc.getObjectName(), this.notifySeqNum++));
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.management.wlm.ClusterAdmin.start", "622", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to send cluster notification: type=[" + string + "] for cluster=[" + this.rtc.getObjectName() + "]. Exception: " + mBeanException.getMessage());
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "sendStateNotification");
            }
        }
    }

    public void handleNotification(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", "type = " + notification.getType());
        }
        String string = notification.getType();
        if (object.equals(NODE_AGENT_LISTENER)) {
            if (string.equals("websphere.process.stopping") || string.equals("websphere.process.stopped")) {
                this.processStopped(notification, object);
            } else if (string.equals("websphere.process.failed")) {
                this.processFailed(notification, object);
            } else if (string.equals("websphere.process.running")) {
                this.processStarted(notification, object);
            }
        } else if (object.equals(DEPLOYMENT_MANAGER_LISTENER)) {
            if (string.equals("websphere.process.stopping") || string.equals("websphere.process.failed")) {
                this.nodeAgentFailed(notification, object);
            } else if (string.equals("websphere.process.running")) {
                this.nodeAgentStarted(notification, object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    private String getNodeName(Notification notification) {
        return ((ObjectName)notification.getSource()).getKeyProperty("node");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStarted(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processStarted", notification);
        }
        Properties properties = null;
        String string = null;
        if (notification.getUserData() instanceof Properties && (properties = (Properties)notification.getUserData()) != null) {
            string = properties.getProperty("processName");
        }
        ClusterMemberData clusterMemberData = null;
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Received websphere.process.running for member: " + string);
            }
            clusterMemberData = this.getClusterMember(string, this.getNodeName(notification));
        }
        if (clusterMemberData != null) {
            Object object2;
            clusterMemberData.memberObjectName = ClusterMgr.getObjName(clusterMemberData.memberName, "Server", clusterMemberData.nodeName);
            String string2 = clusterMemberData.nodeName + ":" + clusterMemberData.memberName;
            if (this.rippleStart) {
                object2 = this.rippleObject;
                synchronized (object2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "rippleMember = " + this.rippleMember);
                        Tr.debug(tc, "memberName = " + string);
                    }
                    if (string.equals(this.rippleMember)) {
                        this.rippleObject.notify();
                    }
                }
            }
            if (this.starting) {
                object2 = (Thread)this.stateChangeQueue.get(string2);
                Runnable runnable = object2;
                synchronized (runnable) {
                    ((Thread)object2).interrupt();
                }
            }
            if (!this.rippleStart) {
                object2 = this.stateChangeMutex;
                synchronized (object2) {
                    if (this.isAllClusterMembersRunning()) {
                        this.setStateAndNotify("websphere.cluster.running");
                        this.starting = false;
                    } else {
                        this.setStateAndNotify("websphere.cluster.partial.start");
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processStarted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStopped(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processStopped", notification);
        }
        Properties properties = null;
        String string = null;
        if (notification.getUserData() instanceof Properties && (properties = (Properties)notification.getUserData()) != null) {
            string = properties.getProperty("processName");
        }
        ClusterMemberData clusterMemberData = null;
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Received " + notification.getType() + " for member: " + string);
            }
            clusterMemberData = this.getClusterMember(string, this.getNodeName(notification));
        }
        if (clusterMemberData != null) {
            Object object2;
            if (notification.getType().equals("websphere.process.stopped")) {
                clusterMemberData.memberObjectName = null;
            }
            String string2 = clusterMemberData.nodeName + ":" + clusterMemberData.memberName;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "rippleStart = " + this.rippleStart);
            }
            if (this.rippleStart && notification.getType().equals("websphere.process.stopped")) {
                object2 = this.rippleObject;
                synchronized (object2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "rippleMember = " + this.rippleMember);
                        Tr.debug(tc, "memberName = " + string);
                    }
                    if (string.equals(this.rippleMember)) {
                        this.rippleObject.notify();
                    }
                }
            }
            if (this.stopping && notification.getType().equals("websphere.process.stopped")) {
                Object object3 = object2 = (Thread)this.stateChangeQueue.get(string2);
                synchronized (object3) {
                    ((Thread)object2).interrupt();
                }
            }
            if (!this.rippleStart) {
                object2 = this.stateChangeMutex;
                synchronized (object2) {
                    if (this.isAllClusterMembersStopped()) {
                        this.setStateAndNotify("websphere.cluster.stopped");
                        this.stopping = false;
                    } else {
                        this.setStateAndNotify("websphere.cluster.partial.stop");
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processStopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFailed(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processFailed", notification);
        }
        Properties properties = null;
        String string = null;
        if (notification.getUserData() instanceof Properties && (properties = (Properties)notification.getUserData()) != null) {
            string = properties.getProperty("processName");
        }
        ClusterMemberData clusterMemberData = null;
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Received " + notification.getType() + " for member: " + string);
            }
            clusterMemberData = this.getClusterMember(string, this.getNodeName(notification));
        }
        if (clusterMemberData != null) {
            clusterMemberData.memberObjectName = ClusterMgr.getObjName(clusterMemberData.memberName, "Server", clusterMemberData.nodeName);
            if (clusterMemberData.memberObjectName == null) {
                this.processStopped(notification, object);
            } else if (!this.rippleStart) {
                Object object2 = this.stateChangeMutex;
                synchronized (object2) {
                    if (this.isAllClusterMembersStopped()) {
                        this.setStateAndNotify("websphere.cluster.stopped");
                    } else {
                        this.setStateAndNotify("websphere.cluster.partial.start");
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processFailed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nodeAgentStarted(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "nodeAgentStarted", notification);
        }
        Properties properties = null;
        String string = null;
        if (notification.getUserData() instanceof Properties && (properties = (Properties)notification.getUserData()) != null) {
            string = properties.getProperty("nodeName");
        }
        Object var5_5 = null;
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Received websphere.process.running for node agent: " + string);
            }
            ClusterMemberData[] clusterMemberDataArray = this.getClusterMembers();
            for (int i = 0; i < clusterMemberDataArray.length; ++i) {
                if (!clusterMemberDataArray[i].nodeName.equals(string)) continue;
                clusterMemberDataArray[i].memberObjectName = ClusterMgr.getObjName(clusterMemberDataArray[i].memberName, "Server", clusterMemberDataArray[i].nodeName);
            }
            if (!this.rippleStart) {
                Object object2 = this.stateChangeMutex;
                synchronized (object2) {
                    if (this.isAllClusterMembersRunning()) {
                        if (!this.state.equals("websphere.cluster.running")) {
                            this.setStateAndNotify("websphere.cluster.running");
                        }
                    } else if (this.isAllClusterMembersStopped()) {
                        if (!this.state.equals("websphere.cluster.stopped")) {
                            this.setStateAndNotify("websphere.cluster.stopped");
                        }
                    } else if (this.state.equals("websphere.cluster.stopped")) {
                        this.setStateAndNotify("websphere.cluster.partial.stop");
                    } else if (this.state.equals("websphere.cluster.running")) {
                        this.setStateAndNotify("websphere.cluster.partial.start");
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "nodeAgentStarted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nodeAgentFailed(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "nodeAgentFailed", notification);
        }
        Properties properties = null;
        String string = null;
        if (notification.getUserData() instanceof Properties && (properties = (Properties)notification.getUserData()) != null) {
            string = properties.getProperty("nodeName");
        }
        Object var5_5 = null;
        if (string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Received websphere.process.failed for node agent: " + string);
            }
            ClusterMemberData[] clusterMemberDataArray = this.getClusterMembers();
            for (int i = 0; i < clusterMemberDataArray.length; ++i) {
                if (!clusterMemberDataArray[i].nodeName.equals(string)) continue;
                clusterMemberDataArray[i].memberObjectName = null;
            }
            Object object2 = this.stateChangeMutex;
            synchronized (object2) {
                if (this.isAllClusterMembersStopped()) {
                    if (!this.state.equals("websphere.cluster.stopped")) {
                        this.setStateAndNotify("websphere.cluster.stopped");
                    }
                } else if (this.isAllClusterMembersRunning()) {
                    if (!this.state.equals("websphere.cluster.running")) {
                        this.setStateAndNotify("websphere.cluster.running");
                    }
                } else if (this.state.equals("websphere.cluster.stopped")) {
                    this.setStateAndNotify("websphere.cluster.partial.stop");
                } else if (this.state.equals("websphere.cluster.running")) {
                    this.setStateAndNotify("websphere.cluster.partial.start");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "nodeAgentFailed");
        }
    }

    private boolean isAllClusterMembersRunning() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAllClusterMembersRunning");
        }
        boolean bl = this.getClusterMembers().length > 0;
        ClusterMemberData clusterMemberData = null;
        ClusterMemberData[] clusterMemberDataArray = this.getClusterMembers();
        if (clusterMemberDataArray != null) {
            for (int i = 0; i < clusterMemberDataArray.length && bl; ++i) {
                clusterMemberData = clusterMemberDataArray[i];
                if (clusterMemberData.memberObjectName != null) continue;
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAllClusterMembersRunning", bl ? Boolean.TRUE : Boolean.FALSE);
        }
        return bl;
    }

    private boolean isAllClusterMembersStopped() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAllClusterMembersStopped");
        }
        boolean bl = true;
        ClusterMemberData clusterMemberData = null;
        ClusterMemberData[] clusterMemberDataArray = this.getClusterMembers();
        if (clusterMemberDataArray != null) {
            for (int i = 0; i < clusterMemberDataArray.length && bl; ++i) {
                clusterMemberData = clusterMemberDataArray[i];
                if (clusterMemberData.memberObjectName == null) continue;
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAllClusterMembersStopped", bl ? Boolean.TRUE : Boolean.FALSE);
        }
        return bl;
    }

    private void setStateAndNotify(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setStateAndNotify", new Object[]{string, this.state});
        }
        if (!this.state.equals(string)) {
            this.setState(string);
            this.sendStateNotification(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setStateAndNotify");
        }
    }

    protected void setClusterState() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClusterState");
        }
        if (this.isAllClusterMembersRunning()) {
            this.setState("websphere.cluster.running");
        } else if (this.isAllClusterMembersStopped()) {
            this.setState("websphere.cluster.stopped");
        } else {
            this.setState("websphere.cluster.partial.start");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClusterState", this.getState());
        }
    }

    public String dumpClusterInfo() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dumpClusterInfo");
        }
        String string = "";
        ClusterData clusterData = this.getClusterData();
        if (clusterData == null) {
            return "ClusterData is null";
        }
        ClusterMemberData[] clusterMemberDataArray = clusterData.clusterMembers;
        if (clusterMemberDataArray == null) {
            return "ClusterMemberData is null";
        }
        ClusterWeightTableEntry[] clusterWeightTableEntryArray = clusterData.weightTable;
        if (clusterWeightTableEntryArray == null) {
            return "ClusterWeightTableEntry is null";
        }
        string = string.concat("Cluster Name:        " + clusterData.clusterName + "\nCluster State:       " + this.getState() + "\nCluster Object Name: " + clusterData.clusterObjectName.toString() + "\nPrefer Local:        " + clusterData.preferLocal + "\nBackup Cluster:      " + this.getBackupName() + "\nBackup Host:         " + this.getBackupBootstrapHost() + "\nBackup Port:         " + this.getBackupBootstrapPort());
        int n = clusterMemberDataArray.length;
        if (n == 0) {
            string = string.concat("\n***** No members found in this cluster *****");
        }
        for (int i = 0; i < n; ++i) {
            string = string.concat("\n\nMember Name:         " + clusterMemberDataArray[i].memberName);
            string = string.concat("\nNode Name:           " + clusterMemberDataArray[i].nodeName);
            try {
                string = string.concat("\nMember Available:    " + this.getAvailable(clusterMemberDataArray[i].memberName, clusterMemberDataArray[i].nodeName));
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                string = string.concat("\n***** Cannot get availability, Member Name or Node Name is null");
            }
            catch (NullPointerException nullPointerException) {
                string = string.concat("\n***** Cannot get availability, Member Name or Node Name is null");
            }
            ClusterWeightTableEntry clusterWeightTableEntry = clusterMemberDataArray[i].weightTableEntry;
            if (!clusterWeightTableEntry.memberName.equals(clusterMemberDataArray[i].memberName)) {
                string = string.concat("\n***** Unsynchronized data for member " + clusterMemberDataArray[i].memberName);
                string = string.concat("\n      Member Name in Weight Table Entry (" + clusterWeightTableEntry.memberName + " different than in Cluster Member Data");
            }
            if (!clusterWeightTableEntry.nodeName.equals(clusterMemberDataArray[i].nodeName)) {
                string = string.concat("\n***** Unsynchronized data for member " + clusterMemberDataArray[i].memberName);
                string = string.concat("\n      Node Name in Weight Table Entry (" + clusterWeightTableEntry.nodeName + " different than in Cluster Member Data");
            }
            string = string.concat("\nMember Weight:       " + clusterWeightTableEntry.weight);
            string = string.concat("\nUnique ID:           " + clusterMemberDataArray[i].uniqueID);
            string = string.concat("\nMember Object Name:  " + clusterMemberDataArray[i].memberObjectName);
            if (!clusterMemberDataArray[i].clusterObjectName.toString().equals(clusterData.clusterObjectName.toString())) {
                string = string.concat("\n***** Unsynchronized data for member " + clusterMemberDataArray[i].memberName);
                string = string.concat("\n      clusterObjectName in clusterMemberDescription (" + clusterMemberDataArray[i].clusterObjectName.toString() + " different than in clusterData");
            }
            if (clusterMemberDataArray[i].clusterName.equals(clusterData.clusterName)) continue;
            string = string.concat("\n***** Unsynchronized data for member " + clusterMemberDataArray[i].memberName);
            string = string.concat("\n      clusterName in clusterMemberDescription (" + clusterMemberDataArray[i].clusterName + " different than in clusterData");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dumpClusterInfo");
        }
        return string;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.60.1.5 ");
        }
        NODE_AGENT_LISTENER = new Integer(1);
        DEPLOYMENT_MANAGER_LISTENER = new Integer(2);
        ripplestartTimeoutWait = 300000;
    }

    private class RippleStarter
    implements Runnable {
        private Cluster cluster = null;
        private Subject subject = null;
        private Subject savedSubject = null;

        RippleStarter(Cluster cluster2) {
            this.cluster = cluster2;
            try {
                this.subject = Cluster.this.contextManager.getCallerSubject();
                if (this.subject == null) {
                    this.subject = Cluster.this.contextManager.getInvocationSubject();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.wlm.ClusterAdmin.start", "1221", this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (this.subject != null) {
                    this.savedSubject = Cluster.this.contextManager.pushInvocationSubject(this.subject);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.wlm.ClusterAdmin.start", "1233", this);
            }
            try {
                this.rippleStart();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.wlm.ClusterAdmin.start", "1241", this);
                Tr.error(tc, "WLMKEY_CLUSTER_OPERATION_FAILED", new Object[]{"rippleStart", Cluster.this.getClusterName(), exception});
            }
            finally {
                try {
                    Cluster.this.contextManager.popInvocationSubject(this.savedSubject);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.wlm.ClusterAdmin.start", "1251", this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void rippleStart() throws ClusterException {
            block27: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "RippleStarter.rippleStart");
                }
                try {
                    block24: {
                        try {
                            Cluster.this.refresh();
                        }
                        catch (ClusterException clusterException) {
                            FFDCFilter.processException((Throwable)clusterException, "com.ibm.ws.management.wlm.ClusterAdmin.start", "1267", this);
                            if (!tc.isDebugEnabled()) break block24;
                            Tr.debug(tc, "Cluster refresh failed during start processing:", clusterException);
                        }
                    }
                    ClusterMemberData[] clusterMemberDataArray = Cluster.this.getClusterMembers();
                    ClusterMemberData clusterMemberData = null;
                    Object var3_4 = null;
                    if (clusterMemberDataArray != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "cluster members size=" + clusterMemberDataArray.length);
                        }
                        for (int i = 0; i < clusterMemberDataArray.length; ++i) {
                            block26: {
                                clusterMemberData = clusterMemberDataArray[i];
                                if (clusterMemberData.memberObjectName != null) {
                                    block25: {
                                        if (i != 0) {
                                            try {
                                                this.wait(ripplestartTimeoutWait);
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "wait() completed for started");
                                                }
                                            }
                                            catch (InterruptedException interruptedException) {
                                                if (!tc.isDebugEnabled()) break block25;
                                                Tr.debug(tc, "wait() was interrupted.");
                                            }
                                        }
                                    }
                                    Cluster.this.rippleMember = clusterMemberData.memberName;
                                    Cluster.this.stopMember(clusterMemberData, "stop");
                                    try {
                                        this.wait(ripplestartTimeoutWait);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "wait() completed for stop");
                                        }
                                    }
                                    catch (InterruptedException interruptedException) {
                                        if (!tc.isDebugEnabled()) break block26;
                                        Tr.debug(tc, "wait() was interrupted.");
                                    }
                                }
                            }
                            Cluster.this.launchMember(clusterMemberData, null);
                            if (i == 0) {
                                Cluster.this.setStateAndNotify("websphere.cluster.partial.start");
                            }
                            if (i != clusterMemberDataArray.length - 1) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "wait() for last server in list");
                            }
                            try {
                                this.wait(ripplestartTimeoutWait);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "wait() completed for for started for last server in list");
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "wait() was interrupted.");
                            }
                        }
                        if (Cluster.this.rippleStart && Cluster.this.isAllClusterMembersRunning()) {
                            Cluster.this.setStateAndNotify("websphere.cluster.running");
                        }
                        break block27;
                    }
                    Cluster.this.setStateAndNotify("websphere.cluster.stopped");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The cluster has no members");
                    }
                }
                finally {
                    Cluster.this.rippleMember = null;
                    Cluster.this.rippleStart = false;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "RippleStarter.rippleStart");
                    }
                }
            }
        }
    }

    private class MemberStateChange
    implements Runnable {
        private Cluster cluster = null;
        private ClusterMemberData member = null;
        private ObjectName nodeAgent = null;
        private String memberID = null;
        private String stateChange = null;
        private Subject subject = null;
        private Subject savedSubject = null;

        MemberStateChange(Cluster cluster2, ClusterMemberData clusterMemberData, ObjectName objectName, String string) {
            if (clusterMemberData == null) {
                new Exception().printStackTrace();
            }
            this.cluster = cluster2;
            this.member = clusterMemberData;
            this.nodeAgent = objectName;
            this.stateChange = string;
            this.memberID = clusterMemberData.nodeName + ":" + clusterMemberData.memberName;
            try {
                this.subject = Cluster.this.contextManager.getCallerSubject();
                if (this.subject == null) {
                    this.subject = Cluster.this.contextManager.getInvocationSubject();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "MemberStateChange", "1113", this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block68: {
                block61: {
                    try {
                        if (this.subject != null) {
                            this.savedSubject = Cluster.this.contextManager.pushInvocationSubject(this.subject);
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "MemberStateChange", "1123", this);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "MemberStateChange.run " + this.member.memberName);
                    }
                    if (this.stateChange.equals("start")) {
                        Cluster.this.launchMember(this.member, this.nodeAgent);
                        break block61;
                    }
                    Cluster.this.stopMember(this.member, this.stateChange);
                }
                Object var3_3 = null;
                try {
                    Cluster.this.contextManager.popInvocationSubject(this.savedSubject);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "MemberStateChange", "1150", this);
                }
                boolean bl = false;
                MemberStateChange memberStateChange = this;
                synchronized (memberStateChange) {
                    try {
                        this.wait(300000L);
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Unexpected: state change thread has timed out for state change " + this.stateChange);
                        }
                        bl = true;
                        Cluster.this.stateChangeQueue.remove(this.memberID);
                        if (this.stateChange.equals("start")) {
                            Cluster.this.starting = false;
                        } else {
                            Cluster.this.stopping = false;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!bl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "state change thread notified that its member's state change: " + this.stateChange + " was succesful");
                    }
                    Cluster.this.stateChangeQueue.remove(this.memberID);
                    if (Cluster.this.stateChangeQueue.isEmpty()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "state change queue is empty");
                        }
                        if (this.stateChange.equals("start")) {
                            Cluster.this.starting = false;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "no longer in starting state");
                            }
                        } else {
                            Cluster.this.stopping = false;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "no longer in stopping state");
                            }
                        }
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "MemberStateChange.run " + this.member.memberName);
                }
                break block68;
                {
                    catch (ClusterException clusterException) {
                        FFDCFilter.processException((Throwable)clusterException, "MemberStateChange", "1137", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "State change failed from MemberStateChange. member=" + this.member + ".  Exception: " + clusterException.getMessage());
                        }
                        Object var3_4 = null;
                        try {
                            Cluster.this.contextManager.popInvocationSubject(this.savedSubject);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "MemberStateChange", "1150", this);
                        }
                        boolean bl2 = false;
                        MemberStateChange memberStateChange2 = this;
                        synchronized (memberStateChange2) {
                            try {
                                this.wait(300000L);
                                if (tc.isEventEnabled()) {
                                    Tr.event(tc, "Unexpected: state change thread has timed out for state change " + this.stateChange);
                                }
                                bl2 = true;
                                Cluster.this.stateChangeQueue.remove(this.memberID);
                                if (this.stateChange.equals("start")) {
                                    Cluster.this.starting = false;
                                } else {
                                    Cluster.this.stopping = false;
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (!bl2) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "state change thread notified that its member's state change: " + this.stateChange + " was succesful");
                            }
                            Cluster.this.stateChangeQueue.remove(this.memberID);
                            if (Cluster.this.stateChangeQueue.isEmpty()) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "state change queue is empty");
                                }
                                if (this.stateChange.equals("start")) {
                                    Cluster.this.starting = false;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "no longer in starting state");
                                    }
                                } else {
                                    Cluster.this.stopping = false;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "no longer in stopping state");
                                    }
                                }
                            }
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "MemberStateChange.run " + this.member.memberName);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    try {
                        Cluster.this.contextManager.popInvocationSubject(this.savedSubject);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "MemberStateChange", "1150", this);
                    }
                    boolean bl3 = false;
                    MemberStateChange memberStateChange3 = this;
                    synchronized (memberStateChange3) {
                        try {
                            this.wait(300000L);
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Unexpected: state change thread has timed out for state change " + this.stateChange);
                            }
                            bl3 = true;
                            Cluster.this.stateChangeQueue.remove(this.memberID);
                            if (this.stateChange.equals("start")) {
                                Cluster.this.starting = false;
                            } else {
                                Cluster.this.stopping = false;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (!bl3) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "state change thread notified that its member's state change: " + this.stateChange + " was succesful");
                        }
                        Cluster.this.stateChangeQueue.remove(this.memberID);
                        if (Cluster.this.stateChangeQueue.isEmpty()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "state change queue is empty");
                            }
                            if (this.stateChange.equals("start")) {
                                Cluster.this.starting = false;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "no longer in starting state");
                                }
                            } else {
                                Cluster.this.stopping = false;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "no longer in stopping state");
                                }
                            }
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "MemberStateChange.run " + this.member.memberName);
                    }
                    throw throwable;
                }
            }
        }
    }
}

