/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wlm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.wlm.ClusterData;
import com.ibm.websphere.management.wlm.ClusterMemberData;
import com.ibm.websphere.management.wlm.ClusterWeightTableEntry;
import com.ibm.ws.cluster.ProcessProperties;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.management.wlm.Cluster;
import com.ibm.ws.management.wlm.ClusterMgrNotificationHandler;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.wlm.Factory;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;

public class ClusterMgr
implements ConfigChangeListener,
NotificationListener {
    private static TraceComponent tc = Tr.register(ClusterMgr.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    public static String configPath;
    public static final String wlmID = "com.ibm.ws.wlm.clusterMgr";
    public static final String ClusterMgrMBeanType = "ClusterMgr";
    public static final String ServerMBeanType = "Server";
    public static final String TYPE_ACTIVATE_CLUSTER = "cluster.changed.activate";
    public static final String TYPE_DEACTIVATE_CLUSTER = "cluster.changed.deactivate";
    public static final String TYPE_MEMBER_ADDED = "cluster.member.added";
    public static final String TYPE_MEMBER_REMOVED = "cluster.member.removed";
    public static final String KEY_CLUSTER_NAME = "clusterName";
    protected HashMap activeClusters = new HashMap();
    protected HashMap clusterNameHash = new HashMap();
    protected ObjectName objectName;
    protected static final Integer NODE_AGENT_LISTENER;
    protected static final Integer DEPLOYMENT_MANAGER_LISTENER;
    private AdminService adminService;
    protected ConfigService configService;
    protected Session session;
    private DefaultRuntimeCollaborator rtc;
    private ObjectName objectNameForConfigService;
    private MBeanFactory mbfactory;
    private Map clusterLockObjects = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(HashMap hashMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", hashMap);
        }
        try {
            this.adminService = AdminServiceFactory.getAdminService();
            this.session = new Session(wlmID, true);
            this.configService = ConfigServiceFactory.getConfigService();
            this.discard(this.session);
            this.mbfactory = this.adminService.getMBeanFactory();
            this.rtc = new DefaultRuntimeCollaborator(this);
            this.objectName = this.mbfactory.activateMBean(ClusterMgrMBeanType, this.rtc, ClusterMgrMBeanType, null);
            this.registerNotificationListener();
            Repository repository2 = (Repository)hashMap.get("Repository");
            ConfigRoot configRoot = repository2.getConfigRoot();
            configPath = (configRoot.getConfigRootPath() + configRoot.getURIBaseForType(0)).replace('/', File.separatorChar);
            this.loadRefreshClusters(null);
            ProcessProperties processProperties = ProcessProperties.getInstance();
            if (processProperties != null) {
                processProperties.put("key.clustermgr", this);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processProperties null, unable to cache reference to ClusterMgr.");
            }
        }
        catch (AdminException adminException) {
            FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.wlm.ClusterMgr.initialize", "248", this);
            Tr.warning(tc, "WLMKEY_UNABLE_TO_ACTIVATE_CLUSTERMGR_MBEAN", new Object[]{adminException});
            if (tc.isEventEnabled()) {
                Tr.event(tc, "unable to activate the ClusterMgr MBean", adminException);
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize", configPath);
            }
        }
    }

    public void shutdown() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdown");
        }
        this.discard(this.session);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterData[] retrieveClusters() {
        ClusterData[] clusterDataArray;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "retrieveClusters");
            }
            clusterDataArray = null;
            try {
                this.loadRefreshClusters(null);
                HashMap hashMap = this.activeClusters;
                synchronized (hashMap) {
                    if (!this.activeClusters.isEmpty()) {
                        clusterDataArray = new ClusterData[this.activeClusters.size()];
                        Collection collection = this.activeClusters.values();
                        Iterator iterator = collection.iterator();
                        int n = 0;
                        while (iterator.hasNext()) {
                            Cluster cluster = (Cluster)iterator.next();
                            clusterDataArray[n++] = cluster.getClusterData();
                        }
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.wlm.ClusterMgr.retrieveClusters", "311", this);
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "Error in ClusterMgr.retrieveClusters()", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveClusters");
        }
        return clusterDataArray;
    }

    public ClusterData retrieveCluster(String string) {
        ClusterData clusterData;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "retrieveCluster", string);
            }
            clusterData = null;
            try {
                Cluster cluster = (Cluster)this.activeClusters.get(string);
                if (cluster == null) {
                    this.loadRefreshClusters(string);
                    cluster = (Cluster)this.activeClusters.get(string);
                }
                if (cluster != null) {
                    clusterData = cluster.getClusterData();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.wlm.ClusterMgr.retrieveCluster", "362", this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Error in ClusterMgr.retrieveCluster()", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveCluster");
        }
        return clusterData;
    }

    public ClusterData retrieveClusterByMember(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveClusterByMember", new String[]{string, string2});
        }
        ClusterData clusterData = null;
        String string3 = (String)this.clusterNameHash.get(string + ":" + string2);
        if (string3 == null) {
            this.loadRefreshClusters(null);
            string3 = (String)this.clusterNameHash.get(string + ":" + string2);
        }
        if (string3 != null) {
            clusterData = this.retrieveCluster(string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveClusterByMember", clusterData);
        }
        return clusterData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributeList[] loadClusterConfig(String string, boolean bl) {
        AttributeList[] attributeListArray;
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "loadClusterConfig", string);
            }
            attributeListArray = new AttributeList[]{};
            AttributeList attributeList = new AttributeList();
            String string2 = null;
            try {
                Session session = this.session;
                synchronized (session) {
                    if (bl) {
                        this.discard(this.session);
                    }
                    String string3 = null;
                    string3 = string != null ? "Cell=:ServerCluster=" + string : "Cell=:ServerCluster=";
                    ObjectName[] objectNameArray = this.configService.resolve(this.session, string3);
                    if (objectNameArray.length > 0) {
                        if (string != null) {
                            for (int i = 0; i < objectNameArray.length; ++i) {
                                attributeList = this.configService.getAttributes(this.session, objectNameArray[i], null, true);
                                string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "name");
                                if (string2 == null || !string.equals(string2)) continue;
                                attributeListArray = new AttributeList[]{attributeList};
                                if (!tc.isDebugEnabled()) break;
                                Tr.debug(tc, "clusterArray[0]: " + string2);
                                break;
                            }
                        } else {
                            attributeListArray = new AttributeList[objectNameArray.length];
                            for (int i = 0; i < attributeListArray.length; ++i) {
                                attributeListArray[i] = this.configService.getAttributes(this.session, objectNameArray[i], null, true);
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "clusterArray[" + i + "] added");
                            }
                        }
                    }
                }
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                FFDCFilter.processException((Throwable)attributeNotFoundException, "com.ibm.ws.management.wlm.ClusterMgr.loadClusterConfig", "474", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cluster attribute not found", attributeNotFoundException);
                }
            }
            catch (ConfigServiceException configServiceException) {
                FFDCFilter.processException((Throwable)configServiceException, "com.ibm.ws.management.wlm.ClusterMgr.loadClusterConfig", "482", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Problem with the ConfigService.", configServiceException);
                }
            }
            catch (ConnectorException connectorException) {
                FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.wlm.ClusterMgr.loadClusterConfig", "489", this);
                if (!tc.isDebugEnabled()) break block18;
                Tr.debug(tc, "Problem with the ConfigService.", connectorException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadClusterConfig");
        }
        return attributeListArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterData convertCluster(AttributeList attributeList) {
        ClusterData clusterData;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "convertCluster", attributeList);
            }
            clusterData = new ClusterData();
            try {
                clusterData.clusterName = (String)ConfigServiceHelper.getAttributeValue(attributeList, "name");
                clusterData.clusterObjectName = ClusterMgr.getObjName(clusterData.clusterName, "Cluster", this.adminService.getNodeName(), this.adminService.getProcessName());
                clusterData.preferLocal = (Boolean)ConfigServiceHelper.getAttributeValue(attributeList, "preferLocal");
                ArrayList arrayList = (ArrayList)ConfigServiceHelper.getAttributeValue(attributeList, "members");
                clusterData.clusterMembers = new ClusterMemberData[arrayList.size()];
                clusterData.weightTable = new ClusterWeightTableEntry[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    AttributeList attributeList2 = (AttributeList)arrayList.get(i);
                    clusterData.weightTable[i] = new ClusterWeightTableEntry();
                    clusterData.weightTable[i].memberName = (String)ConfigServiceHelper.getAttributeValue(attributeList2, "memberName");
                    clusterData.weightTable[i].nodeName = (String)ConfigServiceHelper.getAttributeValue(attributeList2, "nodeName");
                    clusterData.weightTable[i].weight = (Integer)ConfigServiceHelper.getAttributeValue(attributeList2, "weight");
                    clusterData.clusterMembers[i] = new ClusterMemberData();
                    clusterData.clusterMembers[i].nodeName = clusterData.weightTable[i].nodeName;
                    clusterData.clusterMembers[i].memberName = clusterData.weightTable[i].memberName;
                    clusterData.clusterMembers[i].memberObjectName = ClusterMgr.getObjName(clusterData.clusterMembers[i].memberName, ServerMBeanType, clusterData.clusterMembers[i].nodeName, clusterData.clusterMembers[i].memberName);
                    clusterData.clusterMembers[i].clusterName = clusterData.clusterName;
                    clusterData.clusterMembers[i].clusterObjectName = clusterData.clusterObjectName;
                    clusterData.clusterMembers[i].type = 0;
                    clusterData.clusterMembers[i].weightTableEntry = clusterData.weightTable[i];
                    clusterData.clusterMembers[i].uniqueID = (String)ConfigServiceHelper.getAttributeValue(attributeList2, "uniqueId");
                    String string = clusterData.weightTable[i].memberName;
                    String string2 = clusterData.weightTable[i].nodeName;
                    String string3 = clusterData.clusterName;
                    HashMap hashMap = this.clusterNameHash;
                    synchronized (hashMap) {
                        this.clusterNameHash.put(string + ":" + string2, string3);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "added member:node: ", new Object[]{string + ":" + string2, string3});
                        }
                        continue;
                    }
                }
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                FFDCFilter.processException((Throwable)attributeNotFoundException, "com.ibm.ws.management.wlm.ClusterMgr.convertCluster", "606", this);
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "Cluster attribute not found", attributeNotFoundException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertCluster");
        }
        return clusterData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateCluster(ClusterData clusterData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "activateCluster", clusterData.clusterName);
        }
        Cluster cluster = (Cluster)Factory.loadImpl(Cluster.class);
        cluster.setClusterData(clusterData);
        cluster.activate();
        HashMap hashMap = this.activeClusters;
        synchronized (hashMap) {
            this.activeClusters.put(clusterData.clusterName, cluster);
        }
        this.updateClusterObjName(cluster);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "activateCluster", this.activeClusters);
        }
    }

    protected void loadRefreshClusters(String string) {
        this.loadRefreshClusters(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadRefreshClusters(String string, boolean bl) {
        block43: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "loadRefreshClusters", string);
            }
            try {
                AttributeList[] attributeListArray = this.loadClusterConfig(string, bl);
                if (string == null && attributeListArray != null && attributeListArray.length == this.activeClusters.size()) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "activeClusters matches the wccmClusters, returning.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "loadRefreshClusters");
                    }
                    return;
                }
                if (attributeListArray != null) {
                    ClusterData[] clusterDataArray = new ClusterData[attributeListArray.length];
                    for (int i = 0; i < attributeListArray.length; ++i) {
                        String string2 = (String)ConfigServiceHelper.getAttributeValue(attributeListArray[i], "name");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "got clusterName " + string2);
                        }
                        Map map = this.clusterLockObjects;
                        synchronized (map) {
                            if (!this.clusterLockObjects.containsKey(string2)) {
                                this.clusterLockObjects.put(string2, new Object());
                            }
                        }
                        map = this.clusterLockObjects.get(string2);
                        synchronized (map) {
                            Object object;
                            Serializable serializable;
                            if (!this.activeClusters.containsKey(string2)) {
                                clusterDataArray[i] = this.convertCluster(attributeListArray[i]);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "activeClusters", this.activeClusters);
                                }
                                this.activateCluster(clusterDataArray[i]);
                                serializable = new Notification(TYPE_ACTIVATE_CLUSTER, (Object)this.objectName, -1L, System.currentTimeMillis());
                                object = new Properties();
                                ((Properties)object).setProperty(KEY_CLUSTER_NAME, string2);
                                ((Notification)serializable).setUserData(object);
                                try {
                                    this.rtc.sendNotification((Notification)serializable);
                                }
                                catch (RuntimeOperationsException runtimeOperationsException) {
                                    FFDCFilter.processException((Throwable)runtimeOperationsException, (class$com$ibm$ws$management$wlm$ClusterMgr == null ? ClusterMgr.class$("com.ibm.ws.management.wlm.ClusterMgr") : class$com$ibm$ws$management$wlm$ClusterMgr).getName() + ".loadRefreshClusters", "707", this);
                                }
                                catch (MBeanException mBeanException) {
                                    FFDCFilter.processException((Throwable)mBeanException, (class$com$ibm$ws$management$wlm$ClusterMgr == null ? ClusterMgr.class$("com.ibm.ws.management.wlm.ClusterMgr") : class$com$ibm$ws$management$wlm$ClusterMgr).getName() + ".loadRefreshClusters", "710", this);
                                }
                            } else {
                                Object object2;
                                Object object3;
                                Serializable serializable2;
                                String string3;
                                String string4;
                                serializable = (ArrayList)ConfigServiceHelper.getAttributeValue(attributeListArray[i], "members");
                                object = (Cluster)this.activeClusters.get(string2);
                                boolean bl2 = false;
                                for (int j = 0; j < ((ArrayList)serializable).size(); ++j) {
                                    AttributeList attributeList = (AttributeList)((ArrayList)serializable).get(j);
                                    string4 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "memberName");
                                    ClusterMemberData clusterMemberData = ((Cluster)object).getClusterMember(string4, string3 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "nodeName"));
                                    if (clusterMemberData == null) {
                                        ClusterData clusterData = this.convertCluster(attributeListArray[i]);
                                        ((Cluster)object).setClusterData(clusterData);
                                        bl2 = true;
                                        serializable2 = new Notification(TYPE_MEMBER_ADDED, (Object)this.objectName, -1L, System.currentTimeMillis());
                                        object3 = new Properties();
                                        ((Properties)object3).setProperty(KEY_CLUSTER_NAME, ((Cluster)object).getClusterName());
                                        ((Properties)object3).setProperty("nodeName", string3);
                                        ((Properties)object3).setProperty("processName", string4);
                                        ((Notification)serializable2).setUserData(object3);
                                        object2 = this.clusterNameHash;
                                        synchronized (object2) {
                                            this.clusterNameHash.put(string4 + ":" + string3, string2);
                                        }
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "added member:node: ", new Object[]{string4 + ":" + string3, string2});
                                        }
                                        try {
                                            this.rtc.sendNotification((Notification)serializable2);
                                        }
                                        catch (RuntimeOperationsException runtimeOperationsException) {
                                            FFDCFilter.processException((Throwable)runtimeOperationsException, (class$com$ibm$ws$management$wlm$ClusterMgr == null ? ClusterMgr.class$("com.ibm.ws.management.wlm.ClusterMgr") : class$com$ibm$ws$management$wlm$ClusterMgr).getName() + ".loadRefreshClusters", "759", this);
                                        }
                                        catch (MBeanException mBeanException) {
                                            FFDCFilter.processException((Throwable)mBeanException, (class$com$ibm$ws$management$wlm$ClusterMgr == null ? ClusterMgr.class$("com.ibm.ws.management.wlm.ClusterMgr") : class$com$ibm$ws$management$wlm$ClusterMgr).getName() + ".loadRefreshClusters", "762", this);
                                        }
                                        continue;
                                    }
                                    ((Cluster)object).setMemberObjName(string4, string3);
                                }
                                if (!bl2 && ((Cluster)object).getClusterMembers().length != ((ArrayList)serializable).size()) {
                                    ClusterMemberData[] clusterMemberDataArray = ((Cluster)object).getClusterMembers();
                                    for (int j = 0; j < clusterMemberDataArray.length; ++j) {
                                        string4 = clusterMemberDataArray[j].memberName;
                                        string3 = clusterMemberDataArray[j].nodeName;
                                        boolean bl3 = false;
                                        for (int k = 0; k < ((ArrayList)serializable).size(); ++k) {
                                            serializable2 = (AttributeList)((ArrayList)serializable).get(k);
                                            object3 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)serializable2, "memberName");
                                            object2 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)serializable2, "nodeName");
                                            if (!string4.equals(object3) || !string3.equals(object2)) continue;
                                            bl3 = true;
                                            break;
                                        }
                                        if (bl3) continue;
                                        ((Cluster)object).removeMember(string4, string3);
                                        Serializable serializable3 = this.clusterNameHash;
                                        synchronized (serializable3) {
                                            this.clusterNameHash.remove(string4 + ":" + string3);
                                        }
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "removed member:node: ", new Object[]{string4 + ":" + string3, ((Cluster)object).getClusterName()});
                                        }
                                        serializable3 = new Notification(TYPE_MEMBER_REMOVED, (Object)this.objectName, -1L, System.currentTimeMillis());
                                        serializable2 = new Properties();
                                        ((Properties)serializable2).setProperty(KEY_CLUSTER_NAME, ((Cluster)object).getClusterName());
                                        ((Properties)serializable2).setProperty("nodeName", string3);
                                        ((Properties)serializable2).setProperty("processName", string4);
                                        ((Notification)serializable3).setUserData(serializable2);
                                        try {
                                            this.rtc.sendNotification((Notification)serializable3);
                                            continue;
                                        }
                                        catch (RuntimeOperationsException runtimeOperationsException) {
                                            FFDCFilter.processException((Throwable)runtimeOperationsException, (class$com$ibm$ws$management$wlm$ClusterMgr == null ? ClusterMgr.class$("com.ibm.ws.management.wlm.ClusterMgr") : class$com$ibm$ws$management$wlm$ClusterMgr).getName() + ".loadRefreshClusters", "821", this);
                                            continue;
                                        }
                                        catch (MBeanException mBeanException) {
                                            FFDCFilter.processException((Throwable)mBeanException, (class$com$ibm$ws$management$wlm$ClusterMgr == null ? ClusterMgr.class$("com.ibm.ws.management.wlm.ClusterMgr") : class$com$ibm$ws$management$wlm$ClusterMgr).getName() + ".loadRefreshClusters", "824", this);
                                        }
                                    }
                                }
                            }
                            continue;
                        }
                    }
                    break block43;
                }
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "no clusters in the config repository", attributeListArray);
                }
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                FFDCFilter.processException((Throwable)attributeNotFoundException, "com.ibm.ws.management.wlm.ClusterMgr.loadRefreshClusters", "840", this);
                if (!tc.isDebugEnabled()) break block43;
                Tr.debug(tc, "Cluster attribute not found", attributeNotFoundException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadRefreshClusters");
        }
    }

    private void updateClusterObjName(Cluster cluster) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "updateClusterObjName");
            }
            try {
                ObjectName objectName = new ObjectName(this.adminService.getDomainName() + ":*,mbeanIdentifier=" + cluster.getClusterName() + ",type=Cluster" + ",process=" + this.adminService.getProcessName());
                Set set = this.adminService.queryNames(objectName, null);
                if (!set.isEmpty()) {
                    Iterator iterator = set.iterator();
                    ObjectName objectName2 = (ObjectName)iterator.next();
                    cluster.setClusterObjName(objectName2);
                } else {
                    Tr.warning(tc, "WLMKEY_ACTIVATED_CLUSTER_MBEAN_NOT_FOUND", new Object[]{cluster.getClusterName(), objectName});
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Activated cluster MBean not found", objectName);
                    }
                }
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.management.wlm.ClusterMgr.updateClusterObjName", "892", this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "new ObjectName() for query failed", malformedObjectNameException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateClusterObjName");
        }
    }

    protected static String getDomainName() {
        AdminService adminService = AdminServiceFactory.getAdminService();
        String string = adminService.getDomainName();
        if (string == null) {
            string = "*";
        }
        return string;
    }

    protected static ObjectName getObjName(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjName(1)", string);
        }
        ObjectName objectName = null;
        String string2 = ClusterMgr.getDomainName() + ":*,name=" + string;
        objectName = ClusterMgr.getObjectName(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjName(1)", objectName);
        }
        return objectName;
    }

    protected static ObjectName getObjName(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjName(2)", new Object[]{string, string2});
        }
        ObjectName objectName = null;
        String string3 = ClusterMgr.getDomainName() + ":*,name=" + string + ",type=" + string2;
        objectName = ClusterMgr.getObjectName(string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjName(2)", objectName);
        }
        return objectName;
    }

    protected static ObjectName getObjName(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjName(3)", new Object[]{string, string2, string3});
        }
        ObjectName objectName = null;
        String string4 = ClusterMgr.getDomainName() + ":*,name=" + string + ",type=" + string2 + ",node=" + string3;
        objectName = ClusterMgr.getObjectName(string4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjName(3)", objectName);
        }
        return objectName;
    }

    protected static ObjectName getObjName(String string, String string2, String string3, String string4) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjName(4)", new Object[]{string, string2, string3, string4});
        }
        ObjectName objectName = null;
        String string5 = ClusterMgr.getDomainName() + ":*,name=" + string + ",type=" + string2 + ",node=" + string3 + ",process=" + string4;
        objectName = ClusterMgr.getObjectName(string5);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjName(4)", objectName);
        }
        return objectName;
    }

    protected static ObjectName getObjectName(String string) {
        ObjectName objectName;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getObjectName", new Object[]{string});
            }
            objectName = null;
            AdminService adminService = AdminServiceFactory.getAdminService();
            try {
                ObjectName objectName2 = new ObjectName(string);
                Set set = adminService.queryNames(objectName2, null);
                if (!set.isEmpty()) {
                    Iterator iterator = set.iterator();
                    objectName = (ObjectName)iterator.next();
                }
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                FFDCFilter.processException(malformedObjectNameException, "com.ibm.ws.management.wlm.ClusterMgr.getObjName", "1085");
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "new ObjectName() for query failed", malformedObjectNameException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectName", objectName);
        }
        return objectName;
    }

    private ObjectName getConfigService() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, " getConfigService");
        }
        try {
            if (this.objectNameForConfigService == null) {
                String string = this.getKey();
                this.objectNameForConfigService = ClusterMgr.getObjectName(string);
            }
        }
        catch (Exception exception) {
            Tr.debug(tc, "Error occured during geting ConfigService name ", exception);
            throw new AdminException("Error occured during getConfigService");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigService", this.objectNameForConfigService);
        }
        return this.objectNameForConfigService;
    }

    private Object invokeMBean(ObjectName objectName, String string, String[] stringArray, Object[] objectArray) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, " invokeMBean:" + string + "objectName=" + objectName);
        }
        try {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invokeMBean");
            }
            return this.adminService.invoke(objectName, string, objectArray, stringArray);
        }
        catch (Exception exception) {
            Tr.debug(tc, "Error occured during invokeMBean operation", exception);
            throw new AdminException(exception);
        }
    }

    private String getKey() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKey");
        }
        String string = AdminServiceFactory.getAdminService().getProcessName();
        String string2 = AdminServiceFactory.getAdminService().getCellName();
        String string3 = AdminServiceFactory.getAdminService().getNodeName();
        String string4 = "WebSphere:process=" + string + ",type=ConfigService,cell=" + string2 + ",node=" + string3 + ",*";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKey", string4);
        }
        return string4;
    }

    protected void discard(Session session) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "discard", session);
            }
            try {
                this.configService.discard(session);
            }
            catch (ConfigServiceException configServiceException) {
                FFDCFilter.processException((Throwable)configServiceException, "com.ibm.ws.management.wlm.ClusterMgr.discard", "1183", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Problem with the ConfigService.", configServiceException);
                }
            }
            catch (ConnectorException connectorException) {
                FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.wlm.ClusterMgr.discart", "1187", this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Problem with the ConfigService.", connectorException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "discard");
        }
    }

    private AttributeList getAttributes(Session session, ObjectName objectName, String[] stringArray, boolean bl) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{session, objectName, stringArray, Boolean.toString(bl)});
        }
        AttributeList attributeList = null;
        ObjectName objectName2 = this.getConfigService();
        String string = "getAttributes";
        String[] stringArray2 = new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "[Ljava.lang.String;", "boolean"};
        Object[] objectArray = new Object[]{session, objectName, stringArray, new Boolean(bl)};
        attributeList = (AttributeList)this.invokeMBean(objectName2, string, stringArray2, objectArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", attributeList);
        }
        return attributeList;
    }

    private void registerNotificationListener() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "registerNotificationListener");
            }
            try {
                String string = ClusterMgr.getDomainName() + ":*,type=" + "NodeAgent";
                ObjectName objectName = new ObjectName(string);
                NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                notificationFilterSupport.enableType("websphere.process.running");
                notificationFilterSupport.enableType("websphere.process.stopping");
                notificationFilterSupport.enableType("websphere.process.stopped");
                notificationFilterSupport.enableType("websphere.process.failed");
                this.adminService.addNotificationListenerExtended(objectName, this, notificationFilterSupport, NODE_AGENT_LISTENER);
                string = ClusterMgr.getDomainName() + ":*,type=" + "DeploymentManager";
                ObjectName objectName2 = new ObjectName(string);
                notificationFilterSupport = new NotificationFilterSupport();
                notificationFilterSupport.enableType("websphere.process.running");
                notificationFilterSupport.enableType("websphere.process.stopping");
                notificationFilterSupport.enableType("websphere.process.stopped");
                notificationFilterSupport.enableType("websphere.process.failed");
                this.adminService.addNotificationListenerExtended(objectName2, this, notificationFilterSupport, DEPLOYMENT_MANAGER_LISTENER);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.wlm.ClusterMgr.registerNotificationListener", "1290", this);
                Tr.service(tc, "WLMKEY_NOTIFICATION_ERROR", exception);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "exception: " + exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerNotificationListener");
        }
    }

    public void configChanged(ConfigRepositoryEvent configRepositoryEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configChanged", configRepositoryEvent);
        }
        this.spawnThread(null, null, configRepositoryEvent);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configChanged");
        }
    }

    public void handleNotification(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", "type = " + notification.getType());
        }
        if (!this.activeClusters.isEmpty()) {
            this.spawnThread(notification, object, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    private void spawnThread(Notification notification, Object object, ConfigRepositoryEvent configRepositoryEvent) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "spawnThread");
            }
            try {
                ClusterMgrNotificationHandler clusterMgrNotificationHandler = new ClusterMgrNotificationHandler(notification, object, configRepositoryEvent, this, this.rtc);
                clusterMgrNotificationHandler.start();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.wlm.ClusterMgr.spawnThread", "1349", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "spawnThread", "Exception thrown from ClusterMgr " + exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "spawnThread");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : iFix", "1.57.1.3 : none");
        }
        configPath = null;
        NODE_AGENT_LISTENER = new Integer(1);
        DEPLOYMENT_MANAGER_LISTENER = new Integer(2);
    }
}

