/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.wlm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.management.wlm.Cluster;
import com.ibm.ws.management.wlm.ClusterMgr;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.io.Serializable;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;

final class ClusterMgrNotificationHandler
extends Thread {
    private DefaultRuntimeCollaborator rtc;
    private Notification notif = null;
    private Object hb = null;
    private ContextManager contextMgr = null;
    private ConfigRepositoryEvent event = null;
    private ClusterMgr clusterMgr = null;
    private Integer NODE_AGENT_LISTENER = new Integer(1);
    private Integer DEPLOYMENT_MANAGER_LISTENER = new Integer(2);
    private static TraceComponent tc = Tr.register(ClusterMgrNotificationHandler.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");

    public ClusterMgrNotificationHandler(Notification notification, Object object, ConfigRepositoryEvent configRepositoryEvent, ClusterMgr clusterMgr, DefaultRuntimeCollaborator defaultRuntimeCollaborator) {
        this.notif = notification;
        this.hb = object;
        this.event = configRepositoryEvent;
        this.clusterMgr = clusterMgr;
        this.rtc = defaultRuntimeCollaborator;
        String string = "ClusterMgrNotificationHandler:" + this.getName();
        this.setName(string);
        this.setDaemon(true);
        this.contextMgr = ContextManagerFactory.getInstance();
    }

    public void run() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run", this.getName());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " activeClusters: " + this.clusterMgr.activeClusters);
                Tr.debug(tc, "clusterNameHash: " + this.clusterMgr.clusterNameHash);
                Tr.debug(tc, "   Notification: " + this.notif);
                Tr.debug(tc, "       handback: " + this.hb);
                Tr.debug(tc, "          event: " + this.event);
            }
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (ClusterMgrNotificationHandler.this.notif != null) {
                        ClusterMgrNotificationHandler.this.notificationReceived();
                    } else if (ClusterMgrNotificationHandler.this.event != null) {
                        ClusterMgrNotificationHandler.this.configChanged();
                    }
                    return null;
                }
            };
            try {
                this.contextMgr.runAsSystem(privilegedExceptionAction);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.wlm.server.ClusterMgrNotificationHandler.run", "1434", this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "run exception", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run", this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configChanged() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configChanged");
        }
        String string = "cluster.xml";
        String string2 = "xformed";
        ConfigChangeNotifier[] configChangeNotifierArray = this.event.getChanges();
        String string3 = null;
        int n = 0;
        String string4 = null;
        for (int i = 0; i < configChangeNotifierArray.length; ++i) {
            string3 = configChangeNotifierArray[i].getUri();
            n = configChangeNotifierArray[i].getChangeType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "uri, type", new Object[]{string3, new Integer(n)});
            }
            if (string3.toLowerCase().startsWith(string2)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "tranformation in mixed version -- do nothing");
                }
                return;
            }
            if (!string3.toLowerCase().endsWith(string)) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "/");
            int n2 = stringTokenizer.countTokens();
            int n3 = n2 - 1;
            for (int j = 0; j < n3; ++j) {
                string4 = stringTokenizer.nextToken();
            }
            if (n == 0 || n == 2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "" + string4 + " added/changed");
                }
                this.clusterMgr.loadRefreshClusters(string4, true);
                ((Cluster)this.clusterMgr.activeClusters.get(string4)).setClusterState();
                continue;
            }
            if (n != 1) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "" + string4 + " deleted");
            }
            Serializable serializable = this.clusterMgr.session;
            synchronized (serializable) {
                this.clusterMgr.discard(this.clusterMgr.session);
            }
            ((Cluster)this.clusterMgr.activeClusters.get(string4)).deactivate();
            serializable = new Notification("cluster.changed.deactivate", (Object)this.clusterMgr.objectName, -1L, System.currentTimeMillis());
            Properties properties = new Properties();
            properties.setProperty("clusterName", string4);
            ((Notification)serializable).setUserData(properties);
            try {
                this.rtc.sendNotification((Notification)serializable);
            }
            catch (RuntimeOperationsException runtimeOperationsException) {
                FFDCFilter.processException((Throwable)runtimeOperationsException, (class$com$ibm$ws$management$wlm$ClusterMgrNotificationHandler == null ? ClusterMgrNotificationHandler.class$("com.ibm.ws.management.wlm.ClusterMgrNotificationHandler") : class$com$ibm$ws$management$wlm$ClusterMgrNotificationHandler).getName() + ".configChanged", "1505", this);
            }
            catch (MBeanException mBeanException) {
                FFDCFilter.processException((Throwable)mBeanException, (class$com$ibm$ws$management$wlm$ClusterMgrNotificationHandler == null ? ClusterMgrNotificationHandler.class$("com.ibm.ws.management.wlm.ClusterMgrNotificationHandler") : class$com$ibm$ws$management$wlm$ClusterMgrNotificationHandler).getName() + ".configChanged", "1508", this);
            }
            HashMap hashMap = this.clusterMgr.activeClusters;
            synchronized (hashMap) {
                this.clusterMgr.activeClusters.remove(string4);
            }
            hashMap = this.clusterMgr.clusterNameHash;
            synchronized (hashMap) {
                Iterator iterator = this.clusterMgr.clusterNameHash.values().iterator();
                while (iterator.hasNext()) {
                    Object v = iterator.next();
                    if (!v.equals(string4)) continue;
                    iterator.remove();
                }
                continue;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "activeClusters: " + this.clusterMgr.activeClusters);
            Tr.debug(tc, "clusterNameHash: " + this.clusterMgr.clusterNameHash);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configChanged");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void notificationReceived() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notificationReceived");
        }
        if (this.hb.equals(this.NODE_AGENT_LISTENER)) {
            String string;
            ObjectName objectName = (ObjectName)this.notif.getSource();
            String string2 = objectName.getKeyProperty("process");
            String string3 = objectName.getKeyProperty("node");
            Properties properties = null;
            String string4 = null;
            if (this.notif.getUserData() instanceof Properties && (properties = (Properties)this.notif.getUserData()) != null) {
                string4 = properties.getProperty("processName");
            }
            if ((string = (String)this.clusterMgr.clusterNameHash.get(string4 + ":" + string3)) != null) {
                ((Cluster)this.clusterMgr.activeClusters.get(string)).handleNotification(this.notif, this.hb);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "process=" + string2);
                Tr.debug(tc, "member=" + string4);
                Tr.debug(tc, "node=" + string3);
                Tr.debug(tc, "clusterName=" + string);
            }
        } else if (this.hb.equals(this.DEPLOYMENT_MANAGER_LISTENER)) {
            Properties properties = null;
            String string = null;
            if (this.notif.getUserData() instanceof Properties && (properties = (Properties)this.notif.getUserData()) != null) {
                string = properties.getProperty("nodeName");
            }
            HashSet hashSet = new HashSet();
            Object[] objectArray = this.clusterMgr.clusterNameHash;
            // MONITORENTER : this.clusterMgr.clusterNameHash
            Iterator iterator = this.clusterMgr.clusterNameHash.keySet().iterator();
            while (iterator.hasNext()) {
                String string5 = (String)iterator.next();
                if (!string5.endsWith(string)) continue;
                hashSet.add(this.clusterMgr.activeClusters.get(this.clusterMgr.clusterNameHash.get(string5)));
            }
            // MONITOREXIT : objectArray
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodes set: " + hashSet);
            }
            objectArray = hashSet.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((Cluster)objectArray[i]).handleNotification(this.notif, this.hb);
            }
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "notificationReceived");
    }
}

