/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.Serializable;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public class MessageMBeanImpl {
    private static int verbose = 1;
    private static final TraceComponent tc = Tr.register(MessageMBeanImpl.class, "JMSHelperMBean", "com.ibm.ws.messaging.MSGSMessages");
    private static SimpleDateFormat formatter = new SimpleDateFormat("yy.MM.dd HH:mm:ss:SSS z");
    private static Date date = new Date();
    private static final int Seconds_2 = 2000;
    private static final int SmallWait = 1;
    static String lineSeperator = null;
    private static boolean specialMessage = false;

    protected static String defaultMessage(int n) {
        String string;
        int n2 = n + 1;
        long l = System.currentTimeMillis();
        try {
            date.setTime(l);
            string = formatter.format(date);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.messaging.MessageMBeanImpl.defaultMessage", "94");
            string = " ";
        }
        return n2 + " " + string;
    }

    protected static InitialContext getContext() throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConext");
        }
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
        }
        catch (NamingException namingException) {
            FFDCFilter.processException(namingException, "com.ibm.ws.messaging.MessageMBeanImpl.getContext", "107");
            Tr.error(tc, "TEMPORARY_MSGS9999", new Object[]{namingException});
            throw namingException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConext");
        }
        return initialContext;
    }

    private static void cleanUp(Connection connection, Session session, MessageProducer messageProducer) {
        MessageMBeanImpl.cleanUpImpl(connection, session, messageProducer, null, null);
    }

    private static void cleanUp(Connection connection, Session session, MessageConsumer messageConsumer) {
        MessageMBeanImpl.cleanUpImpl(connection, session, null, messageConsumer, null);
    }

    private static void cleanUp(Connection connection, Session session, QueueBrowser queueBrowser) {
        MessageMBeanImpl.cleanUpImpl(connection, session, null, null, queueBrowser);
    }

    private static void cleanUpImpl(Connection connection, Session session, MessageProducer messageProducer, MessageConsumer messageConsumer, QueueBrowser queueBrowser) {
        String string = "cleanUp";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        try {
            if (session != null) {
                session.close();
            }
            if (connection != null) {
                connection.close();
                connection = null;
            }
            if (messageProducer != null) {
                messageProducer.close();
            }
            if (messageConsumer != null) {
                messageConsumer.close();
            }
            if (queueBrowser != null) {
                queueBrowser.close();
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.messaging.MessageMBeanImpl.cleanUp", "199");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static ConnectionFactory getConnectionFactory(String string, Context context) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionFactory");
        }
        ConnectionFactory connectionFactory = null;
        try {
            connectionFactory = (ConnectionFactory)context.lookup(string);
        }
        catch (CommunicationException communicationException) {
            FFDCFilter.processException(communicationException, "com.ibm.ws.messaging.MessageMBeanImpl.getConnectionFactory", "213");
            throw communicationException;
        }
        catch (NameNotFoundException nameNotFoundException) {
            FFDCFilter.processException(nameNotFoundException, "com.ibm.ws.messaging.MessageMBeanImpl.getConnectionFactory", "217");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Connection factory not found ..." + string);
            }
            throw nameNotFoundException;
        }
        catch (NamingException namingException) {
            FFDCFilter.processException(namingException, "com.ibm.ws.messaging.MessageMBeanImpl.getConnectionFactory", "222");
            throw namingException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionFactory");
        }
        return connectionFactory;
    }

    protected static Destination getDestination(String string, Context context) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDestination");
        }
        Destination destination = null;
        try {
            destination = (Destination)context.lookup(string);
        }
        catch (CommunicationException communicationException) {
            FFDCFilter.processException(communicationException, "com.ibm.ws.messaging.MessageMBeanImpl.getDestination", "239");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server not started");
            }
            throw communicationException;
        }
        catch (NameNotFoundException nameNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Destination ..." + string);
            }
            throw nameNotFoundException;
        }
        catch (NamingException namingException) {
            FFDCFilter.processException(namingException, "com.ibm.ws.messaging.MessageMBeanImpl.getDestination", "247");
            throw namingException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDestination");
        }
        return destination;
    }

    private static synchronized String getLineSeperator() {
        if (lineSeperator != null) {
            return lineSeperator;
        }
        try {
            String string = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("line.separator");
                }
            });
            return string;
        }
        catch (SecurityException securityException) {
            FFDCFilter.processException(securityException, "com.ibm.ws.messaging.MessageMBeanImpl.getLineSeperator", "282");
            return "\n";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String processNonTextMessage(Message message, int n) {
        String string;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "processNonTextMessage");
            }
            String string2 = null;
            Object var3_3 = null;
            string = "";
            try {
                string2 = message.toString();
                if (n == 1) {
                    string = string2;
                    break block12;
                }
                int n2 = 0;
                String string3 = MessageMBeanImpl.getLineSeperator();
                int n3 = string3.length();
                int n4 = 0;
                if (n3 == 1) {
                    string = string2.replace(string3.charAt(0), ' ');
                    break block12;
                }
                if (string2.indexOf(string3) == -1) {
                    string = string2.replace('\n', ' ');
                    break block12;
                }
                for (int i = 0; i < 100; ++i) {
                    n2 = string2.indexOf(string3, n4);
                    if (n2 == -1) {
                        if (n4 < string2.length()) {
                            string = string + ' ' + string2.substring(n4, string2.length());
                        }
                        break;
                    }
                    string = string + ' ' + string2.substring(n4, n2);
                    n4 = n2 + n3;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.messaging.MessageMBeanImpl.processNonTextMessage", "340");
                string = string2;
            }
        }
        string = string.trim();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processNonTextMessage");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Boolean putSpecialImpl(String string, String string2, String string3, String string4) throws JMSException, NamingException {
        specialMessage = true;
        try {
            Boolean bl = MessageMBeanImpl.putImpl(string, string2, null, null, string3, new Integer(1), string4);
            return bl;
        }
        finally {
            specialMessage = false;
        }
    }

    private static Message createSpecialMessage(String string, QueueSession queueSession, String string2) {
        BytesMessage bytesMessage = null;
        MapMessage mapMessage = null;
        ObjectMessage objectMessage = null;
        StreamMessage streamMessage = null;
        TextMessage textMessage = null;
        BytesMessage bytesMessage2 = null;
        try {
            if (string.indexOf("byte") != -1) {
                bytesMessage = queueSession.createBytesMessage();
                bytesMessage.writeBoolean(true);
                bytesMessage2 = bytesMessage;
            }
            if (string.indexOf("map") != -1) {
                mapMessage = queueSession.createMapMessage();
                mapMessage.setString("Name", "value");
                bytesMessage2 = mapMessage;
            }
            if (string.indexOf("object") != -1) {
                String string3 = new String("TestObject");
                objectMessage = queueSession.createObjectMessage();
                objectMessage.setObject((Serializable)((Object)string3));
                bytesMessage2 = objectMessage;
            }
            if (string.indexOf("stream") != -1) {
                streamMessage = queueSession.createStreamMessage();
                streamMessage.writeString("This is a test string");
                bytesMessage2 = streamMessage;
            }
            if (bytesMessage2 == null) {
                textMessage = queueSession.createTextMessage();
                textMessage.setText("Default Message information");
                bytesMessage2 = textMessage;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException(jMSException, "com.ibm.ws.messaging.MessageMBeanImpl.createSpecialMessage", "410");
            jMSException.printStackTrace();
        }
        if (string2 != null) {
            try {
                bytesMessage2.setJMSType(string2);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException(jMSException, "com.ibm.ws.messaging.MessageMBeanImpl.createSpecialMessage", "418");
            }
        }
        return bytesMessage2;
    }

    protected static Boolean putImpl(String string, String string2, String string3, String string4, String string5, Integer n) throws JMSException, NamingException {
        return MessageMBeanImpl.putImpl(string, string2, string3, string4, string5, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Boolean putImpl(String string, String string2, String string3, String string4, String string5, Integer n, String string6) throws JMSException, NamingException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = string4;
            if (string4 != null) {
                object = new String("********");
            }
            Tr.entry(tc, "putImpl", new Object[]{string, string2, string3, object, string5, n});
        }
        object = null;
        QueueConnectionFactory queueConnectionFactory = null;
        Queue queue = null;
        QueueConnection queueConnection = null;
        TextMessage textMessage = null;
        QueueSender queueSender = null;
        QueueSession queueSession = null;
        String string7 = null;
        String string8 = null;
        try {
            object = MessageMBeanImpl.getContext();
            queueConnectionFactory = (QueueConnectionFactory)MessageMBeanImpl.getConnectionFactory(string2, (Context)object);
            Destination destination = MessageMBeanImpl.getDestination(string, (Context)object);
            if (destination instanceof Queue) {
                queue = (Queue)destination;
            } else {
                try {
                    queue = (Queue)destination;
                }
                catch (ClassCastException classCastException) {
                    FFDCFilter.processException(classCastException, "com.ibm.ws.messaging.MessageMBeanImpl.putImpl", "498");
                    throw classCastException;
                }
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting connection ...");
                }
                queueConnection = string3 != null ? queueConnectionFactory.createQueueConnection(string3, string4) : queueConnectionFactory.createQueueConnection();
                queueConnection.start();
                string8 = queue.getQueueName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "connection.start()..." + string8 + " started");
                }
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException(jMSException, "com.ibm.ws.messaging.MessageMBeanImpl.putImpl", "515");
                Tr.error(tc, "TEMPORARY_MSGS9999", new Object[]{jMSException});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creation problem");
                }
                throw jMSException;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Starting JMS Connection");
            }
            try {
                queueSession = queueConnection.createQueueSession(false, 1);
                queueSender = queueSession.createSender(queue);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "creating TextMessage");
                }
                textMessage = queueSession.createTextMessage();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException(jMSException, "com.ibm.ws.messaging.MessageMBeanImpl.putImpl", "528");
                Tr.error(tc, "TEMPORARY_MSGS9999", new Object[]{jMSException});
                throw jMSException;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Sending " + n + " messages to " + string8);
            }
            try {
                if (specialMessage) {
                    Message message = MessageMBeanImpl.createSpecialMessage(string5, queueSession, string6);
                    queueSender.send(message);
                } else {
                    for (int i = 0; i < n; ++i) {
                        string7 = string5 == null ? MessageMBeanImpl.defaultMessage(i) : string5;
                        textMessage.setText(string7);
                        queueSender.send((Message)textMessage);
                    }
                }
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException(jMSException, "com.ibm.ws.messaging.MessageMBeanImpl.putImpl", "554");
                Tr.error(tc, "TEMPORARY_MSGS9999", new Object[]{jMSException});
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            MessageMBeanImpl.cleanUp(queueConnection, queueSession, queueSender);
            throw throwable;
        }
        MessageMBeanImpl.cleanUp((Connection)queueConnection, (Session)queueSession, (MessageProducer)queueSender);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "putImpl");
        }
        return Boolean.TRUE;
    }

    protected static String[] getMessages(QueueReceiver queueReceiver, int n, boolean bl, boolean bl2) throws JMSException {
        return MessageMBeanImpl.getMessages(queueReceiver, n, bl, bl2, true);
    }

    protected static String[] getMessages(QueueReceiver queueReceiver, int n, boolean bl, boolean bl2, boolean bl3) throws JMSException {
        Object object;
        int n2;
        String string = "getMessages";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        int n3 = 2000;
        Message message = null;
        Vector<Object[]> vector = new Vector<Object[]>();
        try {
            for (n2 = 0; bl || bl2 && n == 0 || n2 < n; ++n2) {
                message = queueReceiver.receive((long)n3);
                n3 = 1;
                if (message != null) {
                    if (message instanceof TextMessage && bl3) {
                        object = ((TextMessage)message).getText();
                        object = MessageMBeanImpl.deliminateMessage((String)object);
                        vector.addElement((Object[])object);
                        continue;
                    }
                    object = MessageMBeanImpl.processNonTextMessage(message, n);
                    object = MessageMBeanImpl.deliminateMessage((String)object);
                    vector.addElement((Object[])object);
                    continue;
                }
                break;
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException(jMSException, "com.ibm.ws.messaging.MessageMBeanImpl.getMessages", "634");
            Tr.error(tc, "TEMPORARY_MSGS9999", new Object[]{jMSException});
            throw jMSException;
        }
        object = new String[n2];
        vector.copyInto((Object[])object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
        return object;
    }

    private static String deliminateMessage(String string) {
        try {
            int n = 0;
            int n2 = 0;
            char c = '{';
            char c2 = '}';
            int n3 = 0;
            char c3 = '\"';
            int n4 = 0;
            int n5 = 0;
            char c4 = '[';
            char c5 = ']';
            n = MessageMBeanImpl.countCharacter(string, c);
            n2 = MessageMBeanImpl.countCharacter(string, c2);
            n3 = MessageMBeanImpl.countCharacter(string, c3);
            n4 = MessageMBeanImpl.countCharacter(string, c4);
            n5 = MessageMBeanImpl.countCharacter(string, c5);
            if (n2 == 0 && n == 0 && n4 == 0 && n5 == 0 && n3 == 0) {
                return string;
            }
            if (n == n2 && n4 == 0 && n5 == 0 && n3 == 0) {
                return c + string + c2;
            }
            if (n == 0 && n2 == 0 && n4 == n5 && n3 == 0) {
                return c + string + c2;
            }
            if (n == 0 && n2 == 0 && n4 == 0 && n5 == 0 && n3 % 2 == 0) {
                return c + string + c2;
            }
            return c3 + MessageMBeanImpl.replaceCharacter(MessageMBeanImpl.replaceCharacter(MessageMBeanImpl.replaceCharacter(MessageMBeanImpl.replaceCharacter(MessageMBeanImpl.replaceCharacter(string, c5), c4), c), c2), c3) + c3;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.messaging.MessageMBeanImpl.deliminateMessages", "818");
            return string;
        }
    }

    private static String replaceCharacter(String string, char c) {
        String string2 = null;
        int n = 0;
        int n2 = 0;
        while ((n = string.indexOf(c, n2)) != -1) {
            string2 = string2 == null ? string.substring(n2, n) + '\\' + c : string2 + string.substring(n2, n) + '\\' + c;
            n2 = n + 1;
        }
        string2 = string2 == null ? string : string2 + string.substring(n2, string.length());
        return string2;
    }

    private static int countCharacter(String string, char c) {
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        do {
            n2 = string.indexOf(c, n2);
            ++n;
            ++n2;
            if (++n3 <= 100) continue;
            return 0;
        } while (n2 != 0);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String[] getImpl(String string, String string2, String string3, String string4, Integer n, String string5) throws JMSException, NamingException {
        if (tc.isEntryEnabled()) {
            String string6 = string4;
            if (string4 != null) {
                string6 = new String("********");
            }
            Tr.entry(tc, "getImpl", new Object[]{string, string2, string3, string6, n, string5});
        }
        boolean bl = false;
        boolean bl2 = false;
        QueueConnectionFactory queueConnectionFactory = null;
        Queue queue = null;
        QueueConnection queueConnection = null;
        InitialContext initialContext = null;
        QueueSession queueSession = null;
        QueueReceiver queueReceiver = null;
        Object var15_15 = null;
        boolean bl3 = false;
        String[] stringArray = null;
        if (n == 0 && string5 == null) {
            return null;
        }
        if (n == -1) {
            bl2 = true;
        }
        if (string5 != null) {
            bl = true;
        }
        try {
            initialContext = MessageMBeanImpl.getContext();
            queueConnectionFactory = (QueueConnectionFactory)MessageMBeanImpl.getConnectionFactory(string2, initialContext);
            Destination destination = MessageMBeanImpl.getDestination(string, initialContext);
            if (queue instanceof Queue) {
                queue = (Queue)destination;
            } else {
                try {
                    queue = (Queue)destination;
                }
                catch (ClassCastException classCastException) {
                    FFDCFilter.processException(classCastException, "com.ibm.ws.messaging.MessageMBeanImpl.getImpl", "713");
                    throw classCastException;
                }
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Create queue connection");
                }
                queueConnection = string3 != null ? queueConnectionFactory.createQueueConnection(string3, string4) : queueConnectionFactory.createQueueConnection();
                queueConnection.start();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "connection.start()..." + queue.getQueueName() + " started");
                }
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException(jMSException, "com.ibm.ws.messaging.MessageMBeanImpl.getImpl", "728");
                Tr.error(tc, "TEMPORARY_MSGS9999", new Object[]{jMSException});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creation problem");
                }
                throw jMSException;
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Create queue session");
                }
                queueSession = queueConnection.createQueueSession(false, 1);
                queueReceiver = bl ? queueSession.createReceiver(queue, string5) : queueSession.createReceiver(queue);
            }
            catch (InvalidSelectorException invalidSelectorException) {
                FFDCFilter.processException(invalidSelectorException, "com.ibm.ws.messaging.MessageMBeanImpl.getImpl", "743");
                throw invalidSelectorException;
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException(jMSException, "com.ibm.ws.messaging.MessageMBeanImpl.getImpl", "746");
                Tr.error(tc, "TEMPORARY_MSGS9999", new Object[]{jMSException});
                throw jMSException;
            }
            stringArray = MessageMBeanImpl.getMessages(queueReceiver, n, bl2, bl);
        }
        catch (Throwable throwable) {
            MessageMBeanImpl.cleanUp(queueConnection, queueSession, queueReceiver);
            throw throwable;
        }
        MessageMBeanImpl.cleanUp((Connection)queueConnection, (Session)queueSession, (MessageConsumer)queueReceiver);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getImpl");
        }
        return stringArray;
    }

    protected static String[] browseMessages(Enumeration enumeration, int n, boolean bl, boolean bl2) throws JMSException {
        return MessageMBeanImpl.browseMessages(enumeration, n, bl, bl2, true);
    }

    protected static String[] browseMessages(Enumeration enumeration, int n, boolean bl, boolean bl2, boolean bl3) throws JMSException {
        Message message;
        String string = "browseMessage";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        try {
            while (enumeration.hasMoreElements() && (bl2 && n == 0 || n2 < n || bl)) {
                String string2;
                ++n2;
                message = (Message)enumeration.nextElement();
                if (message instanceof TextMessage && bl3) {
                    string2 = ((TextMessage)message).getText();
                    string2 = MessageMBeanImpl.deliminateMessage(string2);
                    vector.addElement(string2);
                } else {
                    string2 = MessageMBeanImpl.processNonTextMessage(message, n);
                    string2 = MessageMBeanImpl.deliminateMessage(string2);
                    vector.addElement(string2);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding message: {0}", new Object[]{message});
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException(jMSException, "com.ibm.ws.messaging.MessageMBeanImpl.browseMessages", "809");
            Tr.error(tc, "TEMPORARY_MSGS9999", new Object[]{jMSException});
            throw jMSException;
        }
        message = new String[n2];
        vector.copyInto((Object[])message);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
        return message;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String[] browseImpl(String string, String string2, String string3, String string4, Integer n, String string5) throws JMSException, NamingException {
        String string6;
        if (tc.isEntryEnabled()) {
            string6 = string4;
            if (string4 != null) {
                string6 = new String("********");
            }
            Tr.entry(tc, "browseImpl", new Object[]{string, string2, string3, string6, n, string5});
        }
        string6 = null;
        Queue queue = null;
        QueueConnection queueConnection = null;
        QueueBrowser queueBrowser = null;
        QueueSession queueSession = null;
        InitialContext initialContext = null;
        String[] stringArray = null;
        int n2 = n;
        boolean bl = false;
        boolean bl2 = false;
        if (n2 == 0 && string5 == null) {
            return null;
        }
        if (n2 == -1) {
            bl2 = true;
        }
        if (string5 != null) {
            bl = true;
        }
        initialContext = MessageMBeanImpl.getContext();
        string6 = (QueueConnectionFactory)MessageMBeanImpl.getConnectionFactory(string2, initialContext);
        Destination destination = MessageMBeanImpl.getDestination(string, initialContext);
        if (destination instanceof Queue) {
            queue = (Queue)destination;
        } else {
            try {
                queue = (Queue)destination;
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException(classCastException, "com.ibm.ws.messaging.MessageMBeanImpl.browseImpl", "878");
                throw classCastException;
            }
        }
        try {
            queueConnection = string3 != null ? string6.createQueueConnection(string3, string4) : string6.createQueueConnection();
            queueConnection.start();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "connection.start()..." + queue.getQueueName() + " started");
            }
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException(jMSException, "com.ibm.ws.messaging.MessageMBeanImpl.browseImpl", "894");
            Tr.error(tc, "TEMPORARY_MSGS9999", new Object[]{jMSException});
            throw jMSException;
        }
        try {
            queueSession = queueConnection.createQueueSession(false, 1);
            queueBrowser = bl ? queueSession.createBrowser(queue, string5) : queueSession.createBrowser(queue);
            Enumeration enumeration = queueBrowser.getEnumeration();
            stringArray = MessageMBeanImpl.browseMessages(enumeration, n2, bl2, bl);
        }
        catch (InvalidSelectorException invalidSelectorException) {
            try {
                FFDCFilter.processException(invalidSelectorException, "com.ibm.ws.messaging.MessageMBeanImpl.browseImpl", "910");
                throw invalidSelectorException;
                catch (JMSException jMSException) {
                    FFDCFilter.processException(jMSException, "com.ibm.ws.messaging.MessageMBeanImpl.browseImpl", "913");
                    Tr.error(tc, "TEMPORARY_MSGS9999", new Object[]{jMSException});
                    throw jMSException;
                }
            }
            catch (Throwable throwable) {
                MessageMBeanImpl.cleanUp((Connection)queueConnection, (Session)queueSession, queueBrowser);
                throw throwable;
            }
        }
        MessageMBeanImpl.cleanUp((Connection)queueConnection, (Session)queueSession, queueBrowser);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "browseImpl");
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Boolean publishImpl(String string, String string2, String string3, String string4, String string5, Integer n) throws JMSException, NamingException {
        String string6;
        if (tc.isEntryEnabled()) {
            string6 = string4;
            if (string4 != null) {
                string6 = new String("********");
            }
            Tr.entry(tc, "publishImpl", new Object[]{string, string2, string3, string6, string5, n});
        }
        string6 = null;
        Topic topic = null;
        TopicConnection topicConnection = null;
        TopicSession topicSession = null;
        TopicPublisher topicPublisher = null;
        TextMessage textMessage = null;
        InitialContext initialContext = null;
        String string7 = null;
        try {
            initialContext = MessageMBeanImpl.getContext();
            string6 = (TopicConnectionFactory)MessageMBeanImpl.getConnectionFactory(string2, initialContext);
            Destination destination = MessageMBeanImpl.getDestination(string, initialContext);
            if (destination instanceof Topic) {
                topic = (Topic)destination;
            } else {
                try {
                    topic = (Topic)destination;
                }
                catch (ClassCastException classCastException) {
                    FFDCFilter.processException(classCastException, "com.ibm.ws.messaging.MessageMBeanImpl.publishImpl", "978");
                    throw classCastException;
                }
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Get Connection ...");
                }
                topicConnection = string3 != null ? string6.createTopicConnection(string3, string4) : string6.createTopicConnection();
                topicConnection.start();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "connection.start()..." + topic.getTopicName() + " started");
                }
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException(jMSException, "com.ibm.ws.messaging.MessageMBeanImpl.publishImpl", "993");
                Tr.error(tc, "TEMPORARY_MSGS9999", new Object[]{jMSException});
                throw jMSException;
            }
            try {
                topicSession = topicConnection.createTopicSession(false, 1);
                topicPublisher = topicSession.createPublisher(topic);
                textMessage = topicSession.createTextMessage();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException(jMSException, "com.ibm.ws.messaging.MessageMBeanImpl.publishImpl", "1003");
                Tr.error(tc, "TEMPORARY_MSGS9999", new Object[]{jMSException});
                throw jMSException;
            }
            try {
                for (int i = 0; i < n; ++i) {
                    string7 = string5 == null ? MessageMBeanImpl.defaultMessage(i) : string5;
                    textMessage.setText(string7);
                    topicPublisher.publish((Message)textMessage);
                }
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException(jMSException, "com.ibm.ws.messaging.MessageMBeanImpl.publishImpl", "1019");
                Tr.error(tc, "TEMPORARY_MSGS9999", new Object[]{jMSException});
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            MessageMBeanImpl.cleanUp(topicConnection, topicSession, topicPublisher);
            throw throwable;
        }
        MessageMBeanImpl.cleanUp((Connection)topicConnection, (Session)topicSession, (MessageProducer)topicPublisher);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "publishImpl");
        }
        return Boolean.TRUE;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String[] subscribeImpl(String string, String string2, String string3, String string4, Integer n, Integer n2, String string5) throws JMSException, NamingException {
        Object[] objectArray;
        String string6;
        if (tc.isEntryEnabled()) {
            string6 = string4;
            if (string4 != null) {
                string6 = new String("********");
            }
            Tr.entry(tc, "subscribeImpl", new Object[]{string, string2, string3, string6, n, n2, string5});
        }
        string6 = null;
        Topic topic = null;
        TopicConnection topicConnection = null;
        TopicSession topicSession = null;
        TopicSubscriber topicSubscriber = null;
        InitialContext initialContext = null;
        Vector<String> vector = new Vector<String>();
        int n3 = 0;
        boolean bl = false;
        if (n2 == 0 && string5 == null) {
            return null;
        }
        if (string5 != null) {
            bl = true;
        }
        try {
            initialContext = MessageMBeanImpl.getContext();
            string6 = (TopicConnectionFactory)MessageMBeanImpl.getConnectionFactory(string2, initialContext);
            objectArray = MessageMBeanImpl.getDestination(string, initialContext);
            if (objectArray instanceof Topic) {
                topic = (Topic)objectArray;
            } else {
                try {
                    topic = (Topic)objectArray;
                }
                catch (ClassCastException classCastException) {
                    FFDCFilter.processException(classCastException, "com.ibm.ws.messaging.MessageMBeanImpl.subscribeImpl", "1099");
                    throw classCastException;
                }
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Get Connection ...");
                }
                topicConnection = string3 != null ? string6.createTopicConnection(string3, string4) : string6.createTopicConnection();
                topicConnection.start();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "connection.start()..." + topic.getTopicName() + " started");
                }
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException(jMSException, "com.ibm.ws.messaging.MessageMBeanImpl.subscribeImpl", "1116");
                Tr.error(tc, "TEMPORARY_MSGS9999", new Object[]{jMSException});
                throw jMSException;
            }
            try {
                topicSession = topicConnection.createTopicSession(false, 1);
                topicSubscriber = bl ? topicSession.createSubscriber(topic, string5, true) : topicSession.createSubscriber(topic);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException(jMSException, "com.ibm.ws.messaging.MessageMBeanImpl.subscribeImpl", "1129");
                Tr.error(tc, "TEMPORARY_MSGS9999", new Object[]{jMSException});
                throw jMSException;
            }
            int n4 = n * 1000;
            if (n4 < 1000) {
                n4 = 1000;
            }
            while (bl && n2 == 0 || n3 < n2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "receive(" + n4 + ")");
                }
                Message message = topicSubscriber.receive((long)n4);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "receive(" + n4 + ") ... completed");
                }
                ++n3;
                if (message != null) {
                    String string7 = null;
                    string7 = message instanceof TextMessage ? ((TextMessage)message).getText() : MessageMBeanImpl.processNonTextMessage(message, n2);
                    string7 = MessageMBeanImpl.deliminateMessage(string7);
                    vector.addElement(string7);
                    continue;
                }
                break;
            }
        }
        catch (JMSException jMSException) {
            try {
                FFDCFilter.processException(jMSException, "com.ibm.ws.messaging.MessageMBeanImpl.subscribeImpl", "1176");
                Tr.error(tc, "TEMPORARY_MSGS9999", new Object[]{jMSException});
                throw jMSException;
                catch (NamingException namingException) {
                    FFDCFilter.processException(namingException, "com.ibm.ws.messaging.MessageMBeanImpl.subscribeImpl", "1181");
                    throw namingException;
                }
            }
            catch (Throwable throwable) {
                MessageMBeanImpl.cleanUp(topicConnection, topicSession, topicSubscriber);
                throw throwable;
            }
        }
        MessageMBeanImpl.cleanUp((Connection)topicConnection, (Session)topicSession, (MessageConsumer)topicSubscriber);
        objectArray = new String[n3];
        vector.copyInto(objectArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "subscribeImpl");
        }
        return objectArray;
    }
}

