/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.admin.command;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.messaging.admin.command.AdminCommandException;
import javax.management.ObjectName;

public class DeleteJMSObjectCmd
extends AbstractTaskCommand {
    private static final TraceComponent tc = Tr.register(DeleteJMSObjectCmd.class, "Webui", "com.ibm.ws.messaging.admin.command.CWMSRText");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.messaging.admin.command.CWMSRMessages");
    private static ConfigService configService = ConfigServiceFactory.getConfigService();
    private boolean deleted = false;

    public DeleteJMSObjectCmd(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public DeleteJMSObjectCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted", this);
        }
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getCommandResult();
        taskCommandResultImpl.reset();
        Session session = this.getConfigSession();
        try {
            ObjectName objectName = (ObjectName)this.getTargetObject();
            String string = ConfigServiceHelper.getConfigDataType(objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "JMS object type is: " + string);
            }
            if (string.equals("JMSProvider")) {
                String string2 = ConfigServiceHelper.getConfigDataId(objectName).getHref();
                String string3 = string2.substring(string2.indexOf("#") + 1);
                if (string3.startsWith("builtin_")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Built in JMS provider detected, cannot delete");
                    }
                    throw new AdminCommandException(nls.getFormattedMessage("BUILT_IN_PROVIDER_CWMSR0000", new Object[0], null));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Custom JMS provider detected, deleting...");
                }
                configService.deleteConfigData(session, objectName);
                this.setDeleted(true);
            } else if (string.equals("MQConnectionFactory") || string.equals("MQQueueConnectionFactory") || string.equals("MQTopicConnectionFactory") || string.equals("MQQueue") || string.equals("MQTopic") || string.equals("WASQueueConnectionFactory") || string.equals("WASTopicConnectionFactory") || string.equals("WASQueue") || string.equals("WASTopic") || string.equals("GenericJMSConnectionFactory") || string.equals("GenericJMSDestination")) {
                configService.deleteConfigData(session, objectName);
                this.setDeleted(true);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.sib.wsnotification.admin.commands.CreateBrokerCommand.beforeStepsExecuted", "106", this);
            taskCommandResultImpl.setException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }

    protected void afterStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean bl) {
        this.deleted = bl;
    }
}

