/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.admin.command;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.messaging.admin.command.AdminCommandException;
import com.ibm.ws.messaging.admin.command.GetJMSObjectCmd;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.ObjectName;

public class GetJMSProvidersCmd
extends GetJMSObjectCmd {
    private static final TraceComponent tc = Tr.register(GetJMSProvidersCmd.class, "Webui", "com.ibm.ws.messaging.admin.command.CWMSRText");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.messaging.admin.command.CWMSRMessages");
    private static ConfigService configService = ConfigServiceFactory.getConfigService();

    public GetJMSProvidersCmd(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public GetJMSProvidersCmd(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public HashMap getJMSObjectType2TileNameMap() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJMSObjectType2TileNameMap", this);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("JMSProvider", "JMSProvider.config.view");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJMSObjectType2TileNameMap", hashMap);
        }
        return hashMap;
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted", this);
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getCommandResult();
        try {
            String string = (String)this.getParameter("objectType");
            if (taskCommandResultImpl.isSuccessful() && string != null) {
                String string2 = null;
                String string3 = null;
                String string4 = null;
                if (string.equals("ConnectionFactory")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting tiles for: ConnectionFactory");
                    }
                    string2 = "MQConnectionFactory.config.view";
                    string4 = "GenericJMSConnectionFactory.config.view";
                } else if (string.equals("QueueConnectionFactory")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting tiles for: QueueConnectionFactory");
                    }
                    string2 = "MQQueueConnectionFactory.config.view";
                    string3 = "WASQueueConnectionFactory.config.view";
                    string4 = "GenericJMSConnectionFactory.config.view";
                } else if (string.equals("TopicConnectionFactory")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting tiles for: TopicConnectionFactory");
                    }
                    string2 = "MQTopicConnectionFactory.config.view";
                    string3 = "WASTopicConnectionFactory.config.view";
                    string4 = "GenericJMSConnectionFactory.config.view";
                } else if (string.equals("Queue")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting tiles for: Queue");
                    }
                    string2 = "MQQueue.config.view";
                    string3 = "WASQueue.config.view";
                    string4 = "GenericJMSDestination.config.view";
                } else if (string.equals("Topic")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting tiles for: Topic");
                    }
                    string2 = "MQTopic.config.view";
                    string3 = "WASTopic.config.view";
                    string4 = "GenericJMSDestination.config.view";
                } else if (string.equals("ActivationSpec")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting tiles for: ActivationSpec");
                    }
                } else {
                    taskCommandResultImpl.setException(new AdminCommandException(nls.getFormattedMessage("ILLEGAL_OBJECT_TYPE_CWMSR0002", new Object[0], null)));
                }
                Session session = this.getConfigSession();
                HashMap hashMap = (HashMap)taskCommandResultImpl.getResult();
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String string5 = (String)iterator.next();
                    ObjectName objectName = new ObjectName(string5);
                    String string6 = ConfigServiceHelper.getConfigDataId(objectName).getHref();
                    String string7 = string6.substring(string6.indexOf("#") + 1);
                    if (string7.equals("builtin_mqprovider")) {
                        if (string2 != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "MQ provider handles selected object: " + string);
                            }
                            hashMap2.put(string5, string2);
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "MQ provider cannot handle selected object: " + string);
                        continue;
                    }
                    if (string7.equals("builtin_jmsprovider")) {
                        if (string3 != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "V5 provider handles selected object: " + string);
                            }
                            hashMap2.put(string5, string3);
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "V5 provider cannot handle selected object: " + string);
                        continue;
                    }
                    if (string4 != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "MQ provider handles selected object: " + string);
                        }
                        hashMap2.put(string5, string4);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "MQ provider cannot handle selected object: " + string);
                }
                taskCommandResultImpl.setResult(hashMap2);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.messaging.admin.command.GetJMSProvidersCmd.beforeStepsExecuted", "248", this);
            taskCommandResultImpl.setException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

